F /* This file is the driver for Ken Kundert's sparse Matrix Package. */  ' #include <math.h>    /* Math library */s= #include <errno.h>   /* Error definitions for math library */,% #include <stdio.h>   /* IO library */t #include "simconst.h"h: #include "MtrxError.h"    /* Sparse matrix error macros */ #include "simglbdef.h" #include "simstruct.h"     /* Decompose full matrix. */ ludecomp(subptr) struct subcircuit *subptr; {  register double **locmat;m
 int i,j,k;&   locmat = (double **) subptr->matrix;$   for(i=1; i <= subptr->size; i++) {;     if( (locmat[i][i] < FUZZ) && (locmat[i][i] > NFUZZ) ) { .       printf("Close to singular locmat!!!\n");       return(FALSE);     } D     for(j=i+1; j <= subptr->size; j++) locmat[j][i] /= locmat[i][i];'     for(j=i+1; j <= subptr->size; j++) s$ 	for(k=i+1; k <= subptr->size; k++) 0 		locmat[j][k] -= (locmat[j][i] * locmat[i][k]);   }L   return(TRUE);v }n       /* Decompose sparse matrix. */ sludecomp(subptr)  struct subcircuit *subptr; {   double Growth, Pseudo, elephant;
 int Error;  N /* Matrix routines have been complied such that they do not calculate Growth, (    PseudoCondition or LargestElement. */    uG    Error = DecomposeMatrix(subptr->matrix,&Growth, &Pseudo, &elephant);;'    if(Error == SINGULAR) return(FALSE);d    else return(TRUE);  }u    /* Solve Matrix. */ lusol(rhs,subptr)( register double *rhs;j struct subcircuit *subptr; {c register double **locmat;- int i,j;   if(subptr->sparse == FALSE) {((     locmat = (double **) subptr->matrix;$     for(i=1; i <= subptr->size; i++)& 	  for(j=i+1; j <= subptr->size; j++) & 				rhs[j] -= (locmat[j][i] * rhs[i]);%     for(i=subptr->size; i > 0; i--) {z       rhs[i] /= locmat[i][i];r@       for(j=1; j <= i-1; j++) rhs[j] -= (locmat[j][i] * rhs[i]);     }    }    else {.     SolveRealMatrix(subptr->matrix, rhs, rhs);   }h }x   /* Zero out the matrix. */ szeromat(subptr) struct subcircuit *subptr; {    ClearMatrix(subptr->matrix); }:    J /* Get the subcircuit just the right sized matrix and decide whether it */ /* should be sparse or not. */ allocmat(subptr) struct subcircuit *subptr; {= int i; char *AllocateMatrix();  double **locmat;
 int Error;N   if((subptr->size > sprsthrsh) || ((dcflag == TRUE) && (subptr->size > 1))) {=     subptr->matrix = AllocateMatrix(subptr->size, 0, &Error);t     subptr->sparse = TRUE;   }p   else {     subptr->sparse = FALSE;uF     locmat = (double **) ralloc((subptr->size + 1), sizeof(double *));1     for(i=1; i <= subptr->size; i++) locmat[i] = d> 		    ( double * ) ralloc((subptr->size + 1), sizeof(double));%     subptr->matrix = (char *) locmat;b   }e   }a  . /* Matrix element pointers for full matrix. */ double *getmat(i,j,subptr) i int i,j; struct subcircuit *subptr; {t' double **locmat, *AddElementToMatrix();r   if( (i > 0) && (j > 0) ) {!     if(subptr->sparse == FALSE) {t*       locmat = (double **) subptr->matrix;       return(&(locmat[i][j]));     } 
     else {<       return(AddElementToMatrix(subptr->matrix, i, j, 1.0));     }t   }    else return(NULL); }    /* Print the Matrix. */e dismat(subptr) struct subcircuit *subptr; {, int i,j; double **locmat;   if(subptr->sparse == FALSE) {t(     locmat = (double **) subptr->matrix;"     printf("displaying matrix\n");(     for(i = 1; i <= subptr->size; i++) {E       for(j = 1; j <= subptr->size; j++) printf("%g ", locmat[i][j]);        printf("\n");n     }e   }s   else {3     printf("No sparse matrix printing routine.\n");m   }  }a  