 /*  *  MATRIX ALLOCATION MODULE  *  *  Author:   *     Kenneth S. Kundertc  *     UC Berkeley  *  *  Advising professor: &  *     Alberto Sangiovanni-Vincentelli  *J  *  This module contains the allocation and deallocation routines for the   *  sparse matrix routines.     *:  *  >>> User accessable functionscontained in this module:  *  AllocateMatrix  *  DeallocateMatrix  *  MatrixErrore  *  ClearMatrixError  *+  *  >>> Functions contained in this module:   *  AllocateMatrix  *  GetElement  *  InitializeElementBlocksp
  *  GetFillIne  *  RecordAllocation  *  AllocateBlockAllocationListr  *  DeallocateMatrix  *  MatrixErrord  *  ClearMatrixError  */,         a /*  *  IMPORTSm  *  *  >>> Import decriptions:;  *  stdio.ht  *     Standard C IO library.n  *  MtrxPers.h8  *     Macros that customize the sparse matrix routines.  *  MtrxExpt.h:  *     Macros and declarations to be imported by the user.  *  MtrxDefs.hH  *     Matrix type and macro definitions for the sparse matrix routines.  *  MtrxError.h*&  *     Matrix error macro definitions.  */t    #include <stdio.h> #include "MtrxPers.h"  #include "MtrxExpt.h"  #include "MtrxDefs.h"o #include "MtrxError.h"           , /*  *  MATRIX ALLOCATION;  *K  *  Allocates and initializes the data structures associated with a matrix.t  *  *  >>> Returned:uJ  *  A pointer to the matrix is returned cast into the form of a pointer toJ  *  a character.  This pointer is then passed and used by the other matrixK  *  routines to refer to a particular matrix.  If an error ocurrs, the NULL_  *  pointer is returned.  *  *  >>> Arguments:  *  Size  <input>  (int)  *     Size of matrix.    *  Complex  <input>  (int)cJ  *     Type of matrix.  If Complex is 0 then the matrix is real, otherwiseL  *     the matrix will be complex.  Note that if the routines are not set upM  *     to handle the type of matrix requested, then a RANGE error will occur._  *  lError  <output>  (int *) M  *     Returns error flag, needed because function MatrixError will not work rP  *     correctly if AllocateMatrix returns NULL. Local version of Matrix->Error,  *     as denoted by l prefix. n  *  *  >>> Local variables:  *  Matrix  (MatrixPointer)+N  *     Local version of gMatrix.  A pointer to the matrix frame being created.  *  *  >>> Global variables:r  *  gMatrix  <set>  *  *  >>> Possible errors:
  *  NO_MEMORYr	  *  RANGEa'  *  Error is cleared in this procedure._  */p     /* Allocation Declarations. */ char  *malloc(); char  *calloc();     char*  i& AllocateMatrix (Size, Complex, lError)   int  Size, *lError;  BOOLEAN  Complex;s   {a  register  unsigned  SizePlusOne;  register  MatrixPointer  Matrix; register  int  I;p  m /* Begin. */ /* Clear error flag. */      *lError = NO_ERROR;-   /* Test for valid size. */5     if ((Size <= 1) OR (Size >= MAX_MATRIX_SIZE - 1))      {   *lError = RANGE;         return( NULL );m     }r   /* Test for valid type. */ #if (NOT COMPLEX)i     if (Complex) e     {   *lError = RANGE;         return( NULL );l     }  #endif #if (NOT REAL)     if (NOT Complex) (     {   *lError = RANGE;         return( NULL );;     }e #endif   /* Create Matrix. */'     SizePlusOne = (unsigned)(Size + 1);b  P     if ((Matrix = (MatrixPointer)malloc(sizeof( struct MatrixFrame ))) == NULL )     {   *lError = NO_MEMORY;         return( NULL );(     }l  a /* Initialize matrix */"     gMatrix = Matrix;      Matrix->Error = *lError;     Matrix->FirstTime = TRUE;      Matrix->Decomposed = FALSE;u     Matrix->Size = Size;     Matrix->Complex = Complex;     Matrix->RowsLinked = FALSE;*     Matrix->FillIns = 0;     Matrix->Growth = 0.0; '     Matrix->TopOfAllocationList = NULL; !     Matrix->RecordsRemaining = 0; "     Matrix->ElementsRemaining = 0;!     Matrix->FillInsRemaining = 0;u)     Matrix->InitialDecompStarted = FALSE;.  %     RecordAllocation((char *)Matrix); #     if (Matrix->Error == NO_MEMORY)e         goto MemoryError;   > /* Allocate space in memory for ColEliminationOrder vector. */G     if (( Matrix->ColEliminationOrder = (EliminationOrderVector)malloc(SP                                             SizePlusOne * sizeof(int))) == NULL)         goto MemoryError;   :     RecordAllocation((char *)Matrix->ColEliminationOrder);#     if (Matrix->Error == NO_MEMORY)          goto MemoryError;a  7 /* Allocate space in memory for Diag pointer vector. */ D     if (( Matrix->Diag = (ElementPointerVector)calloc( SizePlusOne, P                                                sizeof(ElementPointer))) == NULL)         goto MemoryError;c  +     RecordAllocation((char *)Matrix->Diag);v#     if (Matrix->Error == NO_MEMORY)e         goto MemoryError;*     = /* Allocate space in memory for FirstInCol pointer vector. */rH     if (( Matrix->FirstInCol = (ElementPointerVector)calloc(SizePlusOne,P                                                sizeof(ElementPointer))) == NULL)         goto MemoryError;   1     RecordAllocation((char *)Matrix->FirstInCol);o#     if (Matrix->Error == NO_MEMORY)          goto MemoryError;   = /* Allocate space in memory for FirstInRow pointer vector. */ I     if (( Matrix->FirstInRow = (ElementPointerVector)calloc(SizePlusOne, rP                                                sizeof(ElementPointer))) == NULL)         goto MemoryError;   1     RecordAllocation((char *)Matrix->FirstInRow);(#     if (Matrix->Error == NO_MEMORY)          goto MemoryError;   > /* Allocate space in memory for RowEliminationOrder vector. */G     if (( Matrix->RowEliminationOrder = (EliminationOrderVector)malloc(UP                                             SizePlusOne * sizeof(int))) == NULL)         goto MemoryError;L  :     RecordAllocation((char *)Matrix->RowEliminationOrder);#     if (Matrix->Error == NO_MEMORY)M         goto MemoryError;o  * /* Initialize EliminationOrder vectors. */     for (I = 1; I <= Size; I++) +     {   Matrix->RowEliminationOrder[I] = I; +         Matrix->ColEliminationOrder[I] = I;x     }   > /* Allocate space for fill-ins and initial set of elements. */O     InitializeElementBlocks( SPACE_FOR_ELEMENTS*Size, SPACE_FOR_FILL_INS*Size);>#     if (Matrix->Error == NO_MEMORY)l         goto MemoryError;h       return( (char*)Matrix );   MemoryError:  J /* Dealocate matrix and return no pointer to matrix if there is not enough
    memory. */n     Matrix->Error = NO_MEMORY;     *lError = NO_MEMORY;     DeallocateMatrix(Matrix);r     return( NULL );( }r                 O /*  *  ELEMENT ALLOCATION    *N  *  This routine allocates space for matrix elements. It requests large blocksM  *  of storage from the system and doles out individual elements as required. L  *  This technique, as opposed to allocating elements indivdually, tends to !  *  speed the allocation process.(  *  *  >>> Returned:n  *  A pointer to an elemnt.>  *  *  >>> Local variables:  *  pElement  (ElementPointer)O  *     A pointer to the first element in the group of elements being allocated.P  *  *  >>> Global variables:e  *  gMatrix  <used>   *  *  >>> Possible errors:
  *  NO_MEMORYi  */)   ElementPointer GetElement()   {* ElementPointer  pElement;o   /* Begin. */  (     if (gMatrix->ElementsRemaining == 0)  ' /* Allocate block of MatrixElements. */ H     {   if ((pElement = (ElementPointer)malloc(ELEMENTS_PER_ALLOCATION *O                                         sizeof(struct MatrixElement))) == NULL)o'         {   gMatrix->Error = NO_MEMORY;x             return(NULL);e	         }t  +         RecordAllocation((char *)pElement); (         if (gMatrix->Error == NO_MEMORY)             return(NULL); =         gMatrix->ElementsRemaining = ELEMENTS_PER_ALLOCATION; -         gMatrix->NextAvailElement = pElement;      }e  ; /* Update Element counter and return pointer to Element. */ !     gMatrix->ElementsRemaining--;T*     return(gMatrix->NextAvailElement++);     }s               t /*&  *  ELEMENT ALLOCATION INITIALIZATION   *K  *  This routine allocates space for matrix fill-ins and an initial set of  K  *  elements.  Besides being faster than allocating space for elements one tK  *  at a time, it tends to keep the fill-ins physically close to the other nN  *  matrix elements in the computer memory.  This keeps virtual memory paging   *  to a minimum.o  *  *  >>> Arguments:"  *  InitialNumberOfElements  (int)B  *     This number is used as the size of the block of memory, in J  *     MatrixElements, reserved for elements. If more than this number of D  *     elements are generated, then more space is allocated later.  #  *  NumberOfFillInsExpected  (int) fB  *     This number is used as the size of the block of memory, in J  *     MatrixElements, reserved for fill-ins. If more than this number of I  *     fill-ins are generated, then more space is allocated, but they may 5  *     not be physically close in computer's memory. I  *  *  >>> Local variables:  *  pElement  (ElementPointer)O  *     A pointer to the first element in the group of elements being allocated.o  *  *  Global variables:d  *  gMatrix  <used>t  *  *  >>> Possible errors:  *  NO_MEMORY   */O   static2 InitializeElementBlocks( InitialNumberOfElements, 3                          NumberOfFillInsExpected ) *  8 int  InitialNumberOfElements, NumberOfFillInsExpected;     {t ElementPointer  pElement;o   /* Begin. */4 /* Allocate block of MatrixElements for elements. */N     if ((pElement = (ElementPointer)malloc((unsigned)InitialNumberOfElements *O                                         sizeof(struct MatrixElement))) == NULL)b#     {   gMatrix->Error = NO_MEMORY;          return;b     }r  9     gMatrix->ElementsRemaining = InitialNumberOfElements;*'     RecordAllocation((char *)pElement); $     if (gMatrix->Error == NO_MEMORY)         return;l)     gMatrix->NextAvailElement = pElement;   4 /* Allocate block of MatrixElements for fill-ins. */N     if ((pElement = (ElementPointer)malloc((unsigned)NumberOfFillInsExpected *O                                         sizeof(struct MatrixElement))) == NULL) #     {   gMatrix->Error = NO_MEMORY;n         return;)     }   8     gMatrix->FillInsRemaining = NumberOfFillInsExpected;'     RecordAllocation((char *)pElement);=$     if (gMatrix->Error == NO_MEMORY)         return;l(     gMatrix->NextAvailFillIn = pElement;       return;n }e                   n /*  *  FILL-IN ALLOCATION    *N  *  This routine allocates space for matrix fill-ins. It requests large blocksM  *  of storage from the system and doles out individual elements as required.fL  *  This technique, as opposed to allocating elements indivdually, tends to !  *  speed the allocation process.s  *  *  >>> Returned:i  *  A pointer to the fill-in.y  *  *  >>> Global variables:*  *  gMatrix  <used>t  *  *  >>> Possible errors:
  *  NO_MEMORYy  */n   ElementPointer   GetFillIn()>   {u ElementPointer GetElement();   /* Begin. */'     if (gMatrix->FillInsRemaining == 0)h          return ( GetElement() );     else  ; /* Update Fill-in counter and return pointer to Fill-in. */e      gMatrix->FillInsRemaining--;)     return(gMatrix->NextAvailFillIn++);  l }E                 * /*  *  RECORD A MEMORY ALLOCATION  *M  *  This routine is used to record all memory allocations so that the memory    *  can be freed later.   *  *  >>> Arguments:#  *  AllocatedPtr  <input>  (char *)tM  *     The pointer returned by malloc or calloc.  These pointers are saved ino/  *     a list so that they can be easily freed.*  *  *  >>> Global variables:m  *  gMatrix  <used>l  *  *  >>> Possible errors:
  *  NO_MEMORYa  */d   static  RecordAllocation( AllocatedPtr )   char  *AllocatedPtr; {*   /* Begin. */'     if (gMatrix->RecordsRemaining == 0)n  ' /* Allocate block of MatrixElements. */ (     {   AllocateBlockOfAllocationList();(         if (gMatrix->Error == NO_MEMORY)         {   free(AllocatedPtr);              return;i	         }N     }   / /* Add Allocated pointer to Allocation List. */hB     (++gMatrix->TopOfAllocationList)->AllocatedPtr = AllocatedPtr;      gMatrix->RecordsRemaining--;     return;n   }r               i /*,  *  ADD A BLOCK OF SLOTS TO ALLOCATION LIST	  *;  *  This routine increases the size of the allocation list.   *  *  >>> Local variables:   *  ListPtr  (AllocationListPtr)K  *     Pointer to the list that contains the pointers to segments of memoryOL  *     that were allocated by the operating system for the current matrix.    *    *  >>> Global variables:o  *  gMatrix  <used>1  *  *  >>> Possible errors:
  *  NO_MEMORYa  */r   static AllocateBlockOfAllocationList()n   {[ register  int  I; % register  AllocationListPtr  ListPtr;i   /* Begin. */4 /* Allocate block of records for allocation list. */L     if ((ListPtr = (AllocationListPtr)malloc((ELEMENTS_PER_ALLOCATION + 1) *P                                       sizeof(struct AllocationRecord))) == NULL)#     {   gMatrix->Error = NO_MEMORY;m         return;      }u  M /* String entries of allocation list into singly linked list.  List is linked 7    such that any record points to the one before it. */   7     ListPtr->NextRecord = gMatrix->TopOfAllocationList;r+     gMatrix->TopOfAllocationList = ListPtr;t'     ListPtr += ELEMENTS_PER_ALLOCATION;f1     for (I = ELEMENTS_PER_ALLOCATION; I > 0; I--)s+     {    ListPtr->NextRecord = ListPtr - 1;           ListPtr--;e     }   H /* Record allocation of space for allocation list on allocation list. */A     gMatrix->TopOfAllocationList->AllocatedPtr = (char *)ListPtr;c8     gMatrix->RecordsRemaining = ELEMENTS_PER_ALLOCATION;       return;  }                r /*  *  MATRIX DE-ALLOCATION  *1  *  De-allocates pointers and elements of Matrix.r  *  *  >>> Arguments:  *  Matrix  <input>  (char *)iF  *     Pointer to the matrix frame which is to be removed from memory.  *  *  >>> Local veriables:   *  ListPtr  (AllocationListPtr)M  *     Pointer into the linked list of pointers to allocated data structures.e2  *     Points to pointer to structure to be freed.$  *  NextListPtr  (AllocationListPtr)M  *     Pointer into the linked list of pointers to allocated data structures.*K  *     Points to the next pointer to structure to be freed.  This is needed L  *     because the data structure to be freed could include the current node  *     in the allocation list.  */e   DeallocateMatrix (Matrix)    /* PARAMETER DECLARATIONS */ register MatrixPointer  Matrix;t {  /* VARIABLE DECLARATIONS */ ) register  AllocationListPtr  ListPtr    ; ) register  AllocationListPtr  NextListPtr;A     /* BODY OF FUNCTION */4 /* Deallocate Markowitz and Intermediate vectors. */  -     if (Matrix->InitialDecompStarted == TRUE) -     {   free( (char *)Matrix->MarkowitzRow );s-         free( (char *)Matrix->MarkowitzCol );i.         free( (char *)Matrix->MarkowitzProd );1         free( (char *)Matrix->IntermediateReal );a     }i  L /* Sequentially step through the list of allocated pointers freeing pointers  * along the way. */     *     ListPtr = Matrix->TopOfAllocationList;     while (ListPtr != NULL) *     {   NextListPtr = ListPtr->NextRecord;&         free( ListPtr->AllocatedPtr );         ListPtr = NextListPtr;     }      gMatrix = NULL;s     return;B   }                  c /*  *  RETURN MATRIX ERROR STATUS  *L  *  This function is used to determine the error status of the given matrix.  *  *  >>> Arguments:  *  Matrix  <input>  (char *)a8  *     The matrix for which the error status is desired.  */    MatrixError( Matrix )     register  MatrixPointer  Matrix; {t   /* Begin. */     if (Matrix != NULL)          return(Matrix->Error);     elseL         return(NO_MEMORY);   /* This error may actually be RANGE, no way to )                                 tell. */   }i                 E /*  *  CLEAR MATRIX ERROR FLAGE  *H  *  This function is used to clear the error status of the given matrix.  *  *  >>> Arguments:  *  Matrix  <input>  (char *)o>  *     The matrix for which the error status is to be cleared.  */f   ClearMatrixError( Matrix )    register  MatrixPointer  Matrix; {s      /* Begin. */     if (Matrix != NULL)e!         Matrix->Error = NO_ERROR;*   }R  