 /*  *  MATRIX BUILD MODULEL  *O  *  This module contains the routines to build the matrix for the sparse matrixe  *  routines for real matrices.e  *  *  Author:   *     Kenneth S. KundertT  *     UC Berkeley  *  *  Advising professor: &  *     Alberto Sangiovanni-Vincentelli  *;  *  >>> User accessable functions contained in this module:   *  ClearMatrixL  *  AddElementToMatrix  *  AddAdmittanceToMatrixL  *  AddRealQuadElementToMatrix  *  AddImagQuadElementToMatrix!  *  AddComplexQuadElementToMatrix=  *  PreorderForModifiedNodal  *  ScaleRealMatrixh  *  ScaleComplexMatrix  *+  *  >>> Functions contained in this module:   *  ClearMatrixA  *  AddElementToMatrix  *  FindElementInCol  *  AddAdmittanceToMatrixi  *  AddRealQuadElementToMatrix  *  AddImagQuadElementToMatrix!  *  AddComplexQuadElementToMatrix   *  CreateElement   *  LinkRows  *  PreorderForModifiedNodal  *  ScaleRealMatrix-  *  ScaleComplexMatrix  */                    /*  *  IMPORTSI  *  *  >>> Import decriptions:c  *  stdio.ho  *     Standard C IO library.=  *  MtrxPers.h8  *     Macros that customize the sparse matrix routines.  *  MtrxExpt.h:  *     Macros and declarations to be imported by the user.  *  MtrxDefs.hH  *     Matrix type and macro definitions for the sparse matrix routines.  *  MtrxError.h*&  *     Matrix error macro definitions.  */d  d #include <stdio.h> #include "MtrxPers.h"q #include "MtrxExpt.h"a #include "MtrxDefs.h"l #include "MtrxError.h"           n /*  *  CLEAR MATRIX    */  *  Clears every element of the matrix to zero.>  *  *  >>> Arguments:  *  Matrix  <input>  (char *) /  *     Pointer to matrix that is to be cleared.P  *  *  >>> Local variables:  *  Size  (int)tJ  *     The size of the matrix.  Local version of gMatrix->Size.  Placed in  *     register for speed.  *  pElement  (ElementPointer).  *     A pointer to the element being cleared.  */-  l ClearMatrix( Matrix )e    register  MatrixPointer  Matrix;   {  register  int  Size, I;*# register  ElementPointer  pElement;    /* Begin. */" /* Test for nonexistant matrix. */     if (Matrix == NULL)m         return;    /* Clear matrix. */i     Size = Matrix->Size;     Matrix->Decomposed = FALSE;l  
 #if (COMPLEX)o     if (Matrix->Complex)     {   for (I=1; I<=Size; I++)t-         {   pElement = Matrix->FirstInCol[I];i$             while (pElement != NULL)%             {   pElement->Real = 0.0; %                 pElement->Imag = 0.0; /                 pElement = pElement->NextInCol; 
             }e	         }t     }      else #endif     {   for (I=1; I<=Size; I++)i-         {   pElement = Matrix->FirstInCol[I];x$             while (pElement != NULL)%             {   pElement->Real = 0.0; /                 pElement = pElement->NextInCol;a
             }s	         }      }r       return;t }                      B /*/  *  SINGLE ELEMENT ADDITION TO MATRIX BY INDEX m  *O  *  Finds element [Row,Col] and adds Data to it.  If element is not found then cL  *  it is created and spliced into matrix.  This routine is only to be used M  *  after AllocateMatrix and before PreorderForModifiedNodal, DecomposeMatrix>L  *  or OrderAndDecomposeMatrix.  Returns a pointer to the Real portion of a J  *  MatrixElement. This pointer is later used by ADD_ELEMENT_TO_MATRIX to   *  directly access element.  *  *  >>> Returns:L  *  Returns a pointer to the element.  This pointer is then used to directly/  *  access the element during sucessive builds.   *  *  >>> Arguments:$  *  Matrix  <input>  (MatrixPointer)A  *     Pointer to the matrix that the element is to be added to.    *  Row  <input>  (int)a  *     Row index for element.   *  Col  <input>  (int)r!  *     Column index for element. m  *  Real  <input>  (double)t)  *     Real data to be added to element.    *  Imag  <input>  (double) J  *     Imaginary data to be added to element.  If the matrix is real, then'  *     this parameter is not necessary.E  *  *  >>> Local variables:  *  pElement  (double *)!  *     Pointer to the element.   e  *  *  >>>Global variables:  *  gMatrix  <set>  *  *  >>> Possible errors:
  *  NO_MEMORYd	  *  RANGE *  *  Error is not cleared in this routine.   */r   double *2 AddElementToMatrix( Matrix, Row, Col, Real, Imag )  k  register  MatrixPointer  Matrix; int  Row, Col; double  Real, Imag;l    {  register  double  *pElement;" ElementPointer FindElementInCol();   /* Begin. */     gMatrix = Matrix;*   #if (DEBUG)T /* Test for possible errors. */oO     if ((Row < 1) OR (Row > Matrix->Size) OR (Col < 1) OR (Col > Matrix->Size) tP                                                      OR (NOT Matrix->FirstTime))     {   gMatrix->Error = RANGE;i         return(NULL);i     }; #endif  O /* The condition part of the following if statement tests to see if the element M  * resides along the diagonal, if it does then it tests to see if the element K  * has been created yet (Diag pointer not NULL). The pointer to the element K  * is then assigned to Element after it is cast into a pointer to a double. L  * This casting makes the pointer into a pointer to the Real. This statementI  * depends on the fact that Real is the first record in the MatrixElementl  * structure. */  K     if ((Row != Col) OR ((pElement = (double *)Matrix->Diag[Row]) == NULL))-     {  l? /* Element does not exist or does not reside along diagonal. */     /* Search column for element. */M /* As in the if statement above, the pointer to the element which is returnedtC  * by FindElementInCol is cast into a pointer to Real, a double. */e  V         pElement = (double*)FindElementInCol(&(Matrix->FirstInCol[Col]),Row,Col,TRUE);     }M  ! /* Add Data to element. */       r     *pElement += Real;
 #if (COMPLEX)i     if (Matrix->Complex)3         ADD_IMAG_ELEMENT_TO_MATRIX (pElement,Imag);y #endif       return(pElement);i }t                       /*$  *  FIND ELEMENT BY SEARCHING COLUMN  *O  *  Searches column starting at element specified at PtrAddr and finds element uJ  *  in Row. If Element does not exists, it is created. The pointer to the   *  element is returned.  *  *  >>> Returned: %  *  A pointer to the desired element:   *  *  >>> Arguments:0  *  LastAddr  <input-output>  (ElementPointer *)O  *     Address of pointer that initially points to the element in Col at which aN  *     the search is started.  The pointer in this location may be changed if K  *     a fill-in is required in and ajacent element. For this reason it is cL  *     important that LastAddr be the address of a FirstInCol or a NextInCol)  *     rather than a temporary variable. a  *  Row  <input>  (int)e  *     Row being searched for.    *  Col  (int)  *     Column being searched. '  *  CreateIfMissing  <input>  (BOOLEAN) L  *     Indicates what to do if element is not found, create one or return a   *     NULL pointer. o  *  *  Local variables:  *  pElement  (ElementPointer)-  *     Pointer used to search through matrix.B  */    ElementPointer  5 FindElementInCol(LastAddr, Row, Col, CreateIfMissing)o  $ register ElementPointer *LastAddr;   register int  Row;	 int  Col;i BOOLEAN  CreateIfMissing;N   { # register  ElementPointer  pElement;x  ElementPointer  CreateElement();   /* Begin. */     pElement = *LastAddr;*   /* Search for element. */d     while (pElement != NULL)      {   if (pElement->Row < Row)	         {*# /* Have not reached element yet. */C.             LastAddr = &(pElement->NextInCol);+             pElement = pElement->NextInCol;*	         }M&         else if (pElement->Row == Row)	         {  /* Reached element. */             return(pElement);c	         }.%         else break;  /* while loop */      }s  1 /* Element does not exist and must be created. */u     if (CreateIfMissing)2        return (CreateElement(Row, Col, LastAddr));     else return(NULL); }                  c #if (QUAD_ELEMENT) /*-  *  ADDITION OF ADMITTANCE TO MATRIX BY INDEX   *P  *  Performs same function as AddElementToMatrix except rather than one element,N  *  all four Matrix elements for a floating component are added.  This routineJ  *  also works if component is grounded.  Positive elements are placed at L  *  [Node1,Node2] and [Node2,Node1].  This routine is only to be used after J  *  AllocateMatrix and before PreorderForModifiedNodal, MatrixDecompose or  *  OrderAndDecomposeMatrix.  *  *  >>> Arguments:$  *  Matrix  <input>  (MatrixPointer)@  *     Pointer to the matrix that component is to be entered in.  *  Node1  <input>  (int)l,  *     Row and column indices for elements.   *  Node2  <input>  (int)i,  *     Row and column indices for elements. *  *  Template  <output>  (TemplateStruct *)O  *     Collection of pointers to four elements that are later used to directly EK  *     address elements.  User must supply the template, this routine will r  *     fill it.g  *  Real  <input>  (double) *  *     Real data to be added to elements.   *  Imag  <input>  (double)sK  *     Imag data to be added to elements.  If matrix is real, this argumentt  *     may be deleted.    *  *  >>> Local variables:  *  Pointer  (double *)r-  *     A pointer to an element in the matrix.o  *  AnotherPointer  (double *)A  *     A pointer to an element in the matrix.  One is not enough.   *  *  Global variables:u  *  gMatrix  <set>  *  *  Possible errors:
  *  NO_MEMORY 	  *  RANGEt*  *  Error is not cleared in this routine.   */*  - AddAdmittanceToMatrix( Matrix, Node1, Node2, ),                       Template, Real, Imag )     register  MatrixPointer  Matrix; int  Node1, Node2;, register  struct  TemplateStruct  *Template; double  Real, Imag;    {t register  double   *Pointer;# register  double   *AnotherPointer;r" ElementPointer  GetElementInCol();   /* Begin. */ /* Diagonal elements. */       gMatrix = Matrix;r   #if (DEBUG)  /* Test for possible errors. */mL     if ((NOT Matrix->FirstTime) OR (Node1 < 0) OR (Node1 > Matrix->Size) OR I                                    (Node2 < 0) OR (Node2 > Matrix->Size))      {   gMatrix->Error = RANGE;l         return(NULL);      }  #endif  /     if (Node1 > Node2) SWAP(int, Node1, Node2);      if (Node1 == 0)l     {c, /* Addition of a non-floating component. */ >         if ((Pointer = (double *)Matrix->Diag[Node2]) == NULL)L             Pointer = (double *)FindElementInCol(&Matrix->FirstInCol[Node2],O                                                              Node2,Node2,TRUE);          *Pointer += Real;A
 #if (COMPLEX)          if (Matrix->Complex)6             ADD_IMAG_ELEMENT_TO_MATRIX (Pointer,Imag); #endif  %         Template->Element1 = Pointer;n"         Template->Element2 = NULL;)         Template->Element3Negated = NULL;e)         Template->Element4Negated = NULL;      }                         else     {e( /* Addition of a floating component. */ ! /* Left-most diagonal element. */e>         if ((Pointer = (double *)Matrix->Diag[Node1]) == NULL)L             Pointer = (double *)FindElementInCol(&Matrix->FirstInCol[Node1],O                                                              Node1,Node1,TRUE);i%         Template->Element1 = Pointer;          *Pointer += Real;m  / /* Element below left-most diagonal element. */T,         Pointer = (double*)FindElementInCol(P                                         &(((ElementPointer)Pointer)->NextInCol),O                                                              Node2,Node1,TRUE);p,         Template->Element3Negated = Pointer;         *Pointer -= Real;p  0 /* Element above right-most diagonal element. */H         Pointer = (double *)FindElementInCol(&Matrix->FirstInCol[Node2],O                                                              Node1,Node2,TRUE);a,         Template->Element4Negated = Pointer;         *Pointer -= Real;   " /* Right-most diagonal element. */E         if ((AnotherPointer = (double *)Matrix->Diag[Node2]) == NULL)E8             AnotherPointer = (double *)FindElementInCol(P                                         &(((ElementPointer)Pointer)->NextInCol),P                                                               Node2,Node2,TRUE);,         Template->Element2 = AnotherPointer;          *AnotherPointer += Real;  
 #if (COMPLEX)          if (Matrix->Complex)A         {   ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element1,Imag);d=             ADD_IMAG_ELEMENT_TO_MATRIX (AnotherPointer,Imag);LI             ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element3Negated,-Imag);tI             ADD_IMAG_ELEMENT_TO_MATRIX (Template->Element4Negated,-Imag); 	         }E #endif       }      return;* }e #endif   /* QUAD_ELEMENT */m                     r #if (QUAD_ELEMENT) /*9  *  QUADRUPLE REAL ELEMENT ADDITION TO MATRIX BY POINTER i  *>  *  Adds Data to four real elements specified by the Template.  *  *  >>> Arguments:)  *  Template  <input>  (TemplateStruct *)t;  *     Pointer to the group of pointers to four elements.  o  *  Real  <input>  (double)o*  *     Real data to be added to elements.   *  *  >>> Local variables:  *  pElement  (double *)$  *     Pointer to element in matrix.  */   - AddRealQuadElementToMatrix( Template, Real )    , register  struct  TemplateStruct  *Template;
 double  Real;N /* VARIABLE DECLARATIONS */a {m register  double  *pElement;   /* Begin. */1     if ((pElement = Template->Element1) != NULL)  3         ADD_REAL_ELEMENT_TO_MATRIX (pElement,Real);s	          t1     if ((pElement = Template->Element2) != NULL)  3         ADD_REAL_ELEMENT_TO_MATRIX (pElement,Real);e                m8     if ((pElement = Template->Element3Negated) != NULL) 4         ADD_REAL_ELEMENT_TO_MATRIX (pElement,-Real);	          ;8     if ((pElement = Template->Element4Negated) != NULL) 4         ADD_REAL_ELEMENT_TO_MATRIX (pElement,-Real);	          m     return;  }    #endif   /* QUAD_ELEMENT */n                       #if (QUAD_ELEMENT AND COMPLEX) /*=  *  QUADRUPLE IMAGINARY ELEMENT ADDITION TO MATRIX BY POINTER   *C  *  Adds data to four imaginary elements specified by the Template.e  *  *  >>> Arguments:)  *  Template  <input>  (TemplateStruct *)g;  *     Pointer to the group of pointers to four elements.  d  *  Imag  <input>  (double)C/  *     Imaginary data to be added to elements.    *  *  >>> Local variables:  *  pElement  (double *)$  *     Pointer to element in matrix.  */P      -- AddImagQuadElementToMatrix( Template, Imag )    , register  struct  TemplateStruct  *Template;
 double  Imag;    {E register  double  *pElement;   /* Begin. */1     if ((pElement = Template->Element1) != NULL)  3         ADD_IMAG_ELEMENT_TO_MATRIX (pElement,Imag); 	           1     if ((pElement = Template->Element2) != NULL) ,3         ADD_IMAG_ELEMENT_TO_MATRIX (pElement,Imag);                 o8     if ((pElement = Template->Element3Negated) != NULL) 4         ADD_IMAG_ELEMENT_TO_MATRIX (pElement,-Imag);	          I8     if ((pElement = Template->Element4Negated) != NULL) 4         ADD_IMAG_ELEMENT_TO_MATRIX (pElement,-Imag);	          l     return;,   })' #endif   /* QUAD_ELEMENT AND COMPLEX */X                     a #if (QUAD_ELEMENT AND COMPLEX) /*;  *  QUADRUPLE COMPLEX ELEMENT ADDITION TO MATRIX BY POINTER   *A  *  Adds Data to four complex elements specified by the Template.D  *  *  >>> Arguments:)  *  Template  <input>  (TemplateStruct *)t;  *     Pointer to the group of pointers to four elements.  p  *  Real  <input>  (double)t*  *     Real data to be added to elements.   *  Imag  <input>  (double)e/  *     Imaginary data to be added to elements. d  *  *  >>> Local variables:  *  pElement  (double *)$  *     Pointer to element in matrix.  */   ) AddComplexQuadElementToMatrix( Template, x)                             Real, Imag ) e  , register  struct  TemplateStruct  *Template; double  Real, Imag;a   {  register  double  *pElement;   /* Begin. */1     if ((pElement = Template->Element1) != NULL)  9         ADD_CMPLX_ELEMENT_TO_MATRIX (pElement,Real,Imag); 	          f1     if ((pElement = Template->Element2) != NULL)  9         ADD_CMPLX_ELEMENT_TO_MATRIX (pElement,Real,Imag);                 l8     if ((pElement = Template->Element3Negated) != NULL) ;         ADD_CMPLX_ELEMENT_TO_MATRIX (pElement,-Real,-Imag);(	           8     if ((pElement = Template->Element4Negated) != NULL) ;         ADD_CMPLX_ELEMENT_TO_MATRIX (pElement,-Real,-Imag);e	          P     return;m }P' #endif   /* QUAD_ELEMENT AND COMPLEX *//               m /*  *)  *  CREATE AND SPLICE ELEMENT INTO MATRIX   *O  *  This routine is used to create new matrix elements and splice them into theN  *  matrix.-  *  *  >>> Returned: :  *  A pointer to the element that was created is returned.  *  *  >>> Arguments:  *  Row  <input>  (int)u  *      Row index for element.  *  Col  <input>  (int)("  *      Column index for element. 0  *  LastAddr  <input-output>  (ElementPointer *)O  *      This contains the address of the pointer to the element just above the  P  *      one being created. It is used to speed the search and it is updated with)  *      address of the created element.     *  *  >>> Local variables:  *  pElement  (ElementPointer)M  *      Pointer to an element in the matrix. It is used to refer to the newly(N  *      created element and to restring the pointers of the element's row and   *      column.  ;"  *  pLastElement  (ElementPointer)N  *      Pointer to the element in the matrix that was just previously pointed M  *      to by pElement. It is used to restring the pointers of the element's o  *      row and column.  f%  *  pCreatedElement  (ElementPointer)eF  *      Pointer to the desired element, the one that was just created.  *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:  *  NO_MEMORY   */    ElementPointer n$ CreateElement( Row, Col, LastAddr )    register int  Col;# register ElementPointer  *LastAddr;n	 int  Row;e  f {/1 register  ElementPointer  pElement, pLastElement;A  ElementPointer  pCreatedElement; ElementPointer  GetElement();I ElementPointer  GetFillIn();    d /* Begin. */F /* If decomposition has started then a fill-in is needed, otherwise, a   * regular element is needed. */     if (gMatrix->RowsLinked)     {u" /* Allocate memory for Fill-in. */         pElement = GetFillIn();          gMatrix->FillIns++; (         if (gMatrix->Error == NO_MEMORY)             return (NULL);  7 /* If element is on diagonal, store pointer in Diag. */n     if (Row == Col) &         gMatrix->Diag[Row] = pElement;   /* Initialize Element. */ #         pCreatedElement = pElement;=         pElement->Row = Row;         pElement->Col = Col;         pElement->Real = 0.0; 
 #if (COMPLEX)          pElement->Imag = 0.0;U #endif  " /* Splice element into column. */ (         pElement->NextInCol = *LastAddr;         *LastAddr = pElement;e  /  /* Search row for proper element position. */ I,         pElement = gMatrix->FirstInRow[Row];         pLastElement = NULL;          while (pElement != NULL)	         { ' /* Search for element row position. */ T$             if (pElement->Col < Col)
             {i( /* Have not reached desired element. */ (                 pLastElement = pElement;/                 pElement = pElement->NextInRow;.
             }r!             else pElement = NULL; 	         }    /* Splice element into row. */ >#         pElement = pCreatedElement;e!         if (pLastElement == NULL)>	         {o /* Element is first in row. */ h;             pElement->NextInRow = gMatrix->FirstInRow[Row]; 0             gMatrix->FirstInRow[Row] = pElement;	         }i
         else  " /* Element is not first in row. */	         { :             pElement->NextInRow = pLastElement->NextInRow;/             pLastElement->NextInRow = pElement;u	         }r       }e     else     {aM /* Matrix has not been decomposed yet.  Thus get element rather than fill-in.u(  * Also, row pointers can be ignored. */  " /* Allocate memory for Element. */          pElement = GetElement();(         if (gMatrix->Error == NO_MEMORY)             return (NULL);  7 /* If element is on diagonal, store pointer in Diag. */d     if (Row == Col)t&         gMatrix->Diag[Row] = pElement;   /* Initialize Element. */r#         pCreatedElement = pElement;          pElement->Row = Row;         pElement->Real = 0.0;M
 #if (COMPLEX)          pElement->Imag = 0.0;( #endif  " /* Splice element into column. */ (         pElement->NextInCol = *LastAddr;         *LastAddr = pElement;n     }r       return(pCreatedElement); }P               l /*  *  *  LINK ROWS   *J  *  This routine is used to generate the row links.  The Add_____ToMatrix N  *  routines do not create row links, which are needed by the DecomposeMatrix   *  routines.  f  *  *  >>> Local variables:   *  pElement  (ElementPointer)  ,  *      Pointer to an element in the matrix.)  *  FirstInRowEntry  (ElementPointer *)  EL  *      A pointer into the FirstInRow array.  Points to the FirstInRow entry&  *      currently being operated upon.,  *  FirstInRowArray  (ElementPointerVector) K  *      A pointer to the FirstInRow array.  Same as gMatrix->FirstInRow butmK  *      resides in a register and requires less indirection so is faster to   *      use.  *  Col  (int)-  *      Column currently being operated upon.n  *  *  >>>  Global variables:  *  gMatrix  <used>E  */T   LinkRows() e   {I5 register  ElementPointer  pElement, *FirstInRowEntry;>0 register  ElementPointerVector  FirstInRowArray; register  int  Col;t   /* Begin. */*     FirstInRowArray = gMatrix->FirstInRow;.     for (Col = gMatrix->Size; Col >= 1; Col--)     {(? /* Generate row links for the elements in the Col'th column. */D,         pElement = gMatrix->FirstInCol[Col];            while (pElement != NULL)          {   pElement->Col = Col;>             FirstInRowEntry = &FirstInRowArray[pElement->Row];3             pElement->NextInRow = *FirstInRowEntry;r(             *FirstInRowEntry = pElement;+             pElement = pElement->NextInCol;i	         }u     }n     gMatrix->RowsLinked = TRUE;e     return;a }a                   m /*J  *  PREORDER MODIFIED NODE ADMITTANCE MATRIX TO REMOVE ZEROS FROM DIAGONAL  *P  *  This routine massages modified node admittance matrices to remove zeros fromJ  *  the diagonal.  It takes advantage of the fact that the row and column H  *  associated with a zero diagonal usually have structural ones placed O  *  symmetricly.  This routine should be used only on modified node admittance oO  *  matrices and should be executed after the matrix has been built but before aE  *  the decomposition begins.  It should be executed for the initial nO  *  decomposition only and should be executed before the matrix is scaled with  *  *  ScaleRealMatrix or ScaleComplexMatrix.  *P  *  This routine makes two passes through the matrix.  The first tries to removeN  *  singleton zeros from the diagonal, the second tries to remove nonsingletonO  *  zeros from the diagonal.  Two passes are needed because the act of removing H  *  nonsingleton zeros from the diagonal could move the structrual ones H  *  associated with a singleton zero so that they are no longer located   *  symmetricly in the matrix.  *  *  >>> Arguments:  *  Matrix  <input>  (char *) /  *      Pointer to the matrix to be preordered.>  *  *  >>> Local variables;  *  Col  (int)  *      Column of Original.   *  pDiag  (ElementPointer *)s?  *      Pointer used to sequentially step through Diag vector. r  *  lSize  (int)2  *      Local version of the size of the matrix.    *  pOriginal  (ElementPointer)rL  *      Pointer to structural one found in the column belonging to the zero   *      diagonal.  o  *  Row  (int)  *      Row of Original. e!  *  SecondPassRequired  (BOOLEAN)rB  *      Flag indicating that a nonsingleton zero diagonal exists.   *  StartAt  (int)O  *      Column number of first nonsingleton zero diagonal.  Second pass starts i  *      at this diagonal.  t  *  pTwin  (ElementPointer)rI  *      Pointer to structural one found in the row belonging to the zero    *      diagonal.  a  */M    # PreorderForModifiedNodal( Matrix ) x    register  MatrixPointer  Matrix;   {r #if (MODIFIED_NODAL)  3 register  ElementPointer  *pDiag, pOriginal, pTwin;g register  int  Col, lSize; int  Row, StartAt; BOOLEAN  SecondPassRequired;   /* Begin. */     lSize = Matrix->Size;r     SecondPassRequired = FALSE;w     pDiag= &Matrix->Diag[1];                     H /* First pass, looking for singletons associated with zero diagonals. */' /* Search for zeros on the diagonal. */ &     for (Col = 1; Col <= lSize; Col++)     {a         if (*pDiag++ == NULL) 	         {D2 /* Zero diagonal found; now test for singleton. */0             pOriginal = Matrix->FirstInCol[Col];-             if (pOriginal->NextInCol == NULL) 
             {I /* Singleton found. */0                 if (ABS(pOriginal->Real) == 1.0))                 {   Row = pOriginal->Row;n4                     pTwin = Matrix->FirstInCol[Row];C                     while ((pTwin != NULL) AND (pTwin->Row != Col))e1                         pTwin = pTwin->NextInCol; F                     if ((pTwin != NULL) AND (ABS(pTwin->Real) == 1.0))                     {a' /* Accept Twin; interchange columns. */sF                         SWAP (ElementPointer, Matrix->FirstInCol[Col],G                                               Matrix->FirstInCol[Row]); D                         SWAP (int, Matrix->ColEliminationOrder[Col],E                                    Matrix->ColEliminationOrder[Row]);>6                         Matrix->Diag[Row] = pOriginal;2                         Matrix->Diag[Col] = pTwin;                     }/                 }(
             }              else
             {  /* Not singleton. */0                 if (SecondPassRequired == FALSE).                 {   SecondPassRequired = TRUE;"                     StartAt = Col;                 } 
             }S	         }n     }r     if (SecondPassRequired)p     {E  L /* Second pass, looking for nonsingletons associated with zero diagonals. */'         pDiag = &Matrix->Diag[StartAt];o  ' /* Search for zeros on the diagonal. */ 0         for (Col = StartAt; Col <= lSize; Col++)	         {e!             if (*pDiag++ == NULL) 
             {  /* Zero diagonal found. */4                 pOriginal = Matrix->FirstInCol[Col];)                 while (pOriginal != NULL)                  { 4                     if (ABS(pOriginal->Real) == 1.0)-                     {   Row = pOriginal->Row;t8                         pTwin = Matrix->FirstInCol[Row];G                         while ((pTwin != NULL) AND (pTwin->Row != Col))M5                             pTwin = pTwin->NextInCol; J                         if ((pTwin != NULL) AND (ABS(pTwin->Real) == 1.0))                         {*' /* Accept Twin; interchange columns. */dJ                             SWAP (ElementPointer, Matrix->FirstInCol[Col],K                                                   Matrix->FirstInCol[Row]);lH                             SWAP (int, Matrix->ColEliminationOrder[Col],I                                        Matrix->ColEliminationOrder[Row]);t:                             Matrix->Diag[Row] = pOriginal;6                             Matrix->Diag[Col] = pTwin;6                             goto DoneWithThisDiagonal;                         }t                     } 5                     pOriginal = pOriginal->NextInCol;o                 }  DoneWithThisDiagonal:;
             } 	         }d     }u     return;    #endif  /* MODIFIED_NODAL */ }                    /*  *  SCALE REAL MATRIX   *P  *  This function scales the matrix to enhance the possibility of finding a goodI  *  pivoting order.  Note that scaling enhances accuracy of the solution cM  *  only if it affects the pivoting order, so it makes no sence to scale the rL  *  matrix before DecomposeMatrix.  If scaling is desired it should be done K  *  before OrderAndDecomposeMatrix.  There are several things to take into tK  *  account when choosing the scale factors.  First, the scale factors are rP  *  directly multiplied times the elements in the matrix.  To prevent roundoff, P  *  each scale factor should be equal to an integer power of the number base of P  *  the machine.  Since most machines operate in base two, scale factors should P  *  be a power of two.  Second, the matrix should be scaled such that the matrixO  *  of element uncertainties is equilibrated.  Third, this function multiplies  F  *  the scale factors times the elements, so if one row tends to have I  *  uncertainties 1000 times smaller than the other rows, then its scale  P  *  factor should be 1024, not 1/1024.  Fourth, to save time, this function doesN  *  not scale rows or columns if their scale factors are equal to one.  Thus, M  *  the scale factors should be normalized to the most common scale factor.  aO  *  Rows and columns should be normalized separately.  For example, if the size N  *  of the matrix is 100 and 10 rows tend to have uncertainties near 1e-6 and N  *  the remaining 90 have uncertainties near 1e-12, then the scale factor for L  *  the 10 should be 1/1,048,576 and the scale factors for the remaining 90 O  *  should be 1. Fifth, since this routine directly operates on the matrix, it  O  *  is necessary to apply the scale factors to the Source and Solution vectors.*N  *  It may be easier to simply use OrderAndDecomposeMatrix on a scaled matrix N  *  to choose the pivoting order, and then throw away the matrix.  Subsequent J  *  decomposes, performed with DecomposeMatrix, will not need to have the O  *  Source and Solution vectors descaled.  Lastly, this function should not be l:  *  executed before the function PreorderForModifiedNodal.  *  *  >>> Arguments:  *  Matrix  <input (char *) +  *      Pointer to the matrix to be scaled. .  *  SolutionScaleFactors  <input>  (double [])N  *      The array of Solution scale factors.  These factors scale the columns.O  *      This array, as all arrays in this package, use a starting index of one,   *      not zero. ,  *  SourceScaleFactors  <input>  (double [])O  *      The array of Source scale factors.  These factors scale the rows.  ThisiN  *      array, as all arrays in this package, use a starting index of one, not
  *      zero.i  *  *  >>> Local variables:  *  lSize  (int)2  *      Local version of the size of the matrix.    *  pElement  (ElementPointer)-  *      Pointer to an element in the matrix.    *  pEliminationOrder  (int *)H  *      Pointer into either Row- or ColEliminationOrder vector. Used to I  *      compensate for any row or column swaps that have been performed.    *  ScaleFactor  (double) K  *      The scale factor being used on the current row or column.             */i  D ScaleRealMatrix( Matrix, SourceScaleFactors, SolutionScaleFactors )    MatrixPointer  Matrix;? register  double  SourceScaleFactors[], SolutionScaleFactors[];O   {  #if (REAL AND SCALING)  " register ElementPointer  pElement;+ register int  I, lSize, *pEliminationOrder;a double  ScaleFactor;     /* Begin. */     lSize = Matrix->Size;f     if (NOT Matrix->RowsLinked)o     {   gMatrix = Matrix;o         LinkRows();a     }    /* Scale Rows */  8     pEliminationOrder = &Matrix->RowEliminationOrder[1];      for (I = 1; I <= lSize; I++)N     {   if ((ScaleFactor = SourceScaleFactors[*(pEliminationOrder++)]) != 1.0)-         {   pElement = Matrix->FirstInRow[I];   $             while (pElement != NULL).             {   pElement->Real *= ScaleFactor;/                 pElement = pElement->NextInRow; 
             } 	         }r     }s   /* Scale Columns *//8     pEliminationOrder = &Matrix->ColEliminationOrder[1];      for (I = 1; I <= lSize; I++)P     {   if ((ScaleFactor = SolutionScaleFactors[*(pEliminationOrder++)]) != 1.0)-         {   pElement = Matrix->FirstInCol[I];n  $             while (pElement != NULL).             {   pElement->Real *= ScaleFactor;/                 pElement = pElement->NextInCol;o
             }*	         }d     }c     return;    #endif  /* REAL AND SCALING */ }o                 n /*  *  SCALE COMPLEX MATRIX  *P  *  This function scales the matrix to enhance the possibility of finding a goodI  *  pivoting order.  Note that scaling enhances accuracy of the solution  M  *  only if it affects the pivoting order, so it makes no sence to scale the  L  *  matrix before DecomposeMatrix.  If scaling is desired it should be done K  *  before OrderAndDecomposeMatrix.  There are several things to take into sK  *  account when choosing the scale factors.  First, the scale factors are  P  *  directly multiplied times the elements in the matrix.  To prevent roundoff, P  *  each scale factor should be equal to an integer power of the number base of P  *  the machine.  Since most machines operate in base two, scale factors should P  *  be a power of two.  Second, the matrix should be scaled such that the matrixO  *  of element uncertainties is equilibrated.  Third, this function multiplies iF  *  the scale factors times the elements, so if one row tends to have I  *  uncertainties 1000 times smaller than the other rows, then its scale oP  *  factor should be 1024, not 1/1024.  Fourth, to save time, this function doesN  *  not scale rows or columns if their scale factors are equal to one.  Thus, M  *  the scale factors should be normalized to the most common scale factor.  MO  *  Rows and columns should be normalized separately.  For example, if the sizeiN  *  of the matrix is 100 and 10 rows tend to have uncertainties near 1e-6 and N  *  the remaining 90 have uncertainties near 1e-12, then the scale factor for L  *  the 10 should be 1/1,048,576 and the scale factors for the remaining 90 O  *  should be 1. Fifth, since this routine directly operates on the matrix, it -O  *  is necessary to apply the scale factors to the Source and Solution vectors.tN  *  It may be easier to simply use OrderAndDecomposeMatrix on a scaled matrix N  *  to choose the pivoting order, and then throw away the matrix.  Subsequent J  *  decomposes, performed with DecomposeMatrix, will not need to have the O  *  Source and Solution vectors descaled.  Lastly, this function should not be i:  *  executed before the function PreorderForModifiedNodal.  *  *  >>> Arguments:  *  Matrix  <input (char *)S+  *      Pointer to the matrix to be scaled. .  *  SolutionScaleFactors  <input>  (double [])N  *      The array of Solution scale factors.  These factors scale the columns.O  *      This array, as all arrays in this package, use a starting index of one, 5  *      not zero.  All scale factors are real valued. ,  *  SourceScaleFactors  <input>  (double [])O  *      The array of Source scale factors.  These factors scale the rows.  ThisnN  *      array, as all arrays in this package, use a starting index of one, not1  *      zero.  All scale factors are real valued.   *  *  >>> Local variables:  *  lSize  (int)2  *      Local version of the size of the matrix.    *  pElement  (ElementPointer)-  *      Pointer to an element in the matrix. n  *  pEliminationOrder  (int *)H  *      Pointer into either Row- or ColEliminationOrder vector. Used to I  *      compensate for any row or column swaps that have been performed.    *  ScaleFactor  (double) K  *      The scale factor being used on the current row or column.             */o  0 ScaleComplexMatrix( Matrix, SourceScaleFactors, 3                             SolutionScaleFactors )     MatrixPointer  Matrix;? register  double  SourceScaleFactors[], SolutionScaleFactors[];e   {e #if (REAL AND SCALING)  " register ElementPointer  pElement;+ register int  I, lSize, *pEliminationOrder;n double  ScaleFactor; 0   /* Begin. */     lSize = gMatrix->Size;      if (NOT gMatrix->RowsLinked)     {   gMatrix = Matrix;e         LinkRows();i     }      Matrix->RowsLinked = TRUE;   /* Scale Rows */8     pEliminationOrder = &Matrix->RowEliminationOrder[1];      for (I = 1; I <= lSize; I++)N     {   if ((ScaleFactor = SourceScaleFactors[*(pEliminationOrder++)]) != 1.0)-         {   pElement = Matrix->FirstInRow[I];g  $             while (pElement != NULL).             {   pElement->Real *= ScaleFactor;.                 pElement->Imag *= ScaleFactor;/                 pElement = pElement->NextInRow; 
             } 	         }g     }    /* Scale Columns */n8     pEliminationOrder = &Matrix->ColEliminationOrder[1];      for (I = 1; I <= lSize; I++)P     {   if ((ScaleFactor = SolutionScaleFactors[*(pEliminationOrder++)]) != 1.0)-         {   pElement = Matrix->FirstInCol[I];r  $             while (pElement != NULL).             {   pElement->Real *= ScaleFactor;.                 pElement->Imag *= ScaleFactor;/                 pElement = pElement->NextInCol;e
             }d	         }      }n     return;   " #endif   /* SCALING AND COMPLEX */ }         