 /*5  *  GLOBAL DEFINITIONS for the sparse matrix routinesd  *  *  Author:   *      Kenneth S. Kundert  *      UC Berkeleyi  *  *  Advising professor:t'  *      Alberto Sangiovanni-Vincentelliw  *K  *  This module contains common type definitions and macros for the sparse MH  *  matrix routines.  These definitions are of no interest to the user.   */l               g /*  *   MACRO DEFINITIONS  *F  *   Macros are distinguished by using solely capital letters in theirP  *   identifiers.  This contrasts with C defined identifiers which are strickly O  *   lower case, and program variable and procedure names which use both upper e  *   and lower case.  */t   /* Begin. */ /* Boolean data type */  #define  BOOLEAN	int #define  FALSE		0f #define  TRUE		1 #define  NOT		!n #define  AND		&& #define  OR		||.   /* Macro commands */M /* Macro functions that return the maximun or minimum independent of type. */n3 #define  MAX(a,b)           ((a) > (b) ? (a) : (b))t3 #define  MIN(a,b)           ((a) < (b) ? (a) : (b))n  P /* Macro function that returns the absolute value of a floating point number. */4 #define  ABS(a)             ((a) < 0.0 ? (-a) : (a))  . /* Macro procedure that swaps two entities. */F #define  SWAP(type, a, b)   {type swapx; swapx = a; a = b; b = swapx;}  P /* Macro function that returns the approx absolute value of a complex number. *// #define  ELEMENT_MAG_DECLARATIONS   double *p,cn
 #if (COMPLEX)dI #define  ELEMENT_MAG(ptr)   (p = (double*)(ptr), (ABS(*p) + ABS(*(p+1)))); #elserG #define  ELEMENT_MAG(ptr)   (c = (ptr)->Real, ((c) < 0.0 ? (-c) : (c)))N #endif  P /* Macro function that returns the approx absolute value of a complex number. */- #define  CMPLX_ABS(a,b)     (ABS(a) + ABS(b))   K /* Macro function that is equivalent to += operator for complex numbers. */o5 #define  CMPLX_ADD_ASSIGN(to_r,to_i,from_r,from_i)  \w#          {   (to_r) += (from_r);  \n#              (to_i) += (from_i);  \ 
          }  H /* Macro function that multiplies two complex numbers and then adds them    to another. */p8 #define  CMPLX_MULT_ADD_ASSIGN(to_r,to_i,ar,ai,br,bi)  \4          {   (to_r) += (ar) * (br) - (ai) * (bi);  \4              (to_i) += (ar) * (bi) + (ai) * (br);  \
          }  M /* Macro function that multiplies two complex numbers and then subtracts them;    from another. */e9 #define  CMPLX_MULT_SUBT_ASSIGN(to_r,to_i,ar,ai,br,bi)  \'4          {   (to_r) -= (ar) * (br) - (ai) * (bi);  \4              (to_i) -= (ar) * (bi) + (ai) * (br);  \
          }  6 /* Macro function that divides two complex numbers. */5 #define  CMPLX_DIVIDE_DECLARATIONS       double r,s,t / #define  CMPLX_DIVIDE(to_r,to_i,nr,ni,dr,di)  \=&          {   if (ABS(dr) > ABS(di))  \#              {  r = (di) / (dr);  \ %                 s = (dr) + r*(di);  \P,                 to_r = ((nr) + r*(ni))/s;  \,                 to_i = ((ni) - r*(nr))/s;  \              }  \"              else  \#              {  r = (dr) / (di);  \ %                 s = (di) + r*(dr);  \o,                 to_r = (r*(nr) + (ni))/s;  \,                 to_i = (r*(ni) - (nr))/s;  \              }  \ 
          }, #define  CMPLX_DIVIDE_ASSIGN(nr,ni,dr,di)  \&          {   if (ABS(dr) > ABS(di))  \#              {  r = (di) / (dr);  \"%                 s = (dr) + r*(di);  \ %                 t = (nr + r*ni)/s;  \E&                 ni = (ni - r*nr)/s;  \                 nr = t;  \              }  \l              else  \#              {  r = (dr) / (di);  \I%                 s = (di) + r*(dr);  \m%                 t = (r*nr + ni)/s;  \ &                 ni = (r*ni - nr)/s;  \                 nr = t;  \              }  \ 
          }  I /* Macro function that checks for range errors on array indices. Used forr<  * debuging, should be commented out in normal operation. */9 #define RANGE_CHECK(index,lowerbound,upperbound,message) >" /*  if ((index) < (lowerbound))  \N     {   printf("Error: Array lower bound fault at location %1s.\n",message); \0         printf("       index = %d.\n",index);  \     }  \"     if ((index) > (upperbound))  \N     {   printf("Error: Array upper bound fault at location %1s.\n",message); \0         printf("       index = %d.\n",index);  \     }  \     fflush(stdout)  */                      i /*.  *  GLOBAL TYPE DEFINITIONS  --  MatrixElement  *L  *  Every nonzero element in the matrix is stored in a dynamically allocatedH  *  MatrixElement structure.  These structures are linked together in anJ  *  orthogonal linked list.  Two different MatrixElement structures exist.L  *  One is used when only real matrices are expected, it is missing an entryL  *  for imaginary data.  The other is used if complex matrices are expected.,  *  It contains an entry for imaginary data.  *  *  >>> Structure fields:   *  Real  (double)M  *      The real portion of the value of the element.  Real must be the firstn!  *      field in this structure. T  *  Imag  (double)H  *      The imaginary portion of the value of the element. If the matrixG  *      routines are not compiled to handle complex matrices, then thisfM  *      field does not exist.  If it exists, it must follow imediately after S  *      Real.   *  Row  (int)&  *      The row number of the element.  *  Col  (int))  *      The column number of the element. '  *  NextInRow  (struct MatrixElement *))J  *      NextInRow contains a pointer to the next element in the row to theJ  *      right of this element.  If this element is the last nonzero in the)  *      row then NextInRow contains NULL. '  *  NextInCol  (struct MatrixElement *) L  *      NextInCol contains a pointer to the next element in the column belowN  *      this element.  If this element is the last nonzero in the column then    *      NextInCol contains NULL.  */\   /* Begin. */
 #if (COMPLEX)r8 /* Basic matrix element for real or complex matrices. */ struct  MatrixElement; {   double  Real;      double  Imag;s
     int  Row; 
     int  Col;\&     struct  MatrixElement  *NextInRow;&     struct  MatrixElement  *NextInCol; };   #else - /* Basic matrix element for real matrices. */  struct  MatrixElement  {   double  Real;*
     int  Row; 
     int  Col; &     struct  MatrixElement  *NextInRow;&     struct  MatrixElement  *NextInCol; }; #endif               . /*,  *  GLOBAL TYPE DEFINITIONS  --  Allocations  *L  *  The sparse matrix routines keep track of all memory that is allocated byK  *  the operating system so the memory can later be freed.  This is done bydK  *  saving the pointers to all the chunks of memory that are allocated to a,I  *  particular matrix in an allocation list.  That list is organized as ar;  *  linked list so that it can grow without apriori bounds.   *  *  >>> Structure fields:%  *  AllocatedPtr  (char *)J  *      Pointer to chunk of memory that has been allocated for the matrix.,  *  NextRecord  (struct  AllocationRecord *).  *      Pointer to the next allocation record.  */l  t /* Begin. */ struct AllocationRecord  {   char  *AllocatedPtr;*     struct  AllocationRecord  *NextRecord; };  6 typedef  struct  AllocationRecord  *AllocationListPtr;                 t /*,  *  GLOBAL TYPE DEFINITIONS  --  MatrixFrame  *H  *  This structure contains all the pointers that support the orthogonalI  *  linked list that cantains the matrix elements.  Also included in this J  *  structure are other numbers and pointers that are used globally by theI  *  sparse matrix routines and are associated with one particular matrix.n  *  *  >>> Type definitions:o  *  ElementPointer%  *      A pointer to a MatrixElement.   *  ElementPointerVectorI  *      An array of ElementPointers.  Used for FirstInRow, FirstInCol ando  *      Diag pointer arrays.  *  EliminationOrderVectorM  *      An array of integers.  These vectors indicate in which order the rowsu2  *      and columns of the matrix were eliminated.  *  MatrixPointer;H  *      A pointer to MatrixFrame.  Essentially, a pointer to the matrix.  *  *  >>> Structure fields:u2  *  ColEliminationOrder  (EliminationOrderVector) G  *      An array that lists the step in which each original column was (  *      eliminated.)  *  Complex  (BOOLEAN)I  *      The flag which indicates whether the matrix is complex (true) or M  *      real (false).r  *  Decomposed  (BOOLEAN)e0  *      Indicates if matrix has been decomposed.   *  Diag  (ElementPointerVector)?  *      Array of pointers that points to the diagonal elements.*  *  Error  (int)6  *      The error status of the sparse matrix package.  *  FillIns  (int)L  *      The number of fill-ins created during the decomposition the matrix.   *  FirstTime  (BOOLEAN)K  *      This is a flag that sigifies that an initial decomposition has not rL  *      been performed yet. FirstTime is set True in AllocateMatrix and set )  *      False in OrderAndDecomposeMatrix.t&  *  FirstInCol  (ElementPointerVector)I  *      Array of pointers that point to the first nonzero element of the n*  *      column corresponding to the index.&  *  FirstInRow  (ElementPointerVector)M  *      Array of pointers that point to the first nonzero element of the row e#  *      corresponding to the index.i  *  Growth  (double)N  *      The amount of growth that occurred in the most recent decompose of theL  *      matrix.  Growth is a measure of the amount of roundoff error that is<  *      present in L and U as a result of the decomposition.!  *  IntermediateImag  (double []))O  *      Temporary storage used in the SolveMatrix routines. Intermediate is an AC  *      array used during forward and backward substitution.  It isoO  *      commonly called y when the forward and backward substitution process is J  *      denoted  Ax = b => Ly = b and Ux = y.  IntermediateImag holds the   *      imaginary portion of y.o!  *  IntermediateReal  (double []) O  *      Temporary storage used in the SolveMatrix routines. Intermediate is an tC  *      array used during forward and backward substitution.  It is O  *      commonly called y when the forward and backward substitution process is*J  *      denoted  Ax = b => Ly = b and Ux = y.  IntermediateReal holds the   *      real portion of y.  *  LargestElement  (double)*  *      The largest element in the matrix.  *  MarkowitzCol  (int [])L  *      An array that contains the count of the non-zero elements excluding N  *      the pivots for each column. Used to generate and update MarkowitzProd.  *  MarkowitzProd  (long *)eN  *      The array of the products of the Markowitx row and column counts. The O  *      element with the smallest product is the best pivot to use to maintain    *      sparsity.   *  MarkowitzRow  (int [])L  *      An array that contains the count of the non-zero elements excluding K  *      the pivots for each row. Used to generate and update MarkowitzProd.   *  PseudoCondition  (double) H  *      The ratio of the largest pivot to the smallest pivot.  A measureK  *      of the ill-conditioning of the matrix, a crude measure.  The largerl:  *      the ratio, the more ill-conditioned the matrix is.1  *  RowEliminationOrder  (EliminationOrderVector) O  *      An array that lists the step in which each original row was eliminated.m  *  RowsLinked  (BOOLEAN)iM  *      A flag that indicates whether the row pointers exist.  The AddByIndexrK  *      routines do not generate the row pointers, which are needed by somenO  *      of the other routines, such as OrderAndDecomposeMatrix and ScaleMatrix. @  *      The row pointers are generated in the function LinkRows.  *  Size  (int)pM  *      Number of rows and columns in the matrix.  Does not change as matrix p  *      is decomposed.  *  Threshold  (double)fM  *      The minimum magnitude an element must have relative to other elementst<  *      in its column to be considered as a pivot candidate.  *>  *  >>> The remaining fields are related to memory allocation.,  *  TopOfAllocationList  (AllocationListPtr)K  *      Pointer which points to the top entry in a list. The list contains aL  *      all the pointers to the segments of memory that have been allocated G  *      to this matrix. This is used when the memory is to be freed on c"  *      dallocation of the matrix.  *  RecordsRemaining  (int) 8  *      Number of slots left in the list of allocations.&  *  NextAvailElement  (ElementPointer)N  *      Pointer to the next availible element which has been allocated but as B  *      yet is unused. Matrix elements are allocated in groups of I  *      ELEMENTS_PER_ALLOCATION in order to speed element allocation and    *      freeing.  *  ElementsRemaining  (int)K  *      Number of unused elements left in last block of elements allocated.t%  *  NextAvailFillIn  (ElementPointer)lK  *      Pointer to the next availible fill-in which has been allocated but  N  *      as yet is unused.  Fill-ins are allocated in a group in order to keep B  *      them physically close in memory to the rest of the matrix.  *  FillInsRemaining  (int)lE  *      Number of unused fill-ins left in the last block of fill-ins h  *      allocated.#  *  InitialDecompStarted  (BOOLEAN)yN  *      Boolean flag that is used to indicate that the building of the matrix M  *      has been completed. This indicated that any new elements created are s  *      fill-ins.)  */    /* Begin. */ /* Matrix frame */0 typedef  struct  MatrixElement  *ElementPointer;/ typedef  ElementPointer  *ElementPointerVector;o& typedef  int  *EliminationOrderVector;   struct  MatrixFrame 0 {   EliminationOrderVector  ColEliminationOrder;     BOOLEAN  Complex;r     BOOLEAN  Decomposed;     ElementPointerVector  Diag;      int  Error;d     int  FillIns;      BOOLEAN  FirstTime;t%     ElementPointerVector  FirstInCol;e%     ElementPointerVector  FirstInRow;e     double  Growth;      double  *IntermediateReal;     double  *IntermediateImag;     double  LargestElement;d     int  *MarkowitzRow;i     int  *MarkowitzCol;y     long  *MarkowitzProd;r     double  PseudoCondition;0     EliminationOrderVector  RowEliminationOrder;     BOOLEAN  RowsLinked;     int  Size;     double  Threshold;  +     AllocationListPtr  TopOfAllocationList;x     int  RecordsRemaining;%     ElementPointer  NextAvailElement;l     int  ElementsRemaining;i$     ElementPointer  NextAvailFillIn;     int  FillInsRemaining;     int  InitialDecompStarted; };- typedef  struct  MatrixFrame  *MatrixPointer;n             l /*   *  GLOBAL VARIABLE DECLARATION   *H  *  This variable is global to all matrix routines.  The small g prefix M  *  denotes this.  Making this variable global greatly reduces the amount of    *  parameter passing required.   *  *  >>> Global variable:  *  gMatrix  (MatrixPointer)<  *      A pointer to the matrix currently being operated on.  */i   /* Begin. */ extern  MatrixPointer  gMatrix;i  