 /*  *(  *   EXPORTS for sparse matrix routines.  *  *   Author:  *       Kenneth S. Kundert.  *  *   Advising professor:(  *       Alberto Sangiovanni-Vincentelli  *K  *   This file contains definitions that are useful to the calling program.nL  *   In particular, this file contains some macro functions that are used toI  *   quickly enter data into the matrix and the type definition of a datayI  *   structure that acts as a template for entering admittances into the i  *   matrix.  */                  /*  *   MACRO FUNCTION DEFINITIONS   *  *   >>> Macro descriptions:  *   ADD_REAL_ELEMENT_TO_MATRIX M  *       Macro function that adds a real element to the matrix by a pointer. d  *   ADD_IMAG_ELEMENT_TO_MATRIXrI  *       Macro function that adds a imaginary element to the matrix by a o  *       pointer.    *   ADD_CMPLX_ELEMENT_TO_MATRIXP  *       Macro function that adds a complex element to the matrix by a pointer.   */r   /* Begin. */4 #define  ADD_REAL_ELEMENT_TO_MATRIX(element,real)  \          (*element) += (real)e  4 #define  ADD_IMAG_ELEMENT_TO_MATRIX(element,imag)  \          *(element+1) += (imag)   : #define  ADD_CMPLX_ELEMENT_TO_MATRIX(element,real,imag)  \#          {   *element += (real);  \e'              *(element+1) += (imag);  \z
          }               a /*+  *   TYPE DEFINITION FOR COMPONENT TEMPLATEr  *N  *   This data structure is used to hold pointers to four related elements in :  *   matrix.  It is used in conjunction with the routines   *       AddAdmittanceByIndexx   *       AddRealQuadElementByPtr   *       AddImagQuadElementByPtr&  *       AddComplexQuadElementByPtr   O  *   AddAdmittanceByIndex stuffs the structure which is later used by the ByPtr I  *   routines.  It is also possible for the user to collect four pointersnO  *   returned by AddElementByIndex and stuff them into the template.  The ByPtreO  *   routines stuff data into the matrix in locations specified by Element1 anddK  *   Element2 without changing the data.  The data is negated before being %  *   placed in Element3 and Element4.s  */   o /* Begin. */ struct  TemplateStruct {   double    *Element1       ;e     double    *Element2       ;r     double    *Element3Negated;e     double    *Element4Negated;r };  