 /*  *   MATRIX OUTPUT MODULEs  *  *   Author:  *       Kenneth S. KundertK  *       UC Berkeley  *
  *   Advisor:f(  *       Alberto Sangiovanni-Vincentelli  *N  *   This module contains the output-to-file and output-to-screen routines for  *   the matrix package.  *;  *   >>> User accessable functions declared in this module:i  *   PrintMatrix  *   OutputMatrixToFilee  *   OutputVectorToFile*  *   OutputStatisticsToFilee  *+  *   >>> Functions declared in this module:m  *   PrintMatrix  *   OutputMatrixToFileC  *   OutputVectorToFile   *   OutputStatisticsToFilen  */*                   O /*  *  IMPORTS   *  *  >>> Import descriptions:  *  stdio.h   *     Standard C IO library.D  *  MtrxPers.h8  *     Macros that customize the sparse matrix routines.  *  MtrxExpt.h:  *     Macros and declarations to be imported by the user.  *  MtrxDefs.hH  *     Matrix type and macro definitions for the sparse matrix routines.  *  MtrxError.h/&  *     Matrix error macro definitions.  */,  l #include <stdio.h> #include "MtrxPers.h"f #include "MtrxExpt.h"O #include "MtrxDefs.h"\ #include "MtrxError.h"                 n /*  *   PRINT MATRIX_  *E  *   Formats and send the matrix to standard output.  Some elementary G  *   statistics are also output.  The matrix is formatted so that it isT  *   readable by humans.  *  *   >>> Arguments:i  *   Matrix  <input>  (char *)  *       Pointer to matrix.m  *   Compressed  (int) tK  *       Boolean flag that indicates that output should be compressed such *O  *       that only the existance of an element should be indicated rather than pP  *       giving the actual value. Thus 11 times as many can be printed on a row.M  *       A one signifies that the matrix should be printed compressed. A zerolF  *       indicates that the matrix should be printed in all its glory.  *  *   >>> Local variables:*  *   Data  (double)a7  *       The value of the matrix element being printed.   *   ElementCount  (int)M  *       Variable used to count the number of nonzero elements in the matrix.   *   LargestElement  (double) F  *       The magnitude of the largest element in the matrix.            *   LargestDiag  (double)G  *       The magnitude of the largest diagonal in the matrix.          m'  *   pImagElement  (ElementPointer []) yM  *       Array of pointers to elements in the matrix.  They point to the next I  *       element in the column that has not been printed in those columnsoJ  *       currently being printed.  This variable is used when printing the  *       imaginary entries.B'  *   pRealElement  (ElementPointer []) UM  *       Array of pointers to elements in the matrix.  They point to the next	I  *       element in the column that has not been printed in those columnsJ  *       currently being printed.  This variable is used when printing the  *       real entries.  *   Size  (int)   *       The size of the matrix.  *   SmallestDiag  (double)*H  *       The magnitude of the smallest diagonal in the matrix.            *   SmallestElement  (double)K  *       The magnitude of the smallest element in the matrix excluding zeroo  *       elements.            *   StartCol  (int)L  *       The column number of the first column to be printed in the group of)  *       columns currently being printed.o  *   StopCol  (int) K  *       The column number of the last column to be printed in the group ofb)  *       columns currently being printed.   */n  ! PrintMatrix( Matrix, Compressed )(    register  MatrixPointer  Matrix; BOOLEAN  Compressed; {i #if (DOCUMENTATION)c   register  int  J = 0;t5 int I, Size, StartCol = 1, StopCol, ElementCount = 0; , double  Data, SmallestDiag, SmallestElement;0 double  LargestElement = 0.0, LargestDiag = 0.0;9 ElementPointer  pRealElement[CHARACTER_COLUMNS_PER_PAGE];a9 ElementPointer  pImagElement[CHARACTER_COLUMNS_PER_PAGE];m ELEMENT_MAG_DECLARATIONS;    /* Begin. */# /* Test for existance of matrix. */d     if (Matrix == NULL) +     {   printf("Matrix does not exist.\n");          return;t     }s   /* Print header. */M!     printf("MATRIX SUMMARY\n\n");o     Size = Matrix->Size;:     printf("Size of matrix = %1u X %1u.\n\n", Size, Size);       if ( Matrix->FirstTime ), 	printf("Matrix before decomposition:\n\n");     else* 	printf("Matrix after decompostion:\n\n");  #     SmallestElement = LARGEST_REAL;f#     SmallestDiag = SmallestElement;*  L /* Print matrix by printing groups of complete columns until all the columns  * are printed. */     while ( J <= Size)  > /* Calculate index of last column to printed in this group. */     {   if (Compressed)r@             StopCol = StartCol + CHARACTER_COLUMNS_PER_PAGE - 1;         else>             StopCol = StartCol + NUMERIC_COLUMNS_PER_PAGE - 1;           if (StopCol > Size)h             StopCol = Size;m9         printf("Columns %1d to %1d.\n",StartCol,StopCol);s  M /* Initialize column pointers so that they point to the first element in eachu
  * column. */ -         for (J = StartCol; J <= StopCol; J++)t=         {   pRealElement[J-StartCol] = Matrix->FirstInCol[J]; =             pImagElement[J-StartCol] = Matrix->FirstInCol[J];)	         }    /* Print every row ...  */#         for (I = 1; I <= Size; I++)x  & /* ... in each column of the group. */1         {   for (J = StartCol; J <= StopCol; J++)e9             {   if (pRealElement[J-StartCol] != NULL AND eN                                            pRealElement[J-StartCol]->Row == I)   /* Case where element exists */ , 		{   Data = pRealElement[J-StartCol]->Real; 		    if (Compressed) $                         printf("x");                     else/                         printf("%9.2g  ",Data);    /* Update status variables */o/          	    if ( ABS(Data) > LargestElement )  			LargestElement = ABS(Data);: 		    if ((ABS(Data) < SmallestElement) AND (Data != 0.0)) 			SmallestElement = ABS(Data);u 		    ElementCount++;   5 /* Move pointer to next nonzero element in column. */yS                     pRealElement[J-StartCol] = pRealElement[J-StartCol]->NextInCol;e                 }     /* Case where element is zero */ 		else#                 {   if (Compressed)a$                         printf(".");                     else.                         printf("     ...   ");                 }. 	    }             printf("\n");A  
 #if (COMPLEX)R0 /* Print imaginary data if matrix is complex. */8             if ((Matrix->Complex) AND (NOT Compressed)) 5             {   for (J = StartCol; J <= StopCol; J++)r?                 {   if ((pImagElement[J-StartCol] != NULL) AND  M                                         (pImagElement[J-StartCol]->Row == I))    /* Case where element exists */f0 		    {   Data = pImagElement[J-StartCol]->Imag;0                         printf("%8.2gj  ",Data);   /* Update status variables */l3          	        if ( ABS(Data) > LargestElement ) " 			    LargestElement = ABS(Data);> 		        if ((ABS(Data) < SmallestElement) AND (Data != 0.0))# 			    SmallestElement = ABS(Data);l  5 /* Move pointer to next nonzero element in column. */ W                         pImagElement[J-StartCol] = pImagElement[J-StartCol]->NextInCol;                      }T    /* Case where element is zero */
 		    else.                         printf("           ");
 	        }                 printf("\n\n");x
             }M #endif  /* COMPLEX */e 	}  4 /* Calculate index of first column in next group. */ 	StartCol = StopCol; 	StartCol++;         printf("\n");*     }tF     printf("\nLargest element in matrix = %-1.4g.\n", LargestElement);F     printf("Smallest element in matrix = %-1.4g.\n", SmallestElement);  5 /* Search for largest and smallest diagonal values */i     for (I = 1; I <= Size; I++)t$     {   if (Matrix->Diag[I] != NULL)2         {   Data = ELEMENT_MAG( Matrix->Diag[I] );  *             if ( ABS(Data) > LargestDiag )(                 LargestDiag = ABS(Data);+             if ( ABS(Data) < SmallestDiag )h)                 SmallestDiag = ABS(Data);i	         }      })  4 /* Print the largest and smallest diagonal values */     if ( Matrix->FirstTime )E     {   printf("\nLargest diagonal element = %-1.4g.\n",LargestDiag);eE         printf("Smallest diagonal element = %-1.4g.\n",SmallestDiag);v     }      elseB     {   printf("\nLargest pivot element = %-1.4g.\n",LargestDiag);B         printf("Smallest pivot element = %-1.4g.\n",SmallestDiag);     }d  B /* Calculate and print sparsity and number of fill-ins created. */D     printf("\nDensity = %2.2f%%.\n", (double)(ElementCount * 100) / P                                                        ((double)(Size * Size)));     if ( NOT Matrix->FirstTime)p>         printf("Number of fill-ins = %1d.\n",Matrix->FillIns);     printf("\n");P     fflush(stdout);      return;    #endif  /* DOCUMENTATION */C }L                       /*  *   OUTPUT MATRIX TO FILE  *H  *   Writes matrix to file in format suitable to be read back in by the L  *   matrix test program.  This routine should be executed before the matrix  *   is decomposed..  *  *   >>> Arguments:a  *   Matrix  <input>  (char *)  *       Pointer to matrix.   *   Label  (char *)C  *       String that is transferred to file and is used as a label.   *  *   >>> Local variables:m  *   MatrixID  (int)A  *       The ID number of the matrix as found in the NUMBER_FILE.t  *   pElement  (ElementPointer)	-  *       Pointer to an element in the matrix.   *   pMatrixFile  (FILE *))  *       File pointer to the MATRIX_FILE.e  *   pNumberFile  (FILE *))  *       File pointer to the NUMBER_FILE.   *   Size  (int)   *       The size of the matrix.  */   # OutputMatrixToFile( Matrix, Label )=    register  MatrixPointer  Matrix; char *Label; {  #if (DOCUMENTATION)h   register  int  I, Size; # register  ElementPointer  pElement;f int  MatrixID;! FILE  *pMatrixFile, *pNumberFile;f FILE  *fopen();    /* Begin. */# /* Test for existance of matrix. */i     if (Matrix == NULL)e         return;a  + /* Open file MATRIX_FILE in append mode. */"7     if ((pMatrixFile = fopen(MATRIX_FILE,"a")) == NULL)      {   printf("Can't open ");         printf(MATRIX_FILE);         printf(".\n");         return;      }c  N /* Open file ID_NUMBER_FILE in read mode.  This is the file that contains the   * matrix id number.  */9     if ((pNumberFile= fopen(ID_NUMBER_FILE,"r")) == NULL)      {   printf("Can't open ");         printf(ID_NUMBER_FILE); 2         printf(".\nMatrix id number set to 1.\n");         MatrixID = 1;      } 
     else  +     {   fscanf(pNumberFile,"%d",&MatrixID);P         fclose(pNumberFile);     }l  O /* Open file ID_NUMBER_FILE in write mode.  This is the file that contains the t0  * matrix id number, which is to be updated.  */9     if ((pNumberFile= fopen(ID_NUMBER_FILE,"w")) == NULL)      {   printf("Can't open ");         printf(ID_NUMBER_FILE);r         printf(".\n");     }l	     else e1     {   fprintf(pNumberFile,"%d\n",MatrixID + 1);l         fclose(pNumberFile);     }o   /* Output header. */     Size = Matrix->Size;     if (Matrix->Complex)M         fprintf(pMatrixFile,"Starting complex matrix.  ID = %d.\n",MatrixID);l     elseI         fprintf(pMatrixFile,"Starting new matrix.  ID = %d.\n",MatrixID);i)     fprintf(pMatrixFile,"%-80s\n",Label);"%     fprintf(pMatrixFile,"%d\n",Size);n   /* Output matrix. */
 #if (COMPLEX)      if (Matrix->Complex)#     {   for (I = 1; I <= Size; I++) -         {   pElement = Matrix->FirstInCol[I]; $             while (pElement != NULL)N             {   fprintf(pMatrixFile,"%d %d %-25.15g %-25.15g\n",pElement->Row,O                                             I, pElement->Real, pElement->Imag); /                 pElement = pElement->NextInCol;  	    }	         }t) /* Output terminator, a line of zeros. */ @         fprintf(pMatrixFile,"%d %d %-25g  %-25g\n",0,0,0.0,0.0);       }.     else  /* Not Complex. */ #endif#     {   for (I = 1; I <= Size; I++)o-         {   pElement = Matrix->FirstInCol[I];a$             while (pElement != NULL)G             {   fprintf(pMatrixFile,"%d %d %-25.15g\n",pElement->Row,I, P                                                                 pElement->Real);/                 pElement = pElement->NextInCol;; 	    }	         } ) /* Output terminator, a line of zeros. */25         fprintf(pMatrixFile,"%d %d %-25g\n",0,0,0.0);        }(   /* Close file. */l     fclose(pMatrixFile);       return;    #endif  /* DOCUMENTATION */E }e                       /*!  *   OUTPUT SOURCE VECTOR TO FILE   *H  *   Writes vector to file in format suitable to be read back in by the M  *   matrix test program.  This routine should be executed after the functionl  *   OutputMatrixToFile.  *  *   >>> Arguments:z  *   Matrix  <input>  (char *)  *       Pointer to matrix.   *   SourceReal  (double [])/  *       Right-hand side vector, real portion.    *   SourceImag  (double [])L  *       Right-hand side vector, imaginary portion.  Not necessary if matrix  *       is real.t  *  *   >>> Local variables:   *   pMatrixFile  (FILE *))  *       File pointer to the MATRIX_FILE.S  *   Size  (int)   *       The size of the matrix.  */m  4 OutputVectorToFile( Matrix, SourceReal, SourceImag )   register  MatrixPointer Matrix;h# double  SourceReal[], SourceImag[];    {l #if (DOCUMENTATION)L   register  int  I, Size;i FILE  *pMatrixFile;T FILE  *fopen();h   /* Begin. */5 /* Test for existance of matrix and source vector. */	1     if ((Matrix == NULL) OR (SourceReal == NULL))*         return;F  + /* Open file MATRIX_FILE in append mode. */E7     if ((pMatrixFile = fopen(MATRIX_FILE,"a")) == NULL)t     {   printf("Can't open ");         printf(MATRIX_FILE);         printf(".\n");         return;x     }S   /* Output vector. */     Size = Matrix->Size;3     if ((Matrix->Complex) AND (SourceImag != NULL))MB     {   fprintf(pMatrixFile,"Beginning complex source vector.\n");#         for (I = 1; I <= Size; I++)IS             fprintf(pMatrixFile,"%-25.15g %-25.15g\n",SourceReal[I],SourceImag[I]);h     }l     else:     {   fprintf(pMatrixFile,"Beginning source vector.\n");#         for (I = 1; I <= Size; I++) <             fprintf(pMatrixFile,"%-25.15g\n",SourceReal[I]);     }    /* Close file. */e     fclose(pMatrixFile);       return;    #endif  /* DOCUMENTATION */i }o                     p /*  *   OUTPUT STATISTICS TO FILE  *K  *   Writes useful information concerning the matrix to a file.  Should be I-  *   executed after the matrix is decomposed.M  *  *   >>> Arguments:   *   Matrix  <input>  (char *)  *       Pointer to matrix.   *   Label  (char *)C  *       String that is transferred to file and is used as a label.   *  *   >>> Local variables:e  *   Data  (double) 6  *       The value of the matrix element being output.  *   LargestElement  (double)e+  *       The largest element in the matrix.%  *   MatrixID  (int)A  *       The ID number of the matrix as found in the NUMBER_FILE.n  *   NumberOfElements  (int)2  *       Number of nonzero elements in the matrix.  *   pElement  (ElementPointer)i-  *       Pointer to an element in the matrix.d  *   pMatrixFile  (FILE *))  *       File pointer to the MATRIX_FILE.c  *   pNumberFile  (FILE *))  *       File pointer to the NUMBER_FILE.n  *   Size  (int)   *       The size of the matrix.  *   SmallestElement  (double)D  *       The smallest element in the matrix excluding zero elements.  */I  ' OutputStatisticsToFile( Matrix, Label )v    register  MatrixPointer  Matrix;
 char  *Label;    {  #if (DOCUMENTATION)    register  int  Size, I; # register  ElementPointer  pElement;  int MatrixID, NumberOfElements; . double  Data, LargestElement, SmallestElement;! FILE  *pMatrixFile, *pNumberFile;  FILE      *fopen();g ELEMENT_MAG_DECLARATIONS;e   /* Begin. */# /* Test for existance of matrix. */l     if (Matrix == NULL)          return;   / /* Open file STATISTICS_FILE in append mode. */*;     if ((pMatrixFile = fopen(STATISTICS_FILE,"a")) == NULL).     {   printf("Can't open ");          printf(STATISTICS_FILE);         printf(".\n");         return;p     }d  N /* Open file ID_NUMBER_FILE in read mode.  This is the file that contains the     matrix id number.  */:     if ((pNumberFile = fopen(ID_NUMBER_FILE,"r")) == NULL)         MatrixID = 1; 
     else  +     {   fscanf(pNumberFile,"%d",&MatrixID);I         fclose(pNumberFile);     }i     MatrixID--;t   /* Output statistics. */     Size = Matrix->Size;O     fprintf(pMatrixFile,"|||  Starting new matrix  |||   ID = %d.\n",MatrixID);*)     fprintf(pMatrixFile,"%-80s\n",Label);n     if (Matrix->Complex)4         fprintf(pMatrixFile,"Matrix is complex.\n");     else1         fprintf(pMatrixFile,"Matrix is real.\n"); 1     fprintf(pMatrixFile,"     Size = %d\n",Size);;@     fprintf(pMatrixFile,"     Fill-ins = %d\n",Matrix->FillIns); #if (MONITOR_ROUNDOFF)=     fprintf(pMatrixFile,"     Growth = %e\n",Matrix->Growth);i #elsee:     fprintf(pMatrixFile,"     Growth = Not calculated\n"); #endif #if (CALCULATE_PSEUDOCONDITION) O     fprintf(pMatrixFile,"     PseudoCondition = %e\n",Matrix->PseudoCondition);  #elseeC     fprintf(pMatrixFile,"     PseudoCondition = Not calculated\n");b #endifC     fprintf(pMatrixFile,"     Threshold = %e\n",Matrix->Threshold);i   /* Search matrix. */     NumberOfElements = 0;i     LargestElement = 0.0;f#     SmallestElement = LARGEST_REAL;"       for (I = 1; I <= Size; I++)')     {   pElement = Matrix->FirstInRow[I];r          while (pElement != NULL)         {   NumberOfElements++;e)             Data = ELEMENT_MAG(pElement);e&             if (Data > LargestElement)&                 LargestElement = Data;7             if (Data < SmallestElement AND Data != 0.0) '                 SmallestElement = Data; +             pElement = pElement->NextInRow;*	         }t     }   " /* Output remaining statistics. */L     fprintf(pMatrixFile,"     Number of elements = %d\n", NumberOfElements);0     fprintf(pMatrixFile,"     Density = %f%%\n",P                                             100.0*NumberOfElements/(Size*Size));G     fprintf(pMatrixFile,"     Largest Element = %e\n", LargestElement);gM     fprintf(pMatrixFile,"     Smallest Element = %e\n\n\n", SmallestElement);p   /* Close file. */2     fclose(pMatrixFile);       return;o   #endif  /* DOCUMENTATION */  }B  