 /*=  *   PERSONALITY MACRO DEFINITIONS for sparse matrix routines*  *  *   Author:  *       Kenneth S. Kundert   *       U.C. Berkeley  *  *   Advising professor:(  *       Alberto Sangiovanni-Vincentelli  *K  *   This file contains macros for the sparse matrix routines that are used;I  *   to define the personality of the routines.  The user is expected to RF  *   modify this file to maximize the performance of the routines with  *   his/her matrices.  *  *G  *   Macros are distinguished by using solely capital letters in their  G  *   identifiers.  This contrasts with C defined identifiers which are eM  *   strickly lower case, and program variable and procedure names which use z  *   both upper and lower case.   */i               | /*  *   OPTIONS  *H  *   These are compiler options.  Set each option to one to compile thatE  *   section of the code.  If a feature is not desired, set the macro 
  *   to zero.i  *  *   >>> Option descriptions:p	  *   REALiM  *       This specifies that the routines are expected to handle real systems"L  *       of equations.  The routines can be compiled to handle both real andK  *       complex systems at the same time, but there is a slight speed and NJ  *       memory advantage if the routines are complied to handle only real  *       systems of equations.  *   COMPLEXL  *       This specifies that the routines will be complied to handle complex  *       systems of equations.  *   MODIFIED_MARKOWITZ M  *       This specifies that the Modified Markowitz method of pivot selectionlG  *       is to be used.  The Modified Markowitz method is used to breakEL  *       Markowitz ties.  When two or more elements are pivot candidates andL  *       they all have the same Markowitz product, then the tie is broken byM  *       choosing the element that is best numerically.  The numerically best)J  *       element is the one with the largest ratio of its magnitude to theH  *       magnitude of the largest element in the same column, excluding J  *       itself.  The modified Markowitz method results in higher accuracyN  *       but results in more row and column exchanges, which slows the initialI  *       decomposition.  Thus, if only one matrix is to be solved, and if J  *       accuracy is not an issue, as with positive definite or diagonallyN  *       dominant matrices, Modified Markowitz should not be used.  Otherwize,.  *       it is probably a good idea to use it.  *   MONITOR_ROUNDOFF J  *       This specifies that estamates for the growth that has occurred inK  *       the matrix during the decomposition and the largest element in the H  *       matrix should be calculated.  This slows the routines some, butI  *       the growth is needed to decide if the matrix has been decomposedeI  *       accurately.  If growth is very high during an initial decompose,iL  *       then the pivot threshold should be raised.  If the growth increasesJ  *       greatly on subsequent decomposes, then the matrix should probably  *       be reordered.  *   CALCULATE_PSEUDOCONDITION vK  *       This specifies that a very crude and easily fooled estimate of the H  *       amount ill-conditioning that is present in the matrix should be  *       calculated.  *   MODIFIED_NODALNE  *       This specifies that the routine that preorders modified nodeeI  *       admittance matrices should be compiled.  This routine results intE  *       greater speed and accuracy if used with this type of matrix.   *   QUAD_ELEMENTIJ  *       This specifies that the routines that allow four related elementsJ  *       to be entered into the matrix at once should be compiled.  These O  *       elements are usually related to an admittance.  The routines affected .K  *       by QUAD_ELEMENT ate the AddAdmittance and AddQuadElement routines.   *   TRANSPOSEH  *       This specifies that the routines that solve the matrix as if itK  *       was transposed should be compiled.  These routines are useful when B  *       performing sensitivity analysis using the adjoint method.  *   SCALINGL  *       This specifies that the routine that performs scaling on the matrixM  *       should be complied.  Scaling is not strongly supported.  The routinelI  *       to scale the matrix is provided, but no routines are provided to L  *       scale and descale the Source and Solution vectors.  It is suggestedN  *       that if scaling is desired, it only be preformed when the pivot orderM  *       is being chosen (in OrderAndDecomposeMatrix).  This is the only timesL  *       scaling has an effect.  The scaling may then either be removed fromN  *       the solution by the user or the scaled decompose may simply be thrown  *       away.  *   DOCUMENTATIONK  *       This specifies that routines that are used to document the matrix, H  *       such as PrintMatrix and OutputMatrixToFile, should be compiled.E  *       Also the matrix multiplication routines are considered debugtE  *       routines and so they are only compiled when DOCUMENTATION isR  *       set true.
  *   DEBUGH  *       This specifies that additional error checking will be compiled.E  *       The type of error checked are those that are common when theiJ  *       matrix routines are first integrated into a user's program.  OnceL  *       the routines have been integrated in and are running smoothly, this%  *       option should be turned off.i  */d   /* Begin. */ #define  REAL				1 #define  COMPLEX			0 #define  MODIFIED_MARKOWITZ		0 #define  MONITOR_ROUNDOFF		0 #define  MONITOR_GROWTH			0s$ #define  CALCULATE_PSEUDOCONDITION	0 #define  MODIFIED_NODAL			0I #define  QUAD_ELEMENT			0e #define  TRANSPOSE			0 #define  SCALING			0 #define  DOCUMENTATION			0 #define  DEBUG				0s               a /*  *   MATRIX CONSTANTSl  *J  *   These constants are used throughout the sparse matrix routines.  They;  *   should be set to suit the type of matrix being solved.e  *  *   >>> Constants decriptions:   *   MAX_MATRIX_SIZEN  *       The largest matrix that can be handled by the sparse matrix routines.M  *       This constant is limited to be less than 32767 - 2 without changing eL  *       the short integer declarations to long. Note that nothing is gained/  *       by reducing the size of this constant.i  *   DEFAULT_THRESHOLDJ  *       The threshold used if the user enters an invalid threshold.  Also<  *       the threshold used by DecomposeMatrix when calling L  *       OrderAndDecomposeMatrix.  The default threshold should not be less 4  *       than or equal to zero nor larger than one. 	  *   FUZZiI  *       This is a lower limit on the size of an element to be considerediM  *       as a pivot candidate.  The limit is relative to the largest element s&  *       found initally in the matrix.  *   SPACE_FOR_ELEMENTSrK  *       This number multiplied by the size of the matrix equals the numbert@  *       of elements for which memory is initially allocated in   *       AllocateMatrix().  *   SPACE_FOR_FILL_INSvK  *       This number multiplied by the size of the matrix equals the number M  *       of elements for which memory is initially allocated and specifically 4  *       reserved for fill-ins in AllocateMatrix().   *   ELEMENTS_PER_ALLOCATIONL  *       The number of matrix elements requested from the malloc utility on I  *       each call to it.  Setting this value greater than 1 reduces the |7  *       amount of overhead spent in this system call.    *   MAX_MARKOWITZ_TIES J  *       Specifies the number of Markowitz ties that are allowed to occur K  *       before the search for the pivot is terminated early.  Set to some  M  *       large value if no early termination of the pivot search is desired.  M  *       An array of doubles is allocated of size MAX_MARKOWITZ_TIES so don't P  *       get carried away with the large value.  Active when MODIFIED_MARKOWITZ L  *       is 1 (true). Also used when diagonal pivoting breaks down.  If the I  *       matrices tend to be nonhomogeneous in the sense that the density L  *       varies significantly throughout the matrix, then MAX_MARKOWITZ_TIESO  *       should be set large.  This can occur when nodes are numbered such thatoN  *       a certain type of component gets the first node numbers, another typeN  *       of components gets the next block of nodes, etc.  Setting this numberO  *       to zero effectively eliminates all pivoting, which should be avoided. y  */    /* Begin. */ #define  MAX_MATRIX_SIZE		32760y" #define  DEFAULT_THRESHOLD		1.0e-3 #define  FUZZ				1.0e-15 #define  SPACE_FOR_ELEMENTS		6 #define  SPACE_FOR_FILL_INS		4# #define  ELEMENTS_PER_ALLOCATION	50   #define  MAX_MARKOWITZ_TIES		100           r /*  *  MACHINE CONSTANTSy  *N  *  thest numbers must be updated when the program is ported to a new machine.  */N   /* Begin. */" /* VAX 11/780 Machine Constants */, #define  MACHINE_RESOLUTION      6.93889e-18, #define  LARGEST_REAL            1.70141e+38- #define  SMALLEST_REAL           2.938743-39 o& #define  LARGEST_SHORT_INTEGER   32766+ #define  LARGEST_LONG_INTEGER    2147483646n                  /*  *  OUTPUT FILES  *:  *  These are the files used by the OutputToFile routines.  *  *  >>> Files:  *  MATRIX_FILEaP  *      File to which OutputMatrixToFile and OutputVectorToFile sends a copy of &  *      the matrix and source vector.   *  STATISTICS_FILEr?  *      File to which OutputMatrixStatistics sends statistics.    *  ID_NUMBER_FILEM  *      File which contains an ID number for each matrix outputed to a file. RG  *      Used to tie together statistics to their coresponding matrix.  a  */e   /* Begin. */: #define  MATRIX_FILE		"/cad2/kundert/matrix/data/matrices": #define  STATISTICS_FILE	"/cad2/kundert/matrix/data/stats"; #define  ID_NUMBER_FILE		"/cad2/kundert/matrix/data/number"m         n /*  *  PRINTER WIDTHa  *G  *  These macros characterize the printer for the PrintMatrix routine. 1  *  *  >>> Macros:   *  NUMERIC_COLUMNS_PER_PAGEH  *      Sets the number of columns printed when PrintMatrix is executed.8  *      Set to 7 for terminal and 12 for line printer.    *  CHARACTER_COLUMNS_PER_PAGEK  *      Sets the number of columns printed when PrintMatrix is executed in aL  *      compressed mode.  In this mode, every nonzero entry in the matrix isH  *      printed simply as an `x'.  Set to 79 for terminal, 132 for line @  *      printer.  CHARACTER_COLUMNS_PER_PAGE must be larger than!  *      NUMERIC_COLUMNS_PER_PAGE.i  */e  
 /*  Begin. */ # #define  NUMERIC_COLUMNS_PER_PAGE	7o& #define  CHARACTER_COLUMNS_PER_PAGE	79           e /*  *  ANNOTATION  *G  *  This macro changes the amount of annotation produced by the matrix iL  *  routines.  The annotation is used as a debugging aid.  Change the numberK  *  associated with ANNOTATE to change the amount of annotation produced by   *  the program.  */,   /* Begin. */ #define  ANNOTATE		0   #define  NONE			0i #define  ON_STRANGE_BEHAVIOR	1 #define  FULL			2*  