 /*  *  MATRIX SOLVE MODULE*  *  *  Author:   *      Kenneth S. Kundert  *      UC BerkeleyV  *  *  Advising professor: '  *      Alberto Sangiovanni-Vincentelli*  *L  *  This module contains the forward and backward substitution routines for   *  the sparse matrix routines.i  *;  *  >>> User accessable functions contained in this module:.  *  SolveRealMatrixi  *  SolveComplexMatrix  *  SolveTransposedRealMatrix    *  SolveTransposedComplexMatrix  *  RealMatrixMultiply  *  ComplexMatrixMultiplyf  *+  *  >>> Functions contained in this module:t  *  SolveRealMatrixB  *  SolveComplexMatrix  *  SolveTransposedRealMatrixn   *  SolveTransposedComplexMatrix  *  RealMatrixMultiply  *  ComplexMatrixMultiplyM  */                * /*  *  IMPORTS   *  *  >>> Import descriptions:  *  stdio.hm  *      Standard D IO library.  *  MtrxPers.h/  *      Macros that customize matrix routines. n  *  MtrxExpt.h1  *      Macros for matrix routines used by user. e  *  MtrxDefs.h*  *      Matrix type and macro definitions.  *  MtrxError.hd'  *      Matrix error macro definitions.t  */t   #include <stdio.h> #include "MtrxPers.h"t #include "MtrxExpt.h"2 #include "MtrxDefs.h"n #include "MtrxError.h"               l /*  *  SOLVE REAL MATRIX EQUATION  *N  *  Performs forward elimination and back substitution to find unknown vector /  *  from source vector and decomposed matrix.  *  *  *  >>> Arguments:  *  Matrix  <input>  (char *)a  *      Pointer to matrix. r   *  Source  <input>  (double [])J  *      Source is the input data array, the right hand side. This data is J  *      undisturbed and may be reused for other solves. This array, as allI  *      arrays associated with the sparse matrix routines, use a startingA   *      index of one, not zero. #  *  Solution  <output>  (double [])IP  *      Solution is the output data array. This routine is constructed such thatE  *      Source and Solution can be the same array. This array, as allEI  *      arrays associated with the sparse matrix routines, use a starting*  *      index of one, not zero.   *  *  >>> Local variables:  *  Intermediate  (double []) F  *      Temporary storage for use in forward elimination and backward L  *      substitution.  Commonly referred to as c, when the LU Decomposition H  *      equations are given as  Ax = b, Lc = b, Ux = c Local version of G  *      Matrix->IntermediateReal, which was created during the initial  F  *      decomposition in function CreateMarkowitzVectors in the Matrix  *      Decomposition module.  w  *  pElement  (ElementPointer)M  *      Pointer used to address elements in both the lower and upper trianglen  *      matrices.   *  pEliminationOrder  (int *)M  *      Pointer used to sequentially access each entry in RowEliminationOrder P  *      and ColEliminationOrder arrays.  Used to quickly scramble and unscrambleG  *      Source and Solution to account for row and column interchanges.U  *  pPivot  (ElementPointer)A  *      Pointer that points to current pivot or diagonal element.O  *  Size  (int) :  *      Size of matrix. Made local to reduce indirection.   *  Temp  (double)0  *      Temporary storage for entries in arrays.  *  *  >>> Global variables:   *  gMatrix  <used>n  *  *  >>> Possible errors:	  *  RANGEr)  *  Error is not cleared in this routine.t  */p  f, SolveRealMatrix( Matrix, Source, Solution )                           MatrixPointer  Matrix; double  Source[], Solution[];d   {y
 #if (REAL)  + register  int  I, Size, *pEliminationOrder;i  register  double  *Intermediate;# register  ElementPointer  pElement;t ElementPointer  pPivot;.
 double  Temp;i   /* Begin. */ #if (DEBUG)u8     if ((NOT gMatrix->Decomposed) OR (gMatrix->Complex))     {   gMatrix->Error = RANGE;e         return;n     }h #endif       Size = Matrix->Size;,     Intermediate = Matrix->IntermediateReal;   & /* Initialize Intermediate vector. */ 4     pEliminationOrder = Matrix->RowEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++)a9         Intermediate[I] = Source[*(pEliminationOrder++)];M  L( /* Forward elimination. Solves Lc = b.*/     for (I = 1; I <= Size; I++) !     {   pPivot = Matrix->Diag[I];l         Temp = Intermediate[I];*                 B /* This step of the elimination is skipped if Temp equals zero. */         if (Temp != 0.0)!         {   Temp /= pPivot->Real;i#             Intermediate[I] = Temp;o)             pElement = pPivot->NextInCol; $             while (pElement != NULL)E             {   Intermediate[pElement->Row] -= Temp * pElement->Real;e/                 pElement = pElement->NextInCol;o
             }                  	         }d     }d                   * /* Backward Substitution. Solves Ux = c.*/     for (I = Size; I >= 1; I--)i     {   Temp = Intermediate[I];c.         pElement = Matrix->Diag[I]->NextInRow;          while (pElement != NULL)B         {   Temp -= pElement->Real * Intermediate[pElement->Col]; +             pElement = pElement->NextInRow;t	         }t         Intermediate[I] = Temp;      }   O /* Unscramble Intermediate vector while placing data in to Solution vector. */ s4     pEliminationOrder = Matrix->ColEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++) ;         Solution[*(pEliminationOrder++)] = Intermediate[I];E   #endif  /* REAL */     return;i }a                       /*!  *  SOLVE COMPLEX MATRIX EQUATION   *N  *  Performs forward elimination and back substitution to find unknown vector /  *  from source vector and decomposed matrix.  r  *  *  >>> Arguments:  *  Matrix  <input>  (char *)   *      Pointer to matrix. l$  *  SourceReal  <input>  (double [])O  *      SourceReal is the real portion of the input data array, the right hand aK  *      side. This data is undisturbed and may be reused for other solves. rN  *      This array, as all arrays associated with the sparse matrix routines, /  *      use a starting index of one, not zero. n$  *  SourceImag  <input>  (double [])O  *      SourceImag is the imaginary portion of the input data array, the right rP  *      hand side. This data is undisturbed and may be reused for other solves. N  *      This array, as all arrays associated with the sparse matrix routines, /  *      use a starting index of one, not zero. E'  *  SolutionReal  <output>  (double []) O  *      SolutionReal is the real portion of the output data array. This routine M  *      is constructed such that SourceReal and SolutionReal can be the same EK  *      array. This array, as all arrays associated with the sparse matrix  8  *      routines, use a starting index of one, not zero.'  *  SolutionImag  <output>  (double []) M  *      SolutionImag is the imaginary portion of the output data array. This  L  *      routine is constructed such that SourceImag and SolutionImag can be M  *      the same array. This array, as all arrays associated with the sparse p?  *      matrix routines, use a starting index of one, not zero.   *  *  >>> Local variables:!  *  IntermediateImag  (double [])=F  *      Temporary storage for use in forward elimination and backward K  *      substitution.  Commonly referred to as the imaginary portion of c, iP  *      when the LU Decomposition equations are given as  Ax = b, Lc = b, Ux = cL  *      Local version of Matrix->IntermediateImag, which was created during L  *      the initial decomposition in function CreateMarkowitzVectors in the &  *      Matrix Decomposition module.  !  *  IntermediateReal  (double []) %  *      Real version of Intermediate.   *  pElement  (ElementPointer)M  *      Pointer used to address elements in both the lower and upper triangle   *      matrices.   *  pEliminationOrder  (int *)M  *      Pointer used to sequentially access each entry in RowEliminationOrder P  *      and ColEliminationOrder arrays.  Used to quickly scramble and unscrambleG  *      Source and Solution to account for row and column interchanges.u  *  pPivot  (ElementPointer)A  *      Pointer that points to current pivot or diagonal element.e  *  Size  (int) :  *      Size of matrix. Made local to reduce indirection.   *  TempImag  (double)0  *      Temporary storage for entries in arrays.  *  TempReal  (double)0  *      Temporary storage for entries in arrays.  *  *  >>> Global variables:   *  gMatrix  <used>   *  *  >>> Possible errors:	  *  RANGEa)  *  Error is not cleared in this routine.*  */u  n4 SolveComplexMatrix( Matrix, SourceReal, SourceImag, 9                             SolutionReal, SolutionImag )                            MatrixPointer  Matrix;C double  SourceReal[], SourceImag[], SolutionReal[], SolutionImag[];i   { 
 #if (COMPLEX)E  + register  int  I, Size, *pEliminationOrder; 7 register  double  *IntermediateReal, *IntermediateImag; # register  ElementPointer  pElement;  ElementPointer  pPivot;I double  TempReal, TempImag;I CMPLX_DIVIDE_DECLARATIONS;   /* Begin. */ #if (DEBUG)t<     if ((NOT gMatrix->Decomposed) OR (NOT gMatrix->Complex))     {   gMatrix->Error = RANGE;e         return;      }  #endif       Size = Matrix->Size;0     IntermediateReal = Matrix->IntermediateReal;0     IntermediateImag = Matrix->IntermediateImag;   & /* Initialize Intermediate vector. */ 4     pEliminationOrder = Matrix->RowEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++) ?     {   IntermediateReal[I] = SourceReal[*(pEliminationOrder)]; A         IntermediateImag[I] = SourceImag[*(pEliminationOrder++)];r     }i  ,) /* Forward substitution. Solves Lc = b.*/*     for (I = 1; I <= Size; I++)n!     {   pPivot = Matrix->Diag[I]; '         TempReal = IntermediateReal[I];i'         TempImag = IntermediateImag[I];i                eC /* This step of the substitution is skipped if Temp equals zero. */s3         if ((TempReal != 0.0) OR (TempImag != 0.0)) 	         {a$ /* Complex divide : Temp /= Pivot */P             CMPLX_DIVIDE_ASSIGN(TempReal, TempImag, pPivot->Real, pPivot->Imag);+             IntermediateReal[I] = TempReal;o+             IntermediateImag[I] = TempImag;l)             pElement = pPivot->NextInCol;e$             while (pElement != NULL)             {  dH /* Complex expression : Intermediate[Element->Row] -= Temp * *Element */H                 CMPLX_MULT_SUBT_ASSIGN(IntermediateReal[pElement->Row], P                                       IntermediateImag[pElement->Row], TempReal,Q                                       TempImag, pElement->Real, pElement->Imag); f/                 pElement = pElement->NextInCol;e
             }*	         }e     }p  * /* Backward Substitution. Solves Ux = c.*/     for (I = Size; I >= 1; I--) '     {   TempReal = IntermediateReal[I]; '         TempImag = IntermediateImag[I];r.         pElement = Matrix->Diag[I]->NextInRow;            while (pElement != NULL)         {   H /* Complex expression : Temp -= *Element * Intermediate[Element->Col] */G             CMPLX_MULT_SUBT_ASSIGN(TempReal, TempImag, pElement->Real, *P                                 pElement->Imag, IntermediateReal[pElement->Col],A                                 IntermediateImag[pElement->Col]); +             pElement = pElement->NextInRow;]	         }g'         IntermediateReal[I] = TempReal; '         IntermediateImag[I] = TempImag;e     }m  O /* Unscramble Intermediate vector while placing data in to Solution vector. */  4     pEliminationOrder = Matrix->ColEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++) :     {   RANGE_CHECK(*pEliminationOrder,1,Size,"Solve197");A         SolutionReal[*(pEliminationOrder)] = IntermediateReal[I]; C         SolutionImag[*(pEliminationOrder++)] = IntermediateImag[I];d     }l   #endif  /* COMPLEX */a     return;m }a                           l /*)  *  SOLVE REAL TRANSPOSED MATRIX EQUATIONi  *N  *  Performs forward elimination and back substitution to find unknown vector O  *  from source vector and transposed decomposed matrix. This routine is usefulEO  *  when performing sensitivity analysis on a circuit using the adjoint method.O  *  *  >>> Arguments:  *  Matrix  <input>  (char *)a  *      Pointer to matrix.     *  Source  <input>  (double [])J  *      Source is the input data array, the right hand side. This data is J  *      undisturbed and may be reused for other solves. This array, as allI  *      arrays associated with the sparse matrix routines, use a startingh   *      index of one, not zero. #  *  Solution  <output>  (double [])dP  *      Solution is the output data array. This routine is constructed such thatE  *      Source and Solution can be the same array. This array, as all*I  *      arrays associated with the sparse matrix routines, use a startingt  *      index of one, not zero.r  *  *  >>> Local variables:  *  Intermediate  (double [])eF  *      Temporary storage for use in forward elimination and backward L  *      substitution.  Commonly referred to as c, when the LU Decomposition H  *      equations are given as  Ax = b, Lc = b, Ux = c Local version of G  *      Matrix->IntermediateReal, which was created during the initial tF  *      decomposition in function CreateMarkowitzVectors in the Matrix  *      Decomposition module.  a  *  pElement  (ElementPointer)M  *      Pointer used to address elements in both the lower and upper trianglez  *      matrices.   *  pEliminationOrder  (int *)M  *      Pointer used to sequentially access each entry in RowEliminationOrderzP  *      and ColEliminationOrder arrays.  Used to quickly scramble and unscrambleG  *      Source and Solution to account for row and column interchanges.   *  pPivot  (ElementPointer)A  *      Pointer that points to current pivot or diagonal element.t  *  Size  (int) :  *      Size of matrix. Made local to reduce indirection.   *  Temp  (double)0  *      Temporary storage for entries in arrays.  *  *  >>> Global variables:l  *  gMatrix  <used>S  *  *  >>> Possible errors:	  *  RANGEe)  *  Error is not cleared in this routine.i  */n  e6 SolveTransposedRealMatrix( Matrix, Source, Solution )                           MatrixPointer  Matrix; double  Source[], Solution[];d   {= #if (REAL AND TRANSPOSE)  + register  int  I, Size, *pEliminationOrder;t  register  double  *Intermediate;# register  ElementPointer  pElement;  ElementPointer  pPivot; 
 double  Temp;V   /* Begin. */ #if (DEBUG)T8     if ((NOT gMatrix->Decomposed) OR (gMatrix->Complex))     {   gMatrix->Error = RANGE;*         return;t     }t #endif       Size = Matrix->Size;,     Intermediate = Matrix->IntermediateReal;   & /* Initialize Intermediate vector. */ 4     pEliminationOrder = Matrix->ColEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++)t9         Intermediate[I] = Source[*(pEliminationOrder++)];   h /* Forward elimination. */     for (I = 1; I <= Size; I++)u!     {   pPivot = Matrix->Diag[I];s         Temp = Intermediate[I];i                rB /* This step of the elimination is skipped if Temp equals zero. */         if (Temp != 0.0))         {   pElement = pPivot->NextInRow; $             while (pElement != NULL)E             {   Intermediate[pElement->Col] -= Temp * pElement->Real;a/                 pElement = pElement->NextInRow; 
             },                 	         }e     }e                    /* Backward Substitution. */     for (I = Size; I >= 1; I--) !     {   pPivot = Matrix->Diag[I];d         Temp = Intermediate[I]; %         pElement = pPivot->NextInCol;s          while (pElement != NULL)B         {   Temp -= pElement->Real * Intermediate[pElement->Row]; +             pElement = pElement->NextInCol;a	         }u.         Intermediate[I] = Temp / pPivot->Real;     }r  O /* Unscramble Intermediate vector while placing data in to Solution vector. */  4     pEliminationOrder = Matrix->RowEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++)s5     {   RANGE_CHECK(pElement->Row,1,Size,"Solve317");d;         Solution[*(pEliminationOrder++)] = Intermediate[I];*     }n    #endif  /* REAL AND TRANSPOSE */     return;r }l                     /*,  *  SOLVE COMPLEX TRANSPOSED MATRIX EQUATION  *N  *  Performs forward elimination and back substitution to find unknown vector O  *  from source vector and transposed decomposed matrix. This routine is usefullO  *  when performing sensitivity analysis on a circuit using the adjoint method.o  *  *  >>> Arguments:  *  Matrix  <input>  (char *)   *      Pointer to matrix.  $  *  SourceReal  <input>  (double [])O  *      SourceReal is the real portion of the input data array, the right hand pK  *      side. This data is undisturbed and may be reused for other solves. lN  *      This array, as all arrays associated with the sparse matrix routines, /  *      use a starting index of one, not zero. )$  *  SourceImag  <input>  (double [])O  *      SourceImag is the imaginary portion of the input data array, the right TP  *      hand side. This data is undisturbed and may be reused for other solves. N  *      This array, as all arrays associated with the sparse matrix routines, /  *      use a starting index of one, not zero. f'  *  SolutionReal  <output>  (double [])xO  *      SolutionReal is the real portion of the output data array. This routineUM  *      is constructed such that SourceReal and SolutionReal can be the same [K  *      array. This array, as all arrays associated with the sparse matrix a8  *      routines, use a starting index of one, not zero.'  *  SolutionImag  <output>  (double []) M  *      SolutionImag is the imaginary portion of the output data array. This mL  *      routine is constructed such that SourceImag and SolutionImag can be M  *      the same array. This array, as all arrays associated with the sparse d?  *      matrix routines, use a starting index of one, not zero.I  *  *  >>> Local variables:!  *  IntermediateImag  (double [])uF  *      Temporary storage for use in forward elimination and backward K  *      substitution.  Commonly referred to as the imaginary portion of c, eP  *      when the LU Decomposition equations are given as  Ax = b, Lc = b, Ux = cL  *      Local version of Matrix->IntermediateImag, which was created during L  *      the initial decomposition in function CreateMarkowitzVectors in the &  *      Matrix Decomposition module.  !  *  IntermediateReal  (double [])t%  *      Real version of Intermediate.   *  pElement  (ElementPointer)M  *      Pointer used to address elements in both the lower and upper triangle)  *      matrices.   *  pEliminationOrder  (int *)M  *      Pointer used to sequentially access each entry in RowEliminationOrder P  *      and ColEliminationOrder arrays.  Used to quickly scramble and unscrambleG  *      Source and Solution to account for row and column interchanges.   *  pPivot  (ElementPointer)A  *      Pointer that points to current pivot or diagonal element.   *  Size  (int)s:  *      Size of matrix. Made local to reduce indirection.   *  TempImag  (double)0  *      Temporary storage for entries in arrays.  *  TempReal  (double)0  *      Temporary storage for entries in arrays.  *  *  >>> Global variables:h  *  gMatrix  <used>e  *  *  >>> Possible errors:	  *  RANGEs)  *  Error is not cleared in this routine.   */l  r> SolveTransposedComplexMatrix( Matrix, SourceReal, SourceImag, ;                               SolutionReal, SolutionImag ) (                          MatrixPointer  Matrix;C double  SourceReal[], SourceImag[], SolutionReal[], SolutionImag[];a   {  #if (TRANSPOSE AND COMPLEX)   + register  int  I, Size, *pEliminationOrder;a7 register  double  *IntermediateReal, *IntermediateImag; # register  ElementPointer  pElement;r ElementPointer  pPivot;o double  TempReal, TempImag;  CMPLX_DIVIDE_DECLARATIONS;   /* Begin. */ #if (DEBUG).<     if ((NOT gMatrix->Decomposed) OR (NOT gMatrix->Complex))     {   gMatrix->Error = RANGE;          return;i     }, #endif       Matrix->Error = NO_ERROR;      Size = Matrix->Size;0     IntermediateReal = Matrix->IntermediateReal;0     IntermediateImag = Matrix->IntermediateImag;  g& /* Initialize Intermediate vector. */ 4     pEliminationOrder = Matrix->ColEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++)e?     {   IntermediateReal[I] = SourceReal[*(pEliminationOrder)];*A         IntermediateImag[I] = SourceImag[*(pEliminationOrder++)];      }   a /* Forward elimination. */     for (I = 1; I <= Size; I++)p!     {   pPivot = Matrix->Diag[I];i'         TempReal = IntermediateReal[I];i'         TempImag = IntermediateImag[I];y                 B /* This step of the elimination is skipped if Temp equals zero. */3         if ((TempReal != 0.0) OR (TempImag != 0.0))e)         {   pElement = pPivot->NextInRow; $             while (pElement != NULL)=             {   RANGE_CHECK(pElement->Col,1,Size,"Solve287");mH /* Complex expression : Intermediate[Element->Col] -= Temp * *Element */H                 CMPLX_MULT_SUBT_ASSIGN( IntermediateReal[pElement->Col],I                                         IntermediateImag[pElement->Col], E<                                         TempReal, TempImag, H                                         pElement->Real, pElement->Imag);/                 pElement = pElement->NextInRow;r
             }o	         }n     }                     /* Backward Substitution. */     for (I = Size; I >= 1; I--) !     {   pPivot = Matrix->Diag[I]; '         TempReal = IntermediateReal[I];I'         TempImag = IntermediateImag[I];M%         pElement = pPivot->NextInCol;e            while (pElement != NULL)         {   H /* Complex expression : Temp -= Intermediate[Element->Row] * *Element */8             CMPLX_MULT_SUBT_ASSIGN( TempReal, TempImag, D                                     IntermediateReal[pElement->Row],E                                     IntermediateImag[pElement->Row], wD                                     pElement->Real, pElement->Imag);  +             pElement = pElement->NextInCol;I	         }>3 /* Complex divide : Intermediate = Temp / *Pivot */ H         CMPLX_DIVIDE(IntermediateReal[I], IntermediateImag[I], TempReal,;                      TempImag, pPivot->Real, pPivot->Imag);l     }r  O /* Unscramble Intermediate vector while placing data in to Solution vector. */  4     pEliminationOrder = Matrix->RowEliminationOrder;     pEliminationOrder++;     for (I = 1; I <= Size; I++) A     {   SolutionReal[*(pEliminationOrder)] = IntermediateReal[I];aC         SolutionImag[*(pEliminationOrder++)] = IntermediateImag[I];      }   # #endif  /* TRANSPOSE AND COMPLEX */i     return;  }a                         r /*  *  REAL MATRIX MULTIPLICATION  *L  *  Multiplies matrix times solution vector to find source vector.  Assumes O  *  matrix has not been decomposed.  This routine can be used as a test to see t  *  if solutions are correct.m  *  *  >>> Arguments:  *  Matrix  <input>  (char *)   *      Pointer to the matrix.!  *  Source  <output>  (double [])eK  *      Source is the right hand side. This is  what is being solved for.  e"  *  Solution  <input>  (double [])?  *      Solution is the vector being multiplied by the matrix. o  *  *  >>> Local variables:  *  Index  (int)/  *      Index for Source and Solution vectors. !  *  pElement  (ElementPointer)8  *      Pointer used to address elements in the matrix.   *  Size  (int)    *      The size of the matrix.   *  Temp  (double)  *      Temporary storage. e  */   / RealMatrixMultiply( Matrix, Source, Solution ) L                           register  MatrixPointer  Matrix; double  Source[], Solution[];    {e #if (REAL AND DOCUMENTATION)   register  int  I, Size, Index;# register  ElementPointer  pElement; 
 double  Temp;    /* Begin. */     Size = Matrix->Size;  g     for (I = Size; I >= 1; I--)l)     {   pElement = Matrix->FirstInRow[I];          Temp = 0.0;             while (pElement != NULL)?         {   Index = Matrix->ColEliminationOrder[pElement->Col];a5             Temp += pElement->Real * Solution[Index]; +             pElement = pElement->NextInRow;E	         }i  /         Index = Matrix->RowEliminationOrder[I];)         Source[Index] = Temp;e     }      return;m  $ #endif  /* REAL AND DOCUMENTATION */ }                    S /*!  *  COMPLEX MATRIX MULTIPLICATION   *L  *  Multiplies matrix times solution vector to find source vector.  Assumes L  *  matrix has not been decomposed.  This routine can be  used as a test to !  *  see if solutions are correct.g  *  *  >>> Arguments:  *  Matrix  <input>  (char *)   *      Pointer to the matrix.%  *  SourceReal  <output>  (double [])ML  *      SourceReal is the real portion of the right hand side. This is what   *      is being solved for.  %  *  SourceImag  <output>  (double []) L  *      SourceImag is the imaginary portion of the right hand side. This is #  *      what is being solved for.  r&  *  SolutionReal  <input>  (double [])K  *      SolutionReal is the real portion of the vector being multiplied by e  *      the matrix. &  *  SolutionImag  <input>  (double [])M  *      SolutionImag is the imaginary portion of the vector being multiplied u  *      by the matrix.    *  *  >>> Local variables:  *  Index  (int)/  *      Index for Source and Solution vectors. o  *  pElement  (ElementPointer)8  *      Pointer used to address elements in the matrix.   *  Size  (int)s   *      The size of the matrix.   *  TempImag  (double)  *      Temporary storage. r  *  TempReal  (double)  *      Temporary storage. t  */   7 ComplexMatrixMultiply( Matrix, SourceReal, SourceImag,  4                        SolutionReal, SolutionImag )                           MatrixPointer  Matrix;B double SourceReal[], SourceImag[], SolutionReal[], SolutionImag[];   {  #if (COMPLEX AND DOCUMENTATION)i   register  int  I, Size, Index;# register  ElementPointer  pElement;c double  TempReal, TempImag;l   /* Begin. */     Size = Matrix->Size;  o     for (I = Size; I >= 1; I--) )     {   pElement = Matrix->FirstInRow[I];m         TempReal = 0.0;          TempImag = 0.0;t            while (pElement != NULL)?         {   Index = Matrix->ColEliminationOrder[pElement->Col];C: /* Cmplx expression : Temp += Element * Solution[Index] */7             CMPLX_MULT_ADD_ASSIGN( TempReal, TempImag, eC                                    pElement->Real, pElement->Imag,  M                                    SolutionReal[Index], SolutionImag[Index]); +             pElement = pElement->NextInRow;t	         }x  /         Index = Matrix->RowEliminationOrder[I];n%         SourceReal[Index] = TempReal; %         SourceImag[Index] = TempImag;      }e     return;=  ' #endif  /* COMPLEX AND DOCUMENTATION */e }g  