? /* The partitioner takes a flat description of a circuit and */ # /* breaks it up into subciruits. */g #include <math.h>" #include <stdio.h> #include "simconst.h"r #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"  #include "mstruct.h"   #define ALREADY TRUE+5 #define MAXDEPTH 5  ( /* Stack globals for the partitioner. */ int *tstk, *bstk;;       stuffdev(partdevlist)  struct device *partdevlist;= {  int i; struct device *devptr;  9 /* Put in the minimum linear capacitance at each node. */i  /* And set up for simulation. */   for(i=0; i <= maxnode; i++) {c     devarray[i].sumcap = cmin;8     devarray[i].nodenum = i; /* Just its node number. */H     devarray[i].flag = 0; /* Flag used to indicate subcircuit number. */L     devarray[i].newnode = i; /* Nothing tied together, or converted node. */3     devarray[i].botnode = i; /* Is last in list. */(     devarray[i].oldnodecnt = 0;t     devarray[i].nodecnt = 1;   }f0 /* Put the device list into the device array. */D   for(devptr = partdevlist; devptr != NULL; devptr = devptr->next) {      (*devptr->stuffdev)(devptr);   }  }l  E /* Adddevarray takes a pointer to a device and a node number, and  */tE /* adds that device to the list of devices connected to that node. */i adddevarray(devptr, node)( struct device *devptr;	 int node;p {k struct deventry *deventryptr;,K /* Error exit on negative node number.  Just return if ground or source. */3)   if( (node < 0) || (node > maxnode) ) {  K      printf("adddevice error node = %d out of bounds\n", node); exit(0); };"G   if((node==0)||(waves[node].present->wavetype==USERSRC)) return(OKAY);%  3 /* Then go to end of the dev list for this node. */ (   if(devarray[node].deventptr == NULL) {"     devarray[node].nodenum = node;     devarray[node].deventptr = t9 		(struct deventry *) ralloc(1, sizeof(struct deventry)); +     deventryptr = devarray[node].deventptr;a   }    else {+     deventryptr = devarray[node].deventptr;rE     while(deventryptr->next != NULL) deventryptr = deventryptr->next;     deventryptr->next = 8 	(struct deventry *) ralloc(1, sizeof(struct deventry));$     deventryptr = deventryptr->next;   }y  6 /* And put the device ptr in the device entry list. */   deventryptr->next = NULL;    deventryptr->devptr = devptr;     deventryptr->devptr->flag = 0;   deventryptr->eqnnode = node;   return(OKAY);c }i     /* The partitioning algorithm:D * Step 1: For each node in the circuit, assess the effective sum of ? * 	  conductances and sum of capacitances incident at the node.fE * Step 2: Tie together nodes connected by conductances that are large%? *	  compared to the total conductance incident at the node, and"= *	  tie together nodes connected by capacitors that are large{; *	  compared to the total capacitance incident at the node.(J * Step 3: Tie together tight feedback loops.  So far this involves looking *	  for cross-coupled mosfets. */ partition()) { + double capsum, condsum, hmin, estavgcond();  struct deventry *pentry; struct nodedevlist *pdevlist;, struct fet1 *pm1;  struct fetti *pmti;e struct lcap *cptr; struct lres *rptr; struct diode *dptr;) int conone, i, conflg;   /* Create space for a stack */1   bstk = (int *) ralloc(MAXDEPTH+2, sizeof(int));n   for(i=0; i <= maxnode; i++) { :       devarray[i].nodenum = i; /* Just its node number. */J       devarray[i].flag = 0; /* Flag used to indicate subcircuit number. */N       devarray[i].newnode = i; /* Nothing tied together, or converted node. */5       devarray[i].botnode = i; /* Is last in list. */WJ       devarray[i].nodecnt = 1; /* Number of nodes in subcircuit so far. */!       devarray[i].oldnodecnt = 0;)   }   F /* First pass - tie nodes connected by large floating conductances. */   conone = TRUE; _   while(conone == TRUE) {t     conone = FALSE;AD     for(i=1; i <= maxnode; i++) { /* Run through all the devices. */1       if(waves[i].present->wavetype != USERSRC) {iN         for(pentry= devarray[i].deventptr; pentry!=NULL; pentry=pentry->next) 2 				    if(condtie(pentry) == TRUE) conone = TRUE;       }r     }r   }s  K /* Compute the minimum resonable timestep to scale the conductances with */ " /* respect to the capacitances. */4   estmincap();   /* Node by node min capacitance. */:   for(capsum = 0 , condsum = 0 , i=1; i <= maxnode; i++) {+     if( (devarray[i].deventptr != NULL) && P3         (waves[i].present->wavetype != USERSRC) ) { A       tstk = bstk; *tstk = i; devarray[i].maxcond = estavgcond();v#       capsum += devarray[i].sumcap;v%       condsum += devarray[i].maxcond;p     }e   }tN   hmin = capsum/(condsum + gmin); /* Just make sure conductance isn't zero. */  H /* The second step.  Go back through the circuit tying together nodes */F /* with large floating capacitors.  Don't iterate here.  If someone */; /* puts in a string of large floating capacitors, tough. */    conone = TRUE;   while(conone == TRUE) {c     conone = FALSE;iD     for(i=1; i <= maxnode; i++) { /* Run through all the devices. */1       if(waves[i].present->wavetype != USERSRC) {p+         for(pentry= devarray[i].deventptr; i4                  pentry!=NULL; pentry=pentry->next) 2 				if(captie(pentry,hmin) == TRUE) conone = TRUE;       }o     }"   }   > /* Third pass, Tie tight feedbacks together (gate to drain) */. /* Chase down all the collections of nodes. */   do {     conone = FALSE;r     for(i=1; i < maxnode; i++) i2       if( (waves[i].present->wavetype != USERSRC) F 	  && (devarray[i].deventptr != NULL) && (devarray[i].prev == NULL) ) '       /* Chase down the device list. */*&         for(pdevlist = &(devarray[i]);D                       pdevlist != NULL; pdevlist = pdevlist->next) {;           for(pentry = pdevlist->deventptr; pentry != NULL;/ 	 					 pentry = pentry->next)I           /* Check if this device's gatenode, if its contained in this */oL           /* Node collection, is bidirectionally coupled to another node. */$ 	    switch(pentry->devptr->utype) {             case FET1 : 4 	      pm1 = (struct fet1 *) pentry->devptr->devptr;1               if(pm1->gnode == pentry->eqnnode) {*8 	        if(bicheck(pm1->dnode, &(devarray[i])) == TRUE)? 		  if(connodes(pm1->gnode, pm1->dnode) == TRUE) conone = TRUE; 8 	        if(bicheck(pm1->snode, &(devarray[i])) == TRUE)? 		  if(connodes(pm1->gnode, pm1->snode) == TRUE) conone = TRUE; 	 	      }	L
 	      break;=             case FETTI : R6 	      pmti = (struct fetti *) pentry->devptr->devptr;2               if(pmti->gnode == pentry->eqnnode) {9 	        if(bicheck(pmti->dnode, &(devarray[i])) == TRUE)	2 		  if(connodes(pmti->gnode, pmti->dnode) == TRUE) 							  conone = TRUE;C9 	        if(bicheck(pmti->snode, &(devarray[i])) == TRUE)n2 		  if(connodes(pmti->gnode, pmti->snode) == TRUE) 							  conone = TRUE; 	 	      }	p     	      break;(             case LCAP : break;             case DIODE : break;v             case LRES : break;       	    case ISRC : break;v 	    default :  = 		printf("Unknown device in partitioner phase 3\n"); exit(0);g
             }  	}   } while (conone == TRUE);  }    bicheck(othernode, nodeentptr) int othernode; struct nodedevlist *nodeentptr;a {n struct deventry *pentry;3 struct nodedevlist *pdevlist, *firstptr, *chaseptr;a struct fet1 *fetptr; struct fetti *fettiptr;/H /* Chase down the node collection list, to see if othernode is in the */ /* gate node's collection. *//I   for(pdevlist = nodeentptr; pdevlist != NULL; pdevlist = pdevlist->next);8 			    if(pdevlist->nodenum == othernode) return(FALSE);L /* Then see if the othernode's collection has a gatenode that has a dnode */1 /* or snode in the original gnode's collection.*/L8 /* First get to the top of the othernodes collection. */(   for(firstptr = &(devarray[othernode]);5 		firstptr->prev != NULL; firstptr = firstptr->prev);h1 /* Then chase down the othernodes device list. */nG   for(pdevlist = firstptr; pdevlist != NULL; pdevlist = pdevlist->next) 5     for(pentry = pdevlist->deventptr; pentry != NULL;g 	 					 pentry = pentry->next)%       switch(pentry->devptr->utype) { B       case FET1 : fetptr = (struct fet1 *) pentry->devptr->devptr;.         if(fetptr->gnode == pentry->eqnnode) {/ 	  for(chaseptr = nodeentptr; chaseptr != NULL; " 					 chaseptr = chaseptr->next) {9 	    if(chaseptr->nodenum == fetptr->dnode) return(TRUE);e9 	    if(chaseptr->nodenum == fetptr->snode) return(TRUE);e 	  } 	}         break;F       case FETTI : fettiptr = (struct fetti *) pentry->devptr->devptr;0         if(fettiptr->gnode == pentry->eqnnode) {/ 	  for(chaseptr = nodeentptr; chaseptr != NULL; " 					 chaseptr = chaseptr->next) {; 	    if(chaseptr->nodenum == fettiptr->dnode) return(TRUE);i; 	    if(chaseptr->nodenum == fettiptr->snode) return(TRUE);c 	  } 	}         break;       case LCAP : break;       case DIODE : break;l       case LRES : break;       case ISRC : break;@       default: printf("Unknown device in Bi-Check.\n"); exit(0);       }=   return(FALSE); }e  C /* Ties together nodes connected by large floating conductances. */* condtie(pentry)t struct deventry *pentry; {s double cond, estcond();U struct fet1 *pm1;  struct fetti *pmti;T struct lres *rptr; struct diode *dptr;i int conone;i     conone = FALSE;]!   switch(pentry->devptr->utype) {>     case FET1: e3       pm1 = (struct fet1 *) pentry->devptr->devptr; )       if(pm1->dnode == pentry->eqnnode) {a4         if(chkthis(pm1->dnode,pm1->snode) == TRUE) {<           tstk = bstk; *tstk = pm1->dnode; cond = estcond();,           if(pm1->beta > (pfactor * cond)) {>             tstk = bstk; *tstk = pm1->snode; cond = estcond();.             if(pm1->beta > (pfactor * cond)) {= 		if(connodes(pm1->dnode, pm1->snode) == TRUE) conone = TRUE;n
             }t           }i	         }t       }t       break;     case FETTI:t5       pmti = (struct fetti *) pentry->devptr->devptr;c*       if(pmti->dnode == pentry->eqnnode) {6         if(chkthis(pmti->dnode,pmti->snode) == TRUE) {=           tstk = bstk; *tstk = pmti->dnode; cond = estcond(); -           if(pmti->beta > (pfactor * cond)) {E?             tstk = bstk; *tstk = pmti->snode; cond = estcond(); /             if(pmti->beta > (pfactor * cond)) {'? 		if(connodes(pmti->dnode, pmti->snode) == TRUE) conone = TRUE;c
             }(           }d	         }e       }        break;     case LRES:4       rptr = (struct lres *) pentry->devptr->devptr;*       if(rptr->node1 == pentry->eqnnode) {6         if(chkthis(rptr->node1,rptr->node2) == TRUE) {=           tstk = bstk; *tstk = rptr->node1; cond = estcond();e0           if(rptr->condval > (pfactor * cond)) {?             tstk = bstk; *tstk = rptr->node2; cond = estcond();v2             if(rptr->condval > (pfactor * cond)) {? 		if(connodes(rptr->node1, rptr->node2) == TRUE) conone = TRUE; 
             }e           } 	         }s       }e       break;     case DIODE:U5       dptr = (struct diode *) pentry->devptr->devptr;n)       if(dptr->anode == pentry->eqnnode) a> 		if(connodes(dptr->anode,dptr->cnode) == TRUE) conone = TRUE;       break;     case LCAP: break;>     case ISRC : break;I     default : printf("Unknown dev in condtie in partitioner\n"); exit(0);    }(   return(conone);= }t    C /* Ties together nodes connected by large floating capacitances. */e captie(pentry,hmin)} struct deventry *pentry; double hmin; {a double cap, estcap();b struct fet1 *pm1;L struct fetti *pmti;a struct lcap *cptr; int conone;p     conone = FALSE; !   switch(pentry->devptr->utype) {=     case FET1: ;3       pm1 = (struct fet1 *) pentry->devptr->devptr;a)       if(pm1->gnode == pentry->eqnnode) {t4         if(chkthis(pm1->gnode,pm1->dnode) == TRUE) {>           tstk = bstk; *tstk = pm1->gnode; cap = estcap(hmin);+           if(pm1->cox > (cpfactor * cap)) { @             tstk = bstk; *tstk = pm1->dnode; cap = estcap(hmin);<             if( pm1->cox > (cpfactor * (cap + pm1->cox)) ) {= 		if(connodes(pm1->dnode, pm1->gnode) == TRUE) conone = TRUE; 
             }e           } 	         }i4         if(chkthis(pm1->gnode,pm1->snode) == TRUE) {>           tstk = bstk; *tstk = pm1->gnode; cap = estcap(hmin);+           if(pm1->cox > (cpfactor * cap)) { @             tstk = bstk; *tstk = pm1->snode; cap = estcap(hmin);<             if( pm1->cox > (cpfactor * (cap + pm1->cox)) ) {= 		if(connodes(pm1->snode, pm1->gnode) == TRUE) conone = TRUE;/
             }y           }x	         }        }k       break;     case FETTI:i5       pmti = (struct fetti *) pentry->devptr->devptr; *       if(pmti->gnode == pentry->eqnnode) {6         if(chkthis(pmti->gnode,pmti->dnode) == TRUE) {?           tstk = bstk; *tstk = pmti->gnode; cap = estcap(hmin); .           if(pmti->cgsub > (cpfactor * cap)) {A             tstk = bstk; *tstk = pmti->dnode; cap = estcap(hmin);fB             if( pmti->cgsub > (cpfactor * (cap + pmti->cgsub)) ) {? 		if(connodes(pmti->dnode, pmti->gnode) == TRUE) conone = TRUE;(
             }-           }U	         } 6         if(chkthis(pmti->gnode,pmti->snode) == TRUE) {?           tstk = bstk; *tstk = pmti->gnode; cap = estcap(hmin); .           if(pmti->cgsub > (cpfactor * cap)) {A             tstk = bstk; *tstk = pmti->snode; cap = estcap(hmin);fB             if( pmti->cgsub > (cpfactor * (cap + pmti->cgsub)) ) {? 		if(connodes(pmti->snode, pmti->gnode) == TRUE) conone = TRUE;r
             }e           }e	         }        }        break;     case LCAP:4       cptr = (struct lcap *) pentry->devptr->devptr;*       if(cptr->node1 == pentry->eqnnode) {6         if(chkthis(cptr->node1,cptr->node2) == TRUE) {?           tstk = bstk; *tstk = cptr->node1; cap = estcap(hmin); /           if(cptr->capval > (cpfactor * cap)) { A             tstk = bstk; *tstk = cptr->node2; cap = estcap(hmin); 1             if(cptr->capval > (cpfactor * cap)) {l? 		if(connodes(cptr->node1, cptr->node2) == TRUE) conone = TRUE;p
             }h           }b	         }c       }t       break;     case DIODE: break;     case LRES: break;n     case ISRC : break;H     default : printf("Unknown dev in captie in partitioner\n"); exit(0);   }r   return(conone);> }p     double estcap(hmin)1 double hmin; {- double cap, temp, estcap();h int node, match, *instk; struct deventry *pentry; struct lres *rptr; struct lcap *cptr; struct diode *dptr;f struct fet1 *pm1;o struct fetti *pmti;  /*   printf("estcap stack\n");dE   for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) {m1             printf("stack = %d ",  *(instk--)  );    }U   printf("\n");  */4 /* If this nodeentry is the beginning chase away. */M   cap = devarray[*tstk].sumcap; /* Start with cap equal to sumcap at node. */dM   for(pentry= devarray[*tstk].deventptr; pentry!=NULL; pentry=pentry->next) { #     switch(pentry->devptr->utype) {p       case FET1:  5         pm1 = (struct fet1 *) pentry->devptr->devptr;)G         if(pm1->gnode == *tstk) cap += pm1->cox * min(pm1->gamma, 1.0); L         else if(pm1->bnode == *tstk) cap += pm1->cox * min(pm1->gamma, 1.0);         break;       case FETTI: 7         pmti = (struct fetti *) pentry->devptr->devptr;dI         if(pmti->gnode == *tstk) cap += pmti->cgsub * min(pmti->be, 1.0);kN         else if(pmti->bnode == *tstk) cap += pmti->cgsub * min(pmti->be, 1.0);       case DIODE: 7         dptr = (struct diode *) pentry->devptr->devptr;p8         if(chkconn(dptr->anode, dptr->cnode) == FALSE) {:           if(dptr->anode == *tstk) cap += 0.5 * dptr->cjo;?           else if(dptr->cnode == *tstk) cap += 0.5 * dptr->cjo; 	         }f         break;       case LCAP: =6         cptr = (struct lcap *) pentry->devptr->devptr;5         if(chkconn(cptr->node1,cptr->node2) == TRUE) r4 		          if( ((int) (tstk - bstk)) < MAXDEPTH ) {7         /* Find out which cap node is not this node. */c6           if(cptr->node1 != *tstk) node = cptr->node1;"           else node = cptr->node2;/         /* Avoid going back the way we came. */ M           for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) {d0             if(node == *(instk--)) match = TRUE;           } ,         /* Time to recurse down the tree. */:           if(match == FALSE) {  /* Don't revisit nodes. */A             *(++tstk) = node; /* Place this node on the stack. */               temp = estcap(hmin);L           /* Subtract contribution of this cap to sumcap, and add series. */N             cap += (cptr->capval * temp)/(cptr->capval + temp) - cptr->capval;4             tstk--; /* Pop the node off the stack */           } 	         }d         break;       case ISRC : break;       case LRES: t6         rptr = (struct lres *) pentry->devptr->devptr;6         if(chkconn(rptr->node1,rptr->node2) == FALSE) ! 					cap += hmin * rptr->condval;s6         else if( ((int) (tstk - bstk)) < MAXDEPTH )  {<         /* Find out which resistor node is not this node. */6           if(rptr->node1 != *tstk) node = rptr->node1;"           else node = rptr->node2;  /         /* Avoid going back the way we came. */=M           for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) {d0             if(node == *(instk--)) match = TRUE;           }   ,         /* Time to recurse down the tree. */:           if(match == FALSE) {  /* Don't revisit nodes. */A             *(++tstk) = node; /* Place this node on the stack. */v              temp = estcap(hmin);N             cap += (temp * hmin* rptr->condval)/(hmin * rptr->condval + temp);4             tstk--; /* Pop the node off the stack */           }a	         }e         break;=       default: printf("Unknown device in estcap\n"); exit(0);-     }=   }t   return(cap); }f   double estcond() {p double cond, temp, estcond();U int node, match, *instk; struct deventry *pentry; struct lres *rptr;  4 /* If this nodeentry is the beginning chase away. */   cond = 0; M   for(pentry= devarray[*tstk].deventptr; pentry!=NULL; pentry=pentry->next) { #     switch(pentry->devptr->utype) {2       case FET1: break;        case FETTI: break;       case DIODE: break;       case LCAP: break;        case ISRC : break;       case LRES: e6         rptr = (struct lres *) pentry->devptr->devptr;N       /* If the resistor is tied to voltage source, it adds to conductance. */@         if( (waves[rptr->node1].present->wavetype == USERSRC) ||@             (waves[rptr->node2].present->wavetype == USERSRC) )  							cond += rptr->condval;n5         else if( ((int) (tstk - bstk)) < MAXDEPTH)  { <         /* Find out which resistor node is not this node. */6           if(rptr->node1 != *tstk) node = rptr->node1;"           else node = rptr->node2;  /         /* Avoid going back the way we came. */TM           for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) {s0             if(node == *(instk--)) match = TRUE;           }o  ,         /* Time to recurse down the tree. */:           if(match == FALSE) {  /* Don't revisit nodes. */A             *(++tstk) = node; /* Place this node on the stack. */r+             temp = estcond(); /* Recurse */ H             cond += ( (rptr->condval * temp) / (rptr->condval + temp) );4             tstk--; /* Pop the node off the stack */           }r	         }l         break;>       default: printf("Unknown device in estcond\n"); exit(0);     }    }c   return(cond);- }n     double estavgcond()( {t  double cond, temp, estavgcond(); int node, match, *instk; struct deventry *pentry; struct lres *rptr; struct fet1 *pm1;t struct fetti *pmti;e  4 /* If this nodeentry is the beginning chase away. */( /* Always stop on transistors though. */   cond = 0;=M   for(pentry= devarray[*tstk].deventptr; pentry!=NULL; pentry=pentry->next) { #     switch(pentry->devptr->utype) {        case FET1: T5         pm1 = (struct fet1 *) pentry->devptr->devptr;          cond += pm1->beta;         break;       case FETTI:o7         pmti = (struct fetti *) pentry->devptr->devptr;p         cond += pmti->beta;          break;       case DIODE: break;       case LCAP: break;        case ISRC : break;       case LRES: t6         rptr = (struct lres *) pentry->devptr->devptr;L         if(chkconn(rptr->node1,rptr->node2) == FALSE) cond += rptr->condval;5         else if( ((int) (tstk - bstk)) < MAXDEPTH ) {,6           if(rptr->node1 != *tstk) node = rptr->node1;"           else node = rptr->node2;M           for(instk=tstk , match=FALSE; (match == FALSE)&&(instk >= bstk);) {e0             if(node == *(instk--)) match = TRUE;           } :           if(match == FALSE) {  /* Don't revisit nodes. */A             *(++tstk) = node; /* Place this node on the stack. */L.             temp = estavgcond(); /* Recurse */H             cond += ( (rptr->condval * temp) / (rptr->condval + temp) );4             tstk--; /* Pop the node off the stack */           }e	         }          break;A       default: printf("Unknown device in estavgcond\n"); exit(0);-     }.   }n   return(cond);E }C  * /* Assume estcond has already been run. */ estmincap()1 {  double temp, temp2;  struct deventry *pentry; struct fet1 *pm1;= struct fetti *pmti;m struct diode *dptr;k int i;     for(i=1; i <= maxnode; i++) { ,     devarray[i].mincap = devarray[i].sumcap;/     if(waves[i].present->wavetype != USERSRC) { M       for(pentry= devarray[i].deventptr; pentry!=NULL; pentry=pentry->next) {n(          switch(pentry->devptr->utype) {           case FET1: p9             pm1 = (struct fet1 *) pentry->devptr->devptr;p!             if(pm1->gnode == i) { # 	      temp = min(pm1->gamma, 1.0);r6 	      devarray[pm1->gnode].mincap += temp * pm1->cox;
             }.&             else if(pm1->bnode == i) {# 	      temp = min(pm1->gamma, 1.0);1=               devarray[pm1->bnode].mincap += temp * pm1->cox;t
             }y             break;           case FETTI: ;             pmti = (struct fetti *) pentry->devptr->devptr;l"             if(pmti->gnode == i) {! 	      temp = min(pmti->be, 1.0); : 	      devarray[pmti->gnode].mincap += temp * pmti->cgsub;: 	      devarray[pmti->bnode].mincap += temp * pmti->cgsub;
             } '             else if(pmti->bnode == i) {.! 	      temp = min(pmti->be, 1.0);pA               devarray[pmti->bnode].mincap += temp * pmti->cgsub;r
             }e 	    break;            case DIODE: ;             dptr = (struct diode *) pentry->devptr->devptr;t              if(dptr->anode == i)2 			 devarray[dptr->anode].mincap += 0.5*dptr->cjo;%             else if(dptr->cnode == i)d4 			 devarray[dptr->cnode].mincap += 0.5 * dptr->cjo;             break;           case LRES: break; ?           case LCAP: break; /* Linear caps already included. */            case ISRC : break;N           default : printf("Unknown dev in capacitance estimator\n"); exit(0);	         }a       }.     }    }  }o    > /* Connect the nodes by doubly linking the two node entries */ /* in the device array. */ connodes(node1, node2) int node1, node2;  {*; struct nodedevlist *last1ptr, *top2ptr, *top1ptr, *tempptr;   2 /* Don't con ground nodes or user source nodes. */3   if( (node1 <= 0) || (node2 <= 0) ) return(FALSE);n4   if( (waves[node1].present->wavetype == USERSRC) ||> 		(waves[node2].present->wavetype == USERSRC) ) return(FALSE);( /* Point to the top of the two lists. */2   top1ptr = &(devarray[devarray[node1].newnode]); 3   top2ptr = &(devarray[devarray[node2].newnode]);  e* /* Make sure two aren't already linked. */9   if(top1ptr->newnode == top2ptr->newnode) return(FALSE);./ /* Swap if node2 list has lower node number. */ ,   if(top1ptr->newnode > top2ptr->newnode) { <     tempptr = top1ptr; top1ptr = top2ptr; top2ptr = tempptr;   }t- /* Mark higher with the lower node number. */;B   for(tempptr = top2ptr; tempptr != NULL; tempptr = tempptr->next), 				    tempptr->newnode = top1ptr->newnode; /* Bot of node1 list. */-   last1ptr = &(devarray[top1ptr->botnode]);  ; /* Link the two. */ G   top1ptr->nodecnt += top2ptr->nodecnt;  /* Keep a count of # nodes. */    last1ptr->next = top2ptr;    top2ptr->prev = last1ptr; &   top1ptr->botnode = top2ptr->botnode; /*1   for(; top1ptr != NULL; top1ptr = top1ptr->next)e$     printf("n = %d b= %d on=%d \n", 8 		top1ptr->newnode, top1ptr->botnode, top1ptr->nodenum); */   return(TRUE);. }1  8 /* Check whether node1 is already connected to node2. */8 /* Return false if either node is a source or ground. */ chkconn(node1, node2)i int node1, node2;  {t3   if( (node1 == 0) || (node2 == 0) ) return(FALSE);)4   if( (waves[node1].present->wavetype == USERSRC) ||> 		(waves[node2].present->wavetype == USERSRC) ) return(FALSE);F   if(devarray[node2].newnode == devarray[node1].newnode) return(TRUE);   return(FALSE); }i  J /* Indicate whether to bother checking to connect this two nodes. Don't */I /* bother if one is a voltage source or ground or if already connected */e chkthis(node1, node2)p int node1, node2;* {eM   if( (node1 == 0) || (node2 == 0) ) return(FALSE); /* Ground node is out. */oG   if(devarray[node2].newnode == devarray[node1].newnode) return(FALSE); 4   if( (waves[node1].present->wavetype == USERSRC) ||> 		(waves[node2].present->wavetype == USERSRC) ) return(FALSE);   return(TRUE);a }a