 /*  * qsort.c:eM  * The THRESHold below is the insertion sort threshold, and has been adjusted    * for records of size 48 bytes.;  * The MTHREShold is where we stop finding a better median.r  */i  1 #define		THRESH		4		/* threshold for insertion */ / #define		MTHRESH		6		/* threshold for median */a  5 static  int		(*qcmp)();		/* the comparison routine */d- static  int		qsz;			/* size of each record */c/ static  int		thresh;			/* THRESHold in chars */c0 static  int		mthresh;		/* MTHRESHold in chars */   /*	  * qsort:,J  * First, set up some global parameters for qst to share.  Then, quicksortJ  * with qst(), and then a cleanup insertion sort ourselves.  Sound simple?  * It's not...  */    qsort(base, n, size, compar) 	char	*base; 	int	n;a
 	int	size; 	int	(*compar)();e { # 	register char c, *i, *j, *lo, *hi;  	char *min, *max;f   	if (n <= 1)	 		return;  	qsz = size; 	qcmp = compar;- 	thresh = qsz * THRESH;e 	mthresh = qsz * MTHRESH;- 	max = base + n * qsz; 	if (n >= THRESH) {r 		qst(base, max);j 		hi = base + thresh;+	 	} else {i 		hi = max;( 	} 	/*-E 	 * First put smallest element, which must be in the first THRESH, inrE 	 * the first position as a sentinel.  This is done just by searchingiE 	 * the first THRESH elements (or the first n if n < THRESH), finding)5 	 * the min, and swapping it into the first position.  	 */( 	for (j = lo = base; (lo += qsz) < hi; ) 		if ((*qcmp)(j, lo) > 0)d
 			j = lo; 	if (j != base) {e 		/* swap j into place */[- 		for (i = base, hi = base + qsz; i < hi; ) {f
 			c = *j;
 			*j++ = *i;u 			*i++ = c; 		}r 	} 	/*eC 	 * With our sentinel in place, we now run the following hyper-fast H 	 * insertion sort.  For each remaining element, min, from [1] to [n-1],A 	 * set hi to the index of the element AFTER which this one goes.*G 	 * Then, do the standard insertion sort shift on a character at a time	' 	 * basis for each element in the frob.; 	 */. 	for (min = base; (hi = min += qsz) < max; ) {% 		while ((*qcmp)(hi -= qsz, min) > 0)s 			/* void */; 		if ((hi += qsz) != min) {;( 			for (lo = min + qsz; --lo >= min; ) { 				c = *lo;- 				for (i = j = lo; (j -= qsz) >= hi; i = j)n
 					*i = *j;w 				*i = c;E 			} 		}	 	} }n   /*  * qst:w  * Do a quicksort M  * First, find the median element, and put that one in the first place as therK  * discriminator.  (This "median" is just the median of the first, last andeN  * middle elements).  (Using this median instead of the first element is a bigG  * win).  Then, the usual partitioning/swapping, followed by moving theeM  * discriminator into the right place.  Then, figure out the sizes of the twopN  * partions, do the smaller one recursively and the larger one via a repeat ofO  * this code.  Stopping when there are less than THRESH elements in a partition	H  * and cleaning up with an insertion sort (in our caller) is a huge win.J  * All data swaps are done in-line, which is space-losing but time-saving.8  * (And there are only three places where this is done).  */    static qst(base, max) 	char *base, *max; {t 	register char c, *i, *j, *jj; 	register int ii;  	char *mid, *tmp;N 	int lo, hi;   	/*rF 	 * At the top here, lo is the number of characters of elements in the5 	 * current partition.  (Which should be max - base). C 	 * Find the median of the first, last, and middle element and maketC 	 * that the middle element.  Set j to largest of first and middle.dD 	 * If max is larger than that guy, then it's that guy, else compareB 	 * max with loser of first and take larger.  Things are set up to6 	 * prefer the middle, then the first in case of ties. 	 */4 	lo = max - base;		/* number of elements as chars */ 	do	{t+ 		mid = i = base + qsz * ((lo / qsz) >> 1);t 		if (lo >= mthresh) {. 			j = ((*qcmp)((jj = base), i) > 0 ? jj : i);+ 			if ((*qcmp)(j, (tmp = max - qsz)) > 0) {f 				/* switch to first loser */o 				j = (j == jj ? i : jj);2 				if ((*qcmp)(j, tmp) < 0)
 					j = tmp;r 			} 			if (j != i) {
 				ii = qsz;o 				do	{ 					c = *i; 					*i++ = *j;y 					*j++ = c; 				} while (--ii);* 			} 		}c 		/*2 		 * Semi-standard quicksort partitioning/swapping 		 */a% 		for (i = base, j = max - qsz; ; ) {e* 			while (i < mid && (*qcmp)(i, mid) <= 0)
 				i += qsz;t 			while (j > mid) { 				if ((*qcmp)(mid, j) <= 0) {f 					j -= qsz; 					continue; 				}/. 				tmp = i + qsz;	/* value of i after swap */ 				if (i == mid) {s" 					/* j <-> mid, new mid is j */ 					mid = jj = j; 				} else { 					/* i <-> j */ 					jj = j; 					j -= qsz; 				}m 				goto swap; 			} 			if (i == mid) {
 				break; 			} else {f! 				/* i <-> mid, new mid is i */{
 				jj = mid; . 				tmp = mid = i;	/* value of i after swap */
 				j -= qsz;  			} 		swap:	 			ii = qsz; 			do	{  				c = *i;D 				*i++ = *jj;* 				*jj++ = c; 			} while (--ii); 			i = tmp;  		}e 		/*8 		 * Look at sizes of the two partitions, do the smaller6 		 * one first by recursion, then do the larger one by8 		 * making sure lo is its size, base and max are update4 		 * correctly, and branching back.  But only repeat6 		 * (recursively or by branching) if the partition is 		 * of at least size THRESH.s 		 */  		i = (j = mid) + qsz;* 		if ((lo = j - base) <= (hi = max - i)) { 			if (lo >= thresh) 				qst(base, j);  			base = i; 			lo = hi;R
 		} else { 			if (hi >= thresh) 				qst(i, max); 			max = j;n 		}  	} while (lo >= thresh); }.