 #include "ipintern.h"   ( #define max(a,b) ((a) > (b) ? (a) : (b))  ; #define alloc(type) (type *) mm_alloc(st_mem, sizeof(type))U   #define MAX_DENSITY 5t #define INIT_TABLE_SIZE 11   char *calloc();p  @ #define do_hash(key, table) (*table->hash)(key, table->num_bins)  & static mm_desc *st_mem = nil(mm_desc); static int st_count = 0;  & st_table *st_init_table(compare, hash) int (*compare)();n int (*hash)(); {i     st_table *pnew; 
     int size;(  8     size = max(sizeof(st_table),sizeof(st_table_entry));  !     if (st_mem == nil(mm_desc)) {  	st_mem = mm_init(size, 0, 0); 	if (st_mem == nil(mm_desc)) { 	    return nil(st_table); 	}     }v       st_count++;        pnew = alloc(st_table);t     pnew->compare = compare;     pnew->hash = hash;     pnew->num_entries = 0;%     pnew->num_bins = INIT_TABLE_SIZE;      pnew->bins = *G 	(st_table_entry **) calloc(INIT_TABLE_SIZE, sizeof(st_table_entry *));      return pnew; }    st_free_table(table) st_table *table; {      free((char *) table->bins);t#     mm_free(st_mem,(char *) table);U     if (--st_count <= 0) { 	mm_release_all(st_mem); 	st_mem = nil(mm_desc);s     }e }   + st_table_entry *st_lookup_entry(table, key)  st_table *table;
 char *key; {c     int hash_val;t     st_table_entry *ptr;  #     hash_val = do_hash(key, table);o  $     for(ptr = table->bins[hash_val];H 	    ptr != nil(st_table_entry) && (*table->compare)(key,ptr->key) != 0; 	    ptr = ptr->next) {      }        return ptr;. }n   st_is_member(table, key) st_table *table;
 char *key; {a     int retval;oJ     retval = (st_lookup_entry(table, key) != nil(st_table_entry)) ? 1 : 0;     return retval; }*   char *st_lookup(table, key)a st_table *table;
 char *key; {m     st_table_entry *ptr;  &     ptr = st_lookup_entry(table, key);  %     if (ptr == nil(st_table_entry)) {  	return nil(char);     } else { 	return ptr->record;     }t }s  >     /* add without checking whether an entry already exists */  ! st_add_direct(table, key, record)s st_table *table;
 char *key;
 char *record;d {e     int hash_val;i     st_table_entry *pnew;s  ;     if (table->num_entries/table->num_bins > MAX_DENSITY) {  	rehash(table);o     }I  #     hash_val = do_hash(key, table);o  !     pnew = alloc(st_table_entry);P       pnew->key = key;     pnew->record = record;'     pnew->next = table->bins[hash_val];I!     table->bins[hash_val] = pnew;R     table->num_entries++;_ }L   static rehash(table) st_table *table; {c$     st_table_entry *ptr, **old_bins;     extern print_entry();O*     int i, old_num_bins = table->num_bins;       old_bins = table->bins;b#     old_num_bins = table->num_bins;D  %     table->num_bins = 2*old_num_bins;      table->num_entries = 0;f     table->bins = <       (st_table_entry **) calloc((unsigned) table->num_bins, 	    sizeof(st_table_entry *));n  (     for(i = 0; i < old_num_bins ; i++) { 	for(ptr = old_bins[i];I  	    ptr != nil(st_table_entry); 	    ptr = ptr->next) {s1 	    st_add_direct(table, ptr->key, ptr->record);w 	}     }e }c   st_insert(table, key, record)R st_table *table;
 char *key;
 char *record;N {M     st_table_entry *ptr;  &     ptr = st_lookup_entry(table, key);  %     if (ptr == nil(st_table_entry)) {t# 	st_add_direct(table, key, record);_     } else { 	ptr->record = record;     }  }f   st_delete(table, key, item)e st_table *table; char **key, **item;f {g     int hash_val;S     st_table_entry *ptr, *tmp;  $     hash_val = do_hash(*key, table);        ptr = table->bins[hash_val];  %     if (ptr == nil(st_table_entry)) {A 	*item = nil(char);l 	return;     }e  1     if ((*table->compare)(*key, ptr->key) == 0) { # 	table->bins[hash_val] = ptr->next;q 	table->num_entries--; 	*item = ptr->record;c 	*key = ptr->key;t 	mm_free(st_mem,(char *) ptr); 	return;     }n  >     for(; ptr->next != nil(st_table_entry); ptr = ptr->next) {4 	if ((*table->compare)(ptr->next->key, *key) == 0) { 	    tmp = ptr->next;f! 	    ptr->next = ptr->next->next;o 	    *item = tmp->record;l 	    *key = tmp->key;d" 	    mm_free(st_mem,(char *) tmp); 	    return; 	}     }a       *item = nil(char);     return;y }    st_foreach(table, func, arg) st_table *table; int (*func)();
 char *arg; {T     st_table_entry *ptr;
     int i;  *     for(i = 0; i < table->num_bins; i++) {I 	for(ptr = table->bins[i]; ptr != nil(st_table_entry); ptr = ptr->next) {o) 	    (*func)(ptr->key, ptr->record, arg);, 	}     }  }o   st_strhash(string, num_bins)
 char *string;n
 int num_bins;i {(     register int val = 0;t     register char *ptr;   -     for (ptr = string; *ptr != '\0'; ptr++) {i
 	val += *ptr;e     }n       return val%num_bins; }i   st_numcmp(ptr1, ptr2)D char *ptr1, *ptr2; {l     return ptr1 - ptr2;v }=   st_numhash(ptr, num_bins) 
 char *ptr;
 int num_bins;) {       return ((int) ptr)%num_bins; }o