 #include <stdio.h> #include <math.h>s #include "simconst.h"0 #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"h  F /* There are two types of checks for latency.  The first type of check@ *  is based on the predictor-corrector lte control estimate, andF *  uses the backward differences, and the worst case (inside a window)B *  latent step.  However, it does not guarantee that one is close H *  to an equilibruim point (dc solution point).  This can cause problemsE *  as one moves across window boundaries.  In those cases toughlat is 9 *  used, as it also checks the current and the charge to eA *  insure that no change larger than the relative lte will occur.e */( steplat(present,newtime,subptr,toughchk)$ struct timepoint *present, *newtime; struct subcircuit *subptr;
 int toughchk;, {e	 int i, j; 8 double maxq, maxc, vdiff, stepratio, nowvolt, waveval(); long chngtime, newstep;i struct waveform *presptr;, struct timepoint *temp;a /* Check for latency. */%   stepratio = (stoptime - starttime);s/   stepratio /= (newtime->time - present->time);($   for(i=1; i <= subptr->size; i++) {F     vdiff = (newtime->nodevolt[i] - present->nodevolt[i]) * stepratio;     vdiff = dabs(vdiff);K     if( (latratio * vdiff) > ((lterel*dabs(newtime->nodevolt[i]))+lteabs)) e 								return(FALSE);   }rB   if(toughchk == TRUE) { /* Check for latency, only check hard. */@     for(maxq = 0.0 , maxc = 0.0 , i=1; i <= subptr->size; i++) {+       maxq = max(maxq, newtime->charge[i]);b,       maxc = max(maxc, newtime->current[i]);     } N     if((latratio*mrt*(stoptime-starttime)*maxc) >(maxq*lterel)) return(FALSE);   }-  ; /* Now check all the inputs for the first one to change. */tK   for(chngtime = stoptime , newstep = 0 , i=subptr->external; i < 0; i++) { /     presptr = subptr->waveptrarray[i]->present;eK   /* Waveval leaves lastloc pointing to the point after the passed time. */ .     nowvolt = waveval(presptr, newtime->time);<     for(j = presptr->lastloc; j <= presptr->wavesize; j++) {,       vdiff = presptr->voltage[j] - nowvolt;#       if(dabs(vdiff) > latthresh) {%+         if(presptr->time[j-1] < chngtime) { *           chngtime = presptr->time[j - 1];:           newstep = presptr->time[j] - presptr->time[j-1];	         }*       };     }n   }oM   chngtime = min(chngtime, stoptime - newstep); /* Insure reasonable step. */%  F /* If more than one timestep is to be gained, take the latent step. */6   if( chngtime > (newtime->time + subptr->ltestep) ) {   /* Rotate the timepoints. */     temp = subptr->old2;     subptr->old2 = subptr->old;t#     subptr->old = subptr->present;  &     subptr->present = subptr->newtime;     subptr->newtime = temp; *   /* Copy the present into the newtime. */N     copytimept(subptr->present,subptr->newtime,subptr->size,subptr->external);   /* Change the newtime. */e&     subptr->newtime->time = chngtime;    /* Use input source step. */?     for(i=subptr->external; i < 0; i++) newtime->nodevolt[i] = dA 	waveval(subptr->waveptrarray[i]->present,subptr->newtime->time);a     subptr->ltestep = A 	pickstep( (double) 1.0, newstep, subptr->newtime->time, subptr);mI     subptr->offset = storewave(subptr->newtime, subptr->offset, subptr); l   }2 }n  = long stepnonlat(old2,old,present,newtime,ltestep, predictor, = 						oldstuff, rhs, subptr)1 struct timepoint *old2, *old, *present, *newtime; # double *predictor, *oldstuff, *rhs;; struct subcircuit *subptr;
 long ltestep;s {s< double a0,a1,a2, alpha0, lteratio=0.0, waveval(), calclte(); int i,converg = FALSE; long pickstep(); struct device *devptr;   for(;;) { K     newtime->time = ltestep + present->time;   /* Compute the next time. */nK     alpha0 = 2/(ltestep * mrt);   /* Compute the alpha0 for trapazoidal. */t,   /* Get the input voltages at this time. */=     for(i=subptr->external; i<0; i++) newtime->nodevolt[i] = _; 		waveval(subptr->waveptrarray[i]->present, newtime->time);>?   /* Get the predictor and evalute old stuff for trap rule.. */>&     for(i=1; i <= subptr->size; i++) {H       oldstuff[i] = present->current[i] - (alpha0 * present->charge[i]);E       a0 = present->nodevolt[i];     /* Generate a poly predictor. */e?       a1 = (a0 - old->nodevolt[i])/(present->time - old->time);r       a2 = (
   	     (a1 -cA        (  (a0 - old2->nodevolt[i])/(present->time - old2->time) )a                    )*              / (old->time - old2->time) );I       newtime->nodevolt[i] = a0 + ( ((a2*(newtime->time - old->time))+a1) + 					 * (newtime->time - present->time)  );n*       predictor[i] = newtime->nodevolt[i];     }s2   /* Hand it all to the newton method to solve. */I     converg = newton(alpha0, newtime->charge, newtime->current, oldstuff,g) 					    newtime->nodevolt, rhs, subptr);s4   /* Compute the next try at an integration step. */H     if(ltestep <= minstep) break; /* No smaller step to use so leave. */+     else if(converg == FALSE) ltestep /= 2;e
     else {C       lteratio = calclte(predictor, newtime, present, old, subptr);eL       if(lteratio >= 1.0) break; /* Newton converged, lte fine, so leave. */H       else ltestep = pickstep(lteratio, ltestep, present->time, subptr);     }n   }   E /* Make sure newton converged and if so return predicted timestep. */*   if(converg == TRUE) {eG     subptr->offset = storewave(subptr->newtime, subptr->offset,subptr);,?     return( pickstep(lteratio,ltestep,newtime->time, subptr) );t   }t    else newterr(subptr, ltestep); }c  C /* Note lteratio is bounded above by upstepratio cubed, below by */] /* 1.0/downstepratio. */8 double calclte(predictor, newtime, present, old, subptr)* struct timepoint *present, *newtime, *old; double *predictor; struct subcircuit *subptr; {f int i; double maxvolt,verr, temp;C   for(i = 1 , maxvolt = 0.0 , verr = 0.0; i <= subptr->size; i++) {t0     temp = 0.33 * ( (dabs(newtime->nodevolt[i]))? 	 	+ (dabs(present->nodevolt[i])) + (dabs(old->nodevolt[i])) );o!     maxvolt = max(temp, maxvolt); 5     temp = dabs(newtime->nodevolt[i] - predictor[i]);a     verr = max(temp, verr);,   }v   if(verr > FUZZ) { F     temp = ((lterel * maxvolt) + lteabs) * (newtime->time - old->time)8            /( verr * ( newtime->time - present->time ));!     temp = min(temp, step3ratio);=(     temp = max(temp, 1.0/downstepratio);   }    else temp = step3ratio;t   return(temp);  }t  F /* Predstep is a little weird.  I'm trying to take the cube root of */9 /* lteratio.  I know cube root of 1 is 1 and cube root */m? /* of step3ratio is maxstepratio.  So I will linearly interp */. /* between the two points. */>J /* Or, if lteratio < 1 then I know cube root of 1 is 1 and cube root of */' /* zero is zero.  I linearly interp. */i3 long pickstep(lteratio, prevstep, prestime, subptr)( double lteratio; long prevstep, prestime; struct subcircuit *subptr; {  long tempstep, instep, temp; struct waveform *pw; int i;   if(lteratio < 1.0) {+     tempstep = (0.7 * lteratio) * prevstep;25     tempstep = max(tempstep, prevstep/downstepratio);e   }-   else {=     tempstep = prevstep * (upstepratio - 1) * (lteratio - 1); <     tempstep = prevstep + 0.9 * tempstep / (step3ratio - 1);   } 7 /* Get the minimum of the input waveforms timesteps. */t:   for(instep = maxstep , i=subptr->external; i < 0; i++) {*     pw = subptr->waveptrarray[i]->present;*     if(prestime < pw->time[pw->lastloc]) {?       temp = pw->time[pw->lastloc] - pw->time[pw->lastloc - 1];n!       instep = min(instep, temp);e     }m   }v1   tempstep = min(tempstep, upstepratio * instep);,$   tempstep = min(tempstep, maxstep);$   tempstep = max(minstep, tempstep);)   if( (tempstep + prestime) > stoptime ) t$ 			tempstep = (stoptime - prestime);7   else if((tempstep + tempstep + prestime) > stoptime ))* 			tempstep = 1 + (stoptime - prestime)/2;   return(tempstep);t }a   newterr(subptr, ltestep) struct subcircuit *subptr;
 long ltestep;a {n int i;-    printf("ERROR. Newton nonconvergence.\n");;1    printf("Simulation time =%g, Timestep= %g\n", c3 			(subptr->newtime->time * mrt), (ltestep * mrt));.#    printf("Computed waveforms.\n"); N    for(i=1; i <= subptr->size; i++) diswave(subptr->waveptrarray[i]->present);     printf("Input waveforms.\n");%    for(i=subptr->external; i<0; i++) l. 				diswave(subptr->waveptrarray[i]->present);)    printf("offset=%d\n", subptr->offset);t4    printf("Offending subcircuit\n"); dissub(subptr);5    printf("Newtime =\n"); distimept(subptr->newtime);a6    printf("Present =\n"); distimept(subptr->present); -    printf("Old =\n"); distimept(subptr->old);o/    printf("Old2 =\n"); distimept(subptr->old2);(    exit(0);l }l