> /* The routines in this section solve for the mosfet device */C /* drain current and small signal parameters (e.g. the Jacobian) */n/ /* for Ping Yang / Pallab Chatterjee models. */      #include <stdio.h> #include <math.h>h #include "simconst.h"= #include "simstruct.h" #include "simglbdef.h" #include "simmac.h"( #include "mstruct.h" #include "ipstruct.h"_    > /* This global is shared by the moschg and mosres routines. */
 double vttmp;a  , rhsputmosti(fptr, nodevolt, current, charge)$ double *charge, *current, *nodevolt; register struct fetti *fptr; {*> double vds, vgs, vbs, tempd, *ptempd, idrain, qd, qg, qs, qb, 3        rhsmosreseqti(), rhsjustdti(), rhsjustgti();o	 int temp;   *   if(fptr->type == NMOS) { /* NMOS case */8     vds = nodevolt[fptr->dnode] - nodevolt[fptr->snode];D     if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */       tiswapds(fptr);h:       vds = nodevolt[fptr->dnode] - nodevolt[fptr->snode];     }=8     vgs = nodevolt[fptr->gnode] - nodevolt[fptr->snode];8     vbs = nodevolt[fptr->bnode] - nodevolt[fptr->snode];     if(fptr->snode > 0) {d2       idrain = rhsmosreseqti(vds, vgs, vbs, fptr);;       rhsmoschgeqti(vds,vgs,vbs, &qd, &qg, &qs, &qb, fptr);k&       current[fptr->snode] -= idrain; 4       charge[fptr->snode] += qs - (fptr->cgs * vgs);       if(fptr->dnode > 0) {e(         current[fptr->dnode] += idrain; >         charge[fptr->dnode] += qd + (fptr->cgd * (vds - vgs));       }l3       if(fptr->gnode > 0) charge[fptr->gnode] += qg 5 			  + (fptr->cgd * (vgs - vds)) + (fptr->cgs * vgs);s5       if(fptr->bnode > 0) charge[fptr->bnode] += qb;       }      else if(fptr->dnode > 0) {4       if( (fptr->bnode > 0) || (fptr->gnode > 0) ) {5          idrain = rhsmosreseqti(vds, vgs, vbs, fptr);e>          rhsmoschgeqti(vds,vgs,vbs, &qd, &qg, &qs, &qb, fptr);)          current[fptr->dnode] += idrain; =?          charge[fptr->dnode] += qd + (fptr->cgd * (vds - vgs)); 6          if(fptr->gnode > 0) charge[fptr->gnode] += qg< 	        	  + (fptr->cgd * (vgs - vds)) + (fptr->cgs * vgs);8          if(fptr->bnode > 0) charge[fptr->bnode] += qb;        }h       else {E         current[fptr->dnode] += rhsjustdti(vds, vgs, vbs, &qd, fptr); >         charge[fptr->dnode] += qd + (fptr->cgd * (vds - vgs));       }      }a     else if(fptr->bnode > 0) {;       rhsmoschgeqti(vds,vgs,vbs, &qd, &qg, &qs, &qb, fptr);t!       charge[fptr->bnode] += qb; c3       if(fptr->gnode > 0) charge[fptr->gnode] += qg ; 	          + (fptr->cgd * (vgs - vds)) + (fptr->cgs * vgs);      }e
     else {<       charge[fptr->gnode] += rhsjustgti(vds, vgs, vbs, fptr); 	          + (fptr->cgd * (vgs - vds)) + (fptr->cgs * vgs);t     }s   }     - /* PMOS case, Note everything is inverted. */     else if(fptr->type == PMOS) { 8     vds = nodevolt[fptr->snode] - nodevolt[fptr->dnode];D     if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */       tiswapds(fptr); :       vds = nodevolt[fptr->snode] - nodevolt[fptr->dnode];     } 8     vgs = nodevolt[fptr->snode] - nodevolt[fptr->gnode];8     vbs = nodevolt[fptr->snode] - nodevolt[fptr->bnode];     if(fptr->snode > 0) { 2       idrain = rhsmosreseqti(vds, vgs, vbs, fptr);;       rhsmoschgeqti(vds,vgs,vbs, &qd, &qg, &qs, &qb, fptr);e&       current[fptr->snode] += idrain; 4       charge[fptr->snode] -= qs - (fptr->cgs * vgs);       if(fptr->dnode > 0) {u(         current[fptr->dnode] -= idrain; >         charge[fptr->dnode] -= qd + (fptr->cgd * (vds - vgs));       } 3       if(fptr->gnode > 0) charge[fptr->gnode] -= qgr5 			  + (fptr->cgd * (vgs - vds)) + (fptr->cgs * vgs);a5       if(fptr->bnode > 0) charge[fptr->bnode] -= qb; d     }l     else if(fptr->dnode > 0) {4       if( (fptr->bnode > 0) || (fptr->gnode > 0) ) {5          idrain = rhsmosreseqti(vds, vgs, vbs, fptr); >          rhsmoschgeqti(vds,vgs,vbs, &qd, &qg, &qs, &qb, fptr);)          current[fptr->dnode] -= idrain; l?          charge[fptr->dnode] -= qd + (fptr->cgd * (vds - vgs));)6          if(fptr->gnode > 0) charge[fptr->gnode] -= qg< 	        	  + (fptr->cgd * (vgs - vds)) + (fptr->cgs * vgs);8          if(fptr->bnode > 0) charge[fptr->bnode] -= qb;        }a       else {E         current[fptr->dnode] -= rhsjustdti(vds, vgs, vbs, &qd, fptr); >         charge[fptr->dnode] -= qd + (fptr->cgd * (vds - vgs));       }c     }i     else if(fptr->bnode > 0) {;       rhsmoschgeqti(vds,vgs,vbs, &qd, &qg, &qs, &qb, fptr);t!       charge[fptr->bnode] -= qb; r3       if(fptr->gnode > 0) charge[fptr->gnode] -= qgp; 	          + (fptr->cgd * (vgs - vds)) + (fptr->cgs * vgs);h     } 
     else {<       charge[fptr->gnode] -= rhsjustgti(vds, vgs, vbs, fptr); 	          + (fptr->cgd * (vgs - vds)) + (fptr->cgs * vgs);h     }i   }  },  1 putmosti(fptr, nodevolt, current, charge, alpha0) $ double *charge, *current, *nodevolt; double alpha0; register struct fetti *fptr; {h  double vds, vgs, vbs, vgd, vbd, 0        idrain, qd, qg, qs, qb, gmbs, gmgs, gmds,B        cdg, cds, cdb, cgd, cgs, cgb, csd, csg, csb, cbd, cbg, cbs,A        tempd, *ptempd, mosreseqti(), justdrainti(), justgateti();l	 int temp;    /* NMOS case */    if(fptr->type == NMOS) {*   /* Flip drain and source if vds < 0.0 */8     vds = nodevolt[fptr->dnode] - nodevolt[fptr->snode];D     if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */       tiswapds(fptr);s:       vds = nodevolt[fptr->dnode] - nodevolt[fptr->snode];     }08     vgs = nodevolt[fptr->gnode] - nodevolt[fptr->snode];8     vbs = nodevolt[fptr->bnode] - nodevolt[fptr->snode];/     if( (fptr->snode > 0) || (fptr->bnode > 0) o3 		|| ( (fptr->dnode > 0) && (fptr->gnode > 0) ) ) {oD       idrain = mosreseqti(vds, vgs, vbs, &gmgs, &gmds, &gmbs, fptr);1       moschgeqti(vds,vgs,vbs, &qd, &qg, &qs, &qb,(( 		   &cdg, &cds, &cdb, &cgd, &cgs, &cgb,/ 		   &csd, &csg, &csb, &cbd, &cbg, &cbs, fptr);r*     /* Put the drain row in the matrix. */       if(fptr->dnode > 0) { '         current[fptr->dnode] += idrain; >         charge[fptr->dnode] += qd + (fptr->cgd * (vds - vgs));H         *(fptr->matdd) += gmds + alpha0 * (cds + cdg + cdb + fptr->cgd);C         if(fptr->bnode>0) *(fptr->matdb) += gmbs  - (alpha0 * cdb);0N         if(fptr->gnode>0) *(fptr->matdg) += gmgs - (alpha0*(fptr->cgd + cdg));L         if(fptr->snode>0) *(fptr->matds) -= ((gmgs+gmbs+gmds)+(alpha0*cds));       } +     /* Put the source row in the matrix. */v       if(fptr->snode > 0) {;'         current[fptr->snode] -= idrain;;6         charge[fptr->snode] += qs - (fptr->cgs * vgs);N         *(fptr->matss) += (gmds+gmbs+gmgs) + alpha0 * (csd+csg+csb+fptr->cgs);B         if(fptr->bnode>0) *(fptr->matsb) -= gmbs + (alpha0 * csb);N         if(fptr->gnode>0) *(fptr->matsg) -= gmgs + (alpha0*(csg + fptr->cgs));B         if(fptr->dnode>0) *(fptr->matsd) -= gmds + (alpha0 * csd);       }-)     /* Put the gate row in the matrix. */        if(fptr->gnode > 0) {(N         charge[fptr->gnode] += qg + (fptr->cgs*vgs) + (fptr->cgd*(vgs - vds));M         *(fptr->matgg) += alpha0 * (cgs + cgd + cgb + fptr->cgs + fptr->cgd);o<         if(fptr->bnode>0) *(fptr->matgb) -=  (alpha0 * cgb);J         if(fptr->dnode>0) *(fptr->matgd) -=  (alpha0 * (cgd + fptr->cgd));J         if(fptr->snode>0) *(fptr->matgs) -=  (alpha0 * (cgs + fptr->cgs));       }h*     /* Put the bulk node in the matrix. */       if(fptr->bnode > 0) {M"         charge[fptr->bnode] += qb;5         *(fptr->matbb) += alpha0 * (cbg + cbd + cbs);/;         if(fptr->dnode>0) *(fptr->matbd) -= (alpha0 * cbd);s;         if(fptr->gnode>0) *(fptr->matbg) -= (alpha0 * cbg);s;         if(fptr->snode>0) *(fptr->matbs) -= (alpha0 * cbs);t       };     }bK     else if(fptr->dnode > 0) {  /* Just the drain node is in the subckt. */dB       idrain = justdrainti(vds, vgs, vbs, &gmds, &qd, &cds, fptr);%       current[fptr->dnode] += idrain;f=       charge[fptr->dnode] += qd  + (fptr->cgd * (vds - vgs));t:       *(fptr->matdd) += gmds + alpha0 * (cds + fptr->cgd);     } 2     else {			/* Just the gate is in the subckt. */1       qg = justgateti(vds, vgs, vbs, &cgs, fptr);;N       charge[fptr->gnode] += qg + (fptr->cgs * vgs) + (fptr->cgd*(vgs - vds));?       *(fptr->matgg) += alpha0 * (cgs + fptr->cgs + fptr->cgd);0     }e   }-/ /* PMOS case. Notice everything is inverted. */ 	   else {  8     vds = nodevolt[fptr->snode] - nodevolt[fptr->dnode];D     if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */       tiswapds(fptr); :       vds = nodevolt[fptr->snode] - nodevolt[fptr->dnode];     } 8     vgs = nodevolt[fptr->snode] - nodevolt[fptr->gnode];8     vbs = nodevolt[fptr->snode] - nodevolt[fptr->bnode];/     if( (fptr->snode > 0) || (fptr->bnode > 0) l3 		|| ( (fptr->dnode > 0) && (fptr->gnode > 0) ) ) {sD       idrain = mosreseqti(vds, vgs, vbs, &gmgs, &gmds, &gmbs, fptr);1       moschgeqti(vds,vgs,vbs, &qd, &qg, &qs, &qb,c( 		   &cdg, &cds, &cdb, &cgd, &cgs, &cgb,/ 		   &csd, &csg, &csb, &cbd, &cbg, &cbs, fptr);r*     /* Put the drain row in the matrix. */       if(fptr->dnode > 0) {,'         current[fptr->dnode] -= idrain;g>         charge[fptr->dnode] -= qd + (fptr->cgd * (vds - vgs));H         *(fptr->matdd) += gmds + alpha0 * (cds + cdg + cdb + fptr->cgd);C         if(fptr->bnode>0) *(fptr->matdb) += gmbs  - (alpha0 * cdb);mN         if(fptr->gnode>0) *(fptr->matdg) += gmgs - (alpha0*(fptr->cgd + cdg));L         if(fptr->snode>0) *(fptr->matds) -= ((gmgs+gmbs+gmds)+(alpha0*cds));       }t+     /* Put the source row in the matrix. */        if(fptr->snode > 0) {t'         current[fptr->snode] += idrain;g6         charge[fptr->snode] -= qs - (fptr->cgs * vgs);N         *(fptr->matss) += (gmds+gmbs+gmgs) + alpha0 * (csd+csg+csb+fptr->cgs);B         if(fptr->bnode>0) *(fptr->matsb) -= gmbs + (alpha0 * csb);N         if(fptr->gnode>0) *(fptr->matsg) -= gmgs + (alpha0*(csg + fptr->cgs));B         if(fptr->dnode>0) *(fptr->matsd) -= gmds + (alpha0 * csd);       } )     /* Put the gate row in the matrix. */p       if(fptr->gnode > 0) { N         charge[fptr->gnode] -= qg + (fptr->cgs*vgs) + (fptr->cgd*(vgs - vds));M         *(fptr->matgg) += alpha0 * (cgs + cgd + cgb + fptr->cgs + fptr->cgd);e<         if(fptr->bnode>0) *(fptr->matgb) -=  (alpha0 * cgb);J         if(fptr->dnode>0) *(fptr->matgd) -=  (alpha0 * (cgd + fptr->cgd));J         if(fptr->snode>0) *(fptr->matgs) -=  (alpha0 * (cgs + fptr->cgs));       }>*     /* Put the bulk node in the matrix. */       if(fptr->bnode > 0) {-"         charge[fptr->bnode] -= qb;5         *(fptr->matbb) += alpha0 * (cbg + cbd + cbs);/;         if(fptr->dnode>0) *(fptr->matbd) -= (alpha0 * cbd);d;         if(fptr->gnode>0) *(fptr->matbg) -= (alpha0 * cbg); ;         if(fptr->snode>0) *(fptr->matbs) -= (alpha0 * cbs);a       }l     }(K     else if(fptr->dnode > 0) {  /* Just the drain node is in the subckt. */ B       idrain = justdrainti(vds, vgs, vbs, &gmds, &qd, &cds, fptr);%       current[fptr->dnode] -= idrain; =       charge[fptr->dnode] -= qd  + (fptr->cgd * (vds - vgs));s:       *(fptr->matdd) += gmds + alpha0 * (cds + fptr->cgd);     };2     else {			/* Just the gate is in the subckt. */1       qg = justgateti(vds, vgs, vbs, &cgs, fptr);oN       charge[fptr->gnode] -= qg + (fptr->cgs * vgs) + (fptr->cgd*(vgs - vds));@       *(fptr->matgg) += alpha0 * ( cgs + fptr->cgs + fptr->cgd);     }d   }s }b  & dcrhsputmosti(fptr, nodevolt, current) double *current, *nodevolt;  register struct fetti *fptr; {,> double vds, vgs, vbs, tempd, *ptempd, idrain, rhsmosreseqti();	 int temp;*  *   if(fptr->type == NMOS) { /* NMOS case */8     vds = nodevolt[fptr->dnode] - nodevolt[fptr->snode];D     if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */       tiswapds(fptr);+:       vds = nodevolt[fptr->dnode] - nodevolt[fptr->snode];     } 8     vgs = nodevolt[fptr->gnode] - nodevolt[fptr->snode];8     vbs = nodevolt[fptr->bnode] - nodevolt[fptr->snode];0     idrain = rhsmosreseqti(vds, vgs, vbs, fptr);8     if(fptr->snode > 0) current[fptr->snode] -= idrain; 8     if(fptr->dnode > 0) current[fptr->dnode] += idrain;    } - /* PMOS case, Note everything is inverted. */f    else if(fptr->type == PMOS) { 8     vds = nodevolt[fptr->snode] - nodevolt[fptr->dnode];D     if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */       tiswapds(fptr);a:       vds = nodevolt[fptr->snode] - nodevolt[fptr->dnode];     }o8     vgs = nodevolt[fptr->snode] - nodevolt[fptr->gnode];8     vbs = nodevolt[fptr->snode] - nodevolt[fptr->bnode];0     idrain = rhsmosreseqti(vds, vgs, vbs, fptr);8     if(fptr->snode > 0) current[fptr->snode] += idrain; 8     if(fptr->dnode > 0) current[fptr->dnode] -= idrain;    }  }t  # dcputmosti(fptr, nodevolt, current)> double *current, *nodevolt;s register struct fetti *fptr; { . double vds, vgs, vbs, vgd, vbd, idrain, gmbs, 0        gmgs, gmds, tempd, *ptempd, mosreseqti();	 int temp;m   /* NMOS case */>   if(fptr->type == NMOS) {*   /* Flip drain and source if vds < 0.0 */8     vds = nodevolt[fptr->dnode] - nodevolt[fptr->snode];D     if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */       tiswapds(fptr); :       vds = nodevolt[fptr->dnode] - nodevolt[fptr->snode];     }>8     vgs = nodevolt[fptr->gnode] - nodevolt[fptr->snode];8     vbs = nodevolt[fptr->bnode] - nodevolt[fptr->snode];B     idrain = mosreseqti(vds, vgs, vbs, &gmgs, &gmds, &gmbs, fptr);(   /* Put the drain row in the matrix. */     if(fptr->dnode > 0) {d       *(fptr->matdd) += gmds; %       current[fptr->dnode] += idrain;p/       if(fptr->bnode>0) *(fptr->matdb) += gmbs;n/       if(fptr->gnode>0) *(fptr->matdg) += gmgs; ;       if(fptr->snode>0) *(fptr->matds) -= (gmgs+gmbs+gmds);s     }=)   /* Put the source row in the matrix. */a     if(fptr->snode > 0) {a)       *(fptr->matss) += (gmds+gmbs+gmgs); %       current[fptr->snode] -= idrain;0/       if(fptr->bnode>0) *(fptr->matsb) -= gmbs; /       if(fptr->gnode>0) *(fptr->matsg) -= gmgs;b/       if(fptr->dnode>0) *(fptr->matsd) -= gmds;f     },   }b /* PMOS case */ 	   else { m*   /* Flip drain and source if vds < 0.0 */8     vds = nodevolt[fptr->snode] - nodevolt[fptr->dnode];D     if(vds < 0.0) {  /* If vds < 0.0 swap drain and source nodes. */       tiswapds(fptr);n:       vds = nodevolt[fptr->snode] - nodevolt[fptr->dnode];     }t8     vgs = nodevolt[fptr->snode] - nodevolt[fptr->gnode];8     vbs = nodevolt[fptr->snode] - nodevolt[fptr->bnode];B     idrain = mosreseqti(vds, vgs, vbs, &gmgs, &gmds, &gmbs, fptr);B     if(fptr->dnode > 0) {   /* Put the drain row in the matrix. */       *(fptr->matdd) += gmds;o%       current[fptr->dnode] -= idrain; /       if(fptr->bnode>0) *(fptr->matdb) += gmbs;./       if(fptr->gnode>0) *(fptr->matdg) += gmgs; ;       if(fptr->snode>0) *(fptr->matds) -= (gmgs+gmbs+gmds);0     }/C     if(fptr->snode > 0) {   /* Put the source row in the matrix. */a)       *(fptr->matss) += (gmds+gmbs+gmgs);o%       current[fptr->snode] += idrain;e/       if(fptr->bnode>0) *(fptr->matsb) -= gmbs;b/       if(fptr->gnode>0) *(fptr->matsg) -= gmgs;;/       if(fptr->dnode>0) *(fptr->matsd) -= gmds;;     }f   }- }o  ( /* Solves the resistive nonlinearity. */) double rhsmosreseqti(vds,vgs,vbs, fetptr)- double vds, vgs, vbs;  struct fetti *fetptr;l {c7 double apg, sqdapg, vdsat, xmob, clmod, barid, sqdvgst,eB        sqrtvbsphi, vgst, vtprim, idrain, temp1, temp2, bet, vfb0,         sqrtvds;m double sqrt();  B /* Bound vds away from zero to fix noncont diff. model. Blecch. */   sqrtvds = max(vds, nrvabs);  d   sqrtvds = sqrt(sqrtvds); t%   sqrtvbsphi = fetptr->twophif - vbs;   1 /* If vbs < 2phif - nrvabs, everything is okay */o   if(sqrtvbsphi > nrvabs) {s"     sqrtvbsphi = sqrt(sqrtvbsphi);.     temp2 = sqrt(fetptr->twophif + vds - vbs);(     temp1 = temp2 - fetptr->sqrttwophif;J     vttmp = fetptr->fixvto + (fetptr->be * sqrtvbsphi); /* vttmp global */.     vtprim = (vttmp - (fetptr->de * sqrtvds)) ( 				- (fetptr->cf * temp1 * sqrtvbsphi);     vgst = (vgs - vtprim);   }02 /* If vbs is too close to 2phif fix it. Blecch. */	   else { ]     temp1 = sqrt(nrvabs);-     temp2 = sqrt(vds + nrvabs);nM     vttmp = (fetptr->fixvto + (fetptr->be * temp1)); /* note vttmp global. */p/     vtprim = (vttmp - (fetptr->de * sqrtvds)) -t8 			(fetptr->cf * (temp2 - fetptr->sqrttwophif) * temp1);     vgst = vgs - vtprim;   }c /* Cutoff region. */   if(vgst <= 0) {a   /* No Subthresh. */**     if(fetptr->betas == 0.0) idrain = 0.0;   /* Subthresh. */
     else {.       vfb0 = fetptr->fixvto - fetptr->twophif;-       if( (fetptr->twophif - vbs) < nrvabs ) *F 	temp1 = ((vgs-vfb0) - fetptr->twophif) + nrvabs + fetptr->de*sqrtvds;?       else temp1 = ((vgs - vfb0) - vbs) - fetptr->de * sqrtvds;        if(temp1 >= 0) {D         bet = fetptr->be - fetptr->cf * (temp2-fetptr->sqrttwophif);5         idrain = fetptr->betas * exp(fetptr->xng * ( ; 			vgs - vfb0 - fetptr->twophifr 			+ (fetptr->de * sqrtvds) 4 			+ (bet*0.5*( bet - sqrt(bet*bet + (4.0*temp1)) )) 			      		     )); "         temp1 = fetptr->xng * vds;;         if(temp1 <= MAXEXP) idrain -= idrain * exp(-temp1);        }hB       else { /* If vgs-vfb0-vbs-de*sqrt(vds) < 0 assume it = 0. */6         temp1 = fetptr->xng * (vbs - fetptr->twophif);@         if(temp1 > -MAXEXP) idrain = fetptr->betas * exp(temp1);         else idrain = 0.0;"         temp1 = fetptr->xng * vds;:         if(temp1 < MAXEXP) idrain -= idrain * exp(-temp1);       }s     }r   }o$ /* Saturation and linear Regions. */   else {&   /* Calculate a few useful things. *//     apg = fetptr->alpha + fetptr->gamma * vgst;      vdsat = vgst / apg;qF     xmob = 1.0/( 1.0 + (fetptr->theta * vgst) );  /* Safe division. */   /* Linear Region. */     if(vds <= vdsat) {H       barid = fetptr->beta * vds * apg * ( (2.0 * vgst) - (apg * vds) );       idrain = barid * xmob;     }    /* Saturation Region. */
     else {       sqdapg = apg * apg;n       sqdvgst = vgst * vgst;M       clmod = 1.0 + (fetptr->a2lam * (vds - vdsat) / sqdapg); /* Safe div. */ %       barid = fetptr->beta * sqdvgst;>$       idrain = barid * xmob * clmod;     }*C   /* Add in the subthresh component (to make current continous). */      if(fetptr->betas != 0.0) {        temp1 = fetptr->xng * vds;H       if(temp1 <= MAXEXP) idrain += fetptr->betas * ( 1 - exp(-temp1) );#       else idrain += fetptr->betas;      }t   }-   return(idrain);> }*    8 /* The full Ping-Yang/Pallab Chatterjee Charge model. */; /* Translated to C from Bert Epler's fortran code at TI. */ 6 rhsmoschgeqti(vds,vgs,vbs, pqd, pqg, pqs, pqb, fetptr)+ double vds,vgs,vbs, *pqd, *pqg, *pqs, *pqb;  struct fetti *fetptr;  { D double vfb0, vfbx, vgst, alphax, temp1, temp2, temp3, temp4, sqrt();  *   vfb0 = fetptr->fixvto - fetptr->twophif;/ /* Fix case where vbs is too close to 2phif. */eN   if((fetptr->twophif - vbs) < nrvabs) vfbx = vfb0 + fetptr->twophif - nrvabs;   else vfbx = vfb0 + vbs;  /* Cutoff region. */   if(vgs <= vfbx) { &     *pqg = fetptr->cgsub * (vgs-vfbx);     *pqb = - (*pqg);     *pqd = 0.0;      *pqs = 0.0;x   } , /* Weak inversion or subthreshold region. */   else if(vgs <= vttmp) {=E     temp1 = sqrt( (fetptr->be * fetptr->be) + (4.0 * (vgs - vfbx)) );lC     *pqg = fetptr->cgsub * fetptr->be * 0.5 * (temp1 - fetptr->be);m     *pqb = - ( *pqg );     *pqd = 0.0;t     *pqs = 0.0;f   }-; /* Now handle as a special case when vds is precisely 0. */xH /* This was done to optimize runtime by pulling out this simple case. */   else if(vds == 0) {q2     *pqg = fetptr->cgsub * (vgs - fetptr->fixvto);4     *pqb = fetptr->cgsub * (fetptr->fixvto - vttmp);5     *pqd = - ( fetptr->cgsub * 0.5 * (vgs - vttmp) );      *pqs = *pqd;   }b  $ /* Linear and Saturation Regions. */   else {/   /* First precalculate a few useful things. */      vgst = vgs - vttmp; 2     alphax = fetptr->alpha + fetptr->gamma * vgst;  +  /* The linear region.  God what a mess! */;*     if( vgs > ((alphax * vds) + vttmp) ) {!       temp1 = alphax * vds * 0.5; ,       temp2 = 1.0 / (12.0 * (vgst - temp1));!       temp3 = alphax * vds * vds;        temp4 = 0.5 * vds;
       *pqg = pM         fetptr->cgsub*( ((vgs - fetptr->fixvto) - temp4) + (temp3 * temp2) );h       *pqb = fetptr->cgsub * n 	(  (fetptr->fixvto - vttmp) +  2 		( (1.0 - alphax) * (temp4 - (temp3*temp2)) )  );
       *pqd =  E 	-fetptr->cgsub*((0.5*vgst) - (1.5*temp1) + (temp1*temp1*6.0*temp2));t$       *pqs = - (*pqg + *pqb + *pqd);     }=( /* And finally the saturation region. */
     else {       temp1 = 1.0/alphax;(I       *pqg = fetptr->cgsub*( (vgs-fetptr->fixvto) - (vgst*temp1 / 3.0) );g       *pqd = 0.0;=
       *pqb =  G 	fetptr->cgsub*( (fetptr->fixvto - vttmp) + (vgst * (temp1-1.0)/3.0) );i       *pqs = - (*pqg + *pqb);s     })   }  }   B /* In order to make model changes a little easier, and the code */? /* a little more interpretable, I followed Bert Epler's (TI) */sC /* approach.  Basically, the threshold voltage is differentiated */oC /* with respect to vds, and vbs (stored in dvtdvds and dvtdvbs). */-K /* Then where appropriate, this is multplied by dIdrain/d(vgs-vt) = gmgs */  /* to get other derivatives. */t  ; double mosreseqti(vds,vgs,vbs, pgmgs, pgmds, pgmbs, fetptr)o- double vds, vgs, vbs, *pgmgs, *pgmds, *pgmbs;  struct fetti *fetptr;r {a? double apg, sqdapg, vtprim, vdsat, xmob, clmod, barid, sqdvgst; ! double sqrtvds, dvtdvbs, dvtdvds;dD double sqrtvbsphi, vgst, idrain, temp1, temp2, temp3, temp4, sqrt();' double bet, sqbet, betvbs, vfb0, exp();(B /* Bound vds away from zero to fix noncont diff. model. Blecch. */   sqrtvds = max(vds, nrvabs);  (   sqrtvds = sqrt(sqrtvds);  %   sqrtvbsphi = fetptr->twophif - vbs;s  /* First region, vbs < 2phif. */   if(sqrtvbsphi > nrvabs) { "     sqrtvbsphi = sqrt(sqrtvbsphi);.     temp2 = sqrt(fetptr->twophif + vds - vbs);(     temp1 = temp2 - fetptr->sqrttwophif;  6 /* Note these are globals, used in moschg routines. */7     vttmp = fetptr->fixvto + (fetptr->be * sqrtvbsphi);r.     vtprim = (vttmp - (fetptr->de * sqrtvds)) ( 				- (fetptr->cf * temp1 * sqrtvbsphi);       vgst = (vgs - vtprim);H     if(vgst > 0) { /* Don't bother computing these if device cut off. */7       dvtdvbs = (fetptr->be /(sqrtvbsphi + sqrtvbsphi))  		  - (fetptr->cf * C 	((temp1/(sqrtvbsphi + sqrtvbsphi)) + sqrtvbsphi/(temp2 + temp2)));r5       dvtdvds = (fetptr->de / (sqrtvds + sqrtvds)) + -1 		   (fetptr->cf * sqrtvbsphi / (temp2 + temp2));      }    } 2 /* If vbs is too close to 2phif fix it. Blecch. */	   else { a     temp1 = sqrt(nrvabs);*     temp2 = sqrt(vds + nrvabs);s  +   /* Globals used in the moschg routine. */,4     vttmp = (fetptr->fixvto + (fetptr->be * temp1));/     vtprim = (vttmp - (fetptr->de * sqrtvds)) - 8 			(fetptr->cf * (temp2 - fetptr->sqrttwophif) * temp1);       vgst = vgs - vtprim;     dvtdvbs = 0.0;@     if(vgst > 0) dvtdvds = (fetptr->de / (sqrtvds + sqrtvds)) + + 				(fetptr->cf * temp1 / (temp2 + temp2));f   }f
 /* Cutoff. */-   if(vgst <= 0) {q3     if(fetptr->betas == 0.0) {  /* No subthresh. */i8       *pgmgs = 0.0; *pgmbs =0.0; *pgmds=0.0; idrain=0.0;     }t"     else { /* Subthresh region. */.       vfb0 = fetptr->fixvto - fetptr->twophif;-       if( (fetptr->twophif - vbs) < nrvabs ) tF 	temp1 = ((vgs-vfb0) - fetptr->twophif) + nrvabs + fetptr->de*sqrtvds;?       else temp1 = ((vgs - vfb0) - vbs) - fetptr->de * sqrtvds;,       if(temp1 >= 0) {(         betvbs=fetptr->cf/(temp2+temp2);D         bet = fetptr->be - fetptr->cf * (temp2-fetptr->sqrttwophif);         sqbet = bet * bet;,         temp2 = sqrt( sqbet + (4 * temp1) );5         idrain = fetptr->betas * exp(fetptr->xng * ( i# 				vgs - vfb0 - fetptr->twophif + *1 				(fetptr->de * sqrtvds) + (bet*.5*(bet-temp2))( 			      		     ));g"         temp1 = fetptr->xng * vds;         if(temp1 <= MAXEXP) { ! 	  temp3 = idrain * exp(-temp1); e'           *pgmds = temp3 * fetptr->xng;            idrain -= temp3; 	} else *pgmds = 0.0;d%         temp3 = fetptr->xng * idrain;1"         temp4 = temp3 * bet/temp2;         *pgmgs = temp3 - temp4;)$         *pgmds += temp3 * betvbs * (3 			(1.0 - bet/temp2) * fetptr->de/(sqrtvds+sqrtvds),5 			        + (sqbet + temp1 + temp1)/temp2 - bet   );i/         if( (fetptr->twophif - vbs) < nrvabs ) <G 	  *pgmbs=temp4 + temp3 * betvbs * (bet - (sqbet + (2 * temp1))/temp2);i         else *pgmbs = 0.0;       }+B       else { /* If vgs-vfb0-vbs-de*sqrt(vds) < 0 assume it = 0. */         *pgmgs = 0.0;n6         temp1 = fetptr->xng * (vbs - fetptr->twophif);@         if(temp1 > -MAXEXP) idrain = fetptr->betas * exp(temp1);         else idrain = 0.0;"         temp1 = fetptr->xng * vds;         if(temp1 < MAXEXP) {  	  temp2 = idrain * exp(-temp1);  	  *pgmds = temp2 * fetptr->xng;           idrain -= temp2;	         }s         else *pgmds = 0.0;;         if( (fetptr->twophif - vbs) < nrvabs) *pgmbs = 0.0;e+         else *pgmbs = fetptr->xng * idrain;v       }v     }-   } $ /* Saturation and linear Regions. */   else {&   /* Calculate a few useful things. *//     apg = fetptr->alpha + fetptr->gamma * vgst;      vdsat = vgst / apg; F     xmob = 1.0/( 1.0 + (fetptr->theta * vgst) );  /* Safe division. */   /* Linear Region. */     if(vds <= vdsat) {H       barid = fetptr->beta * vds * apg * ( (2.0 * vgst) - (apg * vds) );       idrain = barid * xmob;       *pgmgs = xmob * (s 		(2.0 * fetptr->beta * vds * E 	 ( (apg * (1.0 - (fetptr->gamma * vds))) + (fetptr->gamma * vgst) ))f 		 - fetptr->theta * idrain);m!       *pgmds = (*pgmgs * dvtdvds)v< 		 + ( 2.0 * fetptr->beta * xmob * apg * (vgst - apg*vds) );        *pgmbs = *pgmgs * dvtdvbs;     }g   /* Saturation Region. */
     else {       sqdapg = apg * apg;        sqdvgst = vgst * vgst;M       clmod = 1.0 + (fetptr->a2lam * (vds - vdsat) / sqdapg); /* Safe div. */ %       barid = fetptr->beta * sqdvgst;l$       idrain = barid * xmob * clmod;       *pgmgs = xmob * - 		( (  (2.0 * fetptr->beta * vgst * clmod) - 07 		     (barid * ( (fetptr->a3lam / (sqdapg * sqdapg)) +s8 			    ((vds-vdsat) * fetptr->a2lamg / (apg * sqdapg))))$ 		  )  - (fetptr->theta * idrain) );L       *pgmds = (*pgmgs * dvtdvds) + ((xmob * barid * fetptr->a2lam)/sqdapg);"       *pgmbs = (*pgmgs * dvtdvbs);     }>C   /* Add in the subthresh component (to make current continous). */)     if(fetptr->betas != 0.0) {        temp1 = fetptr->xng * vds;       idrain += fetptr->betas;       if(temp1 <= MAXEXP) { ,         temp1 = fetptr->betas * exp(-temp1);         idrain -= temp1;&         *pgmds += fetptr->xng * temp1;       }*     }    }g   return(idrain);  }t  8 /* The full Ping-Yang/Pallab Chatterjee Charge model. */; /* Translated to C from Bert Epler's fortran code at TI. */v+ moschgeqti(vds,vgs,vbs, pqd, pqg, pqs, pqb,p( 		   pcdg, pcds, pcdb, pcgd, pcgs, pcgb,0 		   pcsd, pcsg, pcsb, pcbd, pcbg, pcbs, fetptr)+ double vds,vgs,vbs, *pqd, *pqg, *pqs, *pqb;t0 double *pcdg, *pcds, *pcdb, *pcgd, *pcgs, *pcgb;0 double *pcsd, *pcsg, *pcsb, *pcbd, *pcbg, *pcbs; struct fetti *fetptr;t {1' double vfb0, vfbx, vgst, vgsat, alphax;=K double temp, temp1, temp2, temp3, temp4, temp5, temp6, temp7, temp8, temp9;0> double temp10, temp11, temp12, temp13, temp14, temp15, sqrt();    *   vfb0 = fetptr->fixvto - fetptr->twophif;+ /* Fix case where vbs goes too positive. */hM   if( (fetptr->twophif-vbs) < nrvabs) vfbx = vfb0 + fetptr->twophif - nrvabs;t   else vfbx = vfb0 + vbs;t /* Cutoff region. */   if(vgs <= vfbx) { &     *pqg = fetptr->cgsub * (vgs-vfbx);     *pqb = - (*pqg);     *pqd = 0.0;      *pqs = 0.0;>7     *pcgd = 0.0; *pcdb = 0.0; *pcds = 0.0; *pcdg = 0.0;h7     *pcsd = 0.0; *pcsb = 0.0; *pcbd = 0.0; *pcbs = 0.0; D   /* Again deal oddly with the problem of vbs too close to 2phif. */,     if( (fetptr->twophif - vbs)  < nrvabs) {       *pcbg = 0.0; *pcgb =0.0; *3       *pcgs = fetptr->cgsub; *pcsg = fetptr->cgsub;=     } else {3       *pcbg = fetptr->cgsub; *pcgb = fetptr->cgsub;d       *pcgs = 0.0; *pcsg = 0.0;g     }v   }   , /* Weak inversion or subthreshold region. */   else if(vgs <= vttmp) {=E     temp1 = sqrt( (fetptr->be * fetptr->be) + (4.0 * (vgs - vfbx)) );aC     *pqg = fetptr->cgsub * fetptr->be * 0.5 * (temp1 - fetptr->be);      *pqb = - ( *pqg );     *pqd = 0.0;g     *pqs = 0.0;q8     *pcgd = 0.0; *pcdb = 0.0; *pcds = 0.0; *pcdg = 0.0; 7     *pcsb = 0.0; *pcsd = 0.0; *pcbd = 0.0; *pcbs = 0.0; D   /* Again deal oddly with the case where vbs too close to 2phif. */*     if((fetptr->twophif - vbs) < nrvabs) {       *pcbg = 0.0; *pcgb = 0.0;i1       *pcgs = (fetptr->cgsub * fetptr->be)/temp1;        *pcsg = *pcgs;     } else {1       *pcgb = (fetptr->cgsub * fetptr->be)/temp1;;       *pcbg = *pcgb;       *pcgs = 0.0; *pcsg = 0.0;f     }a   }/  $ /* Linear and Saturation Regions. */   else {/   /* First precalculate a few useful things. */c     vgst = vgs - vttmp; 2     alphax = fetptr->alpha + fetptr->gamma * vgst;#     vgsat = (alphax * vds) + vttmp;e#     temp9 = vfb0 + fetptr->twophif; 9     if( (fetptr->twophif - vbs) < nrvabs)  temp1 = 0.0;		-F     else temp1 = fetptr->be / (2.0 * sqrt( (fetptr->twophif - vbs) ));  =   /* Now handle as a special case when vds is precisely 0. */eJ   /* This was done to optimize runtime by pulling out this simple case. */     if(vds == 0) {+       *pqg = fetptr->cgsub * (vgs - temp9);d-       *pqb = fetptr->cgsub * (temp9 - vttmp);s       *pcgb = 0.0;"       *pcgs = fetptr->cgsub * 0.5;       *pcgd = *pcgs;        *pqd = - ( *pcgs * vgst );$       *pqs = - (*pqg + *pqb + *pqd);9       *pcds = *pcgs * ( ((1.5 * alphax) - 1.0) - temp1 );e       *pcdg = *pcgd;       *pcdb = *pcdg * temp1;3       *pcbd = fetptr->cgsub * (alphax - 1.0) * 0.5;t       *pcbg = 0.0;=       *pcbs = fetptr->cgsub * (temp1 + (1.0 - alphax) * 0.5);=8       *pcsb = ((*pcbg + *pcbd + *pcbs) - *pcdb) - *pcgb;8       *pcsd = ((*pcdg + *pcds + *pcdb) - *pcbd) - *pcgd;8       *pcsg = ((*pcgd + *pcgs + *pcgb) - *pcdg) - *pcbg;     }+  +  /* The linear region.  God what a mess! */      else if(vgs > vgsat) {        temp = alphax * vds * 0.5;       temp2 = 1.0/alphax;p       temp3 = alphax * alphax;+       temp4 = 1.0 / (12.0 * (vgst - temp)); "       temp5 = temp4/(vgst - temp);       temp6 = vds * vds;$       temp7 = fetptr->alpha * temp6;       temp8 = alphax * temp6;t       temp10 = 0.5 * vds;-       temp11 = 1.0 - alphax;       temp12 = temp * temp;g!       temp14 = temp * 4.0 * vgst;;&       temp15 = temp10 * fetptr->gamma;  L       *pqg = fetptr->cgsub * ( ((vgs - temp9) - temp10) + (temp8 * temp4) );
       *pqb = pG 	fetptr->cgsub * ( (temp9 - vttmp) + temp11*(temp10 - (temp8*temp4)) ); .       *pcgb = fetptr->cgsub*temp7*temp1*temp5;       *pcgs = fetptr->cgsub * F 	      (0.5 + (temp14 - ( temp7*(1.0+temp1)+temp12+temp12 )) * temp5);I       *pcgd = fetptr->cgsub * ( 0.5 + ((temp12+temp12-temp14) * temp5) );tM       *pqd = fetptr->cgsub * ( (1.5*temp) - (0.5*vgst) - (temp12*6.0*temp4));b$       *pqs = - (*pqg + *pqb + *pqd);       *pcds = fetptr->cgsub * (  	      (0.75 * alphax) + e5         ( ((1.5 * temp15) - 0.5) * (1.0 + temp1) ) + nN        (( (1.0-temp15)*(1.0+temp1) - (alphax * 0.5) )* temp12 * 6.0 * temp5) -J         (  temp * ((alphax * 0.5) + temp15 * (1.0+temp1)) * 12.0 * temp4 ) 			      );e        *pcdg = fetptr->cgsub * (	 		(0.5 - (1.5*temp15))> 	- ((fetptr->alpha*temp5 - fetptr->gamma*temp4) * temp8 *1.5)  			      );        *pcdb = temp1 * *pcdg;K       *pcbd = -fetptr->cgsub * temp11 * (0.5+(temp12+temp12-temp14)*temp5);e       *pcbs = fetptr->cgsub * (n 		 temp1 + (temp11*0.5) ) 		  - ( temp11*(temp14-(temp12+temp12)) +s 		      (1.0+temp1)*temp6*(e* 			 (temp3*(1.0+temp15) - fetptr->alpha) -; 		  	         (2.0*fetptr->gamma*alphax*vgst) ) ) * temp5); %       *pcbg = fetptr->cgsub * (temp15mG 	 - ( temp11*fetptr->alpha*temp5 + alphax*fetptr->gamma*temp4 )*temp6);)8       *pcsb = (*pcbg + *pcbd + *pcbs) - (*pcdb + *pcgb);8       *pcsd = (*pcdg + *pcds + *pcdb) - (*pcbd + *pcgd);8       *pcsg = (*pcgd + *pcgs + *pcgb) - (*pcdg + *pcbg);     }c     ( /* And finally the saturation region. */
     else {       temp2 = 1.0/alphax;        temp3 = alphax * alphax;@       *pqg = fetptr->cgsub*( (vgs-temp9) - (vgst*temp2 / 3.0) );       *pqd = 0.0; H       *pqb = fetptr->cgsub*( (temp9-vttmp) + (vgst * (temp2-1.0)/3.0) );       *pqs = - (*pqg + *pqb);bC       *pcgb = (fetptr->cgsub* fetptr->alpha * temp1) / (3.0*temp3);-J       *pcgs = fetptr->cgsub*(1.0 - fetptr->alpha*(1.0+temp1)/(3.0*temp3));       *pcgd = 0.0; e       *pcdb = 0.0;       *pcds = 0.0;       *pcdg = 0.0;)       *pcsg = fetptr->cgsub * 0.66666666;e       *pcsd = 0.0;1       *pcsb = fetptr->cgsub * temp1 * 0.66666666;        *pcbd = 0.0;$       *pcbs = *pcsg + *pcsb - *pcgs;$       *pcbg = *pcgs + *pcgb - *pcsg;     }e   }> }h    + double rhsjustdti(vds,vgs,vbs, pqd, fetptr)  double vds, vgs, vbs, *pqd;  struct fetti *fetptr;  { 7 double apg, sqdapg, vdsat, xmob, clmod, barid, sqdvgst,;I        sqrtvbsphi, vgst, vttmp, vtprim, idrain, temp1, temp2, bet, vfb0, (        sqrtvds, vfbx, alphax;8 double sqrt();  B /* Bound vds away from zero to fix noncont diff. model. Blecch. */   sqrtvds = max(vds, nrvabs);  e   sqrtvds = sqrt(sqrtvds); ;%   sqrtvbsphi = fetptr->twophif - vbs; *   vfb0 = fetptr->fixvto - fetptr->twophif;  1 /* If vbs < 2phif - nrvabs, everything is okay */    if(sqrtvbsphi > nrvabs) { "     sqrtvbsphi = sqrt(sqrtvbsphi);.     temp2 = sqrt(fetptr->twophif + vds - vbs);(     temp1 = temp2 - fetptr->sqrttwophif;J     vttmp = fetptr->fixvto + (fetptr->be * sqrtvbsphi); /* vttmp global */.     vtprim = (vttmp - (fetptr->de * sqrtvds)) ( 				- (fetptr->cf * temp1 * sqrtvbsphi);     vfbx = vfb0 + vbs;   }e2 /* If vbs is too close to 2phif fix it. Blecch. */	   else { )     temp1 = sqrt(nrvabs);      temp2 = sqrt(vds + nrvabs); M     vttmp = (fetptr->fixvto + (fetptr->be * temp1)); /* note vttmp global. */ /     vtprim = (vttmp - (fetptr->de * sqrtvds)) - 8 			(fetptr->cf * (temp2 - fetptr->sqrttwophif) * temp1);#     vfbx = fetptr->fixvto - nrvabs;b   }e     vgst = (vgs - vtprim); /* Cutoff region. */   if(vgst <= 0) {e   /* No Subthresh. */ *     if(fetptr->betas == 0.0) idrain = 0.0;   /* Subthresh. */
     else {-       if( (fetptr->twophif - vbs) < nrvabs ) pF 	temp1 = ((vgs-vfb0) - fetptr->twophif) + nrvabs + fetptr->de*sqrtvds;?       else temp1 = ((vgs - vfb0) - vbs) - fetptr->de * sqrtvds;c       if(temp1 >= 0) {D         bet = fetptr->be - fetptr->cf * (temp2-fetptr->sqrttwophif);5         idrain = fetptr->betas * exp(fetptr->xng * ( c 			vgs - vfb0 - fetptr->twophify 			+ (fetptr->de * sqrtvds) 4 			+ (bet*0.5*( bet - sqrt(bet*bet + (4.0*temp1)) )) 			      		     ));-"         temp1 = fetptr->xng * vds;;         if(temp1 <= MAXEXP) idrain -= idrain * exp(-temp1);1       }-B       else { /* If vgs-vfb0-vbs-de*sqrt(vds) < 0 assume it = 0. */6         temp1 = fetptr->xng * (vbs - fetptr->twophif);@         if(temp1 > -MAXEXP) idrain = fetptr->betas * exp(temp1);         else idrain = 0.0;"         temp1 = fetptr->xng * vds;:         if(temp1 < MAXEXP) idrain -= idrain * exp(-temp1);       }=     }    } $ /* Saturation and linear Regions. */   else {&   /* Calculate a few useful things. *//     apg = fetptr->alpha + fetptr->gamma * vgst;      vdsat = vgst / apg;pF     xmob = 1.0/( 1.0 + (fetptr->theta * vgst) );  /* Safe division. */   /* Linear Region. */     if(vds <= vdsat) {H       barid = fetptr->beta * vds * apg * ( (2.0 * vgst) - (apg * vds) );       idrain = barid * xmob;     }a   /* Saturation Region. */
     else {       sqdapg = apg * apg;f       sqdvgst = vgst * vgst;M       clmod = 1.0 + (fetptr->a2lam * (vds - vdsat) / sqdapg); /* Safe div. */p%       barid = fetptr->beta * sqdvgst;s$       idrain = barid * xmob * clmod;     }*C   /* Add in the subthresh component (to make current continous). *//     if(fetptr->betas != 0.0) {        temp1 = fetptr->xng * vds;H       if(temp1 <= MAXEXP) idrain += fetptr->betas * ( 1 - exp(-temp1) );#       else idrain += fetptr->betas;      }    };  > /* Cutoff region and Weak inversion or subthreshold region. */3   if( (vgs <= vfbx) || (vgs <= vttmp) ) *pqd = 0.0;)  ; /* Now handle as a special case when vds is precisely 0. */cH /* This was done to optimize runtime by pulling out this simple case. */G   else if(vds == 0.0) *pqd = - ( fetptr->cgsub * 0.5 * (vgs - vttmp) );s  $ /* Linear and Saturation Regions. */   else {:     alphax = (fetptr->alpha + fetptr->gamma * vgst) * vds;   /* The linear region */p"     if( vgs > (alphax + vttmp) ) {       vgst = vgs - vttmp;        temp1 = alphax * 0.5; ,       temp2 = 1.0 / (12.0 * (vgst - temp1));N       *pqd = fetptr->cgsub*( (1.5*temp1)-(0.5*vgst)-(temp1*temp1*6.0*temp2) );     }e*   /* And finally the saturation region. */     else *pqd = 0.0;   }m   return(idrain);f }t  & double rhsjustgti(vds, vgs, vbs, fptr) double vds, vgs, vbs;v struct fetti *fptr;e {r& double temp1, vttmp, vfbx, alphax, qg; double sqrt();     temp1 = fptr->twophif - vbs;5   if(temp1 > nrvabs) {    /* vbs < 2phif - nrvabs. */e4     vttmp = fptr->fixvto + (fptr->be * sqrt(temp1));.     vfbx = fptr->fixvto - fptr->twophif + vbs;&   } else {		/* vbs > 2phif - nrvabs */7     vttmp = (fptr->fixvto + (fptr->be * sqrt(nrvabs))); !     vfbx = fptr->fixvto - nrvabs;    }nE   if(vgs <= vfbx) qg = fptr->cgsub * (vgs-vfbx); /* Cutoff region. */)F   else if(vgs <= vttmp) { /* Weak inversion or subthreshold region. */A     temp1 = sqrt( (fptr->be * fptr->be) + (4.0 * (vgs - vfbx)) );m;     qg = fptr->cgsub * fptr->be * 0.5 * (temp1 - fptr->be);    };>   else if(vds == 0.0) qg = fptr->cgsub * (vgs - fptr->fixvto);.   else {  /* Linear and Saturation Regions. */7     alphax = fptr->alpha + fptr->gamma * (vgs - vttmp); @     if( vgs > ((alphax * vds) + vttmp) ) {  /* Linear region. */$       temp1 = (alphax * vds * vds) /5 		 ( 12.0 * ((vgs - vttmp) - (alphax * vds * 0.5)) );n 							nJ       qg = fptr->cgsub*( ((vgs - fptr->fixvto) - (0.5 * vds) ) +  temp1 );     }  /* Saturation Region. */      else qg = fptr->cgsub *a< 		( (vgs-fptr->fixvto) - ( (vgs - vttmp) / (alphax*3.0) ) );   }f
   return(qg);  }g  6 double justdrainti(vds,vgs,vbs,pgmd, pqd, pcd, fetptr)( double vds, vgs, vbs, *pgmd, *pqd, *pcd; struct fetti *fetptr;d {t> double apg, sqdapg, vttmp, vdsat, xmob, clmod, barid, sqdvgst,        sqrtvds, dvtdvds, gmgs,<        sqrtvbsphi, vgst, idrain, temp1, temp2, temp3, temp4,        bet, sqbet, betvbs,  !        vfb0, vfbx, vgsat, alphax;e double sqrt(), exp();(  *   vfb0 = fetptr->fixvto - fetptr->twophif;B /* Bound vds away from zero to fix noncont diff. model. Blecch. */8   sqrtvds = max(vds, nrvabs);  sqrtvds = sqrt(sqrtvds);   %   sqrtvbsphi = fetptr->twophif - vbs;c<   if(sqrtvbsphi > nrvabs) { /* First region, vbs < 2phif. */"     sqrtvbsphi = sqrt(sqrtvbsphi);.     temp2 = sqrt(fetptr->twophif + vds - vbs);(     temp1 = temp2 - fetptr->sqrttwophif;7     vttmp = fetptr->fixvto + (fetptr->be * sqrtvbsphi);(4     vgst = vgs - ( (vttmp - (fetptr->de * sqrtvds)) * 				- (fetptr->cf * temp1 * sqrtvbsphi) );H     if(vgst > 0) { /* Don't bother computing these if device cut off. */5       dvtdvds = (fetptr->de / (sqrtvds + sqrtvds)) + f1 		   (fetptr->cf * sqrtvbsphi / (temp2 + temp2));e     }.   } ;   else { /* If vbs is too close to 2phif fix it. Blecch. */;     sqrtvbsphi = sqrt(nrvabs);     temp2 = sqrt(vds + nrvabs);b9     vttmp = (fetptr->fixvto + (fetptr->be * sqrtvbsphi));v5     vgst = vgs - ( (vttmp - (fetptr->de * sqrtvds)) -a> 		(fetptr->cf * (temp2 - fetptr->sqrttwophif) * sqrtvbsphi) );@     if(vgst > 0) dvtdvds = (fetptr->de / (sqrtvds + sqrtvds)) + 0 				(fetptr->cf * sqrtvbsphi / (temp2 + temp2));   }    if(vgst <= 0) { /* Cutoff. */dK     if(fetptr->betas == 0.0) { *pgmd=0.0; idrain=0.0; } /* No subthresh. */;"     else { /* Subthresh region. */-       if( (fetptr->twophif - vbs) < nrvabs ) ;F 	temp1 = ((vgs-vfb0) - fetptr->twophif) + nrvabs + fetptr->de*sqrtvds;?       else temp1 = ((vgs - vfb0) - vbs) - fetptr->de * sqrtvds;t       if(temp1 >= 0) {(         betvbs=fetptr->cf/(temp2+temp2);D         bet = fetptr->be - fetptr->cf * (temp2-fetptr->sqrttwophif);         sqbet = bet * bet;,         temp2 = sqrt( sqbet + (4 * temp1) );5         idrain = fetptr->betas * exp(fetptr->xng * (  # 				vgs - vfb0 - fetptr->twophif + i1 				(fetptr->de * sqrtvds) + (bet*.5*(bet-temp2))b 			      		     ));t"         temp1 = fetptr->xng * vds;         if(temp1 <= MAXEXP) {)! 	  temp3 = idrain * exp(-temp1); t&           *pgmd = temp3 * fetptr->xng;           idrain -= temp3; 	} else *pgmd = 0.0;%         temp3 = fetptr->xng * idrain; "         temp4 = temp3 * bet/temp2;#         *pgmd += temp3 * betvbs * (s3 			(1.0 - bet/temp2) * fetptr->de/(sqrtvds+sqrtvds)t5 			        + (sqbet + temp1 + temp1)/temp2 - bet   );y       }rB       else { /* If vgs-vfb0-vbs-de*sqrt(vds) < 0 assume it = 0. */6         temp1 = fetptr->xng * (vbs - fetptr->twophif);@         if(temp1 > -MAXEXP) idrain = fetptr->betas * exp(temp1);         else idrain = 0.0;"         temp1 = fetptr->xng * vds;         if(temp1 < MAXEXP) {  	  temp2 = idrain * exp(-temp1); 	  *pgmd = temp2 * fetptr->xng;(           idrain -= temp2;	         }r         else *pgmd = 0.0;{       }>     }-   }b   else {&   /* Saturation and linear Regions. *//     apg = fetptr->alpha + fetptr->gamma * vgst;p     vdsat = vgst / apg;tF     xmob = 1.0/( 1.0 + (fetptr->theta * vgst) );  /* Safe division. */-     if(vds <= vdsat) {   /* Linear Region. */sH       barid = fetptr->beta * vds * apg * ( (2.0 * vgst) - (apg * vds) );       idrain = barid * xmob;       *pgmd = xmob * ( 		(2.0 * fetptr->beta * vds * E 	 ( (apg * (1.0 - (fetptr->gamma * vds))) + (fetptr->gamma * vgst) ))+ 		 - fetptr->theta * idrain);h        *pgmd  = (*pgmd * dvtdvds)< 		 + ( 2.0 * fetptr->beta * xmob * apg * (vgst - apg*vds) );     } %     else {   /* Saturation Region. */        sqdapg = apg * apg;t       sqdvgst = vgst * vgst;M       clmod = 1.0 + (fetptr->a2lam * (vds - vdsat) / sqdapg); /* Safe div. */ %       barid = fetptr->beta * sqdvgst;o$       idrain = barid * xmob * clmod;       *pgmd = xmob * e- 		( (  (2.0 * fetptr->beta * vgst * clmod) - q7 		     (barid * ( (fetptr->a3lam / (sqdapg * sqdapg)) +C8 			    ((vds-vdsat) * fetptr->a2lamg / (apg * sqdapg))))$ 		  )  - (fetptr->theta * idrain) );J       *pgmd = (*pgmd * dvtdvds) + ((xmob * barid * fetptr->a2lam)/sqdapg);     }1C   /* Add in the subthresh component (to make current continous). */      if(fetptr->betas != 0.0) {        temp1 = fetptr->xng * vds;       idrain += fetptr->betas;       if(temp1 <= MAXEXP) { ,         temp1 = fetptr->betas * exp(-temp1);         idrain -= temp1;%         *pgmd += fetptr->xng * temp1;        }q     }4   }m  + /* Fix case where vbs goes too positive. */tM   if( (fetptr->twophif-vbs) < nrvabs) vfbx = vfb0 + fetptr->twophif - nrvabs;)   else vfbx = vfb0 + vbs;	 /* Cutoff region. */L   if( (vgs <= vfbx) || (vgs <= vttmp) ) { *pqd=0.0; *pcd=0.0; } /* Cutoff */.   else {  /* Linear and Saturation Regions. */     vgst = vgs - vttmp; 2     alphax = fetptr->alpha + fetptr->gamma * vgst;#     vgsat = (alphax * vds) + vttmp;e.     if(vgs > vgsat) { /* The linear region. */       temp1 = alphax * vds;/7       temp2 = temp1 / (12.0 * (vgst - (0.5 * temp1) ));e       *pqd = fetptr->cgsub *  8 		( (0.75*temp1) - (0.5*vgst) - (temp1 * temp2 * 1.5) );&       *pcd = fetptr->cgsub * alphax * - 		( 0.75 - (temp2 * (3.0 + (9.0 * temp2))) );      }m=     else { *pqd = 0.0; *pcd = 0.0; } /* Saturation Region. */e   }i   return(idrain);e }   + double justgateti(vds,vgs,vbs, pcg, fetptr)) double vds, vgs, vbs, *pcg;  struct fetti *fetptr;2 {f, double temp1, temp2, vgst, vfbx, alphax, qg; double sqrt();      temp1 = fetptr->twophif - vbs;2   if(temp1 < nrvabs) { 	/* vbs > 2phif - nrvabs */@     vgst = vgs - (fetptr->fixvto + (fetptr->be * sqrt(nrvabs)));#     vfbx = fetptr->fixvto - nrvabs;f   }   '   else {    /* vbs < 2phif - nrvabs. */pA     vgst = vgs - ( fetptr->fixvto + (fetptr->be * sqrt(temp1)) ); 2     vfbx = fetptr->fixvto - fetptr->twophif + vbs;   }     (   if(vgs <= vfbx) { /* Cutoff region. */%     qg = fetptr->cgsub * (vgs-vfbx); =     *pcg = fetptr->cgsub;>   }oE   else if(vgst <= 0.0) { /* Weak inversion or subthreshold region. */aE     temp1 = sqrt( (fetptr->be * fetptr->be) + (4.0 * (vgs - vfbx)) );tA     qg = fetptr->cgsub * fetptr->be * 0.5 * (temp1 - fetptr->be);/.     *pcg = (fetptr->cgsub * fetptr->be)/temp1;   })   else if(vds == 0.0) {f0     qg = fetptr->cgsub * (vgs - fetptr->fixvto);     *pcg = fetptr->cgsub;u   }n.   else {  /* Linear and Saturation Regions. */2     alphax = fetptr->alpha + fetptr->gamma * vgst;7     if( vgst > (alphax * vds) ) {  /* Linear region. */v*       temp2 = vgst - (alphax * vds * 0.5);5       temp1 = (alphax * vds * vds) / ( 12.0 * temp2);tN       qg = fetptr->cgsub*( ((vgs - fetptr->fixvto) - (0.5 * vds) ) +  temp1 );       *pcg = fetptr->cgsub*v> 	( 1.0 - (fetptr->alpha * vds * vds)/(12.0 * temp2 * temp2) );     } #     else { /* Saturation Region. */h       qg = fetptr->cgsub *7 	( (vgs - fetptr->fixvto) - ( vgst  / (alphax*3.0) ) );vM       *pcg = fetptr->cgsub * (1.0 - ( fetptr->alpha / (3.0*alphax*alphax) ));n     }    }v
   return(qg);d }   1 /* Node swapping Macro that is shared by many. */S tiswapds(fptr) struct fetti *fptr;  {  double tempd, *ptempd;	 int temp;gD   temp = fptr->dnode; fptr->dnode = fptr->snode; fptr->snode = temp;>   tempd = fptr->cgd; fptr->cgs = fptr->cgd; fptr->cgd = tempd;H   ptempd = fptr->matdd; fptr->matdd = fptr->matss; fptr->matss = ptempd;H   ptempd = fptr->matds; fptr->matds = fptr->matsd; fptr->matsd = ptempd;H   ptempd = fptr->matdg; fptr->matdg = fptr->matsg; fptr->matsg = ptempd;H   ptempd = fptr->matdb; fptr->matdb = fptr->matsb; fptr->matsb = ptempd;H   ptempd = fptr->matgd; fptr->matgd = fptr->matgs; fptr->matgs = ptempd;I   ptempd = fptr->matbd; fptr->matbd = fptr->matbs; fptr->matbs = ptempd; - }e     stuffmti(devptr) struct device *devptr; {e struct fetti *fptr; )   fptr = (struct fetti *) devptr->devptr;e#   adddevarray(devptr, fptr->dnode);tB   if(fptr->gnode != fptr->dnode) adddevarray(devptr, fptr->gnode);  &   if( (fptr->snode != fptr->dnode) && F       (fptr->snode != fptr->gnode) ) adddevarray(devptr, fptr->snode);  %   if( (fptr->bnode != fptr->dnode) &&f%       (fptr->bnode != fptr->gnode) &&>F       (fptr->bnode != fptr->snode) ) adddevarray(devptr, fptr->bnode);   }   I /* Initialize the ti fet for simulation.  This includes replacing the  */fC /* global node numbers with subcircuit numbers, initializing the */eD /* matrix pointers, and deciding on the functions to evaluate the */
 /* mosfet. */t' struct device *mtiinit(subptr, extfptr)t struct subcircuit *subptr; struct fetti *extfptr; {v struct fetti *fptr;d struct device *devptr; double *getmat();  int disfetti();4  I /* Do not copy the TIFET model if it has only a gate or bulk in subckt */f> /* and cox, cgs, cgd are all zero or this is a dc solution. */   if( (dcflag == TRUE) || M       ((extfptr->cgsub ==0.0)&&(extfptr->cgd ==0.0)&&(extfptr->cgs == 0.0)) ) 0 	    if( (nomapchk(subptr,extfptr->snode) <= 0) ; 		&& (nomapchk(subptr,extfptr->dnode) <= 0) ) return(NULL);f   /* Allocate the device. */>   devptr = (struct device *) ralloc(1, sizeof(struct device));   devptr->utype = FETTI;<   devptr->devptr = (char *) ralloc(1, sizeof(struct fetti));)   fptr = (struct fetti *) devptr->devptr;p  - /* Copy the external fet to the local fet. */p-   bcopy(fptr, extfptr, sizeof(struct fetti));;  < /* Actually replace the global nodes with the local ones. *//   fptr->dnode = chksubnode(subptr,fptr->dnode); /   fptr->snode = chksubnode(subptr,fptr->snode);(/   fptr->gnode = chksubnode(subptr,fptr->gnode); /   fptr->bnode = chksubnode(subptr,fptr->bnode);i  7   fptr->matdd = getmat(fptr->dnode,fptr->dnode,subptr);t7   fptr->matdg = getmat(fptr->dnode,fptr->gnode,subptr); 7   fptr->matds = getmat(fptr->dnode,fptr->snode,subptr);e7   fptr->matdb = getmat(fptr->dnode,fptr->bnode,subptr);r  7   fptr->matss = getmat(fptr->snode,fptr->snode,subptr);>7   fptr->matsd = getmat(fptr->snode,fptr->dnode,subptr);r7   fptr->matsg = getmat(fptr->snode,fptr->gnode,subptr);f7   fptr->matsb = getmat(fptr->snode,fptr->bnode,subptr);p     if(dcflag == FALSE) { 9     fptr->matgg = getmat(fptr->gnode,fptr->gnode,subptr);v9     fptr->matgd = getmat(fptr->gnode,fptr->dnode,subptr);g9     fptr->matgs = getmat(fptr->gnode,fptr->snode,subptr); 9     fptr->matgb = getmat(fptr->gnode,fptr->bnode,subptr);   9     fptr->matbb = getmat(fptr->bnode,fptr->bnode,subptr);S9     fptr->matbd = getmat(fptr->bnode,fptr->dnode,subptr); 9     fptr->matbg = getmat(fptr->bnode,fptr->gnode,subptr); 9     fptr->matbs = getmat(fptr->bnode,fptr->snode,subptr);    }t  ! /* Debugging Display function. */	   devptr->display = disfetti;a /* Evaluation functions. */ N   if(dcflag ==FALSE) { devptr->eval =putmosti; devptr->rhseval =rhsputmosti; }F   else { devptr->eval = dcputmosti; devptr->rhseval = dcrhsputmosti; }    }e   finishmodti(modptr)  struct inmtimodel *modptr; {{! double leff, weff, sqrt(), log(); $ /* Size independent calculations. */,   modptr->phif = VTHERM * log(modptr->n/NI);%   modptr->twophif = modptr->phif * 2;-.   modptr->sqrttwophif = sqrt(modptr->twophif);D   modptr->fixvto = modptr->vto - (modptr->be * modptr->sqrttwophif);A   modptr->a2lam = modptr->lambda * modptr->alpha * modptr->alpha;p0   modptr->a3lam = modptr->alpha * modptr->a2lam;7   modptr->a2lamg = 2.0 * modptr->gamma * modptr->a2lam; "   modptr->xng = modptr->ng/VTHERM;5   if(modptr->lgos == 0.0) modptr->lgos = modptr->lgo;t5   if(modptr->lgod == 0.0) modptr->lgod = modptr->lgo;g# /* W and L dependent parameters. */d$   weff = modptr->width - modptr->wr;5   leff = (modptr->length - modptr->tld) - modptr->lr; ,   modptr->beta = (modptr->kp * weff) / leff;,   modptr->cgsub = modptr->cox * weff * leff;.   modptr->betas = (modptr->kps * weff) / leff;H   modptr->cgs = modptr->cox * weff * (modptr->lgos + modptr->tld * 0.5);H   modptr->cgd = modptr->cox * weff * (modptr->lgod + modptr->tld * 0.5); }f   modtofetti(fetptr,modelptr)d struct inmtimodel *modelptr; struct fetti *fetptr;p {>    fetptr->type = modelptr->type;%   fetptr->pmodel = (char *) modelptr;n"   fetptr->gamma = modelptr->gamma;    fetptr->phif = modelptr->phif;$   fetptr->lambda = modelptr->lambda;   fetptr->be = modelptr->be;"   fetptr->theta = modelptr->theta;"   fetptr->alpha = modelptr->alpha;   fetptr->de = modelptr->de;   fetptr->cf = modelptr->cf;$   fetptr->fixvto = modelptr->fixvto;&   fetptr->twophif = modelptr->twophif;.   fetptr->sqrttwophif = modelptr->sqrttwophif;"   fetptr->a2lam = modelptr->a2lam;"   fetptr->a3lam = modelptr->a3lam;$   fetptr->a2lamg = modelptr->a2lamg;    fetptr->beta = modelptr->beta;"   fetptr->betas = modelptr->betas;   fetptr->xng = modelptr->xng;"   fetptr->cgsub = modelptr->cgsub;"   fetptr->cgsub = modelptr->cgsub;   fetptr->cgs = modelptr->cgs;   fetptr->cgd = modelptr->cgd; }     C struct device *iprmti(nextdev,netlist,numparams,paramlist,modelptr)a struct device *nextdev;f int netlist[], numparams;p ip_param paramlist[];- struct inmtimodel *modelptr; { % struct device **lpdevptr, *mtiinit();g struct fetti *fptr;p int tempint, i, stuffmti();e double as,ad,ps,pd,tempw,templ;*   /* Allocate the device. */   nextdev->utype = FETTI;f   nextdev->initdev = mtiinit;.   nextdev->stuffdev = stuffmti;t=   nextdev->devptr = (char *) ralloc(1, sizeof(struct fetti));v*   fptr = (struct fetti *) nextdev->devptr;E   nextdev->next = (struct device *) ralloc(1, sizeof(struct device));t   nextdev = nextdev->next;   nextdev->next = NULL;n  F   modtofetti(fptr,modelptr);  /* Copy the model params to instance. */   /* Get the node numbers. */f   fptr->dnode = netlist[0];    fptr->gnode = netlist[1];o   fptr->snode = netlist[2];(   fptr->bnode = netlist[3];h   tempw = modelptr->width;   templ = modelptr->length;m  = /* Get the length, width, as, ad, ps, pd params, if given. */     for(i=0; i < numparams; i++) {      switch(paramlist[i].id[0]) {7       case 'a'  : tempw = pareval(paramlist[i]); break;r7       case 'b'  : templ = pareval(paramlist[i]); break;>4       case 'c'  : as = pareval(paramlist[i]); break;4       case 'd'  : ad = pareval(paramlist[i]); break;4       case 'e'  : ps = pareval(paramlist[i]); break;4       case 'f'  : pd = pareval(paramlist[i]); break;E       default   : printf("Nonexist param spec'ed for m1\n"); exit(0);l     }    }rC   if( (tempw != modelptr->width) || (templ != modelptr->length) ) {o     tempw -= modelptr->wr;,     templ -= (modelptr->tld + modelptr->lr);.     fptr->beta = modelptr->kp * tempw / templ;0     fptr->betas = modelptr->kps * tempw / templ;0     fptr->cgsub = modelptr->cox * tempw * templ;L     fptr->cgd = modelptr->cox * tempw *(modelptr->lgod+(0.5*modelptr->tld));L     fptr->cgs = modelptr->cox * tempw *(modelptr->lgos+(0.5*modelptr->tld));   }p   return(nextdev); }f   disfetti(fetptr) struct fetti *fetptr;v {,$   printf("d=%d, g=%d, s=%d, b=%d ", ?    		fetptr->dnode,fetptr->gnode, fetptr->snode,fetptr->bnode);g$   printf("beta=%g, ", fetptr->beta);&   printf("cgsub=%g, ", fetptr->cgsub);&   printf("type = %d\n", fetptr->type);'   printf("gamma = %g ", fetptr->gamma);d&   printf("phif = %g  ", fetptr->phif);*   printf("lambda = %g\n", fetptr->lambda);!   printf("be = %g ", fetptr->be);d'   printf("theta = %g ", fetptr->theta);i'   printf("alpha = %g ", fetptr->alpha);d"   printf("cf = %g\n", fetptr->cf);!   printf("de = %g ", fetptr->de);e*   printf("fixvto = %g  ", fetptr->fixvto);,   printf("twophif = %g  ", fetptr->twophif);4   printf("sqrttwophif = %g  ", fetptr->sqrttwophif);(   printf("a2lam = %g\n", fetptr->a2lam);(   printf("a3lam = %g  ", fetptr->a3lam);*   printf("a2lamg = %g\n", fetptr->a2lamg);!   printf("xng=%g ", fetptr->xng);t%   printf("betas=%g ", fetptr->betas);c6   printf("cgs=%g cgd=%g\n", fetptr->cgs, fetptr->cgd); } 