/*
 * Mesa (an OpenGL clone) canvas demo
 */
#include "GL/gl.h"
#include "forms.h"
#include <stdlib.h>

extern void menu_cb(FL_OBJECT *, long);
extern void switch_primitive(FL_OBJECT *, long);

typedef struct {
	FL_FORM *form;
	FL_OBJECT *canvas;
	FL_OBJECT *done;
	FL_OBJECT *menu;
	void *vdata;
	long ldata;
} FD_form;

extern FD_form * create_form_form(void);

FD_form *ui;
static int prim = GL_POLYGON ;
void cpack(unsigned long col)
{
   long flcol = FL_BLUE;

   glColor3b((col&0xff),(col>>8)&0xff, (col>>16)&0xff);
   if(col == 0xff) flcol = FL_RED;
   else if(col == 0xff00) flcol = FL_GREEN;
   else if(col == 0xff0000) flcol = FL_BLUE;
   else if(col == 0xffff00) flcol = FL_YELLOW;
   else  if(col == 0xff00ff) flcol = FL_MAGENTA;
   else if(col == 0x00ffff) flcol = FL_CYAN;
   else if(col == 0xffffff) flcol = FL_WHITE;
   else fprintf(stderr,"bad color: 0x%lx\n",col);
   glIndexi(fl_get_flcolor(flcol)); 
}


float v0[3] = {0.0, 0.0, 0.0};
float v1[3] = {1.0, 0.0, 0.0};
float v2[3] = {1.0, 1.0, 0.0};
float v3[3] = {0.0, 1.0, 0.0};
float v4[3] = {0.0, 0.0, 1.0};
float v5[3] = {1.0, 0.0, 1.0};
float v6[3] = {1.0, 1.0, 1.0};
float v7[3] = {0.0, 1.0, 1.0};

#define v3f glVertex3fv

void
draw_cube(void)
{
   glBegin(prim);cpack(0xff0000);v3f(v0);v3f(v1);v3f(v2);v3f(v3); glEnd();
   glBegin(prim);cpack(0xffff00);v3f(v4);v3f(v5);v3f(v6);v3f(v7); glEnd();
   glBegin(prim);cpack(0xff00ff);v3f(v0);v3f(v1);v3f(v5);v3f(v4); glEnd();
   glBegin(prim);cpack(0x00ffff);v3f(v2);v3f(v3);v3f(v7);v3f(v6); glEnd();
   glBegin(prim);cpack(0x00ff00);v3f(v0);v3f(v4);v3f(v7);v3f(v3); glEnd();
   glBegin(prim);cpack(0x0000ff);v3f(v1);v3f(v2);v3f(v6);v3f(v5); glEnd();
}

int
idle_cb(XEvent *ev, void *data)
{
    static GLfloat xrot, yrot, zrot;

    glClear( GL_COLOR_BUFFER_BIT );

    glPushMatrix();

    glRotatef( xrot, 1.0, 0.0, 0.0 );
    glRotatef( yrot, 0.0, 1.0, 0.0 );
    glRotatef( zrot, 0.0, 0.0, 1.0 );
    glTranslatef(-1.0,1.2,-1.5);  
    glScalef(2.0,2.0,2.0);  
    draw_cube();
    glPopMatrix();

    glFinish();

    if(ev)
    {
       xrot += 10.0;
       yrot += 7.0;
       zrot -= 3.0;
    }

    return 0;
}

int
canvas_expose(FL_OBJECT *ob, Window win, int w, int h, XEvent *xev, void *ud)
{

    glViewport(0,0, (GLint)w, (GLint)h);
    glClearColor(0,0,0,0);
    glClearIndex(fl_get_flcolor(FL_BLACK));

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    glFrustum( -1.0, 1.0,  -1.0, 1.0,  1.0, 10.0 ); 
    glTranslatef( 0.0, 0.0, -5.0 );  

    glMatrixMode( GL_MODELVIEW ); 
    glLoadIdentity();
    glCullFace( GL_BACK );
    glEnable( GL_CULL_FACE ); 

    glShadeModel( GL_FLAT );

    idle_cb(0,0);
    return 0;
}


int
buttonpress_cb(FL_OBJECT *ob, Window win, int w, int h, XEvent *xev, void *ud)
{
   static suspended;
   suspended = (suspended + 1) %2;
   fl_set_idle_callback(suspended ? (FL_APPEVENT_CB) 0:idle_cb, 0);
   return 0;
}

void
switch_primitive(FL_OBJECT *ob, long data)
{
    static primitive[] = { GL_POLYGON, GL_LINE_LOOP};
    static int i ;
    prim = primitive[++i%2];
}


void
menu_cb(FL_OBJECT *ob, long data)
{
}

int main(int argc, char *argv[])
{

   FL_OBJECT *ob;

   fl_initialize(&argc, argv, "FormDemo", 0, 0);
   ui = create_form_form();

   /* fill-in form initialization code */
   fl_addto_menu(ui->menu,"Item1|Item2|Item3|Item4");

   fl_add_canvas_handler(ui->canvas, Expose, canvas_expose, 0);
   fl_add_canvas_handler(ui->canvas, ButtonPress, buttonpress_cb, 0);
   fl_set_idle_callback(idle_cb, 0);

   /* geometry stuff */
   fl_set_form_minsize(ui->form, 340, 280);

   fl_show_form(ui->form,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,"Mesa Canvas");
   fl_addto_selected_xevent(FL_ObjWin(ui->canvas), ButtonPressMask);

   while((ob = fl_do_forms()) != ui->done)
       ;
   return 0;
}

FD_form *create_form_form(void)
{
  FL_OBJECT *obj;
  FD_form *fdui = (FD_form *) fl_calloc(1, sizeof(*fdui));

  fdui->form = fl_bgn_form(FL_NO_BOX, 340, 280);
  obj = fl_add_box(FL_UP_BOX,0,0,340,280,"");
  fdui->canvas = obj = fl_add_mesacanvas(FL_NORMAL_CANVAS,20,45,225,215,"");
    fl_set_object_gravity(obj, NorthWestGravity, SouthEastGravity);
  fdui->done = obj = fl_add_button(FL_NORMAL_BUTTON,255,230,70,30,"Done");
    fl_set_button_shortcut(obj,"Dd#d",1);
    fl_set_object_gravity(obj, SouthEastGravity, SouthEastGravity);
  fdui->menu = obj = fl_add_menu(FL_PULLDOWN_MENU,20,15,50,20,"Canvas");
    fl_set_object_shortcut(obj,"#CcC",1);
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_gravity(obj, NorthWestGravity, NorthWestGravity);
    fl_set_object_callback(obj,menu_cb,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,255,45,70,30,"Poly/Line");
    fl_set_object_gravity(obj, NorthEastGravity, NorthEastGravity);
    fl_set_object_callback(obj,switch_primitive,0);
  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

