/*
 * $Id: mesa.c,v 0.75 1995/07/16 03:25:48 zhao Beta $
 *
 *
 *   XMesa canvas
 *
 *   There is really no need to use Mesa canvas. Use GL canvas
 *   instead.
 *
 *   This file works with Mesa 1.2.1 or later.
 */

#include "forms.h"
#include "GL/xmesa.h"
#include "GL/gl.h"

static int
mesa_init(FL_OBJECT * ob)
{
    XMesaContext context;
    int rgb = (fl_vmode == TrueColor && fl_state[fl_vmode].depth >= 24);

    context = XMesaCreateContext(fl_display, fl_state[fl_vmode].xvinfo,
				 rgb,
				 ob->double_buffer,	/* double buffering */
				 GL_FALSE,
				 0);
    if (!context)
    {
	fprintf(stderr, "Can't attatch Mesa context!\n");
	return -1;
    }

    ob->u_vdata = context;

    XMesaBindWindow(context, FL_ObjWin(ob));
    XMesaMakeCurrent(context);

    return 0;
}


static int
mesa_cleanup(FL_OBJECT * ob)
{
    if(ob->u_vdata)
    {
       XMesaDestroyContext(ob->u_vdata);
       ob->u_vdata =0;
    }

    return 0;
}


FL_OBJECT *
fl_create_mesacanvas(int type, FL_Coord x, FL_Coord y, FL_Coord w, FL_Coord h,
		     const char *label)
{
    FL_OBJECT *ob = fl_create_canvas(type, x, y, w, h, label);
    fl_modify_canvas_prop(ob, 0, mesa_init, mesa_cleanup);
    return ob;
}


FL_OBJECT *
fl_add_mesacanvas(int type, FL_Coord x, FL_Coord y, FL_Coord w, FL_Coord h,
		  const char *label)
{
    FL_OBJECT *ob = fl_create_mesacanvas(type, x, y, w, h, label);
    fl_add_object(fl_current_form, ob);
    return ob;
}
