! MMS description file for LIBWAIS
! Bjorn S. Nilsson, Aleph, CERN, 20-Aug-1994
! Mosaic version 2.4 20-Aug-1994
! Only routines needed for Mosaic 2.4 are included in this compilation
!
! Usage:
!       $ MMS                           for DEC/UCX/VAXC
! Add a DECC=1      MACRO when DEC C is used.
! Add a MULTINET=1  MACRO when MultiNet TCP/IP is used.
! Add a DEBUG=1     MACRO when debugging.
! Add a SOCKETSHR=1 MACRO when Socketshr is used.  BGT
!

WDIR = [.$(WORK)]

LIBTARGET = $(WDIR)libwais.olb

.IFDEF DECC
.IFDEF MULTINET
CQUALC=/DECC/Prefix=ANSI
.ELSE
CQUALC=/DECC/Prefix=ALL
.ENDIF
.ELSE
.IFDEF DECCVAXC
CQUALC=/VAXC
.ELSE
CQUALC=
.ENDIF
.ENDIF

.IFDEF MULTINET
CDEFS = /Define=MULTINET
.ENDIF

.IFDEF SOCKETSHR ! BGT
CDEFS = /Define=SOCKETSHR ! BGT
.ENDIF ! BGT

.IFDEF DEBUG
CFLAGS = $(CQUALC)$(CDEFS)/NoOpt/Debug
.ELSE
CFLAGS = $(CQUALC)$(CDEFS)
.ENDIF

OBJECTS = Odir:cutil.obj Odir:futil.obj Odir:panic.obj Odir:ui.obj \
          Odir:wmessage.obj Odir:wprot.obj Odir:wutil.obj Odir:zprot.obj \
          Odir:ztype1.obj Odir:zutil.obj

.FIRST
        @ If F$Search("$(LIBTARGET)") .EQS. "" Then Library/Create $(LIBTARGET)
	@ Define/NoLog Odir $(WDIR)
	@ Define/NoLog Sys SYS$Library
.IFDEF DECC
.IFDEF ALPHA
	@ If F$TRNLNM("ALPHA$LIBRARY") .NES. "" Then Define/NoLog Sys Alpha$Library
.ELSE
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.ENDIF

$(LIBTARGET) : $(LIBTARGET)($(OBJECTS))
	@ Write SYS$Output "Library libwais.olb built."

Odir:cutil.obj : cutil.c
Odir:futil.obj : futil.c
Odir:panic.obj : panic.c
Odir:ui.obj : ui.c
Odir:wmessage.obj : wmessage.c
Odir:wprot.obj : wprot.c
Odir:wutil.obj : wutil.c
Odir:zprot.obj : zprot.c
Odir:ztype1.obj : ztype1.c
Odir:zutil.obj : zutil.c

.c.obj
	$(CC)$(CFLAGS)/OBJECT=$@ $<

.obj.olb
	$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean :
	Delete/Log $(WDIR)*.OBJ;*
	Delete/Log $(LIBTARGET);*

