! MMS description file for LIBPNG
! Mosaic version 2.6 20-Feb-1996, George Cook
!
! Add a DEBUG=1    MACRO when debugging.
! Add a DECC=1     MACRO when compiling with DEC C.

WDIR = [.$(WORK)]

LIBTARGET = $(WDIR)libpng.olb

.FIRST
        @ If F$Search("$(LIBTARGET)") .EQS. "" Then Library/Create $(LIBTARGET)
	@ Define/NoLog Odir $(WDIR)
.IFDEF DECC
.ELSE
        @ Define/NoLog Sys SYS$Library
.ENDIF

.IFDEF DECC
CQUAL = /DECC/INCLUDE=[.ZLIB]
.ELSE
.IFDEF DECCVAXC
CQUAL = /VAXC/PRECISION=SINGLE/INCLUDE=[.ZLIB]
.ELSE
CQUAL = /PRECISION=SINGLE/INCLUDE=[.ZLIB]
.ENDIF
.ENDIF

.IFDEF DEBUG
CC_DEFS = $(CQUAL)/NoOpt/Debug
.ELSE
CC_DEFS = $(CQUAL)
.ENDIF


OBJS = Odir:png.obj, Odir:pngrcb.obj, Odir:pngrutil.obj, Odir:pngtrans.obj,\
   Odir:pngwutil.obj, Odir:pngread.obj, Odir:pngmem.obj, Odir:pngwrite.obj,\
   Odir:pngrtran.obj, Odir:pngwtran.obj, Odir:pngio.obj, Odir:pngerror.obj


CFLAGS= $(CC_DEFS)

$(LIBTARGET) : $(LIBTARGET)($(OBJS))
	@ Write SYS$Output "Library libpng.olb built."

.c.obj
	$(CC)$(CFLAGS)/OBJECT=$@ $<

.obj.olb
	$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean :
	delete $(WDIR)*.obj;*,$(LIBTARGET);*


# Other dependencies.
Odir:png.obj : png.c, png.h, pngconf.h
Odir:pngrcb.obj : pngrcb.c, png.h, pngconf.h
Odir:pngread.obj : pngread.c, png.h, pngconf.h
Odir:pngrtran.obj : pngrtran.c, png.h, pngconf.h
Odir:pngrutil.obj : pngrutil.c, png.h, pngconf.h
Odir:pngerror.obj : pngerror.c, png.h, pngconf.h
Odir:pngmem.obj : pngmem.c, png.h, pngconf.h
Odir:pngio.obj : pngio.c, png.h, pngconf.h
Odir:pngtrans.obj : pngtrans.c, png.h, pngconf.h
Odir:pngwrite.obj : pngwrite.c, png.h, pngconf.h
Odir:pngwtran.obj : pngwtran.c, png.h, pngconf.h
Odir:pngwutil.obj : pngwutil.c, png.h, pngconf.h

# Martin P.J. Zinser		           Email: 
# KP II					          m.zinser@gsi.de
# Gesellschaft f. Schwerionenforschung GSI        vipmzs.physik.uni-mainz.de
# Postfach 11 05 52                               mzdmza.zdv.uni-mainz.de
# D-64220 Darmstadt 		           Voice: 0049+6151/3592887
