! MMS description file for LIBWWW2
! Bjorn S. Nilsson, Aleph, CERN, 20-Nov-1993
! (Mosaic version 2.0)
! Mosaic version 2.4 20-Aug-1994
! Mosaic version 2.6 1-Nov-1995, George Cook
!
! Usage:
!       $ MMS                           for DEC/UCX/VAXC
! Add a MULTINET=1 MACRO when using MultiNet TCP/IP.
! Add a SOCKETSHR=1 MACRO when using SOCKETSHR.  BGT
! Add a DEBUG=1    MACRO when debugging.
! Add a DECC=1     MACRO when compiling with DEC C.
! Add a NOWAIS=1   MACRO when compiling without direct WAIS support.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.

.INCLUDE Config.mms_$(WORK)

WDIR = [.$(WORK)]

LIBTARGET = $(WDIR)libwww.olb

.LAST
	@ Delete config.mms_$(WORK);*
.FIRST
        @ If F$Search("$(LIBTARGET)") .EQS. "" Then Library/Create $(LIBTARGET)
	@ Define/NoLog Odir $(WDIR)
.IFDEF PATHWAY
	@ @[-.TWG]def
.ENDIF
.IFDEF DECC
.IFDEF ALPHA
	@ If F$TRNLNM("ALPHA$LIBRARY") .NES. "" Then Define/NoLog Sys Alpha$Library
.ELSE
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.ELSE
	@ Define/NoLog Sys SYS$Library
.ENDIF
.IFDEF NOWAIS
.ELSE
	@ Topdir = F$Environment("Default")-"LIBWWW2]"
	@ Define WAIS_IR  'Topdir'FREEWAIS-0_5.IR]
.IFDEF DECC
	@ Define DECC$User_Include 'F$Environment("Default")',WAIS_IR
	@ Define DECC$System_Include 'F$Environment("Default")',WAIS_IR,SYS
.ELSE
	@ Define C$Include 'F$Environment("Default")',WAIS_IR
	@ Define VAXC$Include 'F$Environment("Default")',WAIS_IR,SYS
.ENDIF
WAISDEF=DIRECT_WAIS,
WAISDEFS=DIRECT_WAIS
WAISMODULES = Odir:HTWAIS.obj
.ENDIF

.IFDEF DECC
.IFDEF PATHWAY
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS
CQUALC=/DECC/Standard=VAXC/Precision=SINGLE $(CC_PREFIX_NO_SIN)
.ELSE
.IFDEF MULTINET
CQUALC=/DECC/Standard=VAXC/Precision=SINGLE/Prefix=ANSI
.ELSE
CQUALC=/DECC/Standard=VAXC/Precision=SINGLE
.ENDIF
.ENDIF
.ELSE
.IFDEF DECCVAXC
CQUALC=/VAXC/Precision=SINGLE
.ELSE
CQUALC=/Precision=SINGLE
.ENDIF
.ENDIF

.IFDEF MULTINET
CDEFS = /Define=($(WAISDEF)$(NEWSD)MULTINET)
.ENDIF

.IFDEF PATHWAY
CDEFS = /Define=($(WAISDEF)$(NEWSD)WIN_TCP)
.ENDIF
.IFDEF SOCKETSHR ! BGT
CDEFS = /Define=($(WAISDEF)$(NEWSD)SOCKETSHR) ! BGT
.ENDIF ! BGT

.IFDEF CDEFS
.ELSE
CDEFS=/Define=($(NEWSD)$(WAISDEFS))
.ENDIF

.IFDEF DEBUG
CFLAGS = $(CQUALC)$(CDEFS)/NoOpt/Debug
.ELSE
CFLAGS = $(CQUALC)$(CDEFS)
.ENDIF

OBJECTS = Odir:HTAccess.obj Odir:HTAlert.obj Odir:HTAnchor.obj Odir:HTAtom.obj \
  Odir:HTSort.obj Odir:HTChunk.obj Odir:HTFTP.obj Odir:HTFWriter.obj \
  Odir:HTFile.obj Odir:HTFormat.obj Odir:HTGopher.obj Odir:HTInit.obj \
  Odir:HTList.obj Odir:HTMIME.obj Odir:HTML.obj Odir:HTMLDTD.obj \
  Odir:HTMLGen.obj Odir:HTNews.obj Odir:HTParse.obj Odir:HTPlain.obj \
  Odir:HTMosaicHTML.obj Odir:HTString.obj Odir:HTTCP.obj Odir:HTTP.obj \
  Odir:HTTelnet.obj Odir:HTWSRC.obj Odir:HTWriter.obj Odir:SGML.obj \
  Odir:HTIcon.obj Odir:HTCompressed.obj Odir:HTAAUtil.obj Odir:HTAssoc.obj \
  Odir:HTUU.obj Odir:HTAABrow.obj Odir:HTMailto.obj $(WAISMODULES)

$(LIBTARGET) : $(LIBTARGET)($(OBJECTS))
	@ Write SYS$Output "Library libwww.olb built."

Odir:HTAccess.obj :    HTAccess.c
Odir:HTAlert.obj :     HTAlert.c
Odir:HTAnchor.obj :    HTAnchor.c
Odir:HTAtom.obj :      HTAtom.c
Odir:HTSort.obj :      HTSort.c
Odir:HTChunk.obj :     HTChunk.c
Odir:HTFTP.obj :       HTFTP.c tcp.h
Odir:HTFWriter.obj :   HTFWriter.c
Odir:HTFile.obj :      HTFile.c
Odir:HTFormat.obj :    HTFormat.c
Odir:HTGopher.obj :    HTGopher.c
Odir:HTInit.obj :      HTInit.c
Odir:HTList.obj :      HTList.c
Odir:HTMIME.obj :      HTMIME.c
Odir:HTML.obj :        HTML.c
Odir:HTMLDTD.obj :     HTMLDTD.c
Odir:HTMLGen.obj :     HTMLGen.c
Odir:HTNews.obj :      HTNews.c
Odir:HTParse.obj :     HTParse.c
Odir:HTPlain.obj :     HTPlain.c
Odir:HTMosaicHTML.obj : HTMosaicHTML.c 
Odir:HTString.obj :    HTString.c
Odir:HTTCP.obj :       HTTCP.c
Odir:HTTP.obj :        HTTP.c  
Odir:HTTelnet.obj :    HTTelnet.c
Odir:HTWSRC.obj :      HTWSRC.c
Odir:HTWriter.obj :    HTWriter.c
Odir:SGML.obj :        SGML.c  
Odir:HTIcon.obj :      HTIcon.c
Odir:HTCompressed.obj : HTCompressed.c 
Odir:HTAAUtil.obj :    HTAAUtil.c
Odir:HTAssoc.obj :     HTAssoc.c
Odir:HTUU.obj :        HTUU.c  
Odir:HTAABrow.obj :    HTAABrow.c
Odir:HTMailto.obj :    HTMailto.c
Odir:HTWAIS.obj :      HTWAIS.c

.c.obj :
	$(CC)$(CFLAGS)/OBJECT=$@ $<

.obj.olb
	$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean :
	Delete/Log $(WDIR)*.OBJ;*
	Delete/Log $(LIBTARGET);*

