$! Create Mosaic version 2.6 on VMS.
$! This command procedure compiles and links Mosaic 2.6 with MMS or MMK
$! if either is available, otherwise it just compiles and links in one go.
$!
$! Debugging is invoked if P1 is set to DEBUG.  P2 can specify the TCP/IP
$! package (MULTINET, UCX, PATHWAY, SOCKETSHR).  MMS parameters can be added
$! in P3 (e.g. /IGNORE=WARNING to make MMS ignore compilation warnings).
$! Additional arguments (e.g. LUCIDA, NO_17_PT, NOWAIS, VAXC, NOMMS) can
$! be specified in P4 thru P8.
$!
$! Bjrn S. Nilsson, 25-Nov-1993
$! Motif 1.2 sensitivity added 2-June-1994
$! Mosaic 2.4 with WAIS Dec. 1994
$! Mosaic 2.6, Oct. 1995, George Cook
$! Combined build procedure, Nov. 1995, George Cook
$!
$!---------------------------------------------------------------------------
$!
$! Define your home page, default print command, mail prefix, etc. here:
$!
$ HOME_PAGE     ="http://www.ncsa.uiuc.edu/SDG/Software/Mosaic/NCSAMosaicHome.html"
$ PRINT_COMMAND ="Print/Name=\""""""""From Mosaic\""""""""/Notify/Identify/Delete"
$ MAIL_PREFIX   ="in%"
$ EDIT_COMMAND  ="Edit"
$ NEWSHOST      =""
$!
$!---------------------------------------------------------------------------
$!
$! Do not change these
$ QHOME_PAGE     ="HOME_PAGE_DEFAULT=""""""''HOME_PAGE'"""""""
$ QPRINT_COMMAND ="PRINT_DEFAULT=""""""''PRINT_COMMAND'"""""""
$ QMAIL_PREFIX   ="MAIL_PREFIX_DEFAULT=""""""''MAIL_PREFIX'"""""""
$ QEDIT_COMMAND  ="EDITOR_DEFAULT=""""""''EDIT_COMMAND'"""""""
$ QNEWSHOST      ="DEFAULT_NEWS_HOST=""""""''NEWSHOST'"""""""
$!
$ Verify = F$Verify(0)
$ On Error Then Goto The_End
$ On Control_Y Then Goto EndY
$ Set Symbol/Scope=(NoGlobal,NoLocal)
$ pwd = F$Environment("Default")
$ If P2 .EQS. "?" .OR. P2 .EQS. "HELP"
$  Then
$   Write sys$output "Specify UCX, MULTINET, PATHWAY (VAX only) or SOCKETSHR."
$   Goto The_End
$  Endif
$ If P1 .EQS. "?" .OR. P1 .EQS. "HELP"
$  Then
$   Write sys$output "Specify DEBUG in P1 to build with debugging."
$   Write sys$output -
     "Specify the TCP/IP package (UCX, MULTINET, PATHWAY or SOCKETSHR) in P2."
$   Write sys$output "Specify MMS parameters (e.g. /IGNORE=WARNING) in P3."
$   Write sys$output -
	"Specify additional arguments (e.g. LUCIDA, NOWAIS) in P4 thru P8."
$   Goto The_End
$  Endif
$ Args = ""
$ If P4 .NES. "" then Args = P4 + ","
$ If P5 .NES. "" then Args = Args + P5 + ","
$ If P6 .NES. "" then Args = Args + P6 + ","
$ If P7 .NES. "" then Args = Args + P7 + ","
$ If P8 .NES. "" then Args = Args + P8 + ","
$ Args = F$Edit(Args,"Collapse,UPCase")
$ Macro = "(" + Args
$!
$ On Warning Then Platform = "VAX"
$ Platform = F$GetSYI("Arch_Name")
$ On Error Then Goto The_End
$ If Platform .EQS. "Alpha"
$  Then
$   Macro = Macro + "AXP=1,ALPHA=1,"
$   Work = "A"
$  Else
$   Work = "V"
$  Endif
$ If F$Search("SYS$System:DECC$Compiler.Exe") .NES. ""
$  Then
$   If (Platform .EQS. "VAX") .AND. (F$Trnlnm("DECC$LIBRARY_INCLUDE") .EQS. "")
$    Then
$      Write sys$output "DEC C does not appear to be properly installed on"
$      Write sys$output "this system.  Will attempt to use VAX C."
$      Compiler = "VAXC"
$    Else
$     Compiler = "DECC"
$     Macro = Macro + "DECC=1,"
$    Endif
$  Else
$    If Platform .EQS. "Alpha"
$     Then
$      Write sys$output "Aborting because DEC C does not appear to be"
$      Write sys$output "installed on this system."
$      Goto The_End
$     Else Compiler = "VAXC"
$     Endif
$  Endif
$ Extras = P3
$ If F$GetJPI("","CLINAME") .EQS. "DCL_RECALL" Then Extras = Extras + "/CLI=DCL"
$ If (F$Locate("DEBUG",P1) .EQ. F$Length(P1)) .OR. -
	(F$Locate("NODEBUG",P1) .NE. F$Length(P1))
$  Then
$   COpt = "/Optim"
$   LOpt = "/NoTrace"
$   VMS_Extra = ""
$  Else
$   COpt = "/NoOptim/Debug"
$   LOpt = "/Debug"
$   VMS_Extra = "DEBUGVMS,"
$   Macro = Macro + "DEBUG=1,"
$   Work = "D" + Work
$  EndIf
$ If Compiler .EQS. "DECC"
$  Then
$   If (F$Locate("VAXC",Args) .EQ. F$Length(Args)) .OR. (Platform .NES "VAX")
$    Then
$     COpt_NoVAXC = "/DECC" + COpt
$     COpt = "/DECC/Standard=VAXC/PRECISION=SINGLE" + COpt
$    Else
$     Compiler = "VAXC"
$     COpt = "/VAXC/PRECISION=SINGLE" + COpt
$     COpt_NoVAXC = COpt
$     Macro = Macro - "DECC=1,"
$     Macro = Macro + "DECCVAXC=1,"
$    Endif
$  Else
$   COpt_NoVAXC = COpt + "/PRECISION=SINGLE"
$  Endif
$ If F$Locate("VAXC",Args) .NE. F$Length(Args) Then Macro = Macro - "VAXC,"
$ If Compiler .EQS. "VAXC" Then Work = Work + "C"
$!
$ If HOME_PAGE     .NES. "" Then VMS_Extra = VMS_Extra + QHOME_PAGE + ","
$ If PRINT_COMMAND .NES. "" Then VMS_Extra = VMS_Extra + QPRINT_COMMAND + ","
$ If MAIL_PREFIX   .NES. "" Then VMS_Extra = VMS_Extra + QMAIL_PREFIX + ","
$ If EDIT_COMMAND  .NES. "" Then VMS_Extra = VMS_Extra + QEDIT_COMMAND + ","
$!
$! Uncomment the following line(s) if your server does not have
$! 17 pt fonts and/or Lucida fonts
$! VMS_Extra = VMS_Extra + "NO_17_PT,"
$! VMS_Extra = VMS_Extra + "NO_LUCIDA,"
$!
$ If F$Locate("NO_17_PT",Args) .EQ. F$Length(Args)
$  Then
$   If F$Locate("17_PT",Args) .NE. F$Length(Args) Then VMS_Extra = -
     VMS_Extra - "NO_17_PT,"
$  EndIf
$!
$ If F$Locate("NO_LUCIDA",VMS_Extra) .EQ. F$Length(VMS_Extra)
$  Then
$   VMS_Version = F$edit(F$getsyi("Version"),"trim")
$   Major_version = F$extract(1,1,VMS_Version)
$   Minor_version = F$extract(3,1,VMS_Version)
$   If Major_version .LT. 6
$    Then VMS_Extra = VMS_Extra + "NO_LUCIDA,"
$    Else If (Major_version .EQ. 6) .AND. (Minor_version .LT. 1) Then -
	VMS_Extra = VMS_Extra + "NO_LUCIDA,"
$    Endif
$  Endif
$ If F$Locate("NO_LUCIDA",Args) .EQ. F$Length(Args)
$  Then
$   If F$Locate("LUCIDA",Args) .NE. F$Length(Args) Then VMS_Extra = -
     VMS_Extra - "NO_LUCIDA,"
$  EndIf
$!
$ If P2 .EQS. ""
$ Then
$  IP = "UCX"
$  If F$Trnlnm("MULTINET") .NES. ""
$   Then
$    IP = "MULTINET"
$    Goto ip_done
$   Endif
$  If (F$Trnlnm("TWG$TCP") .NES. "") .AND. (Platform .EQS. "VAX")
$   Then 
$    IP = "PATHWAY"
$    @[.twg]def.com      ! define the location of PathWay include files
$    Goto ip_done
$   EndIf
$  If F$Trnlnm("SOCKETSHR") .NES. ""
$   Then
$    IP = "SOCKETSHR"
$    Goto ip_done
$   EndIf
$ Else
$  IP = ""
$  IPX = F$Edit(P2,"UPCase")
$  If F$Locate("UCX",IPX) .NE. F$Length(IPX) Then IP ="UCX"
$  If F$Locate("MULTINET",IPX) .NE. F$Length(IPX) Then IP ="MULTINET"
$  If F$Locate("PATHWAY",IPX) .NE. F$Length(IPX) Then IP ="PATHWAY"
$  If F$Locate("SOCKETSHR",IPX) .NE. F$Length(IPX) Then IP ="SOCKETSHR"
$  If IP .EQS. ""
$   Then
$    Write sys$output "Invalid TCP/IP package specified in P2."
$    Write sys$output "Must be UCX, MULTINET, PATHWAY or SOCKETSHR."
$    Goto The_End
$   Endif
$ Endif
$Ip_done:
$ Macro = Macro + IP + "=1,"
$ If IP .EQS. "UCX" Then Work = Work + "U"
$ If IP .EQS. "MULTINET" Then Work = Work + "M"
$ If IP .EQS. "PATHWAY" Then Work = Work + "P"
$ If IP .EQS. "SOCKETSHR" Then Work = Work + "S"
$ Macro = Macro + "WORK=" + Work + ","
$!
$ If Compiler .EQS. "DECC"
$  Then
$   If IP .EQS. "MULTINET"
$    Then
$     COpt = COpt + "/PREFIX=ANSI"
$     COpt_NoVAXC = COpt_NoVAXC + "/PREFIX=ANSI"
$    Else
$     COpt = COpt + "/PREFIX=ALL"
$     COpt_NoVAXC = COpt_NoVAXC + "/PREFIX=ALL"
$    Endif
$  Endif
$!
$ If IP .EQS. "SOCKETSHR"
$  Then
$   Define Socketshr_Files -
     "''f$parse(f$trnlnm("SOCKETSHR"),,,"DEVICE")'''f$parse(f$trnlnm("SOCKETSHR"),,,"DIRECTORY")"
$   Write SYS$Output "Will look for the SOCKETSHR include files in the same"
$   Write SYS$Output "location as the SOCKETSHR shareable library."
$   Write SYS$Output " "
$  Endif
$!
$ Motif12 = ""
$ Motif123 = ""
$ If F$Search("SYS$Update:DECW$Get_Image_Version.COM") .NES. ""
$  Then
$   Set Symbol/Scope=(Global,Local)
$   @SYS$Update:DECW$Get_Image_Version SYS$Share:DECW$XLibshr.EXE DECW$Version 
$   If (F$Length(DECW$Version) .NE. 0) .AND. -
     (F$Locate("V1.2", DECW$Version) .NE. F$Length(DECW$Version))
$    Then
$     If (F$Locate("V1.2-3", DECW$Version) .NE. F$Length(DECW$Version)) .OR. -
      (F$Locate("V1.23", DECW$Version) .NE. F$Length(DECW$Version))
$      Then
$       Write SYS$Output "Your system has Motif 1.2-3 installed.  Due to a bug"
$       Write SYS$Output "in Motif 1.2-3, the hotlist dialog windows may act oddly."
$       Write SYS$Output " "
$       Motif123 = "MOTIF1_23,"
$      Endif
$      Macro = Macro + "MOTIF1_2=1,"
$      Motif12 = "MOTIF1_2,"
$    EndIf
$   Set Symbol/Scope=(NoGlobal,NoLocal)
$  Else
$   Write SYS$Output "You do not seem to have DECW Motif installed correctly!"
    Goto Err
$  EndIf
$!
$ If F$Trnlnm("XMU") .EQS. ""
$  Then
$   Write SYS$Output -
"You can not build Mosaic without the XMU auxilliary library. It comes as an"
"optional subset with DECWindows Motif, so you should install that now."
$   Goto Err
$  EndIf
$!
$ If F$Locate("NOMMS",Args) .NE. F$Length(Args) Then Goto No_mms
$ If F$Search("SYS$System:MMS.Exe") .NES. ""
$  Then
$   Command = "MMS"
$  Else 
$    If F$Search("MMK_DIR:MMK.Exe") .NES. ""
$     Then 
$      Macro = Macro + "USE_MMK=1,"
$      Command = "MMK"
$     Else
$      Write SYS$Output "Neither MMS or MMK appears to be available."
$      Write SYS$Output "Proceeding with complete (re)build."
$      Write SYS$Output " "
$      Goto No_mms
$     EndIf
$  EndIf
$!
$! Do MMS or MMK build
$!
$ Quals = Extras
$ If Macro .NES. "("
$  Then
$   Quals = Quals + "/Skip/Macro=" + Macro + ")"
$   Quals = Quals - ",)"
$   Quals = Quals + ")"
$  EndIf
$ Open/write config [.src]config.mms_'Work'
$! Modified ML  3-APR-1996 17:36:16.21
$ VMS_DEF1 = "VMS_DEF1 = " + VMS_Extra
$ Write/symbol config VMS_DEF1
$ VMS_DEF2 = "VMS_DEF2 = " + Motif123  + "HAVE_JPEG,HAVE_PNG,"
$ Write/symbol config VMS_DEF2
$ Delete/symbol VMS_DEF1
$ Delete/symbol VMS_DEF2
$! End ML mods
$ Close config 
$ Open/write config [.libwww2]config.mms_'Work'
$ If NEWSHOST .NES. "" then Write config "NEWSD = " + QNEWSHOST + ","
$ Close config 
$! MMS needs global symbols enabled
$ Set Symbol/Scope=(Global,NoLocal)
$! Define them before deleting to avoid warning messages
$ Multinet:==
$ Pathway:==
$ Socketshr:==
$ Delete/symbol/global Multinet
$ Delete/symbol/global Pathway
$ Delete/symbol/global Socketshr
$!
$! Run MMS or MMK now
$!
$ Write SYS$Output "''Command' will be invoked as ''Command'''Quals'"
$ If Command .EQS. "MMS"
$  Then MMS'Quals'
$  Else MMK'Quals'
$  EndIf
$ Goto The_End
$!
$No_mms:
$ If F$Locate("DEB",Args) .NE. F$Length(Args) Then Show Symbol/Local *
$ LibWAIS = ""
$ WAISD = ""
$ Verify = F$Verify(1)
$ If IP .NES. "WIN_TCP"
$  Then
$   If Compiler .EQS. "DECC"
$    Then
$     If Platform .EQS. "VAX" 
$      Then If F$Trnlnm("DECC$LIBRARY_INCLUDE") .NES. "" Then Define Sys DECC$Library_Include
$      Else If F$Trnlnm("ALPHA$LIBRARY") .NES. "" Then Define Sys Alpha$Library
$      Endif
$    Else Define Sys SYS$Library
$    Endif
$  Endif
$ If F$Locate("NOWAIS",Args) .NE. F$Length(Args) Then GoTo After_WAIS
$!
$! Create [.freeWAIS-0_5.ir]libWAIS.olb
$!
$ Set Default [.freeWAIS-0_5.ir]
$ If F$Search("libWAIS.olb") .EQS. "" Then Library/Create/Log libWAIS.olb
$ Comp = "CC" + COpt_NoVAXC + "/Define=''IP'"
$ 'Comp' cutil.c
$ 'Comp' futil.c
$ 'Comp' panic.c
$ 'Comp' ui.c
$ 'Comp' wmessage.c
$ 'Comp' wprot.c
$ 'Comp' wutil.c
$ 'Comp' zprot.c
$ 'Comp' ztype1.c
$ 'Comp' zutil.c
$ Library/Replace/Log libWAIS.olb *.obj
$ LibWAIS = ",[-.freeWAIS-0_5.ir]libWAIS.olb/Lib"
$ WAISD = "DIRECT_WAIS,"
$ Define WAIS_IR 'F$Environment("Default")'
$ Set Default [-.-]
$After_WAIS:
$!
$! Create [.libwww2]libwww.olb
$!
$ Set Default [.libwww2]
$ If F$Search("libwww.olb") .EQS. "" Then Library/Create/Log libwww.olb
$ Comp = "CC" + COpt + "/Define=(''WAISD'''IP')"
$ Compn = Comp
$ If NEWSHOST .NES. ""
$  Then
$   Compn = Comp - ")"
$   Compn = Compn + "," + QNEWSHOST + ")"
$  EndIf
$ 'Comp' HTAccess.c
$ 'Comp' HTAlert.c
$ 'Comp' HTAnchor.c
$ 'Comp' HTAtom.c
$ 'Comp' HTSort.c
$ 'Comp' HTChunk.c
$ 'Comp' HTFTP.c
$ 'Comp' HTFWriter
$ 'Comp' HTFile.c
$ 'Comp' HTFormat.c
$ 'Comp' HTGopher.c
$ 'Comp' HTInit.c
$ 'Comp' HTList.c
$ 'Comp' HTMIME.c
$ 'Comp' HTML.c
$ 'Comp' HTMLDTD.c
$ 'Comp' HTMLGen
$ 'Compn' HTNews.c
$ 'Comp' HTParse.c
$ 'Comp' HTPlain.c
$ 'Comp' HTMosaicHTML.c
$ 'Comp' HTString.c
$ 'Comp' HTTCP.c
$ 'Comp' HTTP.c
$ 'Comp' HTTelnet.c
$ If F$Locate("NOWAIS",Args) .EQ. F$Length(Args) Then 'Comp' HTWSRC.c
$ 'Comp' HTWriter.c
$ 'Comp' SGML.c
$ If F$Locate("NOWAIS",Args) .EQ. F$Length(Args)
$  Then
$   If Compiler .EQS. "DECC"
$    Then
$     Define DECC$User_Include 'F$Environment("Default")',WAIS_IR
$     Define DECC$System_Include 'F$Environment("Default")',WAIS_IR
$    Else
$     Define VAXC$Include 'F$Environment("Default")',WAIS_IR,SYS$Library
$     Define C$Include 'F$Environment("Default")',WAIS_IR
$    EndIf
$   'Comp' HTWAIS.c
$  EndIf
$ 'Comp' HTIcon.c
$ 'Comp' HTCompressed.c
$ 'Comp' HTAAUtil.c
$ 'Comp' HTAssoc.c
$ 'Comp' HTUU.c
$ 'Comp' HTAABrow.c
$ 'Comp' HTMailto.c
$ Library/Replace/Log libwww.olb *.obj
$!
$! Create [.libhtmlw]libhtmlw.olb
$!
$ Set Default [-.libhtmlw]
$ If F$Search("libhtmlw.olb") .EQS. "" Then Library/Create/Log libhtmlw.olb
$ Comp = "CC" + COpt + "/Define=(MOTIF,XMOSAIC,''Motif12'''IP')"
$ 'Comp' HTML.c
$ 'Comp' HTMLlists.c
$ 'Comp' HTMLformat.c
$ 'Comp' HTMLparse.c
$ 'Comp' HTMLimages.c
$ 'Comp' HTMLwidgets.c
$ 'Comp' HTML-PSformat.c
$ 'Comp' HTMLjot.c
$ 'Comp' HTMLtable.c
$ 'Comp' LIST.c
$ Library/Replace/Log libhtmlw.olb *.obj
$!
$! Create [.libxmx]libxmx.olb
$!
$ Set Default [-.libXmx]
$ If F$Search("libXmx.olb") .EQS. "" Then Library/Create/Log libXmx.olb
$ Comp = "CC" + COpt_NoVAXC + "/Define=(''Motif12'''IP')"
$ 'Comp' Xmx.c
$ 'Comp' Xmx2.c
$ Library/Replace/Log libXmx.olb *.obj
$!
$! Create [.libjpeg]libjpeg.olb
$!
$ Set Default [-.libjpeg]
$ @Makefile.com 'Macro'
$!
$! Create [.libnut]libnut.olb
$!
$ Set Default [-.libnut]
$ If F$Search("libnut.olb") .EQS. "" Then Library/Create/Log libnut.olb
$ Comp = "CC" + COpt_NoVAXC + "/Define=(''IP')"
$ 'Comp' mm.c
$ 'Comp' str-tools.c
$ 'Comp' system.c
$ 'Comp' url-utils.c
$ 'Comp' ellipsis.c
$ Library/Replace/Log libnut.olb *.obj
$!
$! Create [.libpng]libpng.olb
$!
$ Set Default [-.libpng]
$ If F$Search("libpng.olb") .EQS. "" Then Library/Create/Log libpng.olb
$ Comp = "CC" + COpt_NoVAXC + "/INCLUDE=[.ZLIB]"
$ 'Comp' png.c
$ 'Comp' pngrcb.c
$ 'Comp' pngrutil.c
$ 'Comp' pngtrans.c
$ 'Comp' pngwutil.c
$ 'Comp' pngread.c
$ 'Comp' pngmem.c
$ 'Comp' pngwrite.c
$ 'Comp' pngrtran.c
$ 'Comp' pngwtran.c
$ 'Comp' pngio.c
$ 'Comp' pngerror.c
$ Library/Replace/Log libpng.olb *.obj
$!
$! Create [.libpng.zlib]libz.olb
$!
$ Set Default [.zlib]
$ If F$Search("libz.olb") .EQS. "" Then Library/Create/Log libz.olb
$ Comp = "CC" + COpt_NoVAXC
$ 'Comp' adler32.c
$ 'Comp' compress.c
$ 'Comp' crc32.c
$ 'Comp' gzio.c
$ 'Comp' uncompr.c
$ 'Comp' deflate.c
$ 'Comp' trees.c
$ 'Comp' zutil.c
$ 'Comp' inflate.c
$ 'Comp' infblock.c
$ 'Comp' inftrees.c
$ 'Comp' infcodes.c
$ 'Comp' infutil.c
$ 'Comp' inffast.c
$ Library/Replace/Log libz.olb *.obj
$ Set Default [-]
$!
$! Compile the [.src] modules.
$!
$ Set Default [-.src]
$ Comp = "CC" + COpt + -
   "/Define=(" + VMS_Extra + Motif12 + Motif123 + IP + ",HAVE_JPEG,HAVE_PNG)"
$ If IP .NES. "WIN_TCP" Then Define Netinet SYS
$ Topdir = F$Environment("Default")-"SRC]"
$ Define LIBWWW2   'Topdir'LIBWWW2]
$ Define LIBXMX    'Topdir'LIBXMX]
$ Define LIBHTMLW  'Topdir'LIBHTMLW]
$ Define LIBJPEG   'Topdir'LIBJPEG]
$ Define LIBNUT    'Topdir'LIBNUT]
$ Define LIBPNG    'Topdir'LIBPNG]
$ Define ZLIB      'Topdir'LIBPNG.ZLIB]
$ If Compiler .EQS. "DECC"
$  Then
$   Define/nolog DECC$User_Include 'F$Environment("Default")', -
	LIBWWW2,LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
$   Define/nolog DECC$System_Include 'F$Environment("Default")', -
	LIBWWW2,LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
$  Else
$   Define/nolog VAXC$Include 'F$Environment("Default")', -
	LIBWWW2,LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS$Library
$   Define/nolog C$Include 'F$Environment("Default")', -
	LIBWWW2,LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS$Library
$  EndIf
$ 'Comp' main.c
$ 'Comp' gui.c
$ 'Comp' gui-dialogs.c
$ 'Comp' gui-menubar.c
$ 'Comp' gui-documents.c
$ 'Comp' mo-www.c
$ 'Comp' mo-dtm.c
$ 'Comp' hotlist.c
$ 'Comp' techsupport.c
$ 'Comp' history.c
$ 'Comp' annotate.c
$ 'Comp' pan.c
$ 'Comp' grpan.c
$ 'Comp' grpan-www.c
$ 'Comp' audan.c
$ 'Comp' globalhist.c
$ 'Comp' img.c
$ 'Comp' picread.c
$ 'Comp' xpmhash.c
$ 'Comp' xpmread.c
$ 'Comp' gifread.c
$ 'Comp' pixmaps.c
$ 'Comp' medcut.c
$ 'Comp' mo-hdf.c
$ 'Comp' accept.c
$ 'Comp' bla.c
$ 'Comp' ccibindings.c
$ 'Comp' ccibindings2.c
$ 'Comp' cciserver.c
$ 'Comp' comment.c
$ 'Comp' gui-news.c
$ 'Comp' hotfile.c
$ 'Comp' kcms.c
$ 'Comp' mailto.c
$ 'Comp' md5.c
$ 'Comp' readjpeg.c
$ 'Comp' support.c
$ 'Comp' proxy-dialogs.c
$ 'Comp' proxy-misc.c
$ 'Comp' child.c
$ 'Comp' gui-extras.c
$ 'Comp' readpng.c
$ 'Comp' gui-ftp.c
$ 'Comp' gui-popup.c
$ 'Comp' newsrc.c
$ 'Comp' prefs.c
$!
$! Finally link ...
$!
$ Optfile = "''IP'.Opt"
$ If IP .EQS. "UCX"
$  Then
$   Optfile = "UCX_VAX.Opt"
$   If Compiler .EQS. "DECC" Then Optfile = "UCX_ALPHA.Opt"
$  EndIf
$ XMOptfile = "Motif1_1.Opt"
$ If Motif12 .NES. "" Then XMOptfile = "Motif1_2.Opt"
$ Link'LOpt'/Exe=mosaic.exe main.obj,gui.obj,gui-dialogs.obj,gui-menubar.obj,-
   gui-documents.obj,mo-www.obj,mo-dtm.obj,hotlist.obj,techsupport.obj,history.obj,-
   annotate.obj,pan.obj,grpan.obj,grpan-www.obj,audan.obj,globalhist.obj,-
   img.obj,picread.obj,xpmhash.obj,xpmread.obj,gifread.obj,pixmaps.obj,-
   medcut.obj,mo-hdf.obj,accept.obj,bla.obj,ccibindings.obj,ccibindings2.obj,-
   cciserver.obj,comment.obj,gui-news.obj,hotfile.obj,kcms.obj,mailto.obj,-
   md5.obj,readjpeg.obj,support.obj,proxy-dialogs.obj,proxy-misc.obj,child.obj,-
   gui-extras.obj,readpng.obj,gui-ftp.obj,gui-popup.obj,newsrc.obj,-
   prefs.obj,[-.libhtmlw]libhtmlw.olb/Lib,-
   [-.libxmx]libxmx.olb/Lib,[-.libwww2]libwww.olb/Lib,-
   [-.libjpeg]libjpeg.olb/Lib'LibWAIS',[-.libnut]libnut.olb/Lib,-
   [-.libpng]libpng.olb/Lib,[-.libpng.zlib]libz.olb/Lib,-
   []'Optfile'/Opt,'XMOptfile'/Opt
$ xxx = F$Verify(Verify)
$ Write SYS$Output "Linking done.  Welcome to VMS Mosaic 2.7-4"
$ Set Default 'pwd'
$ Write SYS$Output "The executable is in [.src]Mosaic.exe"
$ Dir/Date=Modif/Size=All [.src]Mosaic.exe
$ Goto The_End
$EndY:
$ Write SYS$Output "Execution interrupted..."
$Err:
$The_End:
$ xxx = F$Verify(Verify)
$ If F$Trnlnm("SYS","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process SYS
$ If F$Trnlnm("NETINET","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process NETINET
$ If F$Trnlnm("LIBHTMLW","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBHTMLW
$ If F$Trnlnm("LIBWWW2","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBWWW2
$ If F$Trnlnm("LIBXMX","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBXMX
$ If F$Trnlnm("LIBJPEG","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBJPEG
$ If F$Trnlnm("LIBNUT","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBNUT
$ If F$Trnlnm("LIBPNG","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process LIBPNG
$ If F$Trnlnm("ZLIB","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process ZLIB
$ If F$Trnlnm("DECC$User_Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process DECC$User_Include
$ If F$Trnlnm("DECC$System_Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process DECC$System_Include
$ If F$Trnlnm("VAXC$Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process VAXC$Include
$ If F$Trnlnm("C$Include","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process C$Include
$ If F$Trnlnm("WAIS_IR","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process WAIS_IR
$ If F$Trnlnm("SOCKETSHR_FILES","LNM$PROCESS_TABLE") .NES. "" Then -
   Deassign/Process SOCKETSHR_FILES
$ Set Default 'pwd'
$ Exit
