! MMS description file for Mosaic
! Bjorn S. Nilsson, Aleph, CERN, 21-Nov-1993
! (Mosaic version 2.0)
! Motif 1.2 support added on 3-Jun-1994
! Mosaic 2.4 on 20-Aug-1994
! Mosaic 2.6 on 21-Oct-1995 by George Cook
!
! Usage:
!       $ MMS                           for DEC/UCX/VAXC
!       $ MMS/MACRO=(MULTINET=1)        for MultiNet
!       $ MMS/MACRO=(SOCKETSHR=1)       for SOCKETSHR  BGT
! Add a DEBUG=1  macro when debugging.
! Add a DECC=1   macro when compiling with DEC C.
! Add a NOWAIS=1 macro when excluding direct WAIS support
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!

.INCLUDE CONFIG.MMS_$(WORK)

WDIR = [.$(WORK)]

LIBTARGET = $(WDIR)src.olb

VMS_DEFS = $(VMS_DEF1)$(VMS_DEF2)

NAME = MOSAIC

.IFDEF NOWAIS
.ELSE
LIBWAIS = [-.freeWAIS-0_5.ir.$(WORK)]libWAIS.Olb
LIBWAISQ = ,$(LIBWAIS)/LIB
.ENDIF

.IFDEF DECC
.IFDEF PATHWAY
.INCLUDE [-.TWG]DECC_PREFIX_RULES.MMS		! GET OUR RULES
CQUALC=/DECC/Standard=VAXC $(CC_PREFIX_NO_SIN)
.ELSE
.IFDEF MULTINET
CQUALC=/DECC/Standard=VAXC/Prefix=ANSI
.ELSE
CQUALC=/DECC/Standard=VAXC
.ENDIF
.ENDIF
.ELSE	! VAX C
.IFDEF DECCVAXC
CQUALC=/VAXC
.ELSE
CQUALC=
.ENDIF
.ENDIF


.IFDEF MULTINET
CDEFS =/Define=($(VMS_DEFS)MULTINET)
OPTION_FILE = Multinet.Opt
TCP=MULTINET
.ELSE    ! Not MULTINET

.IFDEF PATHWAY
CDEFS =/Define=($(VMS_DEFS)WIN_TCP)
OPTION_FILE = PathWay.Opt
TCP=WIN_TCP
.ELSE  ! Not PATHWAY  BGT

.IFDEF SOCKETSHR ! BGT
CDEFS =/Define=($(VMS_DEFS)SOCKETSHR) ! BGT
OPTION_FILE = Socketshr.Opt ! BGT
TCP=SOCKETSHR ! BGT
.ELSE  ! Not SOCKETSHR, i.e. UCX  BGT

CDEFS =/Define=($(VMS_DEFS)UCX)
.IFDEF DECC
OPTION_FILE = UCX_ALPHA.Opt
.ELSE
OPTION_FILE = UCX_VAX.Opt
.ENDIF
TCP=UCX
.ENDIF

.ENDIF
.ENDIF


.IFDEF DEBUG
CFLAGS =$(CQUALC)$(CDEFS)/NoOpt/Debug
LOPTIONS =/Debug
.ELSE
CFLAGS =$(CQUALC)$(CDEFS)
LOPTIONS =/NoDebug/NoTrace
.ENDIF

.IFDEF MOTIF1_2
LIBS = $(OPTION_FILE)/Opt,Motif1_2.Opt/Opt
.ELSE
LIBS = $(OPTION_FILE)/Opt,Motif1_1.Opt/Opt
.ENDIF

.LAST
	@ Delete Config.mms_$(WORK);*
.FIRST
        @ If F$Search("$(LIBTARGET)") .EQS. "" Then Library/Create $(LIBTARGET)
	@ Define/NoLog Odir $(WDIR)
	@ Topdir = F$Environment("Default")-"SRC]"
	@ Define LIBWWW2  'Topdir'LIBWWW2]
	@ Define LIBXMX   'Topdir'LIBXMX]
	@ Define LIBHTMLW 'Topdir'LIBHTMLW]
	@ Define LIBJPEG  'Topdir'LIBJPEG]
	@ Define LIBNUT   'Topdir'LIBNUT]
	@ Define LIBPNG   'Topdir'LIBPNG]
	@ Define ZLIB     'Topdir'LIBPNG.ZLIB]
	@ Purge Config.mms_$(WORK)
.IFDEF PATHWAY
	@ @[-.TWG]DEF
.ELSE
	@ Define/NoLog Sys SYS$Library
.IFDEF DECC
.IFDEF ALPHA
	@ If F$TRNLNM("ALPHA$LIBRARY") .NES. "" Then Define/NoLog Sys Alpha$Library
.ELSE
	@ If F$TRNLNM("DECC$LIBRARY_INCLUDE") .NES. "" Then Define/NoLog Sys DECC$Library_Include
.ENDIF
.ENDIF
	@ Define Netinet SYS
.ENDIF
.IFDEF DECC
.IFDEF PATHWAY
	@ Define DECC$User_Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB
.ELSE
	@ Define DECC$User_Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
	@ Define DECC$SYSTEM_Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
.ENDIF
.ELSE	! VAX C compilation
.IFDEF PATHWAY
	@ Define C$Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB
.ELSE
	@ Define C$Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
	@ Define VAXC$Include 'F$Environment("Default")',LIBWWW2, -
					LIBHTMLW,LIBXMX,LIBJPEG,LIBPNG,ZLIB,SYS
.ENDIF
.ENDIF

PROG_LIBS = [-.LIBHTMLW.$(WORK)]LIBHTMLW.OLB [-.LIBXMX.$(WORK)]LIBXMX.OLB \
  [-.LIBWWW2.$(WORK)]LIBWWW.OLB [-.LIBJPEG.$(WORK)]LIBJPEG.OLB \
  [-.LIBNUT.$(WORK)]LIBNUT.OLB [-.LIBPNG.$(WORK)]LIBPNG.OLB \
  [-.LIBPNG.ZLIB.$(WORK)]LIBZ.OLB $(LIBWAIS)
PROG_LIBSQ = [-.LIBHTMLW.$(WORK)]LIBHTMLW.OLB/LIB,[-.LIBXMX.$(WORK)]LIBXMX.OLB/LIB,[-.LIBWWW2.$(WORK)]LIBWWW.OLB/LIB,[-.LIBJPEG.$(WORK)]LIBJPEG.OLB/LIB,[-.LIBNUT.$(WORK)]LIBNUT.OLB/LIB,[-.LIBPNG.$(WORK)]LIBPNG.OLB/LIB,[-.LIBPNG.ZLIB.$(WORK)]LIBZ.OLB/LIB$(LIBWAISQ)
 
OBJS = Odir:main.obj,Odir:gui.obj,Odir:gui-dialogs.obj,Odir:gui-menubar.obj,\
 Odir:gui-documents.obj,Odir:mo-www.obj,Odir:mo-dtm.obj,Odir:hotlist.obj,\
 Odir:techsupport.obj,Odir:history.obj,Odir:annotate.obj,Odir:pan.obj,Odir:grpan.obj,\
 Odir:grpan-www.obj,Odir:audan.obj,Odir:globalhist.obj,Odir:img.obj,\
 Odir:picread.obj,Odir:xpmhash.obj,Odir:xpmread.obj,Odir:gifread.obj,\
 Odir:pixmaps.obj,Odir:medcut.obj,Odir:mo-hdf.obj,Odir:accept.obj,Odir:bla.obj,\
 Odir:ccibindings.obj,Odir:ccibindings2.obj,Odir:cciserver.obj,Odir:child.obj,\
 Odir:comment.obj,Odir:gui-news.obj,Odir:hotfile.obj,Odir:kcms.obj,\
 Odir:mailto.obj,Odir:md5.obj,Odir:readjpeg.obj,Odir:support.obj,\
 Odir:proxy-dialogs.obj,Odir:proxy-misc.obj,Odir:gui-extras.obj,Odir:readpng.obj,\
 Odir:prefs.obj,Odir:newsrc.obj,Odir:gui-popup.obj,Odir:gui-ftp.obj

HFILES = mosaic.h

default : $(LIBTARGET) $(NAME).exe_$(WORK)
	@ Continue

$(NAME).exe_$(WORK) : $(LIBTARGET) $(PROG_LIBS)
    LINK$(LOPTIONS)/Exe=$(NAME).exe_$(WORK) $(LIBTARGET)/Lib/Inc=(main,mailto,md5),$(PROG_LIBSQ),[]$(LIBS)
    @ Write SYS$Output "Linking done.  Welcome to VMS Mosaic 2.7-4"

$(LIBTARGET) : $(LIBTARGET)($(OBJS))
        @ If F$Search("$(WDIR)work.mark") .NES. "" Then Delete $(WDIR)work.mark;*
        @ If F$Search("$(WDIR)work.done") .EQS. "" Then Copy Descrip.mms $(WDIR)work.done
	@ Write SYS$Output "Library src.olb built."

Odir:main.obj :          main.c             
Odir:gui.obj :           gui.c xresources.h proxy.h
Odir:gui-dialogs.obj :   gui-dialogs.c      
Odir:gui-menubar.obj :   gui-menubar.c      
Odir:gui-documents.obj : gui-documents.c    
Odir:mo-www.obj :        mo-www.c           
Odir:mo-dtm.obj :        mo-dtm.c           
Odir:hotlist.obj :       hotlist.c          
Odir:techsupport.obj :   techsupport.c            
Odir:history.obj :       history.c          
Odir:annotate.obj :      annotate.c         
Odir:pan.obj :           pan.c              
Odir:grpan.obj :         grpan.c            
Odir:grpan-www.obj :     grpan-www.c        
Odir:audan.obj :         audan.c            
Odir:globalhist.obj :    globalhist.c       
Odir:img.obj :           img.c              
Odir:picread.obj :       picread.c          
Odir:xpmhash.obj :       xpmhash.c          
Odir:xpmread.obj :       xpmread.c          
Odir:gifread.obj :       gifread.c          
Odir:pixmaps.obj :       pixmaps.c          
Odir:medcut.obj :        medcut.c           
Odir:mo-hdf.obj :        mo-hdf.c           
Odir:accept.obj :        accept.c           
Odir:bla.obj :           bla.c              
Odir:ccibindings.obj :   ccibindings.c      
Odir:ccibindings2.obj :  ccibindings2.c     
Odir:cciserver.obj :     cciserver.c
Odir:child.obj :         child.c
Odir:comment.obj :       comment.c comment.h
Odir:gui-news.obj :      gui-news.c         
Odir:hotfile.obj :       hotfile.c          
Odir:kcms.obj :          kcms.c             
Odir:mailto.obj :        mailto.c           
Odir:md5.obj :           md5.c              
Odir:readjpeg.obj :      readjpeg.c         
Odir:support.obj :       support.c          
Odir:proxy-dialogs.obj : proxy-dialogs.c proxy.h
Odir:proxy-misc.obj :    proxy-misc.c proxy.h
Odir:gui-extras.obj :    gui-extras.c       
Odir:readpng.obj :       readpng.c          
Odir:prefs.obj :         prefs.c
Odir:newsrc.obj :        newsrc.c
Odir:gui-popup.obj :     gui-popup.c
Odir:gui-ftp.obj :       gui-ftp.c

$(OBJS) : $(HFILES)

.c.obj :
	$(CC)$(CFLAGS)/OBJECT=$@ $<

.obj.olb :
	$(LIBR) $(LIBRFLAGS) $(MMS$TARGET) $(MMS$SOURCE)

clean :
	Delete/Log $(WDIR)*.OBJ;*
