 #define TRACE 0  #define TRACEOF 1  /* Glenn C. Everhart 1995 */ /*  *  Remote tape TCP server. B  *	This server is designed to run on unix and communicate with theD  *	cmdriver/cmhost/cmsubs combo on the VMS end to implement a remote@  *	magtape system. This system will not be multibuffered, and is>  *	present to give function, not superhigh speed. Data is sentC  *	pretty much a block at a time on the net, though buffers to tape @  *	are whatever either host wants. Interpretation of the magtape@  *	commands is done here. Note that a 10 longword header is sentC  *	in both directions which contains things like total buffer size, D  *	position of the tape (computed here), device status and the like.E  *	This information returns to the VMS driver to handle situations of "  *	screwed up tape and so forth...D  *	Where big buffers are sent, the first block plus the header go inD  *	the initial packet and enough 512 byte following packets are sentC  *	to move the full buffer. On receive the full buffer size must be F  *	extracted out of the first buffer and used to tell how many packetsD  *	to read. On send the full size on the medium should be sent sinceF  *	the VMS end doesn't in general know in advance how big tape records  *	are.   */    #include <sys/types.h> #include <sys/socket.h>  #include <netinet/in.h>  #include <stdio.h> #include <netdb.h> #include <sys/types.h> #include <sys/stat.h>  #include <unistd.h>  #include <fcntl.h> #include <sys/mtio.h>  #include "mtdef.h" #include "iodef.h" #include <sys/ioctl.h> #include <string.h>  #include <sys/devio.h>   /* implicit inputs: N port SERVER_PORT is the port we use for net operations (we sit there listening) till a connect is made by the other end).   F /dev/vmstape  is the tape device we will use. (Later we'll fix this so  	the tape device name can vary.) */  < /* ultimately let the port be given in some variable way. */ #define SERVER_PORT 800 % static int server_port = SERVER_PORT; . static char tapedevice[80] = "/dev/vmstape\0"; 	unsigned short s; 	int n, Status;          int sockfd;          int newsockfd;         static char buf[65600];  	struct sockaddr_in sin;&         struct sockaddr_in serveraddr;         struct hostent *he; +         struct sockaddr_in      clientaddr; C         int                     clientaddrlen = sizeof(clientaddr);          struct hostent *hp;          struct stat *buffer;"         int *bufp, *bufp2, *bufp3;         char *bufcp;         struct stat sbuf;  	struct mtop mymtio; 	struct mtget mymtget; 	struct devget mydevget; 	int buffunc,opcnt,k;          int iosb[2];         int vfild; 	unsigned fcode,fmodif; % #include "cmns.h"	/* includes IOSB */    #include "iodef.h" #include "mtdef.h" #include "ssdef.h"  9 #define ErEmit(m) do {fprintf(stderr,"%s\n",m);} while(0) A #define CHECKX(x) do {unsigned s=x; if(!(s&1)) exit(1);} while(0) , #define MINIMUM(a,b) ((a) < (b)) ? (a) : (b)   typedef struct VMS_ITEM {  	unsigned short size;  	unsigned short code;  	void *bufp; 	unsigned short *lenp; } VMS_ITEM;      /***** tape data *****/  static IOSB t_iosb;  static short t_chan;& static unsigned char t_buffer[0xFFFF];  K static unsigned short ti_iofunc = 0;	/* request function, !=0 while busy */ * static int ti_count;			/* request count */  > static unsigned char *ti_datap = NULL;	/* input 'DMA' pointer,$ 						==NULL unless data expected */5 static int ti_datacnt = 0;		/* input 'DMA' counter */   = static int/*logical*/ ti_replyexp = 0;	/* IOREPLY expected */ 9 static unsigned short ti_replysts;	/* status from same */    /***** network data *****/ static short n_chan;   	/* CM -> NS */  static IOSB ni_iosb; static CMNS_MSG ni_buf;  static CMNS_MSG ni_buf2; static int ni_seq = 1;   	/* NS -> CM (our output) */ static IOSB no_iosb; static CMNS_MSG no_buf;  static int no_seq = 1;     /*****/  /* Forward function defs */ N static void tap_read_wchk(int wchk);	/* wchk==0: read, possibly w/datacheck */@ static void tap_invfun();	/* unsupported function or modifier */? static void tap_skiprec();	/* skip records, forward/backward */ : static void tap_write();	/* write, possibly w/datacheck */1 static unsigned CMns();		/* the action routine */ : static void net_read();	/* here when we receive net msg */ main(int argc, char *argv[]);  /* pass 2 args in here: 
   Port number    Path to physical tape */   static void net_send(fct)  int fct;	/* CMNS_F_xxxx */ {    int cntchk, kkk, mybc;   int curbc,curloc,bcnt;   char * curptr;K   cntchk = ((fct == CMNS_F_DATA) ? (CMNS_LEN1 + no_buf.count) : CMNS_LEN1);    if (cntchk < CMNS_LEN1){?     fprintf(stderr," Short writecnt, nocnt=%d\n",no_buf.count); )     fprintf(stderr," fct seen=%d\n",fct);    }  	no_buf.seq = no_seq++;  	no_buf.func = fct; .         if (no_buf.count < 0)no_buf.count = 0;H 	bcnt = ((fct == CMNS_F_DATA) ? (CMNS_LEN1 + no_buf.count) : CMNS_LEN1);	 #if TRACE 7   fprintf(stderr,"net_send sending %d bytes\n",cntchk);  #endif!           kkk = send(s, &no_buf,  B 	  ((fct == CMNS_F_DATA) ? (CMNS_LEN1 + no_buf.count) : CMNS_LEN1) 	  );            no_iosb.count = kkk; 	  no_iosb.status = 1;	 #if TRACE 1   fprintf(stderr,"net send sent %d bytes\n",kkk);  #endif }      static void net_start()  { /         int sizes[4],kk,kkk,kkkk,nbyts,nbytnow; (         int netblk,nettrk,netsct,netcyl;  F /* This server will generate its own tcp/ip sockets on osf/1 so it canH  * just be run in debug to find out how to get it working. Later another(  * can be built to be called from inetd.  */          buffer = &sbuf; 9    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)  {        exit(1);    }@         bzero((char *) &serveraddr, sizeof(struct sockaddr_in));0            serveraddr.sin_family      = AF_INET;7         serveraddr.sin_addr.s_addr = htonl(INADDR_ANY); 8         serveraddr.sin_port        = htons(server_port);@         /* Bind the address to this socket to make it 'known' */            if ( bind(sockfd,  4                     (struct sockaddr *)&serveraddr, * 		     sizeof(struct sockaddr_in)) < 0)  {' 	                perror("socket_bind");  			exit(2);  		     }           listen(sockfd,1); H           s = accept(sockfd, (struct sockaddr *) &sin, &clientaddrlen); 
         /*= 	 *  Use getpeername() to find out who made the connection to I 	 *  us, so we can act exactly like the example tcpechoserver-standalone.  	 */  1 /*	n = sizeof(sin);*/	   /* Pass in the length */ ( /*	if (getpeername(s, &sin, &n) < 0) {*/3 /*		socket_perror("tcpechoserver: getpeername"); */  /*		exit(0x10000000);  	} */ 	/* 9 	 *  `sin' will be a sockaddr_in structure describing the 8 	 *  remote IP address (and port #) which the connection9 	 *  was made from. Before we start to echo data, write a 2 	 *  string into the network describing this port. 	 */         if (s < 0)           exit(3);  B 	hp = gethostbyaddr(&sin.sin_addr, sizeof(sin.sin_addr), AF_INET);
 	if (hp) { 	    /* < 	     *	We found a corresponding hostname, format the string 	     *	one way... 	     */; /*	    sprintf(buf, "Connection received from %s [%s]\r\n", . 		    hp->h_name, inet_ntoa(sin.sin_addr)); */	 	} else {  	    /* ? 	     *	This host not in the host tables or Domain Name Server.  	     */8 /*	    sprintf(buf, "Connection received from [%s]\r\n"," 		    inet_ntoa(sin.sin_addr)); */ 	}  A /* On startup we must find our device and return its geometry. */ B /* Assume for now that the server device is hardwired here to be a  * link to "/dev/vmstape"   */ ,         vfild = open(&tapedevice[0],O_RDWR);         if (vfild <= 0) return; $         stat(&tapedevice[0],buffer); /* rewind the tape initially */  	  mymtio.mt_op = MTCSE; 	  mymtio.mt_count = 1; : 	  ioctl(vfild, MTIOCTOP, &mymtio); /* do the operation */ 	  mymtio.mt_op = MTENAEOT;  	  mymtio.mt_count = 1; : 	  ioctl(vfild, MTIOCTOP, &mymtio); /* do the operation */ 	  mymtio.mt_op = MTREW; 	  mymtio.mt_count = 1; : 	  ioctl(vfild, MTIOCTOP, &mymtio); /* do the operation */ 	  t_iosb.status = 1;  	  t_iosb.devdep = MT$M_BOT; /* start net reading */  	  net_read(); /* check & dispatch function */ 9 /* Do it here first time through.  Later do in a loop. */ ! 		fcode = ti_iofunc & IO$M_FCODE; ' 		fmodif = ti_iofunc & IO$M_FMODIFIERS;  		switch(fcode) {   ( 		  case IO$_WRITEOF:	/* no modifiers */ 			if(fmodif != 0) { 				tap_invfun();  			} else {  		  mymtio.mt_op = MTWEOF; 		  mymtio.mt_count = 1;A 		  kkk = ioctl(vfild, MTIOCTOP, &mymtio); /* do the operation */  		  t_iosb.status = 1; 		  t_iosb.devdep = 0; 		  if (kkk < 0){  			t_iosb.status = 2;  		  }  			}	 			break;   & 		  case IO$_REWIND:	/* mod: NOWAIT */) 		  case IO$_REWINDOFF:	/* mod: NOWAIT */ % 			if((fmodif & ~IO$M_NOWAIT) != 0) {  				tap_invfun();  			} else { F /* Clear serious exception condition in case we got to physical EOT */ 		  mymtio.mt_op = MTCSE;  		  mymtio.mt_count = 1;A 		  kkk = ioctl(vfild, MTIOCTOP, &mymtio); /* do the operation */  		  mymtio.mt_op = MTREW;  		  mymtio.mt_count = 1;A 		  kkk = ioctl(vfild, MTIOCTOP, &mymtio); /* do the operation */  		  t_iosb.status = 1; 		  t_iosb.devdep = MT$M_BOT;  		  if (kkk < 0){  			t_iosb.status = 2;  			t_iosb.devdep = MT$M_LOST;  		  }  			}	 			break;   + 		  case IO$_SKIPRECORD:	/* no modifiers */  			if(fmodif != 0) { 				tap_invfun();  			} else {  				tap_skiprec(); 			}	 			break;   + 		  case IO$_READLBLK:	/* mod: datacheck */ , 					/* note: datacheck is not end-to-end */( 			if((fmodif & ~IO$M_DATACHECK) != 0) { 				tap_invfun();  			} else {  				tap_read_wchk(0);  			}	 			break;   , 		  case IO$_WRITELBLK:	/* mod: datacheck */, 					/* note: datacheck is not end-to-end */( 			if((fmodif & ~IO$M_DATACHECK) != 0) { 				tap_invfun();  			} else {  				tap_write(); 			}	 			break;   + 		  case IO$_WRITECHECK:	/* no modifiers */ ! 					/* note: this PHYSICAL I/O,  % 					simulated as end-to-end check */  			if(fmodif != 0) { 				tap_invfun();  			} else {  				tap_read_wchk(1);  			}	 			break;    		  default: 			tap_invfun(); 		}    /* fudge */ $ 		if(t_iosb.status == SS$_VOLINV) {	( 			/* 'real' VALID bit apparently clear,! 			/* since we can't change that, 2 			/* say MEDOFL (manual intervention required) */ 			t_iosb.status = SS$_MEDOFL; 		}    /* say we're done */ 		ti_iofunc = 0;   /* return result from t_iosb */  		no_buf.iosb = t_iosb;  		net_send(CMNS_F_IOREPLY);  }     9 static void net_read()	/* here when we receive net msg */  {  int icontinue;
 int iosbbusy; 0 /* Make it an infinite loop here, not an AST. */ 	icontinue = 1;  	while (icontinue == 1){	 #if TRACE -   fprintf(stderr,"net recv receiving msg\n");  #endif/           n = recv(s, &ni_buf, sizeof(ni_buf));  	  iosbbusy = n; 	  if(iosbbusy != 0){            ni_iosb.count = n;	 #if TRACE 3   fprintf(stderr,"net recv received %d bytes\n",n);  #endif 	  ni_iosb.status = 1;! 	  if (n < 0) ni_iosb.status = 8;  /* check seq# */b 	if(ni_buf.seq != ni_seq++) fprintf(stderr,"prot.error: iseq %d ni_seq++:%d\n",ni_buf.seq,ni_seq);   /* check minimum length */C 	if(ni_iosb.count < CMNS_LEN1) ErEmit("prot.error: msg too short");     /* process low level function */ 	switch(ni_buf.func) { 	  default:  		icontinue = 0;; 		fprintf(stderr,"prot.error: bad func1:%d\n",ni_buf.func); 	 		return;    	  case CMNS_F_IOREPLY:  		if(ti_replyexp == 0) {, 			ErEmit("prot.error: unexpected IOREPLY"); 		}  		ti_replyexp = 0;# 		ti_replysts = ni_buf.iosb.status;  		icontinue = 0; 		break;   	  case CMNS_F_IOREQ: + 		if(ti_iofunc != 0) {	/* still busy ... */ * 			ErEmit("prot.error: unexpected IOREQ"); 		}  		ti_iofunc = ni_buf.iofunc; 		ti_count = ni_buf.count; 		icontinue = 0; 		break;   	  case CMNS_F_DATA: 		if(ti_datap == NULL) {) 			ErEmit("prot.error: unexpected DATA");  		} 1 		if(ni_iosb.count != CMNS_LEN1 + ni_buf.count) { \ 			fprintf(stderr,"prot.error: bad DATA msg length:%d buf:%d\n",ni_iosb.count,ni_buf.count); 		} ! 		if(ni_buf.count > ti_datacnt) { ' 			ErEmit("prot.error: too much data");  		}   , 		memcpy(ti_datap,ni_buf.data,ni_buf.count); 		ti_datacnt -= ni_buf.count;  		ti_datap += ni_buf.count;   4 		if(ti_datacnt == 0) {	/* data transfer complete */ 			ti_datap = NULL;  			icontinue = 0;  		}else{, /* Issue a synchronizing send if not done */	 #if TRACE 0   fprintf(stderr,"net_read sending 20 bytes\n"); #endif-           	  n = send(s, &ni_buf, CMNS_LEN1); 	 #if TRACE -   fprintf(stderr,"net_read sent 20 bytes\n");  #endif 		}  		break; 	}   /* wait for next msg */  	  } 	} }      /*****/   ? static void tap_invfun()	/* unsupported function or modifier */  {  	t_iosb.status = SS$_ILLIOFUNC;  	t_iosb.count = 0; 	/* leave devdep! */ }     > static void tap_skiprec()	/* skip records, forward/backward */ { 
   int kkk; 			mymtio.mt_op=MTFSR; 			mymtio.mt_count = ti_count; 			if (ti_count < 0){  			  mymtio.mt_op = MTBSR;" 			  mymtio.mt_count = - ti_count; 			}) 			kkk = ioctl(vfild, MTIOCTOP, &mymtio); ! 			if(kkk != 0)t_iosb.status = 1; - 			if(kkk == 0)t_iosb.status = SS$_ENDOFFILE;  		  t_iosb.status = 1; 		  t_iosb.devdep = 0; 		  if (kkk < 0){ ! 			t_iosb.status = SS$_ENDOFFILE;  			t_iosb.devdep = MT$M_EOF;+ 		  kkk = ioctl(vfild, MTIOCGET, &mymtget);  #if TRACEOF O          if (kkk < 0)fprintf(stderr,"skiprec iocgetioctl err, errno=%d\n",kkk);  #endif0 		    if ((mymtget.mt_dsreg & DEV_TPMARK) != 0){ 			t_iosb.devdep = MT$M_EOF;! 			t_iosb.status = SS$_ENDOFFILE;  #if TRACEOF ,   fprintf(stderr,"EOF mark seen in skip\n"); #endif 			}- 		    if ((mymtget.mt_dsreg & DEV_EOM) != 0){ . /* if we got EOM we better clear exception. */ 			 mymtio.mt_op=MTCSE;  			 mymtio.mt_count = 0;$ 			 ioctl(vfild, MTIOCTOP, &mymtio); 			 t_iosb.devdep = MT$M_EOT; " 			 t_iosb.status = SS$_ENDOFTAPE; 		    } Y 		    if (ti_count < 0 && ((mymtget.mt_dsreg & DEV_BOM) != 0))  t_iosb.devdep = MT$M_BOT; j 		    if ((mymtget.mt_dsreg & DEV_HARDERR) != 0){ t_iosb.devdep = MT$M_PARITY;t_iosb.status = SS$_PARITY;}y 		    if ((mymtget.mt_dsreg & DEV_OFFLINE) != 0){ t_iosb.devdep = MT$M_SEREXCP | MT$M_LOST;t_iosb.status=SS$_DEVOFFLINE;}  		  }   + /* must undo "end-of-volume" recognition */ ) /*	if(t_iosb.status == SS$_ENDOFVOLUME) {  		} */ 		t_iosb.count = 1;  /*	}*/ }     I static void tap_read_wchk(wchk)	/* wchk==0: read, possibly w/datacheck */ 1   int wchk;			/* wchk==1: simulated writecheck */  {    int kkk, icnt, kkkkk;          t_iosb.status = 1;.         icnt = read(vfild, t_buffer,ti_count); 	t_iosb.count = icnt;          kkk = icnt;  		  t_iosb.status = 1; 		  t_iosb.devdep = 0; 		  if (kkk <= 0){! 			t_iosb.status = SS$_ENDOFFILE;  			t_iosb.devdep = MT$M_EOF;+ 		  kkk = ioctl(vfild, MTIOCGET, &mymtget);  #if TRACEOF O          if (kkk < 0)fprintf(stderr,"tapread iocgetioctl err, errno=%d\n",kkk);  #endif0 		    if ((mymtget.mt_dsreg & DEV_TPMARK) != 0){ 			t_iosb.devdep = MT$M_EOF;! 			t_iosb.status = SS$_ENDOFFILE;  #if TRACEOF ,   fprintf(stderr,"EOF mark seen in read\n"); #endif 			}- 		    if ((mymtget.mt_dsreg & DEV_EOM) != 0){ . /* if we got EOM we better clear exception. */ 			 mymtio.mt_op=MTCSE;  			 mymtio.mt_count = 0;$ 			 ioctl(vfild, MTIOCTOP, &mymtio); 			 t_iosb.devdep = MT$M_EOT; " 			 t_iosb.status = SS$_ENDOFTAPE; 		    } h 		    if ((mymtget.mt_dsreg & DEV_HARDERR) != 0){ t_iosb.devdep = MT$M_PARITY;t_iosb.status=SS$_PARITY;}y 		    if ((mymtget.mt_dsreg & DEV_OFFLINE) != 0){ t_iosb.devdep = MT$M_SEREXCP | MT$M_LOST;t_iosb.status=SS$_DEVOFFLINE;}  		  }  	if(t_iosb.count > 0) { 
 		int bcnt,c;  		unsigned char *bpt;   7 		no_buf.count = bcnt = MINIMUM(t_iosb.count,ti_count); 	 #if TRACE C    fprintf(stderr," calling net_send from tap_read_wchk, setup\n");  #endif1 		net_send(wchk ? CMNS_F_C_DATA : CMNS_F_R_DATA);  		bpt = t_buffer; 	 #if TRACE :    fprintf(stderr," read after tap_read setup started\n"); #endif 		recv(s,&ni_buf2,20);	 #if TRACE 7    fprintf(stderr," read after tap_read setup done\n");  #endif 		do {1 			no_buf.count = c = MINIMUM(bcnt,CMNS_DATALEN); 
 			bcnt -= c;  			memcpy(no_buf.data,bpt,c);  			bpt += c;% 			if(bcnt == 0) {	/* last message */  				ti_replyexp = 1; 			}	 #if TRACE B    fprintf(stderr," calling net_send from tap_read_wchk, data\n"); #endif 			net_send(CMNS_F_DATA); % /* Add net synchronizing read here */ 	 #if TRACE >    if (bcnt > 0)fprintf(stderr," recv run for tap_read op\n"); #endif 			kkkkk = c + CMNS_LEN1; ( 			if(bcnt > 0)recv(s, &ni_buf2, kkkkk); 		} while(bcnt > 0);" /* now writecheck might be done */	 #if TRACE :   fprintf(stderr,"Calling net_read from tap_read_wchk\n"); #endif 		net_read();   5 		if(wchk) {	/* CMP may have error = SS$_DATACHECK */  			if((ti_replysts & 1) == 0) {   				t_iosb.status = ti_replysts; 			}! 		} else {	/* GET must be o.k. */  			CHECKX(ti_replysts);  		}  	} }     : static void tap_write()		/* write, possibly w/datacheck */ { 
   int kkk; 	if(ti_count > 0) { ' 		no_buf.count = ti_datacnt = ti_count;  		ti_datap = t_buffer;	 #if TRACE 8    fprintf(stderr," calling net_send from tap_write\n"); #endif 		   net_send(CMNS_F_W_DATA); 	 #if TRACE 6   fprintf(stderr,"Calling net_read from tap_write\n"); #endif
 		net_read();  	}  9                  kkk  = write(vfild, t_buffer, ti_count);  		 t_iosb.count = kkk; 		 t_iosb.status = 1; . 		 if (kkk < 0) t_iosb.status = SS$_ENDOFTAPE; 		  t_iosb.status = 1; 		  t_iosb.devdep = 0; 		  if (kkk < 0){ ! 			t_iosb.status = SS$_ENDOFTAPE;  			t_iosb.devdep = MT$M_EOF;+ 		  kkk = ioctl(vfild, MTIOCGET, &mymtget); 0 		    if ((mymtget.mt_dsreg & DEV_TPMARK) != 0){ 			t_iosb.devdep = MT$M_EOF;! 			t_iosb.status = SS$_ENDOFFILE;  #if TRACEOF 2   fprintf(stderr,"EOF mark seen in write (??)\n"); #endif    			} - 		    if ((mymtget.mt_dsreg & DEV_EOM) != 0){ . /* if we got EOM we better clear exception. */ 			 mymtio.mt_op=MTCSE;  			 mymtio.mt_count = 0;$ 			 ioctl(vfild, MTIOCTOP, &mymtio); 			 t_iosb.devdep = MT$M_EOT; " 			 t_iosb.status = SS$_ENDOFTAPE; 		    } h 		    if ((mymtget.mt_dsreg & DEV_HARDERR) != 0){ t_iosb.devdep = MT$M_PARITY;t_iosb.status=SS$_PARITY;}y 		    if ((mymtget.mt_dsreg & DEV_OFFLINE) != 0){ t_iosb.devdep = MT$M_SEREXCP | MT$M_LOST;t_iosb.status=SS$_DEVOFFLINE;}  		  }  }     0 static unsigned CMns()		/* the action routine */ {  	int/*logical*/ ok = 1;          int kkk;   	while(ok) {    /* sleep waiting for function */	 #if TRACE =   fprintf(stderr,"Calling net_read from cmns (main loop)\n");  #endif
 		net_read();  /* check & dispatch function */ ! 		fcode = ti_iofunc & IO$M_FCODE; ' 		fmodif = ti_iofunc & IO$M_FMODIFIERS;  		switch(fcode) {   ( 		  case IO$_WRITEOF:	/* no modifiers */ 			if(fmodif != 0) { 				tap_invfun();  			} else {  		  mymtio.mt_op = MTWEOF; 		  mymtio.mt_count = 1;A 		  kkk = ioctl(vfild, MTIOCTOP, &mymtio); /* do the operation */  		  t_iosb.status = 1; 		  t_iosb.devdep = 0; 		  if (kkk < 0){  			t_iosb.status = 2;  		  }  			}	 			break;   & 		  case IO$_REWIND:	/* mod: NOWAIT */) 		  case IO$_REWINDOFF:	/* mod: NOWAIT */ % 			if((fmodif & ~IO$M_NOWAIT) != 0) {  				tap_invfun();  			} else {  		  mymtio.mt_op = MTREW;  		  mymtio.mt_count = 1;A 		  kkk = ioctl(vfild, MTIOCTOP, &mymtio); /* do the operation */  		  t_iosb.status = 1; 		  t_iosb.devdep = MT$M_BOT;  		  if (kkk < 0){  			t_iosb.status = 2;  			t_iosb.devdep = MT$M_LOST;  		  }  			}	 			break;   + 		  case IO$_SKIPRECORD:	/* no modifiers */  			if(fmodif != 0) { 				tap_invfun();  			} else {  				tap_skiprec(); 			}	 			break;   + 		  case IO$_READLBLK:	/* mod: datacheck */ , 					/* note: datacheck is not end-to-end */( 			if((fmodif & ~IO$M_DATACHECK) != 0) { 				tap_invfun();  			} else {  				tap_read_wchk(0);  			}	 			break;   , 		  case IO$_WRITELBLK:	/* mod: datacheck */, 					/* note: datacheck is not end-to-end */( 			if((fmodif & ~IO$M_DATACHECK) != 0) { 				tap_invfun();  			} else {  				tap_write(); 			}	 			break;   + 		  case IO$_WRITECHECK:	/* no modifiers */ ! 					/* note: this PHYSICAL I/O,  % 					simulated as end-to-end check */  			if(fmodif != 0) { 				tap_invfun();  			} else {  				tap_read_wchk(1);  			}	 			break;    		  default: 			tap_invfun(); 		}    /* fudge */ $ 		if(t_iosb.status == SS$_VOLINV) {	( 			/* 'real' VALID bit apparently clear,! 			/* since we can't change that, 2 			/* say MEDOFL (manual intervention required) */ 			t_iosb.status = SS$_MEDOFL; 		}    /* say we're done */ 		ti_iofunc = 0;   /* return result from t_iosb */  		no_buf.iosb = t_iosb; 	 #if TRACE ?    fprintf(stderr," calling net_send from cmns for ioreply\n");  #endif 		net_send(CMNS_F_IOREPLY);  	}   	return 1;	/* not reached */ }    		 /*****/ ) /*  static int server_port = SERVER_PORT; 1     static char tapedevice[80] = "/dev/vms\0"; */    main(argc, argv)   int argc;    char *argv[];    { 
   char *s;   int c,kk,kkk,kkkk;   /* Get port and path */  	kk = 0; 	while (--argc > 0 ){  	  if(kk == 0){  	    kkk = atoi(argv[1]); 4 	    if (kkk > 100 && kkk < 8000) server_port = kkk;
 	    kk++;           }else if (kk == 1){ ! 	    /* copy pathname if legal */              kk++; ( 	    strncpy(&tapedevice[0],argv[2],79); 	    tapedevice[80] = 0; 	  } 	}  
 	net_start();    /* do our work ... */    	CMns();
    return; } 