 /*+   *  NAME,  *	cmap_utils --  check_map output utilities  *  *  DESCRIPTION <  *	These routines handle the output report for the check_mapB  *	software, taking advantage of the simple C formatting routines.  *  *&  *	There are  routines in this module:  *		strcpy_D  *		print_undefined_symbols   *		print_psect_data  *		print_psect_module_data   *		open_ouput_file   *		close_output_file   *  *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88		Bauer			Initial implementation. -*/    #include stdio #include descrip #include "sysdefs:stcdefs"  
 /***********/ 
 /* Globals */ 
 /***********/ 5 FILE	*output_fp;								/* Output file pointer 				*/        /*+   *  NAME9  *	strcpy_D --  copy descriptor string to normal C string   *  *  DESCRIPTION *  *	Copies a descriptor string to a normal ,  * 	C string - adds a NULL to the C string 	  *  *  RETURN VALUE  *  *  HISTORY +  *	3/28/88		Bauer			Initial implementation.  -*/ & PROC strcpy_D (into_string, from_D)			  6 char			into_string[];						/* Destination string				*/; struct dsc$descriptor 	*from_D;						/* Source string				*/    BEGIN    	strncpy(into_string,							 		from_D->dsc$a_pointer, 		from_D->dsc$w_length ); * 	into_string[from_D->dsc$w_length] = NULL;   END      /*+   *  NAME=  *	print_undefined_symbols --  prints undefined symbols table   *  *  DESCRIPTION 1  *	This routine prints list of undefined symbols    *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88			Bauer		Initial implementation. -*/ C PROC print_undefined_symbols ( symbol_number, sym_D, mod_D, fil_D )   7 int			symbol_number;						/* Numbered output list				*/ . struct dsc$descriptor 	*sym_D, *mod_D, *fil_D;   BEGIN K 	char 	sym[50], mod[25], fil[100];					/* Temporary C string variables			*/ W 	static  BOOLEAN first_print = TRUE;					/* Used for printing table header only once	*/ S         static  int old_symbol_number = 0;					/* Used to make table look clean		*/  	 ; 	if (first_print)							/* Print the header just once!			*/  	BEGIN 		fprintf (output_fp, & 			 "\n\nUndefined             In\n"); 		fprintf (output_fp, R                               "Symbol Name         Module                File\n"); 		fprintf (output_fp, f 			      "-----------         ------------          ---------------------------------------------\n"); 		first_print = FALSE; 	END  O 	strcpy_D (sym, sym_D);							/* Store symbol, module, and file data into C 	*/ H 	strcpy_D (mod, mod_D);							/* strings to simplify output routines		*/ 	strcpy_D (fil, fil_D);   _ 	if (old_symbol_number != symbol_number)					/* Do wee need to print the symbol name or not?	*/  	{ 		fprintf(output_fp, 			"%-20s%-22s%s\n", 			sym, mod, fil);	 $ 		old_symbol_number = symbol_number; 	} 	else  		fprintf(output_fp, 			"%-20s%-22s%s\n", 			" ", mod, fil);	    END      /*+   *  NAME3  *	print_psect_data --  dumps psect report section    *  *  DESCRIPTION 8  *	This routine prints the header to a psect section of /  * 	the output report with the PSECT name line.   *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88			Bauer		Initial implementation. -*/ 2 PROC print_psect_data ( name_D, base_D, length_D )  2 struct dsc$descriptor *name_D, *base_D, *length_D;   BEGIN  	char	name[50],  		base[10], 
 		length[10];    	strcpy_D (name, name_D);  	strcpy_D (base, base_D);  	strcpy_D (length, length_D);    	fprintf(output_fp, ] "\n\nPsect Name        Module Name             Base Address             Length      File\n");    	fprintf(output_fp, w     "----------        ------------------      ------------             --------    ------------------------------\n");    	fprintf(output_fp,  		"%-18s%-22s%-25s%-12s%s\n",  		name,  		"",  		base, 
 		length,  		""); END      /*+   *  NAME7  *	print_psect_module_data --  dumps psect module line    *  *  DESCRIPTION 4  *	This routine prints the module psect information.  *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88			Bauer		Initial implementation. -*/ O PROC print_psect_module_data ( name_D, base_D, length_D, file_D, error_status )   ; struct dsc$descriptor *name_D, *base_D, *length_D, *file_D;  int 	error_status;   BEGIN  	char	name[50],  		base[10], 
 		length[12],  		file[100]; /*  A 	These are not used but are indicies into the formats array below  */ #define			NO_ERRORS		0 #define			BASE_ERROR		1  #define			LENGTH_ERROR		2  #define			BOTH_ERRORS		3) 										/* Output line formats ...			*/ R 	char 	*formats[] = {	"%-18s%-24s%-25s%-12s%s\n",			/* No errors on this line			*/B 				"%-14s(*) %-23s\*%-25s%-12s%s\n",		/* Base address error				*/= 				"%-14s(*) %-24s%-24s\*%-12s%s\n",		/* Length error					*/ B 				"%-14s(*) %-23s\*%-24s\*%-12s%s\n"  		/* Both errors ...				*/
 			     };  G 	strcpy_D (name,   name_D);						/* Copy descriptors into C strings		*/  	strcpy_D (base,   base_D);  	strcpy_D (length, length_D);  	strcpy_D (file,   file_D);    	fprintf(output_fp, 9 		formats[error_status],						/* Use correct format				*/  		"",  		name,  		base, 
 		length, 	 		file );    END      /*+   *  NAME1  *	close_output_file -- closes output report file   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88			Bauer		Initial implementation. -*/  PROC close_output_file ()    BEGIN Q 	fprintf (output_fp, "\n");						/* Add newline to end of the file, particularly  3 										   nice if job running on BATCH queue to   										   SYS$OUTPUT */8 	fclose (output_fp);							/* Look Ma - No hands !				*/ END        /*+   *  NAME2  *	open_output_file --  opens output report header  *  *  DESCRIPTION 0  *	This routine opens the output report file and)  * 	calls routine to print a file header.   *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88			Bauer		Initial implementation. -*/ 1 PROC open_output_file ( file_name_D, map_name_D )   0 struct dsc$descriptor *file_name_D, *map_name_D;   BEGIN ; 	char file_name[100];							/* Output report file name			*/ < 	char map_name[100];							/* Input map name for header			*/  $ 	strcpy_D (file_name, file_name_D );  V 	if ( (output_fp = fopen(file_name, "w")) == NULL)			/* Open the file for writing			*/ 	BEGINK 		printf("%CHKMAP-E-CANTOPENOUT,  Can't open output file %s\n", file_name); 
 		exit(1); 	END  U 	strcpy_D (map_name, map_name_D );					/* Extract map name and print report header	*/  	fprintf(output_fp, T 		"\n------------   C H E C K - M A P   R E P O R T   F O R :  %s   ------------\n",
 		map_name );    END   