$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! File:	CLEAN_OSB_SCRATCH
$! Purpose:	Maintains the OSB Scratch disk at a 25% free space at 
$!		start of day.  If there is not enough space, then it
$!		first deletes all files on the scratch disk at least
$!		4 BUSINESS days old.  If there is still not enough 
$!		space, it tries to trash those at least 3 BUSINESS days 
$!		old.
$!
$! History:	8-24-88		Bauer			First version
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$ SET NOVERIFY
$ SAY :== MAIL/NOSELF/SUBJECT = 			
$ now = F$TIME()								! Get current time
$ day = F$CVTIME(now,,"WEEKDAY")						! Map to day
$ scratch_disk = "DISK$BRONTO"							! This is the OSB scratch disk
$ logname = F$TRNLNM ( "''scratch_disk'", "LNM$SYSTEM_TABLE",,,, "VALUE" )	! Translate the logical name
$ IF logname .eqs. "" THEN GOTO not_mounted
$ max = F$GETDVI ( "''logname'", "MAXBLOCK" )					! Get maxblocks for the disk for % calculations
$!
$!		
$ free = F$GETDVI ( "''logname'", "FREEBLOCKS" )				! First space check 
$ percent_free = 100 - (((max - free) * 100) / max)				! Calculate free percent
$ IF percent_free .ge. 25 THEN goto NO_CLEANUP_NEEDED				! Enough free space?
$!
$ back_day = 6									! Figure out how far to go back based on
$ IF day .eqs. "Friday"   THEN back_day = 4					! day of the week - dealing only with business
$ IF day .eqs. "Saturday" THEN back_day = 5					! days
$!
$ DELETE/BEFORE="''now'-''back_day'-00"/MODIFIED/EXCLUDE=([000000]*.*) -	! No delete files at least 4 days old
  DISK$BRONTO:[000000...]*.*;*
$!	
$ free = F$GETDVI ( "''logname'", "FREEBLOCKS" )				! Second space check 
$ percent_free = 100 - (((max - free) * 100) / max)				! Calculate free percent
$ IF percent_free .ge. 25 THEN goto CLEANUP_DONE				! Enough free space yet?
$!
$ back_day = 5									! Only business days like above!
$ IF day .eqs. "Thursday" THEN back_day = 3
$ IF day .eqs. "Friday"   THEN back_day = 3
$ IF day .eqs. "Saturday" THEN back_day = 4
$! 
$ DELETE/BEFORE="''now'-''back_day'-00"/MODIFIED/EXCLUDE=([000000]*.*) -	! Nope - now delete files at least 3 days old
 DISK$BRONTO:[000000...]*.*;*
$!	
$ free = F$GETDVI ( "''logname'", "FREEBLOCKS" )				! Closing counts
$ percent_free = 100 - (((max - free) * 100) / max)				! Calculate free percent
$ IF percent_free .ge. 25 THEN goto CLEANUP_DONE				! Enough free space yet?
$!
$!										! Exit messages
$ not_mounted: 									!
$ SAY "OSB Scratch disk ''scratch_disk' not mounted - cleanup aborted." NL: BAUER
$ GOTO das_ende
$!
$ space_still_tight:
$ SAY "After cleaning up files older that 3 days, ''scratch_disk' only has ''free' blocks available (''percent_free'% free)" NL: BAUER
$ GOTO das_ende
$!
$ no_cleanup_needed:								!
$ SAY "No cleanup of ''scratch_disk' needed - there are ''free' blocks available (''percent_free'% free)" NL: BAUER
$ GOTO das_ende
$!
$ cleanup_done:									!
$ SAY "Cleanup completed on ''scratch_disk' - there are ''free' blocks available (''percent_free'% free)" NL: BAUER
$ GOTO das_ende
$!
$ das_ende:									!
$!
$ submit/restart/queue=newtbatch/noprint/after="TOMORROW+0-05:00:00" -
        devtools:clean_osb_scratch.com
$ logout/full
