 /*+   *  NAMEQ  *	disk_master_summary -- collection of routines that print master summary report   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    #include stdio #include descrip #include "sysdefs:stcdefs" #include "disk"   
 /***********/ 
 /* Globals */ 
 /***********/ 5 extern FILE 			*fp;					/* Output file pointer					*/ ? extern char			header[5][150];				/* Report Header buffer					*/ E extern DIR_DATA     	**dir_list; 					/* Directory info by disk				*/ N extern DISK_SUMMARY 	disk_totals [MAX_REPORTS];			/* Disk summary array					*/> extern int	    	total_blocks_count;				/* Grand totals						*/  extern int	    	total_dir_count;   /**********/ /* Common */ /**********/ globalref  		max_depth;  globalref  		input_file_number;      /*+   *  NAME=  * 	print_master_sum_report_hdr -- prints this reports header   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   # PROC print_master_sum_report_hdr ()    BEGIN  	  	strcpy (header[0], G "                                  Master  Root  Summary  Report\n\n");  	strcpy (header[1], Z "Master Root      Disks  Roots  Dirs    Files     Blocks     Cum%  Cumulative Histogram"); 	strcpy (header[2], x "---------------  -----  -----  -----   -------  ---------  ------ --------------------------------------------------"); 	strcpy (header[3], "");   	print_header ();  END   ) PROC print_master_sum_line  (   master_D, 	 				disk,  				index,   				max_blocks,  				print_line )  D struct dsc$descriptor 	*master_D;					/* Master root directory				*/& int			disk;						/* What disk?						*/3 int			index;						/* What index into dir list				*/  int			max_blocks;  int			print_line;    BEGIN ; 	char 		master[20];					/* Non descriptor master name				*/ 6 	char 		histogram[51];					/* Histogram string 					*/ 	float		percent;					 	int 		i;   + 	static char	disk_used[MAX_REPORTS+1] = ""; 9 	static int 	sum_files=0; 					/* Master summaries					*/  	static int 	sum_blocks=0; 	static int 	sum_disks=0;  	static int 	sum_roots = 0;  	static int 	sum_dirs = 0; 	  	if (!print_line)  	BEGIN 		if (!disk_used[disk])  		BEGIN  			sum_disks++;  			disk_used[disk] = TRUE; 		END    		sum_roots ++; 3 		sum_dirs += dir_list[disk][index].total_sub_dirs;   - 		do								/* Tally master root totals 			*/  		BEGIN   S 		    sum_files +=    dir_list[disk][index].act_total_files;	/* Master totals				*/ 7 		    sum_blocks +=   dir_list[disk][index].act_blocks;  		    index ++;   7 		END while ( (index <= disk_totals[disk].dir_count) && 7 		             (dir_list[disk][index].dir_depth > 1) );    	END 	else  	BEGIN  - 		compute_percent_and_histogram (	sum_blocks,  						max_blocks,  						&percent, 	 						2,   						histogram );   		strcpy_D (master, master_D);  B 		fprintf (fp, "%-15s  %5d  %5d  %5d   %7d %10d  %5.1f%% %-50s\n", 				master,  				sum_disks, 				sum_roots,
 				sum_dirs,  				sum_files, 				sum_blocks,  				percent, 				histogram );   		sum_files=0;   		sum_blocks=0;  		sum_disks=0; 	 	sum_roots = 0;  		sum_dirs = 0; " 		for (i=1; i <= MAX_REPORTS; i++) 			disk_used[i] = NULL;    	END   END 