 /*+   *  NAMEH  *	max_blocks -- returns the maximum amount of space available on a disk  *  *  DESCRIPTION A  *	This routine obtains the disk space available on a disk in one   *	of two ways: ;  *		1) Via the SYS$GETDVI system service routine which will @  *		   fail if the disk is not mounted (and also fails strangely  *		   at other times)  *				- and if it fails - C  *		2) Via a lookup table that is located in a local data structure >  *		   in this routine.  It must be updated as a system disk's  *		   configuration changes.   *  *	   *  RETURN VALUE5  *	Block size of disk or -1 if above procedures fail.   *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    #include stdio #include descrip #include dvidef  #include "sysdefs:stcdefs"   /*********/  /* Types */ > /*********/								/* Define local types for this routine			*/  8 typedef struct								/* SYS$GETDVI parameter type				*/< BEGIN									/* System Service Manual SYS-193, SYS-200 		*/ 	unsigned short buffer_length; 	unsigned short item_code; 	unsigned long  buffer_address; & 	unsigned long  return_length_address; 	unsigned long  the_terminator;  END ITEMLST;  2 typedef struct 								/* Lookup table type					*/ BEGIN 1 	char name[20];							/* Disk logical name					*/ @ 	int  max_blocks;						/* Blocks on that disk by disk type 			*/ END DISK_SIZE;     /*************/  /* Constants */  /*************/ + 									/* Disk type block sizes ...				*/ & #define		RM05		500384					/* Blocks */& #define		RA81		891072					/* Blocks */' #define		RP07		1008000					/* Blocks */ ' #define		RA82		1216665					/* Blocks */    int max_blocks ( disk_D )   N struct dsc$descriptor *disk_D;						/* Name of disk	checking getting size			*/ 	  BEGIN    /**********/ /* Locals */ /**********/ 	ITEMLST item_list; 4 	unsigned long maxblock;						/* Return blocks				*/7 	unsigned short iosb[6];						/* GETDVI parameter				*/ @ 	long 	*temp;								/* Used to poing to output GETDVI buffer	*/ 	long	ret_length; 6 	int status, i;								/* Status, index variables			*/H 	char buf[100];								/* String buffer - shouldn't be needed BUT ...	*/ 	int	look_up_disk_size ();   	strcpy_D (buf, disk_D);
 										I 	item_list.item_code = DVI$_MAXBLOCK;					/* Set up GETDVI parameter			*/  	item_list.buffer_length = 4;	7 	temp = &maxblock;							/* Blocks get stored here			*/ ! 	item_list.buffer_address = temp; / 	item_list.return_length_address = &ret_length;  	item_list.the_terminator = 0;  8 	status = sys$getdviw (	0,						/* Call sys$getdvi				*/ 				0, 				disk_D,  				&item_list, 
 				&iosb[0],  				0, 				0, 				0 
 			     );     /*! printf ("Status = %d\n", status); " printf ("iosb 0 = %d\n", iosb[0]);" printf ("iosb 1 = %d\n", iosb[1]);% printf ("maxblock = %d\n", maxblock);  */  W 	if ( (status != 1) || (maxblock == 0) )						/* If error - use the LOOKUP table...		*/  	BEGIN 		i = 0;( 		maxblock = look_up_disk_size (disk_D); 	END  > 	return (maxblock);							/* Return the blocks on the disk		*/   END 