 /*+   *  NAME?  *	disk_process_data -- utilities that fill in the dir_list and 3  *			     disk_totals data structures - get called  4  *			     mainly from SCAN program that is scanning   *			     directory logs.   *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    #include descrip #include "sysdefs:stcdefs" #include "disk"    /***************/  /* Global Data */  /***************/ c DIR_DATA     	tdir_list    [MAX_DIRS_PER_REPORT];		/* Stores individual disk directory summaries	*/ K DIR_DATA     	**dir_list; 	/* Stores individual disk directory summaries	*/ O DISK_SUMMARY 	disk_totals [MAX_REPORTS];				/* Stores totals for each disk			*/   < int 		files_count;						/* Files count for current disk			*/< int		blocks_count;						/* Blocks count for current disk		*/  @ int  		big_root_size;						/* Size of largest root directory		*/ int  		largest_root_size; ; int  		big_dir_size;						/* Size of largest directory			*/  int  		largest_dir_size;  * 									/* Totals accross all disks:			*/7 int  		total_dir_count;					/* Total #directories				*/ 2 int		total_files_count;					/* Total #files					*/4 int 		total_blocks_count;					/* Total #blocks				*/2 int 		total_root_count;					/* Total #roots					*/  6 char  		disk_name[30];						/* Current disk	name				*/  I int   		stack[9];						/* Stack for correlating directories to parents	*/ 4 int   		stack_size;						/* Size of this stack				*/     /***************/  /* Common Data */  /***************/ H globalref	percent_type;						/* Used for computing usage percentages		*/: globalref 	dir_count;						/* Current directory count			*/@ globalref 	root_count;						/* Current root directory count			*/> globalref 	disk_number;						/* Current disk number index			*/A globalref 	input_file_number;					/* Current log file number			*/ & globalref 	total_disk_space_available;   	  /*+   *  NAMEB  *	store_disk_name -- stores name of current disk into disk_totals  *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    PROC store_disk_name ( name_D )  								; struct dsc$descriptor *name_D;						/* Name of disk						*/    BEGIN 2 	strcpy_D (disk_totals[disk_number].name, name_D); END    /*+   *  NAMEG  *	store_dir_data -- stores directory data for current disk's directory   *  *  DESCRIPTION J  *	This routine stores the directory data (#files, #blocks, depth, & name)=  *	for the current directory for the current disk log report.   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/     PROC store_dir_data (	files_cnt, 			blocks_cnt,
 			name_D,
 			depth )  < int			files_cnt;					/* How many files in the directory			*/> int			blocks_cnt;					/* How many blocks in the directory			*/6 int			depth;						/* What directory level (1-8) 				*/? struct dsc$descriptor 	*name_D;					/* Name of directory					*/    BEGIN   C 	strcpy_D(tdir_list[dir_count].name, name_D);	/* Store name						*/ ( 	tdir_list[dir_count].dir_depth = depth;  = 	if (depth == 1)							/* If root - increment root count			*/ % 	        root_count = root_count + 1;   b 	if (strcmp(tdir_list[dir_count].name, "[000000]") 	/* Init stack processing for disk top root		*/
 		== NULL) 	BEGIN 	   stack_size = 0;  	   stack[stack_size] = 0; 	END5 	else								/* Not top root - store parent info			*/  	BEGIN. 		if (depth > stack_size)					/* PUSH							*/ 		BEGIN  			stack_size ++; ! 			stack[stack_size] = dir_count;  		END 6 		else if (depth == stack_size)				/* POP/PUSH						*/! 			stack[stack_size] = dir_count;  		else 		BEGIN 3 			stack_size = depth; 				/* POP POP POP...					*/ ! 			stack[stack_size] = dir_count;  		END  	END  H 	tdir_list[dir_count].parent_index 			/* Never forget your parents				*/ 		= stack[stack_size-1];  I 	tdir_list[dir_count].total_sub_dirs = 0;		/* Init subdirs counter					*/   Y 	tdir_list[dir_count].act_total_files  = files_cnt;	/* Store files and blocks counts			*/ 4 	tdir_list[dir_count].act_blocks       = blocks_cnt;/ 	tdir_list[dir_count].cum_files 	  = files_cnt; 1 	tdir_list[dir_count].cum_blocks 	  = blocks_cnt;   I 	files_count  = files_count + files_cnt;				/* Tally, tally, tally					*/ * 	blocks_count = blocks_count + blocks_cnt;  B 	if (tdir_list[dir_count].act_blocks 		/* WHos the biggest?					*/ 			> largest_dir_size) 	BEGIN# 	    largest_dir_size = blocks_cnt; # 	    big_dir_size     = blocks_cnt;  	END 	else 8 	    if (tdir_list[dir_count].act_blocks > big_dir_size)
 	    BEGIN 		big_dir_size 	 = blocks_cnt; 	    END   END    /*+   *  NAME=  *	store_disk_summary -- stores disks totals for current disk   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/ " PROC store_disk_summary ( name_D )  : struct dsc$descriptor	*name_D;					/* Name of disk						*/   BEGIN   1 	disk_totals[disk_number].dir_count 	= dir_count; 5 	disk_totals[disk_number].files_count 	= files_count; 6 	disk_totals[disk_number].blocks_count	= blocks_count;2 	disk_totals[disk_number].root_count	= root_count;U 	disk_totals[disk_number].big_root_size 	= 0;			/* Have to figure this out later			*/ 6 	disk_totals[disk_number].big_dir_size	= big_dir_size;  [ 	if (percent_type == MAX_BLOCKS_PERCENT)				/* Compute percent full based on max_blocks		*/  	BEGINK 		disk_totals[disk_number].max_blocks			/* Use tot disk space on disk				*/  		    = max_blocks(name_D);	Y 		if (disk_totals[disk_number].max_blocks <= 0)		/* If there's an error fallback ...			*/ & 			disk_totals[disk_number].max_blocks/ 			    = disk_totals[disk_number].blocks_count;  	END0 	else								/* Use total USED disk space 				*/ 	BEGIN% 		disk_totals[disk_number].max_blocks . 		    = disk_totals[disk_number].blocks_count; 	END  C 	total_disk_space_available += disk_totals[disk_number].max_blocks;    END    PROC store_data_in_dir_list ()     BEGIN    	int i;   M 	dir_list[disk_number] = (DIR_DATA *) malloc(sizeof(DIR_DATA)*(dir_count+1));   / 	dir_list[disk_number][0].act_total_files  = 0; ) 	dir_list[disk_number][0].act_blocks = 0; ( 	dir_list[disk_number][0].cum_files = 0;) 	dir_list[disk_number][0].cum_blocks = 0; - 	dir_list[disk_number][0].total_sub_dirs = 0; ( 	dir_list[disk_number][0].dir_depth = 0;   	for (i=1; i <= dir_count; i++)  	BEGIN* 		dir_list[disk_number][i] = tdir_list[i];   	END   END      /*+   *  NAMEL  *	process_dir_list -- this routine sums up the cumulative files and blocks =  *			    counts for all directories and figures out big root    *			    directory size   *  DESCRIPTION N  *	This routines utilizes the parent field of each directory and bubbles back T  *	the files/blocks counts.  This is called AFTER all disk logs have been processed.  *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/  PROC process_dir_list ()	 									  BEGIN : 	int i,j,k, dir_count;						/* Loop counters/indexes				*/  N 	for (k=1; k <= input_file_number; k++)				/* Loop through all the disks				*/ 	BEGIN-   	    dir_count = disk_totals [k].dir_count;   * 	    disk_totals[k].big_root_size = 0;				  \ 	    for (i=dir_count; i >= 2; i--)				/* And for each disk, loop through all directories	*/
 	    BEGIN( 		  j = dir_list[k][i].parent_index;				  > 	          dir_list[k][j].cum_files += 				/* Tally ho						*/ 			dir_list[k][i].cum_files;  ( 	          dir_list[k][j].cum_blocks +=  			dir_list[k][i].cum_blocks;   % 		  dir_list[k][j].total_sub_dirs ++;   C 		  if (dir_list[k][i].dir_depth == 1)			/* Big root contest					*/ 	 		  BEGIN    /*   printf("Root at %d,%d\n", k,i); 7 printf("Cum_blocks = %d\n", dir_list[k][i].cum_blocks); = printf("Big Root Size = %d\n", disk_totals[k].big_root_size);  */  " 			if (dir_list[k][i].cum_blocks >! 				disk_totals[k].big_root_size)  			BEGIN" 				disk_totals[k].big_root_size =" 				    dir_list[k][i].cum_blocks; 			END 		   END   	    END  , 		  if ( (dir_list[k][i].dir_depth == 1) && H 		       (disk_totals[k].root_count == 1) )			/* Big root contest					*/	 		  BEGIN    /* printf("Root at %d,%d\n", k,i); 7 printf("Cum_blocks = %d\n", dir_list[k][i].cum_blocks); = printf("Big Root Size = %d\n", disk_totals[k].big_root_size);  */" 			if (dir_list[k][i].cum_blocks >! 				disk_totals[k].big_root_size)  			BEGIN" 				disk_totals[k].big_root_size =" 				    dir_list[k][i].cum_blocks; 			END 		   END   	END   END    /*+   *  NAMES  *	initialize -- common global variables initialization that need be done only once   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    PROC initialize ()   BEGIN   1 	dir_list = (DIR_DATA **) calloc(MAX_REPORTS, 4);    	input_file_number 	= 0; 	total_dir_count    	= 0;  	total_files_count 	= 0;     	total_blocks_count 	= 0;  	largest_root_size 	= 0; 	largest_dir_size  	= 0;6 	stack_size 		= 0;					/* Probably not necessary				*/ 	stack[stack_size]	= 1;    END    /*+   *  NAMEK  *	step_initalize -- initialization before new directory log report scanned   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    PROC step_initialize ()    BEGIN  	    dir_count		= 0; 	    files_count		= 0; 	    blocks_count	= 0; 	    root_count 		= 0; 	    big_root_size 	= 0; 	    big_dir_size	= 0; END;   /*+   *  NAME5  *	store_totals -- stores grand totals ove all disks.   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/  PROC store_totals ()   BEGIN 7 	    total_dir_count 	= total_dir_count    + dir_count; ; 	    total_files_count 	= total_files_count  + files_count; = 	    total_blocks_count 	= total_blocks_count + blocks_count;    END   