 /*+   *  NAMEL  *	disk_report_utils -- collection of routine that print various reports for  *			     disk report tool  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    #include stdio #include descrip #include "sysdefs:stcdefs" #include "disk"   ( #define 	FORM_FEED 		fprintf (fp, "\n")  
 /***********/ 
 /* Globals */ 
 /***********/ / FILE 			*fp;						/* Output file pointer					*/ 9 char			header[5][150];					/* Report Header buffer					*/ 6 int			line_count = 0;					/* Current line count					*/  A extern DIR_DATA     	**dir_list; 	/* Directory info by disk				*/ N extern DISK_SUMMARY 	disk_totals [MAX_REPORTS];			/* Disk summary array					*/l extern SORT_ENTRIES 	sort_list [MAX_REPORTS*MAX_DIRS_PER_REPORT];	/* Array of sorted dirs by block size			*/> extern int	    	total_blocks_count;				/* Grand totals						*/  extern int	    	total_dir_count;   /**********/ /* Common */ /**********/ globalref  		max_depth;  globalref  		input_file_number;      /*+   *  NAME1  *	close_output_file -- closes output report file   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88			Bauer		Initial implementation. -*/  PROC close_output_file ()    BEGIN K 	fprintf (fp, "\n");							/* Add newline to end of the file, particularly  3 										   nice if job running on BATCH queue to   										   SYS$OUTPUT */2 	fclose (fp);								/* Look Ma - No hands !				*/ END        /*+   *  NAME2  *	open_output_file --  opens output report header  *  *  DESCRIPTION 0  *	This routine opens the output report file and)  * 	calls routine to print a file header.   *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88			Bauer		Initial implementation. -*/ % PROC open_output_file ( file_name_D )   # struct dsc$descriptor *file_name_D;    BEGIN ; 	char file_name[100];							/* Output report file name			*/   $ 	strcpy_D (file_name, file_name_D );  O 	if ( (fp = fopen(file_name, "w")) == NULL)			/* Open the file for writing			*/  	BEGINL 		printf("%DISKRPT-E-CANTOPENOUT,  Can't open output file %s\n", file_name);
 		exit(1); 	END   END    /*+   *  NAMED  *	write_disk_report_command -- writes DCL command that invoked tool  *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY *  *	4-8-88			Bauer		Initial implementation. -*/ , PROC write_disk_report_command ( command_D )  ! struct dsc$descriptor *command_D;    BEGIN 2 	char command[512];						/* C string buffer					*/H 	char temp[133];							/* Temp buffer for partitioning long commands		*/" 	int  i; 							/* Counter						*/   	strcpy_D (command, command_D);    	fprintf (fp, "\n\n$  ");   & 	for (i=0; i < strlen(command); i+=80) 	BEGIN" 		strncpy (temp, &command[i], 80); 		temp[80] = NULL; 		fprintf (fp, "%s\n", temp);  	END   	fprintf (fp, "\n\n"); END    /*+   *  NAMEE  *	print_disk_summary_header -- prints header for disk summary report   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   ! PROC print_disk_summary_header ()    BEGIN    		strcpy (header[0],  J 				"                                     Disk Report Summary Page \n\n"); 		strcpy (header[1],  p "                        Blocks    Blocks    Blocks     %          Num     Num     Big Dir    Num    Big Root"); 		strcpy (header[2],  n "Disk Name               Allocat   Free      Maximum   Full       Files    Dirs     Size     Roots     Size"); 		strcpy (header[3],  p "--------------------    -------   -------   -------  -------     -----    -----   -------   -----   --------"); 		strcpy (header[4], "");  	  		print_header ();   END    /*+   *  NAMEF  *	write_disk_summary_line -- writes a line on the disk summary report  *  *  DESCRIPTION K  *	This routine gets called once per disk to print the disk summary report. F  *	It gives summary info on each disk (name, block usage, files, etc.)  *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   ) PROC write_disk_summary_line (	disk_name,  				dir_count,   				files_count,   				blocks_count,  				tmax_blocks, 				root_count,  				largest_root_count,  				largest_dir_count )    int			dir_count; int			files_count; int			blocks_count;  int			tmax_blocks; int			root_count;  int			largest_root_count;  int			largest_dir_count; char 			*disk_name;    BEGIN  	float 	percent; 	static int first_time = 0; [ 	static int sum_blocks = 0, sum_max_blocks = 0, sum_files = 0, sum_dirs = 0, sum_roots = 0;  	int	temp_max_blocks;  	struct dsc$descriptor name_D;  2 	if (first_time == 0)					/* Print header?						*/ 		print_disk_summary_header ();    	first_time++;  I 	temp_max_blocks = tmax_blocks;				/* Calculate max blocks on disk					*/ ( 	create_descriptor (&name_D, disk_name);% 	tmax_blocks =  max_blocks (&name_D);  	if (tmax_blocks == -1)	  		tmax_blocks = temp_max_blocks;  > 	if (tmax_blocks == 0)					/* Avoid divide by zero case					*/  	    tmax_blocks = blocks_count;  2 	sum_blocks += blocks_count;				/* Tally 							*/ 	sum_max_blocks += tmax_blocks;  	sum_files += files_count; 	sum_dirs += dir_count;  	sum_roots += root_count;   C 	percent = (float) blocks_count 				/* Compute percent full						*/  		   / (float) tmax_blocks  
 		   * 100.0;   1 	fprintf (	fp, 					/* Print line of info						*/ J 			"%-20s    %7d   %7d   %7d  %6.2f%%     %5d    %5d   %7d   %5d   %8d\n", 			disk_name,  			blocks_count, 			tmax_blocks - blocks_count, 			tmax_blocks,  			percent,  			files_count, 
 			dir_count,  			largest_dir_count,  			root_count, 			largest_root_count );  G 	if (first_time == input_file_number)			/* Print summary totals						*/  	BEGIN
 	fprintf (fp, r "--------------------   --------  --------  --------  -------    ------    -----   -------   -----   --------\n");  ? 	percent = (float) sum_blocks / (float) sum_max_blocks * 100.0;   S 	fprintf (fp, 	"%20s   %8d  %8d  %8d  %6.2f%%    %6d    %5d   %7s   %5d   %8s\n\n",  			"Disk Totals:  ", 			sum_blocks, 			sum_max_blocks - sum_blocks,  			sum_max_blocks, 			percent, 
 			sum_files,  			sum_dirs, 			" ", 
 			sum_roots,  			" "); 	END 	else  		fprintf (fp, "\n");    END    /*+   *  NAMEL  *	compute_percent_and_histogram -- figures out percentage disk is full and )  *					 gives a HISTOGRAM string back too   *  *  DESCRIPTION A  *	This routine gets called to calculate disk usage percentage.   A  *	The percentage is based on either the total blocks used or the *  *	total blocks that can be on the disk.    *L  *	The routine also creates a histogram string (with some minimum percentage)  *	representing a star in the histogram).   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   H #define 	HISTOGRAM		"**************************************************"  , PROC compute_percent_and_histogram (	blocks, 					max_blocks,
 					percent,  					percents_per_star,  					histogram_string )   * int 	blocks;								/* Blocks used						*/6 int	max_blocks;							/* Blocks that can be used				*/; int 	percents_per_star;						/* How percent per star?				*/ 4 float	*percent;							/* Percentage calculated				*/7 char	*histogram_string;						/* Histogram string					*/    BEGIN - 	int	how_many;						/* How many stars?					*/   U 	*percent = (float) blocks / (float) max_blocks * 100.0;		/* Calculate percent					*/ K 	how_many = (int) *percent / percents_per_star;			/* How many stars?					*/ S 	strncpy (histogram_string, HISTOGRAM, how_many);		/* Set up histogram string				*/ # 	histogram_string[how_many] = NULL;    END	 	  /*+   *  NAMEI  * 	write_root_report_header -- writes out the root report column headers   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/     PROC write_root_report_header ()   BEGIN   X 	strcpy (header[0], "\n                                 Root Directory Summary Report");o 	strcpy (header[1], "\nDisk            Root                    \#SDirs  \#Files  #Blocks   %OfDisk Histogram");  	strcpy (header[2], "--------------  ---------------------   ------  ------  --------  ------- -------------------------------------");  	strcpy (header[3], "");   	print_header ();    END    /*+   *  NAMEC  *	write_root_report_line  -- writes out a line to the root report.   *  *  DESCRIPTION ?  *	This routine gets called once for every root directory from  2  *	every disk directory log passed to the utility.  *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   * PROC write_root_report_line   ( disk_name,	 				root,  				blocks,  				max_blocks, 
 				files, 				sub_dirs )  , char 			*disk_name, 				/* What disk						*/" 			*root;					/* Root name						*/( int			blocks, 				/* Cum Blocks 						*/' 			max_blocks,				/* Max blocks						*/ # 			files,					/* Cum Files 						*/ + 			sub_dirs;				/* # sub directories					*/    BEGIN  	static int	first_time = TRUE;F 	static  char	old_disk_name[50];			/* Don't repeat the disk name				*/ 	char		histogram_string[51];			  	float		percent; 	int		new_master;      	new_master = FALSE;  T 	if (strcmp (disk_name, old_disk_name) == NULL)		/* Don't repeat the disk name				*/ 		strcpy (old_disk_name, "");  	else if (!first_time) 	{ 		new_master = TRUE;$ 		strcpy (old_disk_name, disk_name); 	} 	else $ 		strcpy (old_disk_name, disk_name); 	  	first_time = FALSE;  I 	compute_percent_and_histogram (	blocks,			/* % full with histogram				*/  					max_blocks, 					&percent, 					2,  					histogram_string );   	if (new_master) 		fprintf (fp, "\n"); = 	fprintf (	fp, 					/* Write the line to the report file			*/ 4 			"%-14s  %-20s    %6d  %6d  %8d  %6.2f%% %-50s\n", 		     	old_disk_name,
 		  	root, 			sub_dirs,	 			files, 
 			blocks, 			percent,    			histogram_string );   	page_check();  # 	strcpy (old_disk_name, disk_name);    END    /*+   *  NAME=  *	write_top_dirs_rep_header -- prints header for this report   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   7 write_top_dirs_rep_header ( how_many_dirs, cum_blocks )t   int 	how_many_dirs;f int	cum_blocks;k   BEGINo 									/* Header time						*/U 	sprintf (	&header[0],  ] 			"\n                                    Top %1d Directories List (contain %1d blocks)\n\n",s 			how_many_dirs, cum_blocks );  	strcpy (header[1], "Rank  Disk            Directory                              \#Files    \#Blocks    %OfTop  Relative Histogram"); 	strcpy (header[2], "----  --------------- -------------------------------------  ------    -------    ------  ---------------------------------");n 	strcpy (header[3], "");   	print_header ();y   END	   /*+x  *  NAMEJ  *	write_top_directories_report -- Writes out the top N directories report  *  *  DESCRIPTIONtF  *	This routine is caled when the top directories report is requested.F  *	It takes the sorted directory list and prints out the user-specifed  *	top N directories.i  *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/_  3 PROC write_top_directories_report ( how_many_dirs )l  : int 	how_many_dirs;							/* Print top N directories				*/   BEGIN*? 	SORT_ENTRIES		cur;					/* Used to minimize array indexing			*/ 9 	float			percent;				/* Used to compute percentages				*/	: 	char			histogram[50];				/* Stores histogram string				*/F 	char			dir_name[40];				/* Shrinking directory name when too long		*/% 	int			i;					/* Loop counter						*/ : 	int			cum_blocks;				/* Cum blocks ovver top N dirs				*/M 	char			disk[50],last_disk[50];			/* Used to print out disk field or not			*/n    ? 	if (how_many_dirs > total_dir_count)				/* Error check						*/r" 		how_many_dirs = total_dir_count;  < 	cum_blocks = 0;							/* Calculate cum overtop N dirs				*/# 	for (i=1; i <= how_many_dirs; i++)t" 		cum_blocks += sort_list[i].size;  V 	write_top_dirs_rep_header ( how_many_dirs, cum_blocks );	/* Dump report header					*/  # 	for (i=1; i <= how_many_dirs; i++)e 	BEGIN9 		cur = sort_list[i];					/* Store current dir data				*/B' 									/* % / HISTO computation				*/CK 		compute_percent_and_histogram (	dir_list[cur.disk][cur.index].act_blocks,* 						cum_blocks,  						&percent,-	 						3, L 						histogram );  R 		check_dir_name (dir_list[cur.disk][cur.index].name,	/* Dir name too long?					*/ 				37, dir_name);% 									/* Print out the line					*/mA 		fprintf (fp, "%4d  %-15s %-37s  %6d    %7d   %6.2f%%  %-33s\n",  				i,S 				(i > 1) && (cur.disk == sort_list[i-1].disk) ? "" : disk_totals[cur.disk].name,  				dir_name, 2 				dir_list[cur.disk][cur.index].act_total_files,- 				dir_list[cur.disk][cur.index].act_blocks,( 				percent, 				histogram );   		page_check();    	END 	G END	   /*+   *  NAMEF  *	page_check -- checks to see when N lines per page have been printed  *  *  DESCRIPTION\D  *	THis routine was intended to make the output report pagify nicelyN  *	but due to time considerations has been stubbed out by returning instantly.  *  *  RETURN VALUE  *  *  HISTORYr4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/_ PROC page_check ()   BEGINc  ' 	return;							/*  S   T   U   B					*/    	line_count ++;k 	if (line_count > 58)\ 	BEGIN 		print_header (); 	END END    /*+   *  NAME:  *	print_header -- prints contents of report header buffer  *  DESCRIPTIONRD  *	This routine was intended to make the output report pagify nicelyK  *	but due to time considerations this was not followed completely through.t  *  *  RETURN VALUE  *  *  HISTORY-4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/-   PROC print_header ()   BEGINt 	int 	i; 	static	first_time = TRUE;   	if (first_time) 		first_time = FALSE;e 	elseu 		fprintf (fp, "\n");   	line_count = 0; 	i = 0;tO 	while (header[i][0] != NULL)				/* Print the report header buffer strings			*/s 	BEGIN" 		fprintf (fp, "%s\n", header[i]); 		line_count++;m 		i++; 	END   END,   /*+   *  NAME<  * 	print_merged_report_header -- prints this reports header  *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORYe4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/s  " PROC print_merged_report_header ()   BEGIN  	a 	strcpy (header[0], N "                             Master  Root  Complete  Directory  Report\n\n");   	strcpy (header[1],  "");	   	print_header ();	   END_   /*+u  *  NAMEG  *	print_intermediate_mheader -- prints this reports root master headers  *  *  DESCRIPTION=G  *	This routine gets called every time a new master root is encounteredd!  *	in the MERGED directory report_  *  *  RETURN VALUE  *  *  HISTORYm4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/r  * PROC print_intermediate_mheader ( master )   char 	master[];s   BEGINl   /*6 	if (line_count + 4 > 58)			S  T  U  B  -  maybe later 	BEGIN 		line_count +=4;	 		page_check (); 	END */   	fprintf (fp, K 		"                                            \#Files        \#Blocks\n");  	fprintf (fp, f 		"%-10s Directory                       Act   Cum    Act      Cum     Cum%%  Cumulative Histogram\n", 		master );s 	fprintf (fp,  		"---------- ------------------------------ ----- -----  -------  ------- ------ --------------------------------------------------\n");C   /* 	line_count += 3;* */   END(   /*+t  *  NAME;  *	check_dir_name -- makes sure directory name is printablef  *  *  DESCRIPTION 9  *	This routine gets called to make sure a directory named9  *	is printable to a certain width.  If it is not, parento;  *	directories, starting with the root, are removed one by  :  *	one until the shoe fits.  The removed dirs are replaced  *	by a [...  *  *  RETURN VALUE  *  *  HISTORY_4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/p) PROC check_dir_name (dir, length, to_dir)-  * char	*dir;								/* Check this dir					*/8 char	*to_dir;							/* Return this dir if too long				*/7 int	length;								/* How big can this sucker be?				*/"   BEGINd% 	int 	i;							/* Array index						*/ 1 	int 	dir_len;						/* Length of char *dir					*/o  6 	dir_len = strlen(dir);						/* How big is dir?					*/  / 	if (dir_len > length)						/* Too big?						*/" 	BEGIN 		for (i=1; i < dir_len; i++)s 		BEGINi6 			if (dir[i] == '.')				/* Nail this directory					*/$ 			   if (dir_len - i + 3 <= length)
 			   BEGIN 	sD 			      sprintf ( to_dir, 			/* If its not too big now, return			*/ 					"[...%s", o 					&dir[i+1]); 			      return;	 			   ENDn 		END  	END 	elseeA 		strcpy (to_dir, dir);					/* Just return passed directory				*/o   ENDt 	n /*+n  *  NAMEC  *	print_merged_report_line -- this routine prints a line from the i!  *				    merged directory reportt  *  *  DESCRIPTION A  *	This routine gets called once for each directory in the mergedrB  *	directory report.  It is too complex and long, but will have to>  *	due until I can clean it up which will probably be never.    *@  *	Nevertheless, it prints out directory information on blocks, >  * 	files, etc. for some root directory under some master.  It@  *	is driven by the scan routine write_merged_report because the7  *	master root mapping was simple to implement in scan.c  *  *  *  RETURN VALUE  *  *  HISTORY	4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   ) PROC print_merged_report_line ( master_D,m 				root_dir_D,m	 				disk,	 				index, e 				max_blocks )  D struct dsc$descriptor 	*master_D;					/* Master root directory				*/@ struct dsc$descriptor 	*root_dir_D;					/* Root directory					*/& int			disk;						/* What disk?						*/3 int			index;						/* What index into dir list				*/h int			max_blocks;_   BEGINU; 	char		dir_name[40];					/* What directory? Too long?				*/r; 	char 		master[20];					/* Non descriptor master name				*/I: 	char		root_dir[35];					/* Non descriptor root name				*/6 	char 		histogram[51];					/* Histogram string 					*/ 	float		percent;				 	char 		what_disk[11]; 	int		printed;  ; 	static int 	sum_files  = 0;					/* Master summaries					*/p 	static int 	sum_blocks = 0;  	static int 	sum_cum_blocks = 0;  J 	static char	old_master[20];					/* Don't repeat the same master name			*/ 	static int	first_time = TRUE;  U 	strcpy_D (master, master_D);					/* What master and what root are we dealing with	*/r! 	strcpy_D (root_dir, root_dir_D);e  = 	if (first_time)							/* First time - init some statics			*/r 	BEGIN 	    first_time = FALSE;  	    strcpy(old_master, master); 	    sum_files  = 0; 	    sum_blocks = 0;8 	    sum_cum_blocks += dir_list[disk][index].cum_blocks;P 	    print_intermediate_mheader ( master );			/* Print intermediate header				*/   	END		h 	else if (strcmp(old_master, master) == NULL)			/* Bogus - routine gets called one extra time with a 	*/C 	BEGIN								/* blank master inorder to get totals on the last 	*/k7 	    strcpy(old_master, "");					/* master root						*/s 	    if (max_depth > 0)	 		    fprintf (fp, "\n");x8 	    sum_cum_blocks += dir_list[disk][index].cum_blocks; 	END 	else 3 	BEGIN								/* New master  - computer totals			*/i1 		compute_percent_and_histogram (	sum_cum_blocks,	 						max_blocks,e 						&percent, 	 						2, o 						histogram );  p 		fprintf (fp, "%41  -----------  ---------------- ------ --------------------------------------------------\n", 			     " " );H 		fprintf (fp, "%30s Totals:     %7d %3s      %7d%4s %5.1f%% %-50s\n\n", 			 old_master,  			 sum_files, c	 			 " ", k 			 sum_blocks, ! 			 " ",   /* sum_cum_blocks,  */m 			 percent, 			 histogram );  ? 		if (master[0] == NULL)					/* last master - if so return			*/t
 			return;    	    strcpy(old_master, master); 	    sum_files  = 0; 	    sum_blocks = 0;7 	    sum_cum_blocks = dir_list[disk][index].cum_blocks;	 	    page_check ();   + 	    print_intermediate_mheader ( master );6   	END  J 	strcpy (what_disk, (char *) (strrchr (disk_totals[disk].name, '$') + 1));   	printed = FALSE;	  ? 	do								/* Print all dirs under this root for this master	*/o 	BEGIN# 	    if (check_flags (disk, index))*
 	    BEGINC 		compute_percent_and_histogram (	dir_list[disk][index].cum_blocks,E 						max_blocks,  						&percent, 	 						2,   						histogram );   		printed = TRUE;_  K 		check_dir_name (dir_list[disk][index].name,		/* Dir name too long?					*/  				30, dir_name);  A 		fprintf (fp,  	"%-10s %-30s %5d %5d  %7d  %7d %5.1f%% %-50s\n",  				what_disk,0 				dir_name, /* 	dir_list[disk][index].name, */* 				dir_list[disk][index].act_total_files,$ 				dir_list[disk][index].cum_files,% 				dir_list[disk][index].act_blocks, % 				dir_list[disk][index].cum_blocks,  				percent, 				histogram );   		page_check (); 	    END  S 	    sum_files +=    dir_list[disk][index].act_total_files;		/* Master totals				*/-6 	    sum_blocks +=   dir_list[disk][index].act_blocks;   	    index ++;   	    strcpy (what_disk, "");  1 	END while (dir_list[disk][index].dir_depth > 1);i   	strcpy(old_master, master);   ENDt