 /*+   *  NAMEJ  *	disk_reports -- contains some C report drivers for the disk_report tool  *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    #include descrip #include "sysdefs:stcdefs" #include "disk"   
 /***********/ 
 /* Globals */ 
 /***********/   extern DIR_DATA     	**dir_list;! 	/* Array of directory data				*/ U extern DISK_SUMMARY 	disk_totals [MAX_REPORTS];			/* Array of disk summary info				*/  	 
 /**********/	  /* Common */
 /**********/	 : globalref 		input_file_number;				/* How many disks					*/   /*+   *  NAME7  *	write_summary_page -- writes the disk report summary   *  *  DESCRIPTION :  *	This routine gets called when a summary report is to be:  *	printed.  The summary contains the disk totals for each(  *	disk in a tabular fashion, including:  *		Name  *		#directories
  *		#files  *		#blocks   *		#max blocks 
  *		% full  *		big root size		   *		big directory size  *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/  PROC write_summary_page ()   BEGIN & 	int i;								/* Loop counter						*/  [ 	for (i=1; i <= input_file_number; i++)				/* For each disk, print a line of the report		*/  	BEGIN4 	    write_disk_summary_line (	disk_totals[i].name,  					disk_totals[i].dir_count,  ! 					disk_totals[i].files_count,  ! 					disk_totals[i].blocks_count,  					disk_totals[i].max_blocks,   					disk_totals[i].root_count, " 					disk_totals[i].big_root_size," 					disk_totals[i].big_dir_size); 	END   END    /*+   *  NAMER  *	write_root_report  -- writes out info on all roots in system in tabular fashion  *  *  DESCRIPTION Q  *	This routines gets called to drive the printing of the root report.  It prints P  *	out information of each root for each disk including their cumulative counts,*  *	disk usage percentage, and a histogram!  *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    PROC write_root_report ()    BEGIN ( 	int i, j;							/* Loop counters					*/  E 	write_root_report_header ();					/* Put a header on the report				*/   B 	for (j=1; j <= input_file_number; j++)				/* For each disk					*/ 	BEGINT 	    for (i=1; i <= disk_totals[j].dir_count; i++)		/* And wach root directory				*/
 	    BEGIN) 		if ( (dir_list[j][i].dir_depth == 1) && , 			(strcmp(dir_list[j][i].name, "[000000]")  				!= NULL) ) 		BEGIN 5 			     write_root_report_line (	disk_totals[j].name,  							dir_list[j][i].name, ! 							dir_list[j][i].cum_blocks, ! 							disk_totals[j].max_blocks,   							dir_list[j][i].cum_files,' 							dir_list[j][i].total_sub_dirs );  		END  	    END 	END   END   