 /*+   *  NAMEL  *	disk_report_utils -- collection of routine that print various reports for  *			     disk report tool  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/    #include stdio #include descrip #include "sysdefs:stcdefs" #include "disk"   
 /***********/ 
 /* Globals */ 
 /***********/ 5 extern FILE 		*fp;						/* Output file pointer					*/ ? extern char		header[5][150];					/* Report Header buffer					*/ C extern DIR_DATA     	**dir_list;    /* Directory info by disk				*/ N extern DISK_SUMMARY 	disk_totals [MAX_REPORTS];			/* Disk summary array					*/> extern int	    	total_blocks_count;				/* Grand totals						*/  extern int	    	total_dir_count;   /**********/ /* Common */ /**********/ globalref  		max_depth;  globalref  		input_file_number;      /*+   *  NAME>  * 	print_complete_report_header -- prints this reports header  *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   $ PROC print_complete_report_header ()   BEGIN  	  	strcpy (header[0], E "                                  Complete  Directory  Report\n\n");  	strcpy (header[1], "");   	print_header ();    END    /*+   *  NAMEC  * 	print_int_complete_header -- prints intermediate reports header   *				     before each root.  *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   ! PROC print_int_complete_header ()    BEGIN 
 	fprintf (fp, K 		"\n                                            #Files        #Blocks\n"); 
 	fprintf (fp, k 		"Disk       Directory                       Act   Cum    Act      Cum     Cum%  Cumulative Histogram\n"); 
 	fprintf (fp,  		"---------- ------------------------------ ----- -----  -------  ------- ------ --------------------------------------------------\n");    END    /*+   *  NAMEE  *	print_complete_report_line -- this routine prints a line from the  %  *				      complete directory report   *  *  DESCRIPTION C  *	This routine gets called once for each directory in the complete B  *	directory report.  It is too complex and long, but will have to>  *	due until I can clean it up which will probably be never.    *@  *	Nevertheless, it prints out directory information on blocks, >  * 	files, etc. for some root directory under some master.  It@  *	is driven by the scan routine write_merged_report because the7  *	master root mapping was simple to implement in scan.   *  *  *  RETURN VALUE  *  *  HISTORY 4  *	6/88	Bauer		Initial version for disk_report tool.  * -*/   ' PROC write_complete_report_line ( disk,  				  index, 				  max_blocks )  & int			disk;						/* What disk?						*/3 int			index;						/* What index into dir list				*/  int			max_blocks;    BEGIN ; 	char		dir_name[40];					/* What directory? Too long?				*/ ; 	char 		master[20];					/* Non descriptor master name				*/ : 	char		root_dir[35];					/* Non descriptor root name				*/6 	char 		histogram[51];					/* Histogram string 					*/ 	float		percent;				 	char 		what_disk[11]; 	static 	int	printed = TRUE;  * 	if (dir_list[disk][index].dir_depth == 1) 	BEGINK 		strcpy (what_disk, (char *) (strrchr (disk_totals[disk].name, '$') + 1));  		if (printed) 		BEGIN   			print_int_complete_header (); 			printed = FALSE;  		END  		 	END 	else  		strcpy (what_disk, "  ");  	  	if (check_flags (disk, index))    	BEGIN 		printed = TRUE; C 		compute_percent_and_histogram (	dir_list[disk][index].cum_blocks,  						max_blocks,  						&percent, 	 						2,   						histogram );  K 		check_dir_name (dir_list[disk][index].name,		/* Dir name too long?					*/  				30, dir_name);  A 		fprintf (fp,  	"%-10s %-30s %5d %5d  %7d  %7d %5.1f%% %-50s\n",  				what_disk,0 				dir_name, /* 	dir_list[disk][index].name, */* 				dir_list[disk][index].act_total_files,$ 				dir_list[disk][index].cum_files,% 				dir_list[disk][index].act_blocks, % 				dir_list[disk][index].cum_blocks,  				percent, 				histogram );   		page_check ();   	END 	  END    PROC write_complete_report ()    BEGIN 
 	int i, j;  ! 	print_complete_report_header ();   ' 	for (i=1; i <= input_file_number; i++) 4   	    for (j=2; j <= disk_totals[i].dir_count; j++)? 		write_complete_report_line (i, j, disk_totals[i].max_blocks);  		 END   