 #include stdio #include descrip #include "sysdefs:stcdefs"   /*+   *  NAMEM  *	process_long_link_command -- handles link command over 254 characters long   *  *  DESCRIPTION F  *	This routine was written as a fix to LNKCHK because of a limitationI  *	in the LIB$DO_COMMAND RTL routine.  The limitation is that it can only P  *	execute a command under 255 characters long.  For SOGS, this is insufficient.,  *	A vendor SPR has been filed against this.  *L  *	So this routine places the LINK command into a DCL command file where theW  *	command length limitation is not as restrictive.  LNKCHK then executes the COM file.   *  *  RETURN VALUE(  *	TRUE - COM file created successfully.-  *	FALSE - COM file NOT created successfully.   *  *  HISTORY +  *	7/14/88 		Bauer		Initial implementation.  -*/   4 process_long_link_command (from_command,  exec_name)  H struct dsc$descriptor 	*from_command, 						/* Link command string				*/* 			*exec_name;						/* COM file name				*/   BEGIN > 	char	c_command[1024];						/* C string with link command			*/@ 	char	c_exec_name[128];						/* C string with COM file name			*/( 	FILE	*fp;								/* File pointer					*/G 	int 	i, j, k, len, last_mark_i, last_mark_j;				/* Counters ...					*/ @ 	char    line[233];							/* Used to print lines in COM file		*/  Y 	strcpy_D (c_command, from_command);					/* Copy command into C string for processing.	*/  	len = strlen(c_command);   P 	strcpy_D (c_exec_name, exec_name);					/* Copy COM file name into C string 		*/  Z 	if ( (fp=fopen(c_exec_name, "w")) == NULL)				/* Open COM file - return FALSE if error	*/
 		return (0);  	else  	BEGINV 		fprintf (fp, "$ SET NOON\n");					/* SPR.15439 - added to make sure set ver gets 	*/$ 										/* 	       turned off			*/+ 		fprintf (fp, "$ VERIFY = F$VERIFY(1)\n");   Q 		for (k=0; k < len; k++)						/* Print everything up to the first space which */ A 		BEGIN								/* where the list of OBJ, OPTs, and LIBs starts	*/  			line[k] = c_command[k]; 			if (c_command[k] == ' ')  			BEGIN 			    line[k+1] = NULL;& 			    fprintf (fp, "$ %s -\n", line);
 			    break;  			END 		END   H 		last_mark_i = 0;						/* Fit as many OBJs, OPTs, and LIBs on a line	*/A 		last_mark_j = 0;						/* as is possible - COMMA is the key.		*/    		j = 0;  B 		for (i=k+1; i < len; i++)					/* Process rest of the string			*/ 		BEGIN  		    line[j++] = c_command[i];   @   		    if (c_command[i] == ',')					/* Comma is seperator				*/ 	 	    BEGIN 			if (j < 79) 			BEGIN 				last_mark_i = i; 				last_mark_j = j; 			END 			else  			BEGINO 				if (last_mark_j == 0)				/* For thos cases where one entry ober 79 chars	*/  					line[j] = NULL; 				else
 				BEGIN	 					i = last_mark_i;  					line[last_mark_j] = NULL; 				END   S 				fprintf (fp, "%s -\n", line);			/* Print out the line with CONTINUATION mark	*/  				last_mark_j = 0;
 				j = 0;
 			END					 		    END  		END   9 		if (j > 0)							/* Print out last chunk of command		*/  		BEGIN  			line[j] = NULL; 			fprintf (fp, "%s\n", line); 		END;  2 		fprintf (fp, "$ DELETE/LOG %s;\n", c_exec_name);; 		fprintf (fp, "$ IF VERIFY .EQ. 0 THEN $ SET NOVERIFY\n");    		fclose (fp);  
 		return (1);  	END		   END    /*+   *  NAME9  *	strcpy_D --  copy descriptor string to normal C string   *  *  DESCRIPTION *  *	Copies a descriptor string to a normal ,  * 	C string - adds a NULL to the C string 	  *  *  RETURN VALUE  *  *  HISTORY +  *	3/28/88		Bauer			Initial implementation.  -*/   & PROC strcpy_D (into_string, from_D)			  6 char			into_string[];						/* Destination string				*/; struct dsc$descriptor 	*from_D;						/* Source string				*/    BEGIN    	strncpy(into_string,							 		from_D->dsc$a_pointer, 		from_D->dsc$w_length ); * 	into_string[from_D->dsc$w_length] = NULL;   END 