 /*+   *  NAME-  *	rcms.h -- include file for Remote Cms tool   *  *  DESCRIPTION 7  *	This file contains primarily message formats for the :  *	messages passed back and forth to the Remote CMS CLIENT  *	and SERVER processes.  *  *  RETURN VALUE  *  *  HISTORY (  *	7/88 		Bauer		Initial implementation. -*/    #define		MAX_ERROR_STACK 	6  #define		MAX_STATUS_TEXT		258   #define		MAX_CMS_OUTPUT_LINE	258 #define 	MAX_CMS_LIBNAME		132 " #define		MAX_DEFAULT_DIRECTORY	132 #define		MAX_CMS_COMMAND		256  #define		MAX_CMS_PARAMETER	132 #define		MAX_CMS_REMARK 		256      #define 	CMS_COMMAND		1  #define		CMS_PARAMETER		2  #define		CMS_REMARK		3 #define		HANDSHAKE		4  #define		EXIT_RCMS		5  #define		STATUS			10 #define		NEED_PARAMETER		11  #define		CMS_OUTPUT		12  #define		NEED_REMARK 		13    /*  ^ 	CLIENT Sent Messages - the following messages arre sent by the client and read by the SERVER.   */  N typedef struct							/* Message Header Structure for messages from Client 		*/ { ; 	int	message_code;					/* Message Codes =	1  -  CMS command  											2  -  CMS parameter 											3  -  CMS remark  											4  -  Handshake  											5  -  EXIT/ABORT			*/8 	int	message_size;					/* How big is this message					*/D 	char	cms_library[MAX_CMS_LIBNAME];			/* Current CMS library						*/S 	char	default_directory[MAX_DEFAULT_DIRECTORY];	/* Current default directory					*/    } CLIENT_MESSAGE_HEADER;  A #define		CLIENT_MESSAGE_HEADER_SIZE	sizeof(CLIENT_MESSAGE_HEADER)    typedef struct { " 	CLIENT_MESSAGE_HEADER	header;				% 	char			cms_command[MAX_CMS_COMMAND];    } CMS_COMMAND_MESSAGE;  = #define		CMS_COMMAND_MESSAGE_SIZE	sizeof(CMS_COMMAND_MESSAGE)      typedef struct { " 	CLIENT_MESSAGE_HEADER	header;				) 	char			cms_parameter[MAX_CMS_PARAMETER];    } CMS_PARAMETER_MESSAGE;  A #define		CMS_PARAMETER_MESSAGE_SIZE	sizeof(CMS_PARAMETER_MESSAGE)      typedef struct { " 	CLIENT_MESSAGE_HEADER	header;				# 	char			cms_remark[MAX_CMS_REMARK];    } CMS_REMARK_MESSAGE;   < #define		CMS_REMARK_MESSAGE_SIZE		sizeof(CMS_REMARK_MESSAGE)     /*  ] 	SERVER Sent Messages - the following messages are sent by the server and read by the CLIENT.    */  N typedef struct							/* Message Header Structure for messages from Server 		*/ { ; 	int	message_code;					/* Message Codes =	4    -  Handshake  											10   -  Status ) 											11   -  Need CMS parameter		*/ 8 	int	message_size;					/* How big is this message					*/   } SERVER_MESSAGE_HEADER;  A #define		SERVER_MESSAGE_HEADER_SIZE	sizeof(SERVER_MESSAGE_HEADER)      typedef struct { " 	SERVER_MESSAGE_HEADER	header;				 	int			more_messages;  	char			text[MAX_STATUS_TEXT];   } STATUS_MESSAGE;   4 #define		STATUS_MESSAGE_SIZE		sizeof(STATUS_MESSAGE)     typedef struct { " 	SERVER_MESSAGE_HEADER	header;				, 	char			parameter_prompt[MAX_CMS_PARAMETER];   } NEED_PARAMETER_MESSAGE;   C #define		NEED_PARAMETER_MESSAGE_SIZE	sizeof(NEED_PARAMETER_MESSAGE)    typedef struct { " 	SERVER_MESSAGE_HEADER	header;				, 	char			parameter_prompt[MAX_CMS_PARAMETER];   } NEED_REMARK_MESSAGE;  = #define		NEED_REMARK_MESSAGE_SIZE	sizeof(NEED_REMARK_MESSAGE)    typedef struct { " 	SERVER_MESSAGE_HEADER	header;				/ 	char			cms_output_string[MAX_CMS_OUTPUT_LINE];    } CMS_OUTPUT_LINE;  6 #define		CMS_OUTPUT_LINE_SIZE		sizeof(CMS_OUTPUT_LINE)       #define			CLIENT			1 #define			SERVER			2    $ typedef char MESSAGE_BUFFER[1024];		