 /*+   *  NAMEH  *	establish_link -- assigns channel for link in either server or client  *  *  DESCRIPTION H  *	This routine is called to establish the DECnet conection by executingG  *	a SYS$ASSIGN call to the appropriate device depending on whether the #  *	process is the client or server.   *  *  RETURN VALUE@  *	Exits with error status if remote connection not established.  *  *  HISTORY *  *	7/8/88 		Bauer		Initial implementation.  *8  *	20-FEB-1989	Richon		Do LIB$DELETE_LOGICAL on RCMS$LIB(  *					when connection fails.  Otherwise,  *					user cannot correct node name because+  *					code keeps failing on establish_link  -*/    /************/ /* Includes */ /************/ #include ssdef #include descrip #include "sysdefs:stcdefs" #include "devtools:rcms"     PROC establish_link ()   BEGIN = 	extern int	      process_type;				/* CLIENT or SERVER					*/ ; 	extern int	      channel;					/* QIO channel number					*/ ) 	extern char	      server_node_name[];			 > 	int		      status;					/* For checking sys$assign status			*/ 	char		      device_name[50]; N 	struct dsc$descriptor device_D;					/* Name of device to be connected to			*/O 	struct dsc$descriptor translated_logical_D;			/* Translated logical name				*/   P 	struct dsc$descriptor logical_name_D;				/* used for RCMS$LIB in job table			*/' 	struct dsc$descriptor logical_table_D;   L 	create_descriptor (&device_D, "SYS$NET");			/* Set up descriptors ...				*/+ 	create_descriptor (&translated_logical_D,  L 			   "                                                                  ");  1 	create_descriptor(&logical_name_D,  "RCMS$LIB"); 0 	create_descriptor(&logical_table_D, "LNM$JOB");  q 	if (c_trnlog(&device_D, &translated_logical_D) == SS$_NORMAL)	/* See if SYS$NET is defines which means this 		*/ , 	BEGIN								/* is the SERVER process				*/   		process_type = SERVER;					   1 		status = sys$assign(&device_D, &channel, 0, 0);   9 		if ( (status != SS$_REMOTE) && (status != SS$_NORMAL) )  		BEGIN a 			printf ("%%RCMS-F-CANT_ESTABLISH_LINK, Can't establish link at remote node for SERVER (%d)\n", 
 					status); < 			LIB$DELETE_LOGICAL( &logical_name_D , &logical_table_D ); 			exit(status); 		END  	END   	else  	BEGIN= 		sprintf (device_name, "%s\"TASK=RCMS\"", server_node_name);   L 		create_descriptor (	&device_D,			/* Set up descriptor for remote task			*/ 					device_name );   D 		process_type = CLIENT;					/* We must be the client task here			*/  1 		status = sys$assign(&device_D, &channel, 0, 0);    		if (status != SS$_REMOTE)  		BEGIN S 			printf ("%%RCMS-F-CANT_ESTABLISH_LINK, Can't establish link from CLIENT (%d)\n", 
 					status); < 			LIB$DELETE_LOGICAL( &logical_name_D , &logical_table_D ); 			exit(status); 		END    	END   END 