 /*+   *  NAME=  *	execute_cms_command -- module with routines to execute CMS $  *			       commands on SERVER node.  *  *  DESCRIPTION 9  *	This module contains 4 routines, 1 to execute the CMS  9  *	comamnd, and 3 of the 4 callback routines (other is in   *	rcms_cms_message_handler.c).   *  *  RETURN VALUE  *  *  HISTORY *  *	7/8/88 		Bauer		Initial implementation. -*/    /************/ /* Includes */ /************/ #include ssdef #include descrip #include "sysdefs:stcdefs" #include "rcms"    /*+   *  NAME>  *	cms_output_routine -- send CMS output to CLIENT for display  *  *  DESCRIPTION <  *	This is the output callback routine for the CMS$CMS call.:  *	It sends all output accross to the client where it gets
  *	displayed.   *9  *	THis routine gets called once for every line of output $  *	to be shipped over to the CLIENT.  *  *  RETURN VALUE  *  *  HISTORY (  *	7/88 		Bauer		Initial implementation. -*/   & cms_output_routine ( string_id, flag )  # struct dsc$descriptor 	**string_id; 
 int 			*flag;    BEGIN  	char			line[257]; 	int			status;A 	CMS_OUTPUT_LINE		output_line;				/* Message sent to client				*/  	char			*string;  < 	if (*flag != 1) 						/* Don't do this when flag is 1				*/ 	BEGIN 		string = *string_id;   		strcpy_D (line, string);  Q 		setup_server_message_header (	&output_line,		/* Set up ouput line message				*/  						CMS_OUTPUT,  						CMS_OUTPUT_LINE_SIZE );   ' 		strcpy(output_line.cms_output_string,  		       line );  ? 		send_message (&output_line);				/* Send line to CLIENT					*/  	END  + 	return(1);							/* Always return 1					*/  END    /*+   *  NAME?  *	cms_prompt_routine -- callback prompting routine for CMS$CMS   *  *  DESCRIPTION A  *	This is the callback routine that gets executed when the user  =  *	issues 	an incomplete CMS command.  It gets the parameter  <  *	prompt and sends it over to the CLIENT process asking him=  *	to send more info.  Upon reading the additional info, this 3  *	routine gives it back to CMS via CMS$PUT_STRING.   *.  *	THis routine also handles Remark: requests.  *  *  RETURN VALUE  *	Always 1.  *  *  HISTORY (  *	7/88 		Bauer		Initial implementation. -*/   & cms_prompt_routine ( string_id, flag )  # struct dsc$descriptor 	**string_id; 
 int 			*flag;    BEGIN 5 	char 		      	prompt_string[100];			/* Prompt					*/ E 	struct dsc$descriptor 	parameter_D;				/* Parameter descriptor				*/  	int			status;G 	CMS_PARAMETER_MESSAGE	*cms_parameter;				/* For reading parameter			*/ O 	NEED_PARAMETER_MESSAGE	need_parameter;				/* For sending parameter prompt			*/ : 	MESSAGE_BUFFER		message;				/* For reading messages				*/ 	char			*string;   #ifdef DEBUG-   printf("\t\tCMSPROMPT flag = %d\n", *flag);  #endif 	string = *string_id;   " 	strcpy_D (prompt_string, string);  : 	if (flag == 2)							/* Need a remark, not a paramter		*/ 	BEGIN7 		setup_server_message_header (	&need_parameter.header,  						NEED_REMARK,  						NEED_REMARK_MESSAGE_SIZE);  ) 		strcpy(need_parameter.parameter_prompt,  		       prompt_string); 	END& 	else								/* Need a paramater				*/ 	BEGIN7 		setup_server_message_header (	&need_parameter.header,  						NEED_PARAMETER, # 						NEED_PARAMETER_MESSAGE_SIZE);   ) 		strcpy(need_parameter.parameter_prompt,  		       prompt_string);   	END;   G 	send_message (&need_parameter);					/* Send request for more info			*/   6 	read_message (&message);					/* Read back reply				*/  I 	cms_parameter = (CMS_PARAMETER_MESSAGE *) &message;		/* Interpret					*/   V 	if ( (cms_parameter->header.message_code != CMS_PARAMETER) &&	/* Valid reply???				*/: 	     (cms_parameter->header.message_code != CMS_REMARK) ) 	BEGINA 		printf("%%RCMS-E-NEEDPARAM, Server expecting parameter (%d)\n", ' 			cms_parameter->header.message_code);  		sys$exit(1); 	END  @ 	create_descriptor (&parameter_D, cms_parameter->cms_parameter);  @ 	cms$put_string ( &parameter_D );				/* Give it to CMS$CMS				*/  + 	return (1);							/* Always return 1				*/  END    /*+   *  NAME5  *	cms_prompt_routine -- handles /CONFIRM for CMS$CMS   *  *  DESCRIPTION 4  *	This routine is a copy of the above and interacts@  *	with the client as if this was just another needed parameter.  *  *  RETURN VALUE  *	Always 1.  *  *  HISTORY (  *	7/88 		Bauer		Initial implementation. -*/   ! cms_confirm_routine ( string_id )   # struct dsc$descriptor 	**string_id;    BEGIN = 	char 		      	prompt_string[100];			/* Confirm prompt					*/ R 	struct dsc$descriptor 	parameter_D;				/* For giving confirm back to CMS$CMS			*/; 	int			status;					/* Same as above cms_prompt_routine			*/ & 	CMS_PARAMETER_MESSAGE	*cms_parameter;' 	NEED_PARAMETER_MESSAGE	need_parameter;  	MESSAGE_BUFFER		message;  	char			*string;  3 	string = *string_id;						/* Get the prompt					*/   " 	strcpy_D (prompt_string, string);  Z 	setup_server_message_header (	&need_parameter.header,		/* Set up message for client				*/ 					NEED_PARAMETER," 					NEED_PARAMETER_MESSAGE_SIZE);  ( 	strcpy(need_parameter.parameter_prompt, 	       prompt_string);   C 	send_message (&need_parameter);					/* Hey CLIENT, Y,N,Q,ALL				*/   = 	read_message (&message);					/* Hey server, read this!				*/   4 	cms_parameter = (CMS_PARAMETER_MESSAGE *) &message;  O 	if (cms_parameter->header.message_code != CMS_PARAMETER)	/* Verify ...						*/  	BEGINL 		printf("%%RCMS-E-NEEDPARAM, Server expecting confirmation message (%d)\n",' 			cms_parameter->header.message_code);  		sys$exit(1); 	END  @ 	create_descriptor (&parameter_D, cms_parameter->cms_parameter);  ; 	cms$put_string ( &parameter_D );				/* Give to CMS						*/   
 	return (1);	    END    /*+   *  NAMEC  *	execute_cms_command -- executes a CLIENT cms command via CMS$CMS   *  *  DESCRIPTION E  *	This is the major routine for the SERVER process where he executes B  *	CMS commands via the CMS$CMS routine.  It handles prompting forA  *	unspecified parameters, remarks, and confirmations.  It queues 8  *	up %CMS messages and sends output back to the CLIENT.  *  *  RETURN VALUE  *  *  HISTORY (  *	7/88 		Bauer		Initial implementation. -*/   4 PROC execute_cms_command (command_line, send_status)  9 char	command_line[];							/* Execute what command					*/ P int	send_status;							/* 0 - means SET LIBRARY - special case send no status	*/   BEGIN   	STATUS_MESSAGE		status_message;% 	struct dsc$descriptor	cms_command_D;  	int			status;	 	int			i; % 	extern int 		cms_message_handler (); 7 	extern char 		cms_message_stack[MAX_ERROR_STACK][133]; $ 	extern int		cms_message_stack_size; 	globalvalue 		CMS$_NOREF;  ` 	create_descriptor (&cms_command_D, command_line);		/* Create descriptor for CMS$CMS command		*/  & 									/* Execute the command					*/? 	status = cms$cms (	&cms_command_D, 			/* Command string					*/ ; 		 		cms_message_handler, 			/* Message handler %CMS					*/ A 				cms_prompt_routine,			/* Parmeter, Remark prompt handler			*/ 4 				cms_confirm_routine,			/* Confirm handler					*/2 				cms_output_routine,			/* Output handler					*/ 				0 );  b  	if ( (send_status) || (status == CMS$_NOREF) ) 			/* Send status back if not startup SET LIB		*/ 	BEGIN	 X 	    setup_server_message_header (&status_message.header,	/* Set up status message				*/
 					 STATUS,  					 STATUS_MESSAGE_SIZE);   N 	    if (cms_message_stack_size > 0)				/* Send over queued %CMS messages			*/
 	    BEGIN. 		for (i=0; i < cms_message_stack_size-1; i++) 		BEGIN   			strcpy( status_message.text,  				cms_message_stack[i]);Q 			status_message.more_messages = TRUE;		/* Tells CLIENT more are coming ...			*/ " 			send_message (&status_message); 		END   4 		strcpy(status_message.text, cms_message_stack[i]);D 		status_message.more_messages = FALSE;			/* Last message ...					*/! 		send_message (&status_message);  	    END	 	    else < 	    BEGIN							/* No status to report - all went well			*/" 		strcpy(status_message.text, "");' 		status_message.more_messages = FALSE; ! 		send_message (&status_message);    	    END 	END  ; 	cms_message_stack_size = 0;					/* Clear stack size					*/  END 