 /*+   *  NAME0  *	rcms_main -- main program for Remote CMS Tool  *  *  DESCRIPTION D  *	The Remote CMS tool allows access to CMS libraries on a differentD  *	NODE than your current node.  This is a feature not found in CMS.  *!  *	The software works as follows:   *6  *		There are two co-operating processes.  One is the 6  *		CLIENT process that is on your current node.  This7  *		is the process that recieves all the RCMS commands, 8  *		and interacts directly to you.  The other process is<  *		the remote process, known as the SERVER, and it recieves=  *		CMS commands from the CLIENT across the DECNet interface, A  *		executes tehm locally, and sends any output (files, messages, =  *		or screen output) back to the CLIENT for display on your  
  *		terminal.   *D  *	The software for both processes is housed in the same executable.I  *	Some of the modules are shared betwwen the client and server, some are G  *	unique.  The software determines which process (CLIENT or SERVER) is D  *	running and sets a global flag which gets checked occasionaly to -  *	set cetain process-specific actions/tasks.   *  *F  *	The software consists of mainly C modules with three SCAN routines H  *	called to get the default directory or to SCAN certain RCMS commands.  *H  *	The server process uses the callbale CMS interface CMS$CMS to executeJ  *	the cms commands at the remote node.  All output is trapped and shipped'  *	across DECNet to the CLIENT process.   *  *  *  RETURN VALUE  *  *  HISTORY +  *	7/11/88 		Bauer		Initial implementation.  -*/    /************/ /* Includes */ /************/ #include descrip #include ssdef #include rms #include "sysdefs:stcdefs" #include "devtools:rcms"    
 /***********/ 
 /* Globals */  /***********/	1 char			node_name[25];						/* Current Node					*/ : char			server_node_name[25];					/* Server node name				*/C struct dsc$descriptor	node_D;							/* Current node descriptor			*/ R char 			full_cms_library[256];					/* Remote CMS library name (node + library) 	*/L char			current_cms_library[128];				/* Remote CMS library (library only)		*/9 char			current_directory[128];					/* SHOW DEFAULT					*/ O struct dsc$descriptor	current_directory_D;					/* Descriptor for above ...			*/ 2 int			process_type;						/* CLIENT or SERVER				*/5 int			channel;						/* QIO channel across DECNet			*/ R char 			cms_message_stack[MAX_ERROR_STACK][133];		/* Server CMS message stack			*/ int			cms_message_stack_size=0; A int			interactive_mode = FALSE;				/* Client RCMS> mode flag			*/ F int			force_prompt;						/* Used for lib$get_input, lib$get_foreign	*/     main (argc, argv)   	 int	argc; 
 char	*argv[];    BEGIN  	int	status;							 : 	char	command_line[257];					/* Stores command line					*/? 	char	temp_node[25];						/* Holding buffer for node name				*/  	int	second_blank;I 	current_directory[0]   = NULL;					/* NULL out some global strings				*/  	current_cms_library[0] = NULL;  	server_node_name[0]    = NULL;   A 	process_type = CLIENT;						/* Assume CLIENT process first				*/   P 	if (argc == 2)							/* if argc = 2 and "server" then its the SERVER process	*/P 		if (strcmp(argv[1], "server") == NULL)			/* this is hardwired in RCMS.COM			*/ 			process_type = SERVER;   Y 	if (process_type == CLIENT)					/* The next chunck os software deals with the CLIENT 	*/ G 	BEGIN								/* see if a remote CMS librayr has been set yet or not	*/ @ 									/* The first RCMS command in a session to be issued 	*// 									/* must be a RCMS SET LIB command			*/   > 		status = translate_cmslib ();				/* RCMS$LIB defined?					*/   		if (!status) 		BEGIN S 			get_first_command (command_line);		/* No - first command better be a set lib		*/ + 			if (!set_library_command (command_line))  			BEGINE 			    printf("%%RCMS-E-REMLIBNOTSET, Remote library not defined\n"); ] 			    printf("-RCMS-E-REMLIBNOTSET, You must issue a RCMS SET LIB node::library command\n");  			    sys$exit(1);  			END 			else  			BEGINX 				define_cmslib (	 full_cms_library );	/* It is so define RCMS$LIB and retranslate		*/! 				status = translate_cmslib ();    				if (!interactive_mode) 					sys$exit(1);    			END 		END  		else_ 			if (set_library_command (command_line))		/* RCMS$LIB defined but check for set lib anyway	*/  			BEGIN( 				define_cmslib (	 full_cms_library );! 				status = translate_cmslib ();  			END   	END  M 	establish_link ();						/* Establish link (client fires up SERVER process	*/   J 	handshake ();							/* Make sure comunications between processes is OK	*/   	if (process_type == CLIENT) 	BEGINU 		get_node_name ( temp_node );				/* Get node name for /INPUT and /OUTPUT commands	*/   		strcpy (node_name, temp_node);P 		create_descriptor (&node_D, node_name);			/* Store it in this descriptor				*/   		if (command_line[0] == NULL)	 $ 			get_first_command (command_line);  E 		if (interactive_mode)					/* Loop on RCMS> prompt until Ctrl-Z			*/  		BEGIN  			do  			BEGIN- 				if (!set_library_command (command_line))	 C 					send_cms_command (command_line); /* Send the CMS command				*/  				else	 				BEGIN ) 					define_cmslib (	 full_cms_library ); 1 					send_cms_set_library_command (command_line);  				END   0 			END  while (get_input_command (command_line) L 				    != RMS$_EOF); 			/* Process until ^Z or EXIT or SERVER goes away		*/ 		END  		elseC 			send_cms_command (command_line);		/* One time CMS command					*/  	END 	 , 	else								/* process_type == SERVER				*/ 	BEGIN< 		for (;;)						/* Read commands until client goes away			*/ 			read_cms_command ();    	END   END 