 /*+   *  NAME6  *	read_cms_command -- reads a CLIENT send CMS command  *  *  DESCRIPTION 9  *	This routine is called by the SERVEr to read a CLIENT  A  * 	CMS command.  It checks to see if the CMS library needs to be @  *	set before executing the command, and if so sets the library.  *  *  RETURN VALUE  *  *  HISTORY *  *	7/12/88 	Bauer		Initial implementation. -*/    /************/ /* Includes */ /************/ #include "sysdefs:stcdefs" #include "rcms"    PROC read_cms_command ()   BEGIN , 	int			status;					/* Return statuses					*/6 	char			command[256];				/* For set lib command					*/E 	CMS_COMMAND_MESSAGE 	*cms_command;				/* Points to CMS message				*/ : 	MESSAGE_BUFFER		message;				/* Read message buffer					*/B 	extern 	char		current_cms_library[];			/* CMS library name					*/  N 	status = read_message (&message);				/* Read the CMS command from CLIENT			*/  ^ 	cms_command = (CMS_COMMAND_MESSAGE *) &message;			/* Overlay the command message pointer			*/  ^ 	if (cms_command->header.message_code != CMS_COMMAND)		/* Verify message is a CMS command			*/ 	BEGIN_             printf ("%%RCMS-F-NO_CMS_COMMAND, Command not recieved from CLIENT process (%d)\n", . 	           cms_command->header.message_code);  	    exit (status); 	END  U 	if (current_cms_library[0] == NULL)				/* Check CMS library to see if it defined		*/  	BEGINH 		sprintf (command, "SET LIBRARY %s", 			/* No - so set lib first 				*/% 			 cms_command->header.cms_library); A 		strcpy (current_cms_library, 				/* Remember the command					*/ $ 			cms_command->header.cms_library);J 		execute_cms_command (command, 0);			/* Execute the SET LIB command				*/: 									/* 0 as second parameter means send no status		*/ 	END  \ 	execute_cms_command (cms_command->cms_command, 1);		/* Execute the CLIENT send command			*/   END 