 /*+   *  NAMEE  *	show_merged_classes --  generates a report showing all of elements 3  *				of a "pending" CMS library class vs. an "spr" !  *				set of CMS library classes.   *  *  DESCRIPTION J  *		The SHOW MERGED CMS CLASSES tools is used compare a set of CMS classesJ  *		to a specific PENDING CMS class .  The comparision shows if there are O  *		any elements that have not been merged from the "set of classes" (typically K  *		SPR and OPR classes) into the pending CMS class.  It also shows if any  K  *		elements found in the pending CMS class are NOT in another class in the   *		"set of classes".   *=  *		This software is restricted to ONE CMS LIBRARY at a time.   *N  *		This software gets called from a command file: SMC.COM, which performs the  *		following tasks:"  *			    1. Map to the CMS libraryR  *			    2. Dump contents of pending CMS class to file called PENDING_CLASS.REPORTM  *			    3. Dump contents of "set of classes" to file called SPR_CLASS.REPORT @  *			    4. Call show_merged_classes with appropriate parameters  *  *   		Calling Sequence:  *B  *				$ SHMC <pending report file> <set of classes report file> - 5  *					<cms library name> <output report file name> - "  *					[<ALL_PENDING>] [<ALL_SPR>]  *    J  *				All parameters must be specified  - there are NO default parameters.  *X  *		Examples:	$ SHMC pending_class.report spr_class.report oss_cms oss.show_merge_reportM  *				$ SHMC pending_class.report spr_class.report oss_cms sys$output ALL_SPR   *  *  *  RETURN VALUE  *	   *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation. *  *	4/5/88		Bauer			Added sys$putmsg calls.L  *	4/14/88		Bauer			Added check to see if a subclass is also in the SPR list)  *						and if not flag it on the report. <  * 	5/23/88		Bauer			Increased MAX_ELEMENTS from 300 to 550.6  *	7/19/88		""			Added /NO_HEADER swith to get rid of 9  *						subclass, reserved, and descendant element lists. 9  *						Also bumped subclass list and element name sizes.  -*/    /************/ /* Includes */ /************/ #include stdio #include descrip #include "sysdefs:stcdefs"   /*************/  /* Constants */  /*************/  #define		MAX_ELEMENT_NAME	40 #define		MAX_USER_NAME		15 #define		MAX_CLASS_NAME		40  #define		MAX_ELEMENTS 		3000 #define		MAX_LINE 		255  #define		MAX_SPR_CLASSES		150  #define		MAX_SUB_CLASSES		400 ! #define		MAX_GENERATION_NUMBER	10  #define		MAX_TEMP_LIST		100   M #define		ELEMENT_IS_NOT_USED	0					/* For ELEMENT_INFO.element_used field		*/  #define		GENERATION_MISMATCH	1 #define		ELEMENT_IS_USED		2   # #define		ALL_PENDING		"all_pending"  #define		ALL_SPR			"all_spr"& #define		NO_SUBCLASSES 		"table_only" N #define		OK_OR_NOT_OK		""					/* Used in report when all elements are printed : 										   out under status field - mioght want to make $ 										   this "(OK)" later				*/% #define		DESCR		struct dsc$descriptor    /*********/  /* TYPES */  /*********/   < typedef struct									/* Holds data for one CMS element		*/ BEGIN D 	char	element_name[MAX_ELEMENT_NAME+1];				/* CMS Element name				*/a 	char 	generation_number[MAX_GENERATION_NUMBER+1];			/* CMS Generation number - must be a string  ) 										   because of CMS variants			*/ _ 	char	gen_error[MAX_GENERATION_NUMBER+1];				/* Shows if there is older generation somewhere */ 7 	short	element_used;							/* See #defines above 				*/ > 	short	element_reserved;						/* 1 if element is reserved			*/F 	char	user_name[MAX_USER_NAME+1];					/* Name of user if reserved			*/   END ELEMENT_INFO;   ; typedef struct									/* Holds data for one CMS class			*/  BEGIN ? 	char		class_name[MAX_CLASS_NAME+1];				/* CMS class name				*/ C 	int		number_of_elements;					/* How many elements in the class		*/ \ 	ELEMENT_INFO 	**elements;  /*MAX_ELEMENTS];	 */				/* Array of this element information		*/B 	int		unmerged_status;					/* Are there any unmerged elements?		*/   END CLASS_INFO;   
 /***********/ 
 /* Globals */ 
 /***********/ 8 	int		ldb[50];						/* CMS Library Data Block buffer		*/Q 	int 		first_merge_error = TRUE;				/* So you only see SYS$PUTMSG warning once	*/ < 	DESCR 		library_D;						/* For callable CMS and putmsg			*/> 	CLASS_INFO	pending_class;						/* CMS Pending class data			*/G 	int		number_of_spr_classes;					/* How many SPR classes are there?		*/ H 	CLASS_INFO	spr_classes[MAX_SPR_CLASSES];				/* CMS SPR class data				*/K 	BOOLEAN 	reset_search = TRUE;					/* Flag that causes pending class to be  * 										   searched from the start 			*/c 	char		sub_class_list[MAX_SUB_CLASSES][MAX_CLASS_NAME+1];	/* List of pending class sub classses		*/ ? 	int		sub_class_list_size = 0;				/* How big is this list?			*/      /*+   *  NAME9  *	create_descriptor --  creates a VMS string descriptor    *  *  DESCRIPTION =  *	This routine creates a VMS string descriptor from a normal   *	C string.  *  *  RETURN VALUE  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/   , PROC create_descriptor ( d_pointer, string )  C struct dsc$descriptor 		*d_pointer;					/* Descriptor pointer				*/ < char				*string;					/* String to go into the descriptor		*/   BEGIN / 	d_pointer->dsc$w_length = strlen (string);				 @ 	d_pointer->dsc$a_pointer = malloc(d_pointer->dsc$w_length + 1);+ 	strcpy (d_pointer->dsc$a_pointer, string); ( 	d_pointer->dsc$b_dtype = DSC$K_DTYPE_T;( 	d_pointer->dsc$b_class = DSC$K_CLASS_S;   END      /*+   *  NAME&  *	strcpy_D --  copy descriptor string  *  *  DESCRIPTION 4  * 	Copies a descriptor string to a normal C string #  *	and adds a NULL to the C string.   *  *  RETURN VALUE  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/   S PROC strcpy_D (into_string, from_D)						/* Copies a descriptor string to a normal  7 										   C string - adds a NULL to the C string 	*/   6 char		into_string[];							/* Destination string				*/, DESCR		*from_D;							/* Source string				*/   BEGIN  	strncpy(into_string,							 		from_D->dsc$a_pointer, 		from_D->dsc$w_length ); * 	into_string[from_D->dsc$w_length] = NULL; END   
 										   /*+   *  NAME@  *	add_to_sub_class_list -- maintains sorted list of class names  *  *  DESCRIPTION H  * 	This routine maintains the sorted global sub_class_list by insertingO  *	new class names into the list when necessary.  It gets called by get_classes H  * 	which is parsing the list of member classes of all the elements in a<  *	particular pending class.  Sort by Insertion_Sort method.  *  *  RETURN VALUE  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/   d PROC add_to_sub_class_list ( sub_class_string )					/* Maintains a sorted list of subclass names 	*/   char	sub_class_string[];   BEGIN ( 	int	i, j;								/* Loop counters				*/C 	int	compare; 							/* Stores result from compare of 2 strings 	*/ M 	BOOLEAN less_than; 							/* Flag denoting new string is at start of list */     F 	if (sub_class_list_size == 0)						/* First element in the list?			*/ 	BEGIN/ 		strcpy (sub_class_list[0], sub_class_string);  		sub_class_list_size = 1;	 		return;  	END  K 	less_than    = TRUE;							/* Assume we are adding to start of the list	*/ 
 										( 	for (i=0; i < sub_class_list_size; i++) 	BEGIN								T 		compare = strcmp(sub_class_string, 				/* Compare new sub class string to list		*/ 				 sub_class_list[i]);  > 		if (compare == 0)						/* Repeated class  - exit routine		*/
 			return;L 		else if (compare < 0)						/* Exit loop - found a spot to insert class 	*/	 			break;  		else 		BEGIN  			less_than    = FALSE; 		END  	END  C 	sub_class_list_size ++;							/* Increment the class list size		*/ : 	if (less_than)								/* Insert at beginning of list			*/ 	BEGINN 		for (j=sub_class_list_size-1; j > 0; j--)			/* Shift up the list by one			*/ 			strcpy(sub_class_list[j],   				sub_class_list[j-1]); U 		strcpy(sub_class_list[0], sub_class_string);			/* Copy the new string to 0 slot		*/  	END 	else J 		if (i < sub_class_list_size-1)					/* Are we at the end of the list?		*/ 		BEGIN X 			for (j=sub_class_list_size-1; j > i; j--)		/* No - so shift up a part of the list		*/ 				strcpy(sub_class_list[j],  					sub_class_list[j-1]);\ 			strcpy(sub_class_list[j], sub_class_string);		/* And copy new class string to jth slot	*/ 		END  		else 		BEGIN R 			strcpy(	sub_class_list[sub_class_list_size-1], 		/* Add to end of the list			*/ 				sub_class_string); 		END    END      /*+   *  NAMEU  *	ignore_cms_warnings --  CMS message callback routine that ignores warning messages   *  *  DESCRIPTION X  * 	This routine can be placed in the message routine parameter slot of any callable CMSV  *	routine if you want any CMS warning, information messages to be ignored when using   * 	the callable interface.   *  *  RETURN VALUE!  *	Always returns 1 (CMS$NORMAL).   *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/ 
 										g FUNCTION int ignore_cms_warnings ( sig1, sig2, ldb )				/* Bogus CMS message return so CMS warnings can , 										   be ignored and not printed			*/ int	sig1[16], sig2[5], ldb[50];    BEGIN  	return(1);  END      /*+   *  NAMEC  *	set_reservation_flag -- is the pending class element reserved???   *  *  DESCRIPTION X  * 	This routine is called by get_classes to see if the current element it is working onT  *	is reserved or not.  If it is it marks the pending class element as reserved and I  * 	stores the user name for the report.  This is a CMS callback routine.   *  *  RETURN VALUE!  *	Always returns 1 (CMS$NORMAL).   *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/   [ FUNCTION int set_reservation_flag (						/* Checks whether an element is reserved or not	*/ . 				new_element, ldb, pending_element_index, 	) 				element_id_D, generation_id_D, time,  ( 				user_id_D, remark_id_D, concurrent, % 				merge_generation_id_D, 	nonotes,   				nohistory, access, fred )   k int		*new_element, ldb[50], *time, pending_element_index;		/* Check Callable CMS manual for details here	*/ 7 DESCR 		**element_id_D, **generation_id_D, **user_id_D;  int		*concurrent; . DESCR		**remark_id_D, **merge_generation_id_D;* int		*nonotes, *nohistory, *access, *fred;   BEGINd  T 	if (*new_element == FALSE) 						/* Check to see if the same element is reserved */+ 	BEGIN									/* and if so ignore it				*/a
 		return (1);* 	END 	Cm 	pending_class.elements[pending_element_index]->element_reserved = TRUE;	/* Flag the element as reserved 		*/ q 	strcpy_D (pending_class.elements[pending_element_index]->user_name, 	/* Store user name who has file reserved	*/e 		  *user_id_D);   	return (1);   ENDi   h /*+d  *  NAME:  *	get_classes --  creates a sorted list of subclass names  *  *  DESCRIPTION Q  * 	This CMS callback routine gets called from a cms$show_generation call that ise  *	equivalent to a:a  *E  *			CMS SHOW GENERATION/MEMBER/GEN=<pending class name> /DESCENDANTS   *L  *	It then parses out all member classes and adds them into a sorted list ofN  *	subclass names by calling add_to_sub_class_list.  Each elements reservation  *	status is also checked.  *  *  RETURN VALUE!  *	Always returns 1 (CMS$NORMAL).   *  *  HISTORYe/  *	3/28/88	    	Bauer			Initial implementation.  -*/l  u FUNCTION int get_classes (new_element, ldb, uparm, element_id_D, 		/* Gets the classes from all pending generation */ ] 			generation_id_D, user_D, trans_time, 			/* elements in order to get the sorted subclass */s9 			create_time, rev_time, remark_id_D, 			/* list						*/l% 			class_list_D, format, attributes, s0 			rev_num, reservations, rec_size, rev_status )  U int		*new_element, *ldb, *uparm;					/* Check Callable CMS manual for details here	*/V4 DESCR 		**element_id_D, **generation_id_D, **user_D;* int		*trans_time, *create_time, *rev_time;% DESCR		**remark_id_D, **class_list_D;	% int		*format, *attributes, *rev_num, l( 		*reservations, *rec_size, *rev_status;   BEGIN										 B 	int		temp_list_size = 0;					/* Size of temporary class list			*/N 	BOOLEAN 	call_back = FALSE;					/* Tells whether second time around for	some	6 										   element because of bug in callable CMS	*/G 	BOOLEAN		is_pending;						/* Flag that tells whether element is in the/' 										   pending class or not				*/e7 	int		status, i, j;							/* Counters and such ...			*/ X 	char		temp_list[MAX_TEMP_LIST][MAX_CLASS_NAME+1];		/* Temporary list of class names		*/D 	char		list[1000], 						/* Buffer for list of class names seperated 										   by spaces					*/X3 			buf[MAX_CLASS_NAME+1];					/* Work buffer					*/dT 	char		element[MAX_CLASS_NAME+1], 				/* Stores the element name - easier than _D	*/U 			gen[MAX_GENERATION_NUMBER+1];				/* Stores the generation name - easier than _D	*/HL 	static int	pending_element_no = -1;				/* Index to pending element list		*/V 	static	char	old_element[MAX_CLASS_NAME+1];				/* Because of a bug in callable CMS		*/K 	static  BOOLEAN first_time=TRUE;					/* Used to initialize old_element		*/d  H 	if (first_time)								/* Set old_element to empty string first time	*/ 	BEGIN 		strcpy(old_element, ""); 		first_time = FALSE;* 	END  E 	strcpy_D (element, *element_id_D);					/* Extract element name				*/eF 	strcpy_D (gen, *generation_id_D);					/* Extract generation name			*/F 	strcpy_D (list, *class_list_D);						/* Extract class list names			*/     #ifdef CMSV2^ 	if (strcmp(old_element, element) == NULL)				/* Are we in callback mode - CMS callable bug	*/1 		call_back = TRUE;						/*			      workaround	*/a #elsem 	if (*new_element == 2)  	    call_back = TRUE;   #endif  P 	strcpy(old_element, element);						/* Remember the element name across calls	*/  I 	if (!call_back)								/* First time into this routine for an element	*/NI 		pending_element_no ++;						/* increment the pending element counter	*/   < 	is_pending = FALSE;							/* Assume not pending class 			*/ 	i = 0;  j = 0;o   #ifdef V3BUG< 	if (!call_back)								/* Any reservations on this guy?		*/( 		status = cms$show_reservations (  ldb, 					 set_reservation_flag,  					 pending_element_no,  					 *element_id_D, d 					 0,	 					 0,   					 ignore_cms_warnings, 					 0 ); s #endif  _ 	while (i < (*class_list_D)->dsc$w_length )				/* Loop through class string list picking out	*/T@ 	BEGIN									/* class names and checking whether in PENDING	*/ 		sscanf(&list[i], "%s", buf);  M 		if (strcmp(buf, pending_class.class_name) == NULL)		/* Pending class?				*// 		BEGINu> 			if (!call_back)						/* Assume no generation errors yet		*/G 				strcpy (pending_class.elements[pending_element_no]->gen_error, "");/   			is_pending = TRUE;= 		END	 		else 		BEGINa& 			if (temp_list_size < MAX_TEMP_LIST)U 				strcpy(temp_list[temp_list_size++], 		/* Store class name onto temporary list		*/]
 					buf); 			elsec= 				printf("Temporary class list too long for element %s\n", w 					element); 		END  		i += strlen(buf)+1;  	END  > 	if (!is_pending)							/* Descendant of pending class ...		*/ 	BEGIN? 		if (!call_back)							/* Generation error on this element		*/  		BEGINnB 			strcpy (pending_class.elements[pending_element_no]->gen_error, 
 				   gen );n 		END  	END 	elseCA 	BEGIN									/* Pending class element generation - add class	*/	- 										/* names to the sub class list			*/h$ 		for (i=0; i < temp_list_size; i++)* 			add_to_sub_class_list ( temp_list[i] ); 	END  D 	return (1);								/* Always return 1 in a CMS callback routine 	*/ END>
 										 1 /*+s  *  NAMEE  *	read_line -- reads a line from a CMS SHOW CLASS/CONTENTS data file_  *  *  DESCRIPTION_G  * 	This routine reads a line from a data file that was created by the yK  *	CMS SHOW CLASS/CONTENTS command.  It skips lines that contain CMS report   *	header line:   *"  *		Classes in DEC CMS library ...  *   *	and reads the following line.  *  *  RETURN VALUE  *  *  HISTORYn/  *	3/28/88	    	Bauer			Initial implementation.m -*/	  L PROC read_line (line, max, fp)							/* Reads a line from the CMS SHOW CLASS* 										   with CONTENTS input file			*/ char 	*line;
 int  	max;
 FILE 	*fp;   BEGIN*R 	char 	temp[MAX_LINE+1];						/* Read into temporary buffer - maybe unnecessary */  ? 	fgets (temp, MAX_LINE, fp);						/* Read into temp string			*/-  d 	if (strncmp("Classes in", temp, sizeof("Classes in")-1) == 0)		/* Ignore line CMS header lines 		*/ 	BEGIN= 		fgets (temp, MAX_LINE, fp);					/* Read the next line				*/i 	END 		= 	strcpy(line, temp);							/* Copy into return parameter			*/ = 	line[strlen(line)-1] = NULL;						/* Wipe out newline 				*/h   ENDp   g /*+l  *  NAMEI  *	open_class_report_file --  opens a CMS SHOW CLASS/CONTENTS report file   *  *  DESCRIPTION.B  * 	This routine opens a CMS SHOW CLASS/CONTENTS report input file5  *	and skips the first 2 lines that are header lines.i  *  *  RETURN VALUE/  *	File pointer upon success;  NULL upon error.s  *  *  HISTORYc/  *	3/28/88	    	Bauer			Initial implementation.o -*/n  2 FUNCTION FILE *open_class_report_file ( filename )   char 	filename[];    BEGINO. 	FILE	*fp;								/* Return file pointer				*/G 	char line[MAX_LINE+1];							/* Used for reading past header lines		*/r  C 	fp = fopen (filename, "r");						/* Open the file for reading			*/c  @ 	if (fp == NULL)								/* Check for errors opening the file		*/ 		return (NULL);
 										I 	read_line (line, MAX_LINE, fp);						/* Skip past CMS header lines 			*/cI 	read_line (line, MAX_LINE, fp);						/* Skip past CMS header lines 			*/	  9 	return (fp);								/* Bubble back the file pointer			*/s   END]     /*+(  *  NAMEI  *	read_class_report_file --  reads a CMS SHOW CLASS/CONTENTS report filea  *  *  DESCRIPTIONlP  * 	This routine reads one classes worth of data from a CMS SHOW CLASS/CONTENTS N  *	report input file and stores it into memory in a CLASS_INFO data structure.  *  *  RETURN VALUE  *  *  HISTORY	/  *	3/28/88	    	Bauer			Initial implementation.	 -*/j  Z PROC read_class_report_file ( class, fp )					/* Reads in a CMS SHOW CLASS with CONTENTS 	5 										   file into a CLASS_INFO data structure	*/s CLASS_INFO	*class; FILE 		*fp;    BEGINnE 	char	line[MAX_LINE+1];						/* Used to read a line of the report		*/)H 	int	number_of_elements = 0;						/* How many elements in this class		*/  0 	do									/* Read the class name in first			*/ 	BEGIN% 		read_line (line, MAX_LINE, fp);				   ) 		sscanf(line, "%s", &class->class_name);l   	END while (strlen(line) == 0);  	 > 	class->elements = (ELEMENT_INFO **) calloc (MAX_ELEMENTS, 4);  X 	read_line (line, MAX_LINE, fp);						/* Read in all the elements next til blank line */5 										/* extracting the element name and the 		*/*9 	while (strlen(line) > 0)						/* generation number				*/i 	BEGINW 		class->elements[number_of_elements] = (ELEMENT_INFO *) malloc (sizeof(ELEMENT_INFO));t   		sscanf (line, "%s", 6 			class->elements[number_of_elements]->element_name);4 		class->elements[number_of_elements]->element_used  			= ELEMENT_IS_NOT_USED;*T 		sscanf (&line[4+strlen(class->elements[number_of_elements]->element_name)], "%s", ; 			class->elements[number_of_elements]->generation_number);i 		number_of_elements++;s  ! 		read_line (line, MAX_LINE, fp);a 	END  ` 	class->number_of_elements = number_of_elements;				/* Store how many elements for that class	*/   END      /*+t  *  NAMEJ  *	open_report_file --  opens a the output show merged classes report file  *  *  DESCRIPTION @  * 	This routine opens the output report fiole for this utility.  *	Upon successful opening it:  *  *		1. Writes header line $  *		2. Writes the pending class name#  *		3. Writes out the subclass listr3  *		4. Writes out the questionable descendants lista4  *		5. Writes out the Reserved Pending elements list1  *		6. Finally, writes out column headers for the	!  *		   main section of the report*  *  *  RETURN VALUE/  *	File pointer upon success;  NULL upon error.m  *  *  HISTORYr/  *	3/28/88	    	Bauer			Initial implementation.n -*/	  h FUNCTION FILE *open_report_file ( 	pending_class_name, 			/* Opens the output report file for writing	*/L 					cms_library_name, 			/* and prints header info and other report data	*/ 					report_name )   char 	pending_class_name[], 	C 	cms_library_name[], e 	report_name[];*   BEGINd  4     FILE    *fp;								/* Return file pointer				*/-     int	    	i;								/* Loop counter					*/;J     BOOLEAN	first_time;							/* Flag denoting first print - used to make ' 										   report look "pretty"				*/m    Q     if ( (fp = fopen(report_name, "w")) == NULL)				/* Open the report file				*/  	return (NULL);g  %     fprintf(fp, 								/* 1.						*/lV "\n\n--------      CMS SHOW MERGED CLASSES REPORT FOR LIBRARY: %s     --------\n\n\n", 	    cms_library_name);    ]  A     fprintf(fp, "Pending Class Name:     %s\n",					/* 2.						*/_ 		pending_class_name);  >     fprintf(fp, "SubClasses:             ");					/* 3.						*/, 	    for (i=0; i < sub_class_list_size; i++)
 		if (i == 0)l. 			fprintf(fp, "%s  %s\n", sub_class_list[0], A 					spr_subclass_in_spr_list (sub_class_list[0]) ? " " : "(*)");I 		elseE 			fprintf(fp, "                        %s  %s\n", sub_class_list[i], A 					spr_subclass_in_spr_list (sub_class_list[i]) ? " " : "(*)");e       if (i == 0)_ 	fprintf(fp, "\n");        first_time = TRUE;  >     fprintf(fp, "Descendant Elements:    ");					/* 4.						*/9 	    for (i=0; i < pending_class.number_of_elements; i++)n6 		if (pending_class.elements[i]->gen_error[0] != NULL) 			if (first_time)	 			BEGIN	e 				first_time = FALSE;aN 				fprintf(fp, "%s  (%s vs. %s)\n", pending_class.elements[i]->element_name, . 							  pending_class.elements[i]->gen_error,7 							  pending_class.elements[i]->generation_number);	 			END 		else= 				fprintf(fp, "                        %s  (%s vs. %s)\n", i/ 						pending_class.elements[i]->element_name, r+ 						pending_class.elements[i]->gen_error,l4 						pending_class.elements[i]->generation_number);       if (first_time)_ 	fprintf(fp, "\n");r     else 	first_time = TRUE;   >     fprintf(fp, "Reserved Elements:      ");					/* 5.						*/9 	    for (i=0; i < pending_class.number_of_elements; i++)	3 		if (pending_class.elements[i]->element_reserved) s 			if (first_time)	 			BEGIN	A 				first_time = FALSE; $ 				fprintf(fp, "%-30s    %-20s\n", - 					pending_class.elements[i]->element_name, + 					pending_class.elements[i]->user_name);  			END 		else< 				fprintf(fp, "                        %-30s    %-20s\n", . 						pending_class.elements[i]->element_name,, 						pending_class.elements[i]->user_name);       fprintf(fp, "\n\n");       fprintf(fp,c] "                                 --  Merged/Unmerged Elements Table  --\n\n");	/* 6.						*/*     fprintf(fp, 							+2 "                       Number of   Number of\n");     fprintf(fp, e "Class Name             Elements    Unmerged     Element Name                Gen Number   Status\n");a     fprintf(fp, e "---------------------  ----------  ---------    -------------------------   ----------   ------\n");r       return (fp);   END+	 									e s /*+a  *  NAMEU  *	spr_element_exists --  checks whtherr an element is in SPR class and PENDING class	  *  *  DESCRIPTIONmP  * 	This routine searches the pending class element list to see if an element inN  *	an spr class is merged correctly into the pending class.  Certain flags getH  *	set by this routine if the element is or is not in the pending class.  *  *  RETURN VALUE"  *	TRUE is it is; FALSE if it not.  *  *  HISTORY*/  *	3/28/88	    	Bauer			Initial implementation.  -*/s  ] FUNCTION int spr_element_exists ( element )					/* Checks whether a specific generation of anb7 									   	   element exists in the pending class		*/* ELEMENT_INFO	*element;   BEGINk  K     static int	position;							/* Where in pending element list we were 	*/n5     int		i, hold;							/* Counter and such ...				*/r    O     if (reset_search)								/* Start from beginning of pending class list? 	*/e 	position = 0;  Y     for (i = position; i < pending_class.number_of_elements; i++)		/* Linear search				*/j	     BEGINi 	reset_search = FALSE;  i 	hold = strcmp(	pending_class.elements[i]->element_name, 		/* Compare element to pending class element	*/t 			element->element_name); 	n 	if (hold == 0)e 	BEGIN  e 	    if (strcmp( pending_class.elements[i]->generation_number, 		/* and now the generation number		*/D$ 			element->generation_number) == 0)
 	    BEGINW 		element->element_used		       = ELEMENT_IS_USED;	/* Good match - element is used			*/	< 		pending_class.elements[i]->element_used = ELEMENT_IS_USED; 	        position ++;	    	        return (TRUE); 	    END  Z 	    element->element_used 		   = GENERATION_MISMATCH;	/* No match - generation error			*/  H 	    if (pending_class.elements[i]->element_used == ELEMENT_IS_NOT_USED)@ 		pending_class.elements[i]->element_used = GENERATION_MISMATCH;   	    return(FALSE);s 	END   	else if (hold > 0)  	BEGIN 	   position = i;	            return (FALSE); 	END     ENDl  5     return (FALSE);									/* Element not found			*/	   END	 		 r /*+u  *  NAMEW  *	generate_report_data_on_spr --  figures out what SPR element is in PENDING class too_  *  *  DESCRIPTIONtT  * 	This routine gets called for each SPR class and checks for the existence of each*  *	SPR class element in the PENDING class.  *  *  RETURN VALUE  *  *  HISTORYd/  *	3/28/88	    	Bauer			Initial implementation.	 -*/	  & PROC generate_report_data_on_spr (spr)   CLASS_INFO  *spr;_   BEGIN)N     int	    not_found_count = 0;						/* How many elements are not merged?		*/0     int	    i;									/* Loop counter ...				*/    D     reset_search = TRUE;							/* Start search from beginning of the, 										   pending class element list			*//     for (i=0; i < spr->number_of_elements; i++)i+ 	if (!spr_element_exists(spr->elements[i]))S@ 		not_found_count++;						/* Keep track of unmerged elements		*/  +     spr->unmerged_status = not_found_count;y  ^     if ( (not_found_count > 0) && (first_merge_error) )				/* Check for not merged errors			*/     {	 	first_merge_error = FALSE;*C 	putmsg (1, "");								/* Log the error to SYS$ERROR/SYS$OUTPUT	*/M       }A 	  END	     /*+   *  NAME9  *	print_class_report --  prints report for one CMS classI  *  *  DESCRIPTIONIX  * 	This routine takes a CLASS_INFO data structure and prints out details on whether theW  *	elements in the class are merged or not.  If not it reports whether the element nameaZ  *	or generation number was the culprit.  The user can optionally have all merged elements  *	printed to the report also.  *  *  RETURN VALUE  *  *  HISTORY	/  *	3/28/88	    	Bauer			Initial implementation.l -*/n  9 PROC print_class_report ( class, fp, print_all_elements )    CLASS_INFO	*class;
 FILE		*fp; int		print_all_elements;   BEGINCK 	char 		*blank_string = " ";					/* Used fro blank fields in the report		*/ . 	int  		i, j;							/* Loop counters ...				*/D 	BOOLEAN		first_print;						/* Used to make report look "pretty"		*/   	first_print = TRUE; 											r1 	fprintf(fp,								/* Print the class name				*/t! 		"%-21s  %5d      %5d         ",I0 		class->class_name, class->number_of_elements,  		class->unmerged_status);  Y 	if ( (class->unmerged_status) || (print_all_elements) )			/* Print the element data			*/d 	BEGIN/ 		for (i=0; i < class->number_of_elements; i++); 		BEGINO; 			if (class->elements[i]->element_used != ELEMENT_IS_USED)C 			BEGIN 				if (first_print)	 				BEGINu 					fprintf (fp,	! 						"%-25s   %5s         %s\n",;( 						class->elements[i]->element_name, , 						class->elements[i]->generation_number,P 						class->elements[i]->element_used == GENERATION_MISMATCH ? "(G)" : "(E)" ); 					first_print = FALSE;* 				ENDA 				else 					fprintf (fp, = 						"%-21s  %5s      %5s         %-25s   %5s         %s\n",I/ 						blank_string, blank_string, blank_string,o( 						class->elements[i]->element_name, , 						class->elements[i]->generation_number,P 						class->elements[i]->element_used == GENERATION_MISMATCH ? "(G)" : "(E)" ); 			END  			else if (print_all_elements)  			BEGIN 				if (first_print)	 				BEGINf 					fprintf (fp, ! 						"%-25s   %5s         %s\n",	( 						class->elements[i]->element_name, , 						class->elements[i]->generation_number, 						OK_OR_NOT_OK); 					first_print = FALSE;  				ENDn 				else 					fprintf (fp,m= 						"%-21s  %5s      %5s         %-25s   %5s         %s\n",// 						blank_string, blank_string, blank_string,	( 						class->elements[i]->element_name, , 						class->elements[i]->generation_number, 						OK_OR_NOT_OK); 			END 		END= 	END 	elsec 		fprintf (fp, "\n");N   END*   l /*+M  *  NAMEi  *	generate_pending_unmerged_count --  figures out which pending class elements have are not in spr class	  *  *  DESCRIPTIONlP  *	This routine is called after all SPR class elements have been checked againstP  *	the pending class.  If the element was in both the SPR and PENDING class the S  *	the pending class CLASS_INFO data structure will store this info.  This routine ><  *	tallies up the number of pending class culprits not used.  *  *  RETURN VALUE  *  *  HISTORYs/  *	3/28/88	    	Bauer			Initial implementation.e -*/]  ' PROC generate_pending_unmerged_count ()s   BEGINf) 	int i;									/* Counter variable				*/o  # 	pending_class.unmerged_status = 0;X  5 	for (i=0; i < pending_class.number_of_elements; i++)_A 		if (pending_class.elements[i]->element_used != ELEMENT_IS_USED) $ 			pending_class.unmerged_status ++;  b 	if ( (pending_class.unmerged_status) && (first_merge_error))		/* Check for not merged errors			*/C 		putmsg (1, "");							/* Log the error to SYS$ERROR/SYS$OUTPUT	*/e   END:     /*+.  *  NAME?  *	putmsg --  calls SYS$PUTMSG to echo an error message to useru  *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORYe+  *	4/5/88		Bauer				Initial implementation.P -*/g   putmsg (error_code, opt_param)  6 int  	error_code;								/* Error message number				*/: char	opt_param[];								/* Optional string parameter			*/   {										e7 	unsigned long	msgvec[16];						/* Message vector				*/ < 	DESCR		opt_param_D;						/* For two parameter warnings			*/   	switch (error_code) 	{. 	case 1:									/* Unmerged class found				*/ 		msgvec[0] = 0xf0000 + 3;; 		msgvec[1] = 0xc208008;						/* Message Error ID code			*/)M 		msgvec[2] = 0xf0000 + 1;					/* One FAO parameter - the CMS library name	*/  		msgvec[3] = &library_D;	   		break; 	 : 	case 2:									/* NO Pending Class -BUT- SPR classes		*/ 		msgvec[0] = 0xf0000 + 4;; 		msgvec[1] = 0xc208010;						/* Message Error ID code			*/	K 		msgvec[2] = 0xf0000 + 2;					/* Two FAO parameters - the CMS library name), 										   and the PENDING Class Name			*/ 		msgvec[3] = &library_D;i. 		create_descriptor (&opt_param_D, opt_param); 		msgvec[4] = &opt_param_D;P   		break;  / 	case 3:									/* Can't open report file			*/) 		msgvec[0] = 0xf0000 + 3;; 		msgvec[1] = 0xc208018;						/* Message Error ID code			*/lL 		msgvec[2] = 0xf0000 + 1;					/* One FAO parameters - output report name	*/. 		create_descriptor (&opt_param_D, opt_param); 		msgvec[3] = &opt_param_D;"   		break; 	}  9 	sys$putmsg(&msgvec);							/* Write the message out			*/[ }      /*+)  *  NAMEJ  *	spr_subclass_in_spr_list --  checks to see is a subclass is in spr list  *  *  DESCRIPTIONs<  *	This routine linearly searches the spr class name list toF  *	see if a subclass name exists in  the class.  This is for reporting1  *	subclasses that are not found in the spr list.f  *  *  RETURN VALUE
  *	TRUE/FALSEe  *  *  HISTORY	*  *	4/14/88		Bauer			Initial implementation -*/L  2 int spr_subclass_in_spr_list ( what_spr_subclass )   char	what_spr_subclass[];(   BEGIN)! 	int 	i;								/* Counter					*/m  * 	for (i=0; i < number_of_spr_classes; i++)C 		if (strcmp(spr_classes[i].class_name, what_spr_subclass) == NULL)	 			return(TRUE);  ; 	return(FALSE);								/* Not found - flag the report!			*/    ENDe 	n   s /*+m  *  NAME6  *	main --  driver for the Show_Merged_Classes utility  *  *  DESCRIPTIONlC  * 	This routine is the  driver for this utility.  It performs the f  *	following steps:e  *&  *		1. Read in the pending class data ;  *		2. Figure out the subclasses, questionable descendants,i   *		   reserved pending elements$  *		3. Read in the SPR classes' data6  *		4. What SPR elements are in the pending class too?8  *		5. Open report file and write out header information>  *		6. Write out the PENDING and SPR class element information  *  *  RETURN VALUE  *  *  HISTORY	/  *	3/28/88	    	Bauer			Initial implementation.  -*/%   PROC main ( argc, argv )  
 int 	argc;
 char	*argv[];e   BEGIN ( 	int	i;								/* Counter variable				*/) 	FILE 	*fp;								/* File pointer 				*/tU 	DESCR 	generation_D, all_elements_D;					/* Descriptor strings for callable CMS 		*/	H 	int	descendants = 1, member_list = 1;				/* Flags for callable CMS			*/j 	int	print_all_pending, print_all_spr, print_subclasses;		/* Flag for printing all pending/spr elements	*/  ^ 	fp = open_class_report_file ( argv[1] );				/* Open pending CMS SHOW CLASS/CONTENTS  file 	*/  W 	create_descriptor (&library_D, argv[3]);				/* CMS Library descriptor from argv[3]		*/	     	print_all_pending = FALSE;e 	print_all_spr     = FALSE;e 	print_subclasses  = TRUE;   	for (i=5; i < argc; i++)  	BEGIN+ 		if (strcmp(argv[i], ALL_PENDING) == NULL)l 			print_all_pending = TRUE;' 		if (strcmp(argv[i], ALL_SPR) == NULL)r 			print_all_spr = TRUE;- 		if (strcmp(argv[i], NO_SUBCLASSES) == NULL)i 			print_subclasses = FALSE; 	END  G 	if (fp == NULL)								/* If no file then there may be a erred CMS 	*/ ? 	BEGIN									/* library that has no pending class but has 	*/*E 		pending_class.number_of_elements = 0;				/* valid SPR classes				*/ ; 		strcpy(pending_class.class_name, "???   NOT FOUND  ???");i$ 		pending_class.unmerged_status = 0;2 		putmsg (2, argv[5]);						/* Log the error				*/ 	END 	elsen 	BEGIN  a 		read_class_report_file (&pending_class, fp);			/* And read in the pending class information:	*/_ 										/*		class name- 												element names - generation #'s	*/t   		fclose (fp);  S 		cms$set_library (&ldb, &library_D, 0, 0, 0, 0, 0, 0, 0);	/* CMS SET LIBRARY				*/   9 										/* Set up cms$show_generations call to get the	l9 										   sub_class, descendant problems, and reservedi! 										   elements lists				*/l  : 		if (print_subclasses)						/* No subclass list, ...			*/ 		BEGINcU 		create_descriptor (&all_elements_D, "*.*");			/* Show gen data on all elements 		*/tZ 		create_descriptor (&generation_D, pending_class.class_name);	/* from pending class				*/ 	o< 										/* CMS SHOW GENERATION/MEMBER/GEN=<pending> *.* */  = 		cms$show_generation (	&ldb,					/* Library data block				*/ F 					get_classes,				/* Output routine to process the subclass list	*/ 					0,					/* User ARG					*/. 					&all_elements_D,			/* Element name					*// 					&generation_D,				/* Generation name				*/	5 					&generation_D, 				/* From generation name				*/S% 					0, 					/* Ancestors - NO!				*/ 1 					&descendants, 				/* Descndants - YES!				*/ ? 					&member_list,				/* Generate class memeber list - YES!		*/	 					0 );						n 		ENDd   	END9 										/* Now we read in the SPR report file from the	s; 										   CMS SHOW CLASS/CONTENTS SPR### ... commands	*/ ) 	fp = open_class_report_file ( argv[2] );  	number_of_spr_classes = 0;	   	if (fp != NULL) 	BEGIN; 		while (!feof (fp))						/* Read until no more clases			*/UC 			read_class_report_file ( &spr_classes[number_of_spr_classes++], a 						 fp);  		fclose (fp); 	END  < 										/* Compare SPR class data to pending class data */Y 	for (i=0; i < number_of_spr_classes; i++)				/* and flag descrepencies for the report	*//2 		generate_report_data_on_spr ( &spr_classes[i] );  Z 	generate_pending_unmerged_count ();					/* Figure out if any pending class elements were 2 										   NOT in an SPR class and flag them as   									  	   "unmerged"					*/  9 										/* Open output report file and put header data, ; 										   pending class  name, subclass list, descendant 8 										   problem list, and reserved elements list	*/B 	fp = open_report_file ( argv[5], 					/* Pending class name				*/+ 				argv[3], 					/* CMS Library name				*/e2 				argv[4] );					/* Output report file name			*/   	if (fp == NULL) 	BEGIN 		putmsg(3, argv[4]);r
 		exit(1); 	END  o 	print_class_report ( &pending_class, fp, print_all_pending );		/* Print the guts of the report, first for the e; 										   pending class, and then for all SPR classes	*/   Q 	for (i=0; i < number_of_spr_classes; i++)				/* Print each SPR class report			*/s) 		print_class_report ( 	&spr_classes[i],  	 					fp, t 					print_all_spr );   8 	fprintf (fp, 								/* Print bottom of the report			*/g "-----------------------------------------------------------------------------------------------\n\n");O  8 	fclose (fp);								/* Close report file then exit			*/   ENDb