/*
 *     stcdefs.h - STScI standard C header file
 *
 * History:  original version imported from GSSS
 *
 * Modifications:
 * 24-Oct-84 by M. Johnston
 * 	Added new typedef for USHORT (unsigned short int)
 *
 * 16-JUL-84 by D. Wilson
 *	Added define for GLOBALVALUE
 *
 * 17-Feb-84 by M. Johnston
 *      Changed VAL to VAL_OF, ADDR to PTR_TO
 *      Changes typedefs for LONG and SHORT to be explicitly
 *       long int and short int, respectively.
 *
 * 09-Feb-84 by M. Johnston
 *	Defined typedefs instead of symbols for data types
 *
 * 08-Dec-83 by PMB Shames:
 * 	Added definitions for VAL and ADDR
 *	Added check on ifndef STCDEFS
 *
 * 21-Nov-83 by M. Johnston:
 * 	Defined EOL to be '\n', not 0 (zero)
 * 	Added PROC, defined as int (to be used instead of VOID FUNCTION
 * 	Removed "standard" from definition of VOID
 *
 */

#ifndef STCDEFS

#define STCDEFS

/* Boolean definitions:				*/

#define TRUE 		1			/* standard		*/
#define FALSE 		0			/* standard		*/

#define SUCCESS		1			/* standard		*/
#define FAILURE 	0			/* standard		*/


/* control structure definitions:		*/

#define BEGIN 		{
#define END 		}

#define	IF		if(			/* standard		*/
#define THEN		){			/* standard		*/
#define ELSE		} else {		/* standard		*/
#define ELSEIF		} else if (		/* standard		*/
#define ENDIF		}			/* standard		*/

#define	WHILE		while (			/* standard		*/
#define	DO		){			/* standard		*/
#define	ENDWHILE	}			/* standard		*/

#define REPEAT		do {			/* standard		*/
#define UNTIL		} while ( NOT (		/* standard		*/
#define	ENDREP		));			/* standard		*/

#define FOR		for (			/* standard		*/
/*	DO		){			use 'DO' as defined above */
#define ENDFOR		}			/* standard		*/

#define	CASE		switch (		/* standard		*/
#define	OF		){			/* standard		*/
#define ENDCASE		}			/* standard		*/


/* prefix operator definitions			*/

#define NOT		!			/* standard		*/
#define VAL_OF 		*			/* Optional		*/
#define PTR_TO		&			/* Optional 		*/


/* infix operator definitions			*/

#define MODULO 		%			/* standard		*/

#define	AND		&&			/* standard		*/
#define	OR		||			/* standard		*/
#define EQ		==			/* standard		*/
#define NEQ		!=			/* standard		*/
#define LT		<			/* standard		*/
#define LE		<=			/* standard		*/
#define GT		>			/* standard		*/
#define GE		>=			/* standard		*/


/* pointer definitions:				*/

#define NULL 		0			/* standard		*/


/* i/o definitions:				*/

#define EOF		(-1)			/* standard		*/
#define EOL		'\n'			/* standard		*/
#define	EOS		'\0'			/* standard		*/

/* routine type defintions			*/

#define	FUNCTION				/* Optional		*/
#define VOID					/* Optional		*/

/* variable type definitions			*/

/* storage classes */
/* Note that EXTERN is redefined to "globaldef noshare" in xpscdefs.h.
   Please refer to the xpscdefs before using any of the following.
   The definitions in stcdefs.h remain only to provide consistency with the
   Institute stcdefs.h. */
   
#define GLOBALDEF	globaldef		/* standard		*/
#define GLOBALREF	globalref		/* standard		*/
#define GLOBALVALUE	globalvalue		/* standard		*/
#define	EXTERN		extern			/* standard		*/
#define STATIC		static			/* standard		*/


/* integer constant definitions			*/

#define MAX_POS_INT	2147483647		/* standard		*/
#define MAX_NEG_INT	(-2147483648)		/* standard		*/


/* data type definitions:			*/

typedef double		DOUBLE,   *DOUBLE_PTR;	/* standard		*/
typedef float		FLOAT,    *FLOAT_PTR;	/* standard		*/

typedef long int	LONG,     *LONG_PTR;	/* standard		*/

typedef int		INT,      *INT_PTR;	/* standard		*/
typedef int		PROC;			/* Optional		*/
typedef unsigned int	UINT,     *UINT_PTR;	/* standard		*/

typedef short int	SHORT,    *SHORT_PTR;	/* standard		*/
typedef unsigned short int USHORT,*USHORT_PTR;	/* standard (24-Oct-84)	*/

typedef char		BYTE,     *BYTE_PTR;	/* standard		*/
typedef unsigned char	UBYTE,    *UBYTE_PTR;	/* standard		*/

typedef int		BOOLEAN,  *BOOLEAN_PTR;	/* standard		*/

typedef char 		CHAR;			/* optional		*/
typedef char		*STRING;		/* standard		*/
 

#endif
