 /*+   *  NAMEV  *	use_cms -- geneates a SubClass list file to be sorted/noduplicates so that this canE  *		   be used as the @file parameter to the show_merged_classes tool   *  *  DESCRIPTION   *   		Calling Sequence:  *Q  *				$ USE_CMS <cms library name> <output report file name> <pending class name>   *    J  *				All parameters must be specified  - there are NO default parameters.  *7  *		Examples:	$ USE_CMS oss_cms oss.use_cms pending19.2   *  *  *  RETURN VALUE  *	   *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/    /************/ /* Includes */ /************/ #include stdio #include ctype #include descrip #include "sysdefs:stcdefs"   /*************/  /* Constants */  /*************/ % #define		DESCR		struct dsc$descriptor   
 /***********/ 
 /* Globals */ 
 /***********/  	FILE		*out_use_cms_fp;  	char		pending_class_name[50];     /*+   *  NAME9  *	create_descriptor --  creates a VMS string descriptor    *  *  DESCRIPTION =  *	This routine creates a VMS string descriptor from a normal   *	C string.  *  *  RETURN VALUE  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/   , PROC create_descriptor ( d_pointer, string )  C struct dsc$descriptor 		*d_pointer;					/* Descriptor pointer				*/ < char				*string;					/* String to go into the descriptor		*/   BEGIN / 	d_pointer->dsc$w_length = strlen (string);				 @ 	d_pointer->dsc$a_pointer = malloc(d_pointer->dsc$w_length + 1);+ 	strcpy (d_pointer->dsc$a_pointer, string); ( 	d_pointer->dsc$b_dtype = DSC$K_DTYPE_T;( 	d_pointer->dsc$b_class = DSC$K_CLASS_S;   END      /*+   *  NAME&  *	strcpy_D --  copy descriptor string  *  *  DESCRIPTION 4  * 	Copies a descriptor string to a normal C string #  *	and adds a NULL to the C string.   *  *  RETURN VALUE  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/   S PROC strcpy_D (into_string, from_D)						/* Copies a descriptor string to a normal  7 										   C string - adds a NULL to the C string 	*/   6 char		into_string[];							/* Destination string				*/, DESCR		*from_D;							/* Source string				*/   BEGIN  	strncpy(into_string,							 		from_D->dsc$a_pointer, 		from_D->dsc$w_length ); * 	into_string[from_D->dsc$w_length] = NULL; END   
 										   /*+   *  NAMEU  *	ignore_cms_warnings --  CMS message callback routine that ignores warning messages   *  *  DESCRIPTION X  * 	This routine can be placed in the message routine parameter slot of any callable CMSV  *	routine if you want any CMS warning, information messages to be ignored when using   * 	the callable interface.   *  *  RETURN VALUE!  *	Always returns 1 (CMS$NORMAL).   *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/ 
 										g FUNCTION int ignore_cms_warnings ( sig1, sig2, ldb )				/* Bogus CMS message return so CMS warnings can , 										   be ignored and not printed			*/  int	sig1[16], sig2[16], ldb[50];   BEGIN  	return(1);  END      /*+   *  NAME/  *	USE_CMS --  creates a list of subclass names   *  *  DESCRIPTION Q  * 	This CMS callback routine gets called from a cms$show_generation call that is   *	equivalent to a:   *9  *			CMS SHOW GENERATION/MEMBER/GEN=<pending class name>    *H  *	It then parses out all member classes and writes them to a file to be!  *	run through SORT/NODUPLICATES.   *  *  RETURN VALUE!  *	Always returns 1 (CMS$NORMAL).   *  *  HISTORY .  *	4/4/88	    	Bauer			Initial implementation. -*/   r FUNCTION int use_cms (new_element, ldb, uparm, element_id_D, 			/* Gets the Sub Class list from pending gener. 	*/* 			generation_id_D, user_D, trans_time, 		( 			create_time, rev_time, remark_id_D, 	% 			class_list_D, format, attributes,  0 			rev_num, reservations, rec_size, rev_status )  U int		*new_element, *ldb, *uparm;					/* Check Callable CMS manual for details here	*/ 4 DESCR 		**element_id_D, **generation_id_D, **user_D;* int		*trans_time, *create_time, *rev_time;% DESCR		**remark_id_D, **class_list_D; K int		*format, *attributes, *rev_num, *reservations, *rec_size, *rev_status;    BEGIN										 / 	int		i, j;							/* Counters and such ...			*/ C 	char		list[500], 						/* Buffer for list of class names seperated  										   by spaces					*/ ' 			buf[50]; 						/* Work buffer					*/     F 	strcpy_D (list, *class_list_D);						/* Extract class list names			*/   	i = 0; _ 	while (i < (*class_list_D)->dsc$w_length )				/* Loop through class string list picking out	*/ @ 	BEGIN									/* class names and checking whether in PENDING	*/ 		sscanf(&list[i], "%s", buf);  H 		if (strcmp(buf, pending_class_name) != NULL)			/* Pending class?				*/ 		BEGIN ( 			fprintf(out_use_cms_fp, "%s\n", buf); 		END    		i += strlen(buf)+1;  	END  D 	return (1);								/* Always return 1 in a CMS callback routine 	*/ END 
 										   /*+   *  NAME6  *	main --  driver for the show_merged_Classes utility  *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY .  *	4/4/88	    	Bauer			Initial implementation. -*/    PROC main ( argc, argv )  
 int 	argc;
 char	*argv[];    BEGIN 8 	int	ldb[50];							/* CMS Library Data Block buffer		*/^ 	DESCR 	library_D, generation_D, all_elements_D;			/* Descriptor strings for callable CMS 		*/9 	int	member_list = 1;						/* Flags for callable CMS			*/ + 	int	i;								/* Ye ole loop counter				*/     Q 	if ( (out_use_cms_fp = fopen(argv[2], "w")) == NULL)			/* Open output file				*/  	BEGINF 		printf("Can't open USE_CMS output file to write subclass names.\n");
 		exit(1); 	END  U 	strcpy(pending_class_name, argv[3]);					/* Store pending class name from argv[3]	*/  	i=0; & 	while (pending_class_name[i] != NULL) 	BEGIN% 		if (islower(pending_class_name[i]))  			pending_class_name[i] =$ 				toupper (pending_class_name[i]); 		i++; 	END   #ifdef DEBUGD 	printf("Was: \"%s\" now is \"%s\"\n", argv[3], pending_class_name); #endif  W 	create_descriptor (&library_D, argv[1]);				/* CMS Library descriptor from argv[3]		*/ S 	cms$set_library (&ldb, &library_D, 0, 0, 0, 0, 0, 0, 0);		/* CMS SET LIBRARY				*/   9 										/* Set up cms$show_generations call to get the	 9 										   sub_class, descendant problems, and reserved ! 										   elements lists				*/   U 	create_descriptor (&all_elements_D, "*.*");				/* Show gen data on all elements 		*/ U 	create_descriptor (&generation_D, pending_class_name);			/* from pending class				*/  	 < 										/* CMS SHOW GENERATION/MEMBER/GEN=<pending> *.* */  = 	cms$show_generation (	&ldb,						/* Library data block				*/ B 				use_cms,					/* Output routine to process the subclass list	*/ 				0,						/* User ARG					*/. 				&all_elements_D,				/* Element name					*// 				&generation_D,					/* Generation name				*/ 5 				&generation_D, 					/* From generation name				*/ % 				0, 						/* Ancestors - NO!				*/ % 				0,						/* Descndants - NO!				*/ ? 				&member_list,					/* Generate class memeber list - YES!		*/  				0 );						   	fclose(out_use_cms_fp); END 