 /*+   *  NAME9  *	weed_classes --  merges/reduces sorted SPR class file    *  *  DESCRIPTION E  *	This program is called as part of the Show_Merged_Classes utility. D  *	It takes a sorted list of class names, and searches a particular D  *	CMS library to see which classes exist or not.  If the class does(  *	exist it writes it to an output file.  *B  *	This is called when a file of SPR class names is used via the @@  *	mechanism.  It can greatly reduce the processing time by onlyF  *	having the Show_Merged_Classes utility deal with known SPR classes.  *  *  RETURN VALUE  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/    #include 	stdio  #include	descrip #include	"sysdefs:stcdefs"  ' #define		DESCR 		struct dsc$descriptor    
 /***********/ 
 /* Globals */ 
 /***********/ 4 	FILE		*class_fp, 						/* Output file pointer				*/. 			*input_fp;						/* Input file pointer				*/8 	char		line[100];						/* Line read from input file			*/     /*+   *  NAME/  *	make_upper --  converts string to upper case   *  *  DESCRIPTION   *  *  RETURN VALUE  *  *  HISTORY +  *	8/15/88 	Bauer			Initial implementation.  -*/    make_upper (string)   
 char *string;    BEGIN  	int i;  	 " 	for (i=0; string[i] != NULL; i++)! 		string[i] = toupper(string[i]);    END    /*+   *  NAME9  *	create_descriptor --  creates a VMS string descriptor    *  *  DESCRIPTION =  *	This routine creates a VMS string descriptor from a normal   *	C string.  *  *  RETURN VALUE  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/   , PROC create_descriptor ( d_pointer, string )  C struct dsc$descriptor 		*d_pointer;					/* Descriptor pointer				*/ < char				*string;					/* String to go into the descriptor		*/   BEGIN / 	d_pointer->dsc$w_length = strlen (string);				 @ 	d_pointer->dsc$a_pointer = malloc(d_pointer->dsc$w_length + 1);+ 	strcpy (d_pointer->dsc$a_pointer, string); ( 	d_pointer->dsc$b_dtype = DSC$K_DTYPE_T;( 	d_pointer->dsc$b_class = DSC$K_CLASS_S;   END      /*+   *  NAMEI  *	show_classes --  CMS callback routine that creates file of class names   *  *  DESCRIPTION L  *	This is the CMS callback routine that gets called once for every class inP  *	the particular CMS library.  Each class name that gets passed to this routineN  *	will be lxigraphically greater than the previous one.  Because of this factO  *	and because the class names file is also sorted this routine can easily run  P  *	through the file (but only as far as it needs to) to see if a class from the   *	library is also in the file.   *  *  RETURN VALUE   *	Always returns 1 - CMS$NORMAL  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation. <  *	6/28/88		Bauer			Changed wildcard from *.* to * since the6  *						*.* would miss class names such as CMO_BASE193 -*/   7 int	show_classes (	first_call, ldb, uparm, class_id_D,   			remark_id_D, read_only )   + int		*first_call, *ldb, *uparm, *read_only;  DESCR 		**class_id_D;    BEGIN  	DESCR		*class_D;  	char		buf[50];  	int		compare, searching;   H 	class_D = *class_id_D;							/* Extract class name from descriptor 		*/ 	strncpy (buf,   		 class_D->dsc$a_pointer,   		 class_D->dsc$w_length );   	buf[class_D->dsc$w_length] = 0;   	searching = TRUE;  K 	while (searching)							/* Search for the class name in the sorted file */  	BEGIN^ 		compare = strncmp(line, buf, strlen(buf));			/* Compare file class to callback class name	*/  H 		if (compare == 0)						/* A match ! Write class name to output file	*/ 		BEGIN " 			fprintf(class_fp, "%s\n", buf); 			searching = FALSE; * 			if (fgets(line, 100, input_fp) == NULL) 				exit(1); 			else  				make_upper (line); 		END G 		else if (compare < 0)						/* Oops - callback class name is less 		*/ ? 		BEGIN								/* lexigraphically greater - so read another 	*/ H 			if (fgets(line, 100, input_fp) == NULL)			/* line from the file				*/ 				exit(1); 			else  				make_upper (line); 		END  		elseJ 			searching = FALSE;					/* Callback name is less than file class name	*/$ 										/* so stop searching				*/ 	END
 										, 	return (1);								/* Always return 1				*/   END    /*+   *  NAME+  *	main --  driver program to show_classes    *  *  DESCRIPTION 3  *	This is the driver for the show_classes utility. '  *	It performs the following functions:   *  *		1. Map to CMS library $  *		2. Open sorted file of SPR names3  *		3. Opens output file of merged classes from CMS -  *		   library and sorted class SPR file name <  *		4. Calls cms$show_class which does the rest of the work.  *  *  RETURN VALUE  *  *  HISTORY /  *	3/28/88	    	Bauer			Initial implementation.  -*/    main ( argc, argv )   
 int 	argc;
 char	*argv[];    BEGIN @ 	DESCR 		library_D, 						/* Descriptor for CMS library name		*/A 			all_classes_D;						/* Descriptor to specify * for class names , 										   on the cms$show_class call			*/5 	int		ldb[50];						/* Library data block buffer			*/     Q 	create_descriptor (&library_D, argv[1]);				/* Set up CMS library descriptor		*/ Y 	cms$set_library (&ldb, &library_D, 0, 0, 0, 0, 0, 0, 0);		/* and map to the library			*/   J 	if ( (class_fp=fopen(argv[2], "w")) == NULL)				/* Open report file				*/ 	BEGIN, 		printf("Can't open class list file %s\n",  			argv[2]);
 		exit(1); 	END  R 	if ( (input_fp=fopen(argv[3], "r")) == NULL)				/* Open sorted SPR list file			*/ 	BEGIN9 		printf("Can't open sorted class list input file %s\n",   			argv[3]);
 		exit(1); 	END  E 	if (fgets(line, 100, input_fp) == NULL)					/* Read first name				*/ . 		exit(1);							/* Exit if file is empty			*/ 	else  		make_upper (line);  T 	create_descriptor (&all_classes_D, "*");				/* Create descritor for all classes		*/ 	 F 	cms$show_class (	&ldb,						/* Call cms$show_class to do the work		*/= 				show_classes,					/* This is the CMS callback routine		*/  				0,= 				&all_classes_D,					/* For all classes in the library		*/  				0 );  G 	fclose (class_fp);							/* This may never get executed if the EOF on	 8 										   the input file is hit before the callback 	0 										   routine class list is exhausted		*/ 	  END 