& 2	!	PROGRAM AUTHOR	:	Phillip C. Brisco 	! 	!	PROGRAM NAME	:	SET_DIR 9 	!	DESCRIPTION	: Changes the default directory of a user. ( 	!	VERSION EDIT	: 1.0   14 January, 1988   	! 	!	V E R S I O N   E D I T 	!G 	!-------------------------------------------------------------------   E 	! 1.1	Phillip Brisco.  Changed program so that when the user pressed > 	!	the return key after choosing help or one of the manuals to$ 	!	pop rather than erase the screen. 	!   	!( 	!	G E N E R A L   D E S C R I P T I O N 	!G 	!-------------------------------------------------------------------   ? 	!	This routine will allow a user to set default to directories B 	! and list the files in the directories if the the directory path6 	! names are set up in a text file named 'X_FILE.LIS'. 	!; 	!	The format for each record in this text file is the path D 	! name of a directory.  A comment can be put in the text file afterD 	! each path name as long as there is at least one space between theH 	! path name and the comment and each comment starts with an exclamation	 	! point.  	!? 	!	The directories are accessed by the numbers in front of each 9 	! path name.  These numbers are assigned by the program.  	!@ 	!	The user can choose a directory by either entering the numberG 	! of the directory or moving the light bar up or down (by using the up ? 	! and down arrow keys) until it is over the path name desired.  	!= 	!	If the user types in a directory number and does not press E 	! the <RETURN> key or any other key for about 3 seconds, the program G 	! will choose the directory typed in.  If the user typed in an invalid H 	! directory number, the program wivll erase it and wait for the user to 	! enter a valid number. 	!= 	!	If the user moves the light bar after entering a directory F 	! number, the number is cleared from the screen and the program waits# 	! for further input from the user.  	!< 	!	When using the light bar, the user must place it over theE 	! desired directory and press the <RETURN> key to change the default 9 	! directory to the path name listed under the light bar.  	!= 	!	This program has online help (<?> key), user's manual (<U> ( 	! key), and reference manual (<R> key). 	!? 	!	To use this program, a global variable must be set up in the B 	! LOGIN.COM file named 'PHILONUM' and set equal to the string "1"F 	! (PHILONUM :== "1"), a sequential file (X_FILE.LIS) must be created,D 	! and the logical 'DIR_PROG' must be assigned the path name wherein@ 	! the file 'X_FILE.LIS' resides ($ASSIGN DIR_PROG <PATH NAME>). 	!> 	!	The directory program is designed to be executed from a DCLH 	! command procedure.  The command procedure will take in all parametersE 	! (if any) supplied by the user and pass them to the program.  Valid D 	! parameters are 'A' (in the first position, this tells the programE 	! to list all directories), '0' - '18' (tells program to go directly @ 	! to the number of the directory typed in by the user), and anyG 	! alphabetic character (these can be executed by the command procedure @ 	! if the command procedure is set up to interpret them), and noD 	! parameters (sets the default to the first path name listed in the; 	! file 'X_FILE.LIS').  All invalid parameters are ignored.  	!; 	!	All alphabetic parameters except 'A' are returned to the B 	! calling DCL command procedure in the local symbol 'TEMP_PHILO'.B 	! These parameters can be executed by the command procedure to doD 	! further processing (e.g. the user enters the parametes '2D'.  TheD 	! directory program will set the default to the second directory inE 	! the file 'X_FILE.LIS'.  The program will return 'D' to the command E 	! procedure.  The user might then write code wherein everytime a 'D' A 	! is returned, the command procedure would perform a 'DIRECTORY'  	! command). 	!= 	!	An example of a possible command procedure is given below:  	! 	! $ temp_philo := 'P1' + 	! $ DEFINE/USER_MODE SYS$INPUT SYS$COMMAND   	! $ RUN DRB0:[PHIL.UTIL]SET_DIR6 	! $ WRITE SYS$OUTPUT "[1;53H[1K[1H[7m''F$PARSE( - 	!	+ "*.*",,,"DEVICE")'"; 	! $ WRITE SYS$OUTPUT "[1;6H''F$DIRECTORY()'[0m[1;56H" - 4 	!	+ "[1mPhaylo directory #''philonum' [0m[2H[J"+ 	! $ IF temp_philo .EQS. "D" THEN directory 	 	! $ EXIT  	!> 	!	The first line assigns the parameter(s) entered by the user$ 	! to the local symbol 'TEMP_PHILO'.> 	!	The second line defines the user mode so that the directory 	! program can be run.; 	!	The third line runs the directory program (note that the  	! full path name is given).: 	!	The fourth and fifth lines set up scrolling regions andA 	! print the directory and directory number the user is currently ? 	! in on the first line of the screen.  The scrolling region is A 	! shortened by one (this works on vt100 type terminals and above B 	! only) so that the first line will not scroll off the screen. InB 	! these two lines, every '[' is part of an escape sequence and is  	! preceded by the <ESCAPE> key.; 	!	The sixth line tests the return parameter for a 'D'.  If ? 	! a 'D' is returned, then the 'DIRECTORY' command is executed.  	!   	!  + 	!	L I S T   O F   I / O   C H A N N E L S   	!			 				OPEN	CLOSE  F 	!CHAN#  FILE NAME  REPT  IN/OUT  ACCESS  ALLOW  EXT  	LINE #  LINE # H 	!---------------------------------------------------------------------  	!  7 	! 1     X_FILE.LIS        I	 READ	 MODIFY	 Y	1500	2090  	!   	! 	!	E X T E R N A L S 	!& 	EXTERNAL LONG FUNCTION LIB$GET_SYMBOL- 	EXTERNAL LONG FUNCTION SMG$CREATE_PASTEBOARD 3 	EXTERNAL LONG FUNCTION SMG$CREATE_VIRTUAL_KEYBOARD 2 	EXTERNAL LONG FUNCTION SMG$CREATE_VIRTUAL_DISPLAY( 	EXTERNAL LONG FUNCTION SMG$LABEL_BORDER1 	EXTERNAL LONG FUNCTION SMG$PASTE_VIRTUAL_DISPLAY ( 	EXTERNAL LONG FUNCTION SMG$INSERT_CHARS% 	EXTERNAL LONG FUNCTION SMG$PUT_CHARS * 	EXTERNAL LONG FUNCTION SMG$READ_KEYSTROKE* 	EXTERNAL LONG FUNCTION SMG$SET_CURSOR_ABS- 	EXTERNAL LONG FUNCTION SMG$READ_FROM_DISPLAY & 	EXTERNAL LONG FUNCTION LIB$DO_COMMAND& 	EXTERNAL LONG FUNCTION LIB$SET_SYMBOL2 	EXTERNAL LONG FUNCTION SMG$DELETE_VIRTUAL_DISPLAY( 	EXTERNAL LONG FUNCTION SMG$INSERT_CHARS' 	EXTERNAL LONG FUNCTION SMG$ERASE_CHARS / 	EXTERNAL LONG FUNCTION SMG$POP_VIRTUAL_DISPLAY   # 	EXTERNAL LONG CONSTANT SMG$M_BLINK " 	EXTERNAL LONG CONSTANT SMG$M_BOLD% 	EXTERNAL LONG CONSTANT SMG$M_REVERSE $ 	EXTERNAL LONG CONSTANT SMG$M_BORDER! 	EXTERNAL LONG CONSTANT SMG$K_TOP , 	EXTERNAL LONG CONSTANT LIB$K_CLI_GLOBAL_SYM   	!- 	!	C O N S T A N T    D E C L A R A T I O N S  	! 	DECLARE BYTE CONSTANT			& 			out_chan = 1%,		& 			ctrl_n = 14%,		&  			ctrl_p = 16%,		&  			return_key = 13%    	DECLARE LONG CONSTANT			& 			dwn_arrow = 275%,	& 			up_arrow = 274%   	!- 	!	V A R I A B L E    D E C L A R A T I O N S  	! 	DECLARE BYTE				& 			arrow_flag,		&  			dir_found,		& 			eof,			& 
 			false,			&  			loop_timer,		& 
 			templ,			&  			question_flag,		& 			reference_flag,		&  			true,			& 			user_flag   	DECLARE LONG				& 			col,			&  			display_id,		&  			home_row,		& 	 			i,			&  			keyboard_id,		& 			last_row,		&  			new_pid,		& 			num_chars,		& 			num_columns,		& 			num_rows,		&  			manual_id,		& 			prompt_col,		&  			prompt_id,		& 			prompt_row,		&  			question_id,		& 			reference_id,		&  			row,			&  			terminator_code,	&  			timeout,		& 			unit,			& 			vir1,			& 			vir2,			&
 			sys_status    	DECLARE REAL 	tempr   	DECLARE STRING				& 			array_of_dir(98%),	&  			dest_dir,		&  			dir_out,		& 			label_text,		&  			parser,			&
 			philo,			&  			philo_out,		& 			prompter,		&  			ref_manual(20%),	&  			ret_buf,		& 			the_dir,		& 			temp_str,		&  			time_str,		&  			user_help(6%),		& 			user_manual(20%)    	!
 	!	M A P S 	! 	MAP (ugga)	STRING booga = 80%   	ON ERROR GOTO 19000   1500	! 	!	File open section 	!  6 	OPEN "DIR_PROG:X_FILE.LIS" FOR INPUT AS #out_chan,		& 		ACCESS READ,						&  		ALLOW MODIFY,						&
 		MAP UGGA 	! 	!	File of directories 	!  
 	timeout = 1% 
 	true = 1% 	false = 0% 	 	col = 1%  	num_columns = 78% 	num_rows = 18% 	 	row = 0%  	vir1,vir2 = 2%  	prompt_row = 2% 	prompt_col = 1%3 	prompter = "Ready for entry of directory number: "    2000	!9 	!	This routine will either send the user directly to theM? 	!	directory chosen, or will list all directories on the screeno 	!  4 	sys_status = LIB$GET_SYMBOL("TEMP_PHILO",RET_BUF,,) 	!= 	!	Get the value from the local symbol 'temp_philo' as set up-( 	!	in the calling DCL command procedure. 	!   	parser = TRM$(ret_buf)g4 	the_dir = XLATE(ret_buf,SPACE$(48%) + "0123456789")F 	the_dir = "1" IF (parser = "") OR (EDIT$(LEFT$(parser,1%),32%) = "D")  A 	IF (the_dir <> "") AND (EDIT$(LEFT$(parser,1%),32%) <> "A") THEN!
 		eof = false-  - 		UNTIL (eof = true) OR (VAL%(the_dir) = row)- 			GET #out_chan, REGARDLESS 			row = row + 1%f7 			array_of_dir(row) = SPACE$(2% - LEN(NUM1$(row))) + &o 				NUM1$(row) + ". " + booga  		NEXT 		!s- 		!	Get the valid directories from X_FILE.LIS! 		!f   	  ELSEa" 		GOSUB 10700	! Show entire screen 	END IFn 	!= 	!	If the user entered the number of the directory desired as!? 	!	parameter, then the program will send the user to the chosene< 	!	directory.  If the user did not enter any parameters, the= 	!	first directory is assumed to be the chosen directory.  Iny@ 	!	all other cases, the user is shown a list of directories that 	!	can be chosen.r 	!  @ 	parser = RIGHT$(parser,2%) IF EDIT$(LEFT$(parser,1%),32%) = "A"? 	dir_out = XLATE(EDIT$(parser,32%),SPACE$(65%) + "ABCDEFGHIJ" &i 		+ "KLMNOPQRSTUVWXYZ")r 	parser = EDIT$(dir_out,2%)e 	row = VAL%(the_dir)
 	CLOSE #1% 	philo = "philonum"e 	philo_out = "temp_philo"r@ 	sys_status = LIB$SET_SYMBOL(philo,the_dir,LIB$K_CLI_GLOBAL_SYM) 	!= 	!	Update the global symbol 'philonum' with the new directorye
 	!	number. 	!  ? 	sys_status = LIB$SET_SYMBOL(philo_out,parser,) IF parser <> ""u 	!6 	!	Update the local symbol 'temp_philo' with the alpha; 	!	characters entered by the user.  These characters are toe7 	!	be used in user-defined functions at the DCL commandr 	!	procedure level.h 	!  A 	dest_dir = "SET DEFAULT " + TRM$(MID$(array_of_dir(row),5%,28%))e9 	sys_status = SMG$POP_VIRTUAL_DISPLAY(display_id,new_pid) 3 	sys_status = SMG$DELETE_VIRTUAL_DISPLAY(prompt_id)d 	!9 	!	Erase and deallocate all outstanding virtual displays.y 	!  & 	sys_status = LIB$DO_COMMAND(dest_dir) 	!) 	!	Set default to the requested directory  	!   9000	! 	! 	!   	IF eof THEN# 		PRINT "***  Directory is invalid"'
 		SLEEP 3% 		CLOSE #1%i 	END IF!   9999	GOTO 32767, s 10000	! < 	!	Obtain input from user.  Valid input consists of numbers,2 	!	control N, control P, up arrow, and down arrow. 	!  
 	the_dir = ""d 	prompt_col = 38%GA 	sys_status = SMG$SET_CURSOR_ABS(prompt_id,prompt_row,prompt_col)u 	!9 	!	Place the cursor on the line that contains the currentl
 	!	directory.a 	!   	last_row = rowu 	row = home_rowr: 	sys_status = SMG$READ_FROM_DISPLAY(display_id,booga,,row) 	!6 	!	Get the current directory path from the main buffer 	!   	dir_found = false 	arrow_flag = false  	user_flag = false 	question_flag = false 	reference_flag = false,   	UNTIL dir_found 		GOSUB 10300	! Update timex@ 		sys_status = SMG$READ_KEYSTROKE(keyboard_id,terminator_code, & 			,timeout,,)  @ 		IF (terminator_code <> 509%) AND (terminator_code <> 13%) THEN   			IF user_flag THEN. 				sys_status = SMG$DELETE_VIRTUAL_DISPLAY( & 					manual_id)A 				user_flag = falses	 			END IF    			IF question_flag THEN. 				sys_status = SMG$DELETE_VIRTUAL_DISPLAY( & 					question_id)e 				question_flag = falsee	 			END IFm   			IF reference_flag THENh. 				sys_status = SMG$DELETE_VIRTUAL_DISPLAY( & 					reference_id) 				reference_flag = false	 			END IFt   		END IF 		!r6 		!	509 is the value that the terminator_code receives. 		!	when nothing is entered from the keyboard. 		!h  4 		loop_timer = 0% IF (terminator_code <> 509%) AND &: 			(terminator_code <> return_key) AND (LEN(the_dir) = 2%)7 		terminator_code = return_key IF (the_dir <> "") AND &s6 			(terminator_code = 509%) AND (arrow_flag = false) & 			AND loop_timer = 3%   		IF loop_timer = 3% THENI 			loop_timer = 0% 		  ELSE 			loop_timer = loop_timer + 1%A   		END IF 		!"2 		!	If the user has entered a number and 3 seconds1 		!	have passed without entering the <RETURN> keyy2 		!	or any other key, set default to the directory! 		!	corresponding to that number.! 		!T   		SELECT terminator_code 			CASE dwn_arrow,ctrl_n 				ITERATE IF row = last_rowE$ 				GOSUB 10100	! Down arrow routine   				IF arrow_flag <> true THEN 					num_chars = 2%  					prompt_col = 38% $ 					sys_status = SMG$ERASE_CHARS( & 						prompt_id,num_chars, & 						prompt_row,prompt_col) 					arrow_flag = true
 				END IF   			CASE up_arrow,ctrl_pd 				ITERATE IF row = 1%i" 				GOSUB 10200	! Up arrow routine   				IF arrow_flag <> true THEN 					num_chars = 2%d 					prompt_col = 38%v$ 					sys_status = SMG$ERASE_CHARS( & 						prompt_id,num_chars, & 						prompt_row,prompt_col) 					arrow_flag = true
 				END IF   			CASE return_key  $ 				IF VAL%(the_dir) > last_row THEN 					num_chars = 2%n 					prompt_col = 38%m$ 					sys_status = SMG$ERASE_CHARS( & 						prompt_id,num_chars, & 						prompt_row,prompt_col) 					the_dir = NUM1$(row)  					arrow_flag = true 					ITERATE
 				END IF  ( 				the_dir = NUM1$(row) IF the_dir = "" 				dir_found = true 			CASE 85, 117- 				GOSUB 10400- 				!-) 				! User's manual.  85 and 117 refer to 2 				! the ASCII value of 'U' and 'u' respectively. 				!    				user_flag = true
 			CASE 63 				GOSUB 10500$ 				!B+ 				! Help message.  63 refers to the ASCIIO 				! value of '?'.F 				!    				question_flag = true 			CASE 82, 114F 				GOSUB 10600E 				!L0 				! Reference manual.  82 and 114 refer to the. 				! ASCII value of 'R' and 'r' respectively. 				!E   				reference_flag = trueE 			CASE ELSE+ 				ITERATE IF (terminator_code < 48%) OR &  					(terminator_code > 57%) 				the_dir = "" IF arrow_flag 				arrow_flag = false- 				the_dir = the_dir + CHR$(terminator_code)A   				IF LEN(the_dir) > 2% THENE  					the_dir = LEFT$(the_dir,2%) 					ITERATE
 				END IF  . 				sys_status = SMG$INSERT_CHARS(prompt_id, &( 					CHR$(terminator_code),prompt_row, & 					prompt_col,,,)  				!A( 				!	Echo the user response next to the' 				!	user prompt in the prompt buffer.E 				!     				prompt_col = prompt_col + 1% 		END SELECT   	NEXTE   10090	RETURN G 10100	! : 	!	This routine is executed when the down arrow key or the 	!	control N key is depressed. 	!   	IF row = home_row THEN < 		sys_status = SMG$PUT_CHARS(display_id,array_of_dir(row), & 			row,col,,SMG$M_BLINK,,) 	  ELSE < 		sys_status = SMG$PUT_CHARS(display_id,array_of_dir(row), & 			row,col,,,,)d 	END IF= 	!< 	!	If the row refers to the current directory, make the line
 	!	blinks. 	!   	row = row + 1%	 	the_dir = NUM1$(row)   ; 	sys_status = SMG$PUT_CHARS(display_id,array_of_dir(row), &, 			row,col,,SMG$M_REVERSE,,) 	!0 	!	Print the chosen directory in reverse video.	 	!   10190	RETURN L 10200	! 8 	!	This routine is executed when the up arrow key or the 	!	control P key is depresseds 	!   	IF row = home_row THENn< 		sys_status = SMG$PUT_CHARS(display_id,array_of_dir(row), & 			row,col,,SMG$M_BLINK,,) 	  ELSE_< 		sys_status = SMG$PUT_CHARS(display_id,array_of_dir(row), & 			row,col,,,,)	 	END IFr 	!= 	!	If the line refers to the current directory, make sure ther 	!	line blinks.a 	!   	row = row - 1%t 	the_dir = NUM1$(row)	  ; 	sys_status = SMG$PUT_CHARS(display_id,array_of_dir(row), && 		row,col,,SMG$M_REVERSE,,)e 	!4 	!	Print the chosen directory line in reverse video. 	!   10290	RETURN   10300	!b7 	!	Update the time in the border of the virtual display  	!   	templ,tempr = TIME(0%)/(3600)! 	tempr,templ = (tempr - templ)*60( 	templ = (tempr - templ)*60O- 	temp_str = "0" + NUM1$(templ) IF templ < 10%c& 	temp_str = NUM1$(templ) IF templ > 9%: 	time_str = LEFT$(TIME$(0%),5%) + ":" + temp_str + " " + & 		RIGHT$(TIME$(0%),7%) + " "G 	label_text = " Phil's directory program " + DATE$(0%) + " " + time_str   B 	sys_status = SMG$LABEL_BORDER(display_id,label_text,SMG$K_TOP,, &  		SMG$M_BOLD OR SMG$M_REVERSE,,) 	!4 	!	Update the time in the border of the main buffer. 	!   10390	RETURN i 10400	!  	!	User's manual 	!   	user_manual(0%) = " ": 	user_manual(1%) = "                        USER'S MANUAL" 	user_manual(2%) = " "F 	user_manual(3%) = "   This program changes the default directory" + & 			" by using a"G 	user_manual(4%) = "number (or arrow key) which is typed in by the" + &  			" user."g 	user_manual(5%) = " "@ 	user_manual(6%) = "   If, after typing in the number of a " + & 			"directory, 3 seconds"%C 	user_manual(7%) = "elapse before another key is pressed, the " + &A 			"default directory"H 	user_manual(8%) = "will be changed to the number typed in by the user." 	user_manual(9%) = " "G 	user_manual(10%) = "   If the number of the directory desired is " + &  			"known, then it"&H 	user_manual(11%) = "can be used as a parameter to set the default " + & 			"directory"F 	user_manual(12%) = "without listing all directories in 'X_FILE.LIS'." 	user_manual(13%) = " "f? 	user_manual(14%) = "   If no parameters are entered, the " + &b 			"program will set the"dD 	user_manual(15%) = "default directory to the first one listed " + & 			"in 'X_FILE.LIS'."T 	user_manual(16%) = " "	H 	user_manual(17%) = "   The current directory flashes when the bar " + & 			"is not on it." 	user_manual(18%) = " "sH 	user_manual(19%) = "   This program is designed to be run in a DCL" + & 			" command file." 
 	vir1 = 3% 	vir2 = 19%I 	num_rows = 19%d 	num_columns = 60%  @ 	sys_status = SMG$CREATE_VIRTUAL_DISPLAY(num_rows,num_columns, & 		manual_id,SMG$M_BORDER,,)o  7 	sys_status = SMG$PUT_CHARS(manual_id,user_manual(i), &t 		i,col,,,,) FOR i = 1% TO 19%  D 	sys_status = SMG$PASTE_VIRTUAL_DISPLAY(manual_id,new_pid,vir1,vir2)   10490	RETURN ! 10500	!h 	!	Help messager 	!  B 	user_help(1%) = "Enter <CTRL> N or the down arrow key to move " & 		+ "light bar down."SE 	user_help(2%) = "Enter <CTRL> P or the up arrow key to move light" &( 		+ " bar up."E 	user_help(3%) = "Press the <RETURN> key to move to the directory " &p 		+ "under the"aH 	user_help(4%) = "   light bar, or type in the number of the directory.": 	user_help(5%) = "Enter <U> to look at the user's manual."= 	user_help(6%) = "Enter <R> to look at the reference manual."r 	vir1 = 13%!
 	vir2 = 3% 	num_rows = 6% 	num_columns = 60%  @ 	sys_status = SMG$CREATE_VIRTUAL_DISPLAY(num_rows,num_columns, & 		question_id,SMG$M_BORDER,,)f  7 	sys_status = SMG$PUT_CHARS(question_id,user_help(i), &d 		i,col,,,,) FOR i = 1% TO 6%(  F 	sys_status = SMG$PASTE_VIRTUAL_DISPLAY(question_id,new_pid,vir1,vir2)   10590	RETURN   10600	!u 	!	Reference manualL 	!   	ref_manual(0%) = " "E5 	ref_manual(1%) = "                 Reference manual"  	ref_manual(2%) = " "$B 	ref_manual(3%) = "   A text file named 'X_FILE.LIS' is required."D 	ref_manual(4%) = "This text file must hold the entire path name of"D 	ref_manual(5%) = "each directory that is to be used.  Comments can"D 	ref_manual(6%) = "be put after each path name in the text file, as"F 	ref_manual(7%) = "long as there is at least one space separating the"F 	ref_manual(8%) = "path name from the comment and a '!' preceding the" 	ref_manual(9%) = "comment." 	ref_manual(10%) = " "A 	ref_manual(11%) = "   A symbol ('PHILONUM') is used to hold the" F 	ref_manual(12%) = "number of the current directory and the path name"9 	ref_manual(13%) = "is stored in the logical 'DIR_PROG'."u 	ref_manual(14%) = " "? 	ref_manual(15%) = "   All parameters are stored in the symbol"=E 	ref_manual(16%) = "'TEMP_PHILO'.  Numeric parameters (and the alpha"pF 	ref_manual(17%) = "parameter 'A') are used in the program, while the"F 	ref_manual(18%) = "calling DCL command procedure executes alphabetic"7 	ref_manual(19%) = "parameters as defined by the user."=  
 	vir1 = 3%
 	vir2 = 7% 	num_rows = 19%_ 	num_columns = 50%  @ 	sys_status = SMG$CREATE_VIRTUAL_DISPLAY(num_rows,num_columns, & 		reference_id,SMG$M_BORDER,,)  9 	sys_status = SMG$PUT_CHARS(reference_id,ref_manual(i), &	 		i,col,,,,) FOR i = 1% TO 19%  G 	sys_status = SMG$PASTE_VIRTUAL_DISPLAY(reference_id,new_pid,vir1,vir2)_   10690	RETURN D 10700	!	 	! 	!  2 	sys_status = LIB$GET_SYMBOL("PHILONUM",RET_BUF,,) 	!* 	!	Get the value from the symbol 'philonum 	!  9 	sys_status = SMG$CREATE_VIRTUAL_KEYBOARD(keyboard_id,,,)D 	!2 	!	Set up the virtual keyboard to allow user input 	!  0 	sys_status = SMG$CREATE_PASTEBOARD(new_pid,,,,) 	!  	!	Define output terminal screen 	!  @ 	sys_status = SMG$CREATE_VIRTUAL_DISPLAY(num_rows,num_columns, & 		display_id,SMG$M_BORDER,,) 	! 	!	Set up main virtual bufferr 	!   	GOSUB 10300	! Update time  = 	sys_status = SMG$PASTE_VIRTUAL_DISPLAY(display_id,new_pid, &u 		vir1,vir2) 	! 	!	Display main virtual buffer 	!  
 	num_rows = 2d@ 	sys_status = SMG$CREATE_VIRTUAL_DISPLAY(num_rows,num_columns, & 		prompt_id,SMG$M_BORDER,,)o 	! 	!	Set up the prompt buffers 	!   	vir1 = 21%0
 	unit = 3%G 	label_text = " [U]ser's manual, [R]eference manual, [?] help message "	  F 	sys_status = SMG$LABEL_BORDER(prompt_id,label_text,SMG$K_TOP,unit,,,) 	!( 	!	Set up border label for prompt buffer 	!  D 	sys_status = SMG$PASTE_VIRTUAL_DISPLAY(prompt_id,new_pid,vir1,vir2) 	! 	!	Display prompt buffer 	!  	 	row = 0%  	eof = false  
 	UNTIL eof 		GET #out_chan, REGARDLESS	 		row = row + 1%   		IF (row = VAL%(ret_buf)) THENR 			home_row = rowi6 			sys_status = SMG$PUT_CHARS(display_id,SPACE$(2% - &3 				LEN(NUM1$(row))) + NUM1$(row) + ". " + booga, &	 				row,col,,SMG$M_REVERSE,,)N 		  ELSE6 			sys_status = SMG$PUT_CHARS(display_id,SPACE$(2% - &3 				LEN(NUM1$(row))) + num1$(ROW) + ". " + booga, &	 				row,col,,,,) 		END IF 		!e1 		!	If the row = the current directory, print theE3 		!	characters to the screen in reverse video, elsei. 		!	just print normal characters to the screen 		!O  A 		array_of_dir(row) = SPACE$(2% - LEN(NUM1$(row))) + NUM1$(row) &  			+ ". " + booga' 	NEXT'  J 10780	sys_status = SMG$LABEL_BORDER(prompt_id,label_text,SMG$K_TOP,unit, & 		SMG$M_REVERSE,,) IF row > 17%  	!= 	!	If the user has more than 17 directories, print the promptf@ 	!	buffer's border label in reverse video to distinguish it from 	!	the regular text. 	!  G 	sys_status = SMG$PUT_CHARS(prompt_id,prompter,prompt_row,prompt_col,,&	 			,,) 	!( 	!	Write the prompt to the prompt buffer 	!    	GOSUB 10000	! Obtain user input   10790	RETURN   19000	!i 	!	Error routinesg 	!   	eof = truef 	RESUME 9000 IF ERL = 2000
 	RESUME 10780o  	 32767	END	