      SUBROUTINE ADAM (INFILE, OUTFILE)
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **           ADAM            **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          ADAM
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-3
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 694-5578
C*
C*     PURPOSE :
C*          ALLOW USER'S PROGRAMS TO CALL ADAM
C*
C*     INPUT ARGUMENTS :
C*          INFILE - INPUT FILE NAME
C*          OUTFILE - OUTPUT FILE NAME (OR BLANK)
C*
C*     OUTPUT ARGUMENTS :
C*          NONE
C*
C*     COMMON BLOCKS :
C*          NONE
C*
C*     SUBPROGRAM REFERENCES :
C*          TPU$TPU,  LENGTH
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          LET'S GET SERIOUS
C*          YOU MUST LINK TO THE SHAREABLE TPU IMAGE WITH AN OPTIONS
C*              FILE:
C*
C*              SYS$SHARE:TPUSHR.EXE/SHAREABLE
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -  15-APR-1988
C*
C*     CHANGE HISTORY :
C*          15-APR-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      CHARACTER *132 COMMAND
      CHARACTER *(*) INFILE, OUTFILE
C
      COMMAND = 'TPU/SECTION=ADAM'
      LC = 17
      OPEN (UNIT=0, FILE='SYS$LOGIN:TPUINI.TPU', STATUS='OLD', 
     $      READONLY, ERR=100)
      CLOSE (UNIT=0)
      COMMAND(LC:) = '/COMMAND=SYS$LOGIN:TPUINI'
      LC = LC + 25
100   IF (OUTFILE .NE. ' ') THEN
         COMMAND(LC:) = '/OUTPUT='//OUTFILE
         LC = LENGTH(COMMAND) + 1
      ENDIF
      COMMAND(LC:) = '  '//INFILE
      CALL TPU$TPU(COMMAND)
      RETURN
      END
C
C---END ADAM
C
