      INTEGER *4 FUNCTION TPU$CALLUSER ( INT, STR, STROUT )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **       TPU$CALLUSER        **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          TPU$CALLUSER
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-3
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 694-5578
C*
C*     PURPOSE :
C*          THIS ROUTINE IS CALLED BY ADAM FOR SEVERAL REASONS:
C*          1. DETERMINE IF INVOKED BY "FRED" OR "ADAM"
C*          2. ADD TWO REAL NUMBERS
C*          3. SET COMPLETION STATUS
C*          4. RETURN KEY_PAD SYMBOL (OR OLD_ADAM IF NONE)
C*          5. SPELL CHECK A WORD (NOT YET IMPLEMENTED)
C*
C*     INPUT ARGUMENTS :
C*          INT - INTEGER ITEM CODE (SAME AS IN LIST, ABOVE)
C*          STR - INPUT STRING 
C*                   (NUMBERS TO ADD FOR ITEM 2)
C*                   (NUMBER OF FILES WRITTEN FOR ITEM 3)
C*                   (WORD TO CHECK FOR ITEM 5)
C*
C*     OUTPUT ARGUMENTS :
C*          STROUT - ITEM 1 = "FRED" OR "ADAM"
C*                   ITEM 2 = SUM OF TWO NUMBERS (TEXT)
C*                   ITEM 3 = COPY OF INPUT (COMPLETION STATUS)
C*                   ITEM 4 = KEYPAD NAME
C*                   ITEM 5 = CORRECTED WORD (IF ANY)
C*          TPU$CALLUSER = .TRUE. FOR SUCCESS
C*                       = .FALSE. FOR ILLEGAL NUMBERS TO ADD OR 
C*                                MISSPELLED WORD
C*
C*     SUBPROGRAM REFERENCES :
C*          RECALL, RIGHT, LEFT, LENGTH, STR$COPY_R
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          YOU CAN'T BE SERIOUS
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     CHANGE HISTORY :
C*          17-DEC-1988  -  ADDED KEYPAD NAME CHECK
C*          26-MAY-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      CHARACTER *100 LINE
      CHARACTER *(*) STR
      CHARACTER *13 CSTRNG
      CHARACTER *12 TEMP
      INTEGER *4 STROUT, STRNG(3)
      EQUIVALENCE (CSTRNG,STRNG)
C
C --- INITIALIZATION
C
C --- FRED OR ADAM ?
C
c      IF (INT .EQ. 1) THEN
c         CALL RECALL ( LINE, 1 )
c         IF ((LINE(1:1) .EQ. 'F') .OR. (LINE(1:1) .EQ. 'f')) THEN
c            CSTRNG = 'FRED'
c         ELSE
c            CSTRNG = 'ADAM'
c         ENDIF
c         NUM = 4
c         CALL LIB$SET_SYMBOL('ADAM_STATUS','0')
C
C --- ADD REAL NUMBERS
C
      IF (INT .EQ. 2) THEN
         I = INDEX(STR,',')
         TEMP = STR(1:I-1)
         CALL RIGHT(TEMP)
         READ(TEMP,900,ERR=100) X
         TEMP = STR(I+1:)
         CALL RIGHT(TEMP)
         READ(TEMP,900,ERR=100) Y
         X = X + Y
         IF ((ABS(X) .LE. 1000.0) .AND. (ABS(X) .GE. 0.0001)) THEN
            WRITE(CSTRNG,910) X
         ELSE
            WRITE(CSTRNG,920) X
         ENDIF
         CALL LEFT(CSTRNG)
         NUM = LENGTH(CSTRNG)
C
C --- COMPLETION STATUS
C
      ELSE IF (INT .EQ. 3) THEN
         CSTRNG = STR
         NUM = LENGTH(STR)
         CALL LIB$SET_SYMBOL('ADAM_STATUS',STR(1:NUM))
C
C --- SEE IF "ADAM_KEYPAD" IS DEFINED
C
      ELSE IF (INT .EQ. 4) THEN
         CALL TRANSL8 ('ADAM_KEYPAD', CSTRNG )
         CALL LEFT (CSTRNG)
         NUM = LENGTH(CSTRNG)
C
C --- SPELL CHECK WORD; NOT YET IMPLEMENTED
C
C     ELSE IF (INT .EQ. 5) THEN
C
      ENDIF
C
      CALL STR$COPY_R ( STROUT, NUM, STRNG )
      TPU$CALLUSER = 1
      RETURN
100   TPU$CALLUSER = 0
      RETURN
900   FORMAT(E12.0)
910   FORMAT(F9.4)
920   FORMAT(E13.6)
      END
C
C---END TPU$CALLUSER
C
      SUBROUTINE TRANSL8 ( LOGIC, PHYSIC )
C*
C*                  *******************************
C*                  *******************************
C*                  **                           **
C*                  **          TRANSL8          **
C*                  **                           **
C*                  *******************************
C*                  *******************************
C*
C*     SUBPROGRAM :
C*          TRANSLATE LOGICAL
C*
C*     AUTHOR :
C*          Arthur E. Ragosta
C*          MS 219-3
C*          NASA Ames Research Center
C*          Moffett Field, Ca.  94035
C*          (415) 694-5578
C*
C*     PURPOSE :
C*          TRANSLATE A LOGICAL NAME INTO A PHYSICAL NAME
C*
C*     INPUT ARGUMENTS :
C*          LOGIC - LOGICAL NAME
C*
C*     OUTPUT ARGUMENTS :
C*          PHYSIC - PHYSICAL NAME (TRANSLATION)
C*
C*     SUBPROGRAM REFERENCES :
C*          CAPS,  LENGTH,  SYS$TRNLNM
C*
C*     ASSUMPTIONS AND RESTRICTIONS :
C*          NOT TRANSPORTABLE
C*          RETURNS ONLY THE MOST USER SPECIFIC TRANSLATION
C*
C*     LANGUAGE AND COMPILER :
C*          ANSI FORTRAN 77
C*
C*     VERSION AND DATE :
C*          VERSION I.0  -  20-JUN-1988
C*
C*     CHANGE HISTORY :
C*          20-JUN-1988  -  INITIAL VERSION
C*
C***********************************************************************
C*
      INCLUDE '($LNMDEF)'
      INCLUDE '($SSDEF)'
      CHARACTER *(*) LOGIC, PHYSIC
      CHARACTER *40 LOGC
      DIMENSION ITMLST(4)
      INTEGER*2 ITEM(2)
      EQUIVALENCE (ITEM(1),ITMLST(1))
      INTEGER SYS$TRNLNM
C
      LOGC = LOGIC
      CALL CAPS(LOGC)
      PHYSIC    = ' '
      ITEM(1)   = LEN(PHYSIC)
      ITEM(2)   = LNM$_STRING
      ITMLST(2) = %LOC(PHYSIC)
      ITMLST(3) = %LOC(LP)
      ITMLST(4) = 0
C
C --- SEARCH USER-SPECIFIC (E.G., PROCESS, JOB) TABLES AT THE
C ---  HIGHEST PRIORITY, THEN GROUP AND SYSTEM
C
10    LL = LENGTH ( LOGC )
      IF (LOGC(LL:LL) .EQ. ':') LL = LL - 1
      ISTAT = SYS$TRNLNM ( , 'LNM$PROCESS', LOGC(1:LL),, ITMLST )
      IF (ISTAT .EQ. SS$_NOLOGNAM) THEN
         ISTAT = SYS$TRNLNM ( , 'LNM$JOB', LOGC(1:LL),, ITMLST )
         IF (ISTAT .EQ. SS$_NOLOGNAM) THEN
            ISTAT = SYS$TRNLNM ( , 'LNM$GROUP', LOGC(1:LL),, ITMLST )
            IF (ISTAT .EQ. SS$_NOLOGNAM) THEN
               ISTAT = SYS$TRNLNM ( , 'LNM$SYSTEM', LOGC(1:LL),,
     $                     ITMLST )
            ENDIF
         ENDIF
      ENDIF
      PHYSIC (LP+1:) = ' '
C
C --- DO MULTIPLE TRANSLATIONS
C
      IF (ISTAT .EQ. SS$_NORMAL) THEN
         LOGC = PHYSIC
         GO TO 10
      ENDIF
      RETURN
      END
C
C---END TRANSL8
C
