 with Text_Io ;/   --| Identification procedure State_Transition   #   --| Filename State_Transition.ada   
   --| History !   --|  10/02/88 	PLT	Created Unit 0   --|  12/12/88         PLT     Final Test Begun  @   --| Summary This package body contains all packages necessary :   --|         for the State Transition Executor to operate     --| Description B   --|  This package body contains the following software hierarchy3   --|    Build_Transition_Actions_Package Procedure 2   --|    Build_Transition_Events_Package Procedure2   --|    Build_State_Transition_Executor Procedure    --|      Get_Threads Procedure     --| Requirements"   --|  Use Ward-Mellor Methodology     --| Keywords   --|  Real-Time, Recursion      --| Developed_By   --|  P.L. Treadway)   --|  GTE Government Systems Corporation    --|  1 Research Drive    --|  Mail Stop #54'   --|  Westborough, Massachusetts 01581    --|  (508) 870-4482      --| As_Part_Of4   --|  Structured Development for Real Time Systems      --| Under_Contract   --|  5-9 (After Hours)  #   package body State_Transition is     ----- ; --  Declare Persistent Data visible throught entire package  ----- &   Num_Valid_Threads   : NATURAL := 0 ;*   Not_First_Thread    : Boolean := False ;"   Any_String   : STRING ( 1..1 ) ;   Length       : NATURAL ;  5   package int_io is new text_io.integer_io (integer); 
   use int_io;   /   Simulation_Report_File : Text_Io.File_Type ;  
              H   ----------------------------------------------------------------------H   --                                                                  --H   --         B u i l d _ T r a n s i t i o n _ A c t i o n s          --H   --                                                                  --H   --  This procedure builds the Ada package Transition_Actions.       --H   --  The package Transaction_Actions consists of two Ada files,      --H   --  one for the specification and the other for the body.  The      --H   --  files are named as follows:                                     --H   --                                                                  --H   --   Package Specification:  Transaction_Actions_Spec.Ada           --H   --   Package Body:           Transaction_Actions_Body.Ada           --H   --                                                                  --H   --   With Mealy State Transition Diagrams, an event at some state   --H   --   may cause the system to transition to another state and        --H   --   optionally cause some action to occur.  The State Transition   --H   --   Executor simulates the events which in turn, will cause        --H   --   "Action" procedures in the Transaction_Action package during   --H   --   run-time.  The action that occurs is displayed on the screen   --H   --   and optionally written to a file as well.                      --H   --                                                                  --H   ----------------------------------------------------------------------  /   procedure Build_Transition_Actions_Package (  . 	TA_Table       : Three_D_25_Char_String ) is       Num_Unique_Actions : Natural ;    Found              : Boolean ;E   Unique_TA_Table    : array ( 1..50 ) of String ( 1..Max_String  ) ; 2   TA                 : String ( 1..Max_String  ) ;*   OS_Data_File       : Text_Io.File_Type ;"   Debug		     : Boolean := false ;7   OS_State_Transition_Action_File : Text_Io.File_Type ;      begin  ----- ! --  Find all unique State Actions  -----    Num_Unique_Actions := 0 ;      for i in 1..Num_States loop      for j in 1..Num_Events loop ,       for k in 1..Max_Actions_Per_Event loop$       TA := TA_Table ( i , j , k ) ;       Found := False ;+         for l in 1..Num_Unique_Actions loop B           if TA = "NULL"  or TA = "                         "  or                TA ( 1 ) = ' ' then              Found := true ; 	  end if ; ,           if TA = Unique_TA_Table ( l ) then              Found := True ;           end if ;9         end loop ; -- for l in 1..Num_Unique_Actions loop          if not Found then 9            Num_Unique_Actions := Num_Unique_Actions + 1 ; 9            Unique_TA_Table ( Num_Unique_Actions ) := TA ;          end if ;;       end loop ; --  for k in 1..Max_Actions_Per_Event loop -     end loop ; -- for j in 1..Num_Events loop +   end loop ; -- for i in 1..Num_States loop  ----- 8 --  Create State Transition Action Package Specification ----- ;   Text_Io.Create (File => OS_State_Transition_Action_File , ! 			  Mode =>   Text_Io.Out_File , . 			  Name =>   "Transition_Actions_Spec.Ada" , 			  Form =>   "" ) ;   6   Text_Io.Put_Line ( OS_State_Transition_Action_File ,(     "package Transition_Actions is " ) ;8   Text_Io.New_Line ( OS_State_Transition_Action_File ) ;  %   for i in 1..Num_Unique_Actions loop A     if Unique_TA_Table  ( i ) /= "NULL                     " then :       Text_Io.Put_Line ( OS_State_Transition_Action_File ,         "  procedure " &            Unique_TA_Table ( i ) &          " ; " ) ; 
      end if ; 
    end loop ;   8   Text_Io.New_Line ( OS_State_Transition_Action_File ) ;6   Text_Io.Put_Line ( OS_State_Transition_Action_File ,"     "end Transition_Actions ;" ) ;  >   Text_Io.Close (  File => OS_State_Transition_Action_File ) ; ----- ) --  Build Transition Actions Package Body  ----- ;   Text_Io.Create (File => OS_State_Transition_Action_File , ! 			  Mode =>   Text_Io.Out_File , . 			  Name =>   "Transition_Actions_Body.Ada" , 			  Form =>   "" ) ;   1   Text_Io.Put ( OS_State_Transition_Action_File ,      "with Text_Io " ) ;   B    if Save_Run_Time_Output then -- with in Global Data at run timeA      Text_Io.Put_Line ( OS_State_Transition_Action_File , "," ) ; :      Text_Io.Put_Line ( OS_State_Transition_Action_File  ,,         "     Transition_Global_Data ; " ) ;G      Num_Write_Passes := 2 ; -- Used for how many times to write output     else C      Text_Io.Put_Line ( OS_State_Transition_Action_File  , "; " ) ;       Num_Write_Passes := 1 ;      end if ;   8   Text_Io.New_Line ( OS_State_Transition_Action_File ) ;6   Text_Io.Put_Line ( OS_State_Transition_Action_File ,-     "package body Transition_Actions is " ) ; 8   Text_Io.New_Line ( OS_State_Transition_Action_File ) ;  %   for i in 1..Num_Unique_Actions loop A     if Unique_TA_Table  ( i ) /= "NULL                     " then :       Text_Io.Put_Line ( OS_State_Transition_Action_File ,         "  procedure " &            Unique_TA_Table ( i ) &          " is" ) ; :       Text_Io.Put_Line ( OS_State_Transition_Action_File ,         "    begin" ) ;   1       for Iteration in 1 .. Num_Write_Passes loop A         if Iteration = 1 then -- redirect output to Run-Time File E           Text_Io.Put_Line ( OS_State_Transition_Action_File        , A       "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ;            elseE           Text_Io.Put_Line ( OS_State_Transition_Action_File        , W "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;            end if ;  ;       Text_Io.Put_Line ( OS_State_Transition_Action_File  ,          "    Text_Io.Put ( " & 	"""" &          " | " &  	"""" &          " ) ; " ) ;   :       Text_Io.Put_Line ( OS_State_Transition_Action_File ,         "    text_io.Put ( " &         """" &          Unique_TA_Table ( i ) &          """" &         " ) ; " ) ;   ;       Text_Io.Put_Line ( OS_State_Transition_Action_File  , "         "    Text_Io.Set_Col ( " &         "84" &         " ) ; " ) ;   ;       Text_Io.Put_Line ( OS_State_Transition_Action_File  , #         "    Text_Io.Put_Line ( " &  	"""" & 
         "|" &  	"""" &          " ) ; " ) ;        end loop ;  :       Text_Io.Put_Line ( OS_State_Transition_Action_File ,         "    end " &          Unique_TA_Table ( i ) &          " ; " ) ; ;      Text_Io.New_Line ( OS_State_Transition_Action_File ) ; 
      end if ; 
    end loop ;   6   Text_Io.Put_Line ( OS_State_Transition_Action_File ,"     "end Transition_Actions ;" ) ;  >   Text_Io.Close (  File => OS_State_Transition_Action_File ) ;(   end Build_Transition_Actions_Package ;  H   ----------------------------------------------------------------------H   --                                                                  --H   --         B u i l d _ T r a n s i t i o n _ E v e n t s            --H   --                                                                  --G   --  This procedure builds the Ada package Transition_Events.       -- H   --  The package Transaction_Events consists of two Ada files,       --H   --  one for the specification and the other for the body.  The      --H   --  files are named as follows:                                     --H   --                                                                  --H   --   Package Specification:  Transaction_Events_Spec.Ada            --H   --   Package Body:           Transaction_Events_Body.Ada            --H   --                                                                  --H   --   With Mealy State Transition Diagrams, an event at some state   --H   --   may cause the system to transition to another state and        --H   --   optionally cause some action to occur.  The State Transition   --H   --   Executor simulates all the valid threads of execution in the   --H   --   State Transition Diagram by placing calls to the various       --H   --   "Event" procedures in the Transition_Events Package.  The      --H   --   events simulated are displayed on the screen and optionally    --H   --   written to a file.                                             --H   --                                                                  --H   ----------------------------------------------------------------------  -   procedure Build_Transition_Events_Package ( $ 	States   		: One_D_25_Char_String ;3         Transition_Events  : One_D_25_Char_String ; $ 	TC_Table 		: Two_D_25_Char_String ;& 	TA_Table 		: Three_D_25_Char_String ; 	Start_State    		: Natural ;r&         Stop_State   	 	: Natural ) is  6   OS_State_Transition_Event_File : Text_Io.File_Type ;0   Action_Counter                     : Natural ;    Action_NULL			     : Boolean ;     begins -----v8 --  Create State Transition Events Package Specification -----P:   Text_Io.Create (File => OS_State_Transition_Event_File ,! 			  Mode =>   Text_Io.Out_File ,o- 			  Name =>   "Transition_Events_Spec.Ada" ,s 			  Form =>   "" ) ;_  3 Text_Io.Put_Line ( OS_State_Transition_Event_File , '     "package Transition_Events is " ) ;   7   Text_Io.New_Line ( OS_State_Transition_Event_File ) ;      for i in 1..Num_Events loop 9       Text_Io.Put_Line ( OS_State_Transition_Event_File ,t<         "  procedure " & Transition_Events ( i ) & " ; " ) ;
    end loop ;e  7   Text_Io.New_Line ( OS_State_Transition_Event_File ) ;i5   Text_Io.Put_Line ( OS_State_Transition_Event_File ,d!     "end Transition_Events ;" ) ;h  =   Text_Io.Close (  File => OS_State_Transition_Event_File ) ;  -----h( --  Build Transition Events Package Body -----t:   Text_Io.Create (File => OS_State_Transition_Event_File ,! 			  Mode =>   Text_Io.Out_File , - 			  Name =>   "Transition_Events_Body.Ada" ,- 			  Form =>   "" ) ;-  5   Text_Io.Put_Line ( OS_State_Transition_Event_File ,      "with Text_Io , " ) ; 0   Text_Io.Put ( OS_State_Transition_Event_File ,"     "     Transition_Actions " ) ;  B    if Save_Run_Time_Output then -- with in Global Data at run time@      Text_Io.Put_Line ( OS_State_Transition_Event_File , "," ) ;9      Text_Io.Put_Line ( OS_State_Transition_Event_File  , ,         "     Transition_Global_Data ; " ) ;G      Num_Write_Passes := 2 ; -- Used for how many times to write output     else 9      Text_Io.Put_Line ( OS_State_Transition_Event_File  ,          " ; " ) ;       Num_Write_Passes := 1 ;      end if ;   8   Text_Io.New_Line ( OS_State_Transition_Event_File  ) ;5   Text_Io.Put_Line ( OS_State_Transition_Event_File , $     "use  Transition_Actions ; " ) ;  8   Text_Io.New_Line ( OS_State_Transition_Event_File  ) ;6   Text_Io.Put_Line ( OS_State_Transition_Event_File  ,,     "package body Transition_Events is " ) ;8   Text_Io.New_Line ( OS_State_Transition_Event_File  ) ;  6   Text_Io.Put_Line ( OS_State_Transition_Event_File  ,4     "  type States is ( " & States ( 1 ) & " , " ) ;     for i in 2..Num_States-1 loop 6   Text_Io.Put_Line ( OS_State_Transition_Event_File  ,;     "                   " & States ( i ) & " , " ) ;           end loop ;  6   Text_Io.Put_Line ( OS_State_Transition_Event_File  ,F     "                   " & States ( Num_States ) & " ) ; " ) ;       8   Text_Io.New_Line ( OS_State_Transition_Event_File  ) ;  6   Text_Io.Put_Line ( OS_State_Transition_Event_File  ,?     "  State : States := " & States ( Start_State ) & " ; " ) ;   <   Text_Io.New_Line ( OS_State_Transition_Event_File  , 2 ) ;  !   for Event in 1..Num_Events loop :       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,         "  procedure " &  &         Transition_Events ( Event ) &          " is" ) ; :       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,         "    begin" ) ; 6       if Event = 1 then  -- gives improved readability>          Text_Io.New_Line ( OS_State_Transition_Event_File ) ;       end if ;  :       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,%         "    case STATE is" ) ;        ----- 9 --  Find all states where this Transition Event may occur  -----       %       for State in 1..Num_States loop )         if TC_Table ( State , Event ) /=  *           "NULL                     " then<         Text_Io.Put_Line ( OS_State_Transition_Event_File  ,         "      when " & %         States ( State ) & " => " ) ; ;         -- Output the Transition Actions that are triggered       Action_Counter := 0;       Action_Null := TRUE ;0      for Action in 1..Max_Actions_Per_Event loop1          if TA_Table ( State, Event, Action ) /=  ,             "NULL                     " then 	      Action_NULL := FALSE ; >               if States ( Start_State ) /= States ( State ) or 	        Action > 1 then  Y                 Action_Counter := Action_Counter + 1 ; -- Finish chart and start new page ,                   if Action_Counter >= 2 or E 		    States ( State ) = States ( Start_State ) then -- special print   @                      for Iteration in 1 .. Num_Write_Passes loopN                      if Iteration = 1 then -- redirect output to Run-Time FileM           	        Text_Io.Put_Line ( OS_State_Transition_Event_File        , A       "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ;                       else M           	        Text_Io.Put_Line ( OS_State_Transition_Event_File        , ]       "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;                       end if ;   C    		    Text_Io.Put_Line ( OS_State_Transition_Event_File        , "       		    "    Text_Io.Put ( " &     		    """" &@ 		    "|                           |                          "& 		    """" & 		    " ) ; " ) ;                   end loop ;          else@                      for Iteration in 1 .. Num_Write_Passes loopN                      if Iteration = 1 then -- redirect output to Run-Time FileR                         Text_Io.Put_Line ( OS_State_Transition_Event_File        ,D       		 "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ;                      else M           	        Text_Io.Put_Line ( OS_State_Transition_Event_File        , ]       "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;                       end if ;   @    		 Text_Io.Put_Line ( OS_State_Transition_Event_File        ,       		"    Text_Io.Put ( " &     		"""" &
 		" | "  & 		"""" &
 		" ) ; " ) ;   E                  Text_Io.Put_Line ( OS_State_Transition_Event_File  , %             	  "    Text_Io.Put ( " &  	  	  """" &(         	  Transition_Events ( Event ) &
 		  """" &         	  " ) ; " ) ;              end loop ;,       end if ; -- If Action_Counter >= 2 ...    else     Not_First_Thread := True ;     .    for Iteration in 1 .. Num_Write_Passes loop>      if Iteration = 1 then -- redirect output to Run-Time FileA        Text_Io.Put_Line ( OS_State_Transition_Event_File        , B       "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ; 
       else9       Text_Io.Put_Line ( OS_State_Transition_Event_File , ]       "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;        end if ;  =    Text_Io.Put_Line ( OS_State_Transition_Event_File        , #         "  Text_Io.New_Page  ;" ) ; =    Text_Io.Put_Line ( OS_State_Transition_Event_File        , !         "  Text_Io.Put_Line ( " &  	"""" & X "====================================================================================" & 	"""" &          " ) ;" ) ;  =    Text_Io.Put_Line ( OS_State_Transition_Event_File        , !         "  Text_Io.Put_Line ( " &  	"""" & X "|    S T A T E              |         E V E N T         |    A C T I O N ( S )     |" &         """" &         " ) ;" ) ;  =    Text_Io.Put_Line ( OS_State_Transition_Event_File        , !         "  Text_Io.Put_Line ( " &  	"""" & X "====================================================================================" & 	"""" &          " ) ;" ) ;  =    Text_Io.Put_Line ( OS_State_Transition_Event_File        ,          "  Text_Io.Put ( " &         """" & 	"| " &          """" &         " ) ;" ) ;  <   Text_Io.Put_Line ( OS_State_Transition_Event_File        ,   "    Text_Io.Put ( " &   """" &   States ( Start_State ) &   """" &   " ) ; " ) ;         4 Text_Io.Put_Line ( OS_State_Transition_Event_File  ,         "    Text_Io.Put ( " & 	"""" &          " | " &  	"""" &          " ) ; " ) ;   4 Text_Io.Put_Line ( OS_State_Transition_Event_File  ,   "    Text_Io.Put ( " &   """" &   Transition_Events ( Event ) &    """" &
   " ) ; " ) ;d   end loop ;  & end if ; -- If Not_First_Thread then   -----   --  Output the Transition Action ----- <         Text_Io.Put_Line ( OS_State_Transition_Event_File  ,!           "Transition_Actions." &-/           TA_Table ( State , Event , Action ) &            " ; " ) ;      n     end if ; -- If Action /= NULL<    end loop ; -- for Action in 1..Max_Actions_Per_Event loop ----- 6 --  Check and handle a State Transition with no Action ------    if Action_NULL then/     for Iteration in 1 .. Num_Write_Passes loop >      if Iteration = 1 then -- redirect output to Run-Time FileA        Text_Io.Put_Line ( OS_State_Transition_Event_File        ,TB       "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ; 
       else9       Text_Io.Put_Line ( OS_State_Transition_Event_File ,_]       "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;        end if ;  4 Text_Io.Put_Line ( OS_State_Transition_Event_File  ,         "    Text_Io.Put ( " & 	"""" &r         " | " &S 	"""" &s         " ) ; " ) ;	  4 Text_Io.Put_Line ( OS_State_Transition_Event_File  ,   "    Text_Io.Put ( " &   """" &   Transition_Events ( Event ) &(   """" &
   " ) ; " ) ;t  4 Text_Io.Put_Line ( OS_State_Transition_Event_File  ,     "    Text_Io.Put ( " &
     """" &     " | " & 
     """" &     " ) ; " ) ;l  :       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,"         "    Text_Io.Set_Col ( " &         "84" &         " ) ; " ) ;l       :       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,#         "    Text_Io.Put_Line ( " &i 	"""" &F         "| " & 	"""" &o         " ) ; " ) ; 
    end loop ;     end if ;t  .    for Iteration in 1 .. Num_Write_Passes loop>      if Iteration = 1 then -- redirect output to Run-Time File8      Text_Io.Put_Line ( OS_State_Transition_Event_File ,C         "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ;r	      else 8      Text_Io.Put_Line ( OS_State_Transition_Event_File ,Z    "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;
      end if ;o  7    Text_Io.Put_Line ( OS_State_Transition_Event_File  ,a    "    Text_Io.Put_Line ( " &	    """" & W "+---------------------------+---------------------------+--------------------------+"&n	    """" &     " ) ; " ) ;  G         -- Update the Current State and Print the Change in report filem<         Text_Io.Put_Line ( OS_State_Transition_Event_File  ,D         "        State := " & TC_Table ( State , Event ) & " ; " ) ;  <         Text_Io.Put_Line ( OS_State_Transition_Event_File  ,            "    Text_Io.Put ( " & 	"""" &i         "| " & 	"""" &E 	" ) ; " ) ;  <         Text_Io.Put_Line ( OS_State_Transition_Event_File  ,            "    Text_Io.Put ( " & 	"""" &.&           TC_Table ( State , Event ) & 	"""" &  	" ) ; " ) ;       end loop ;   end if ; -- If TC_Table ...O -----_3 --  Check If at End OF Thread.  If so, finish table_ -----r>     if TC_Table ( State , Event ) = States ( Stop_State ) then2        for Iteration in 1 .. Num_Write_Passes loopB          if Iteration = 1 then -- redirect output to Run-Time File?            Text_Io.Put_Line ( OS_State_Transition_Event_File  , A       "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ; 
          elset?            Text_Io.Put_Line ( OS_State_Transition_Event_File  ,_]       "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;           end if ;   <         Text_Io.Put_Line ( OS_State_Transition_Event_File  ,"         "    Text_Io.Set_Col ( " &
 	   "29" & 	   " ) ; " ) ;_8 	   Text_Io.Put_Line ( OS_State_Transition_Event_File  ,  	    "    Text_Io.Put_Line ( " & 	    """" & @ 	    "|                           |                          |"& 	    """" &( 	    " ) ; " ) ;8 	   Text_Io.Put_Line ( OS_State_Transition_Event_File  ,  	    "    Text_Io.Put_Line ( " & 	    """" & \ 	    "+---------------------------+---------------------------+--------------------------+"& 	    """" &t 	    " ) ; " ) ;            end loop ;c
      end if ;   /       end loop ; -- for z in 1..Num_States loopa  :       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,(         "      when OTHERS =>" ) ;        2        for Iteration in 1 .. Num_Write_Passes loopB          if Iteration = 1 then -- redirect output to Run-Time FileE            Text_Io.Put_Line ( OS_State_Transition_Event_File        , A       "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ;t
          else0E            Text_Io.Put_Line ( OS_State_Transition_Event_File        ,v]       "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;           end if ;   :       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,'         "        Text_Io.Put_Line ( " &          """" & --|* Should be more descriptivei;         "WARNING - Unexpected State Transition Detected." &          """" &         " ) ; " ) ;             end loop ;=  :       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,"         "    end case ;" ) ;        <       Text_Io.New_Line ( OS_State_Transition_Event_File  ) ;:       Text_Io.Put_Line ( OS_State_Transition_Event_File  ,         "  end " &'         Transition_Events  ( Event ) &           " ; " ) ;u;      Text_Io.New_Line ( OS_State_Transition_Event_File  ) ;e
    end loop ;   6   Text_Io.Put_Line ( OS_State_Transition_Event_File  ,!     "end Transition_Events ;" ) ;O  =   Text_Io.Close (  File => OS_State_Transition_Event_File ) ;   '   end Build_Transition_Events_Package ;	  J   ------------------------------------------------------------------------J   --                                                                    --J   --   B u i l d _ S t a t e _ T r a n s i t i o n _ E x e c u t o r    --J   --                                                                    --J   --  This procedure builds the Ada procedure State_Transition_Executor --J   --  The file name for this procedure is as follows:                   --J   --                                                                    --J   --   Procedure: State_Transition_Executor.Ada                         --J   --                                                                    --J   --   This procedure finds all valid threads of execution from a       --J   --   a specified SOURCE state to a specified SINK state.              --J   --   Thus, this procedure can find all valid flows from the SOURCE to --J   --   SINK state, and find all transitions from any state to any other --J   --   state through the "Ad-Hoc" query feature in the MMI.             --J   --                                                                    --J   --                                                                    --J   --   The algorithm makes full use of recursion to fnd all valid       --J   --   transitions between the specified SOURCE and SINK states.        --J   --   The events are simulated by making calls to the Transition_Events -J   --   package.                                                         --J   ------------------------------------------------------------------------  -   procedure Build_State_Transition_Executor (a' 	States        : One_D_25_Char_String ; ' 	Events        : One_D_25_Char_String ;S( 	TC_Table      : Two_D_25_Char_String ; ) 	TA_Table      : Three_D_25_Char_String ;_ 	The_Source    : Natural ;!         The_Sink      : Natural ;  	Simulate      : Boolean ) is"     One		      : CONSTANT := 1 ;   Two		      : CONSTANT := 2 ;  !   Num_Transitions     : NATURAL ; !   The_First_State     : NATURAL ;P"   Num_Output_Passes    : NATURAL ;     )   Debug               : BOOLEAN := FALSE;   :   OS_State_Transition_Executor_File : Text_Io.File_Type ;   &   Transitions : Two_D_25_Char_String ;  H   ----------------------------------------------------------------------H   --                                                                  --6   -- 		     F i n d _ T r a n s i t i o n s 		      --H   --                                                                  --H   --  This procedure finds all valid threads for a given state.       --H   --  Each possible transition is explored from this state, and if    --H   --  necessary, it will recursively call itself to resolve looping   --H   --  and explore further transitions to the SINK state.              --H   --                                                                  --H   ----------------------------------------------------------------------   1 procedure Find_Transitions ( State : in NATURAL ;F 			     Event : in NATURAL ; 			     Transitions : in out 			     Two_D_25_Char_String ;- 			     Num_Transitions : in out NATURAL ) isF   New_State       : NATURAL ;   : function Loop_Found ( Transitions : Two_D_25_Char_String ;# 		      Num_Transitions : NATURAL ; 0 		      Next_State  : Twenty_Five_Char_String )  return BOOLEAN ist   begin   *   for A_State in 1 .. Num_Transitions loop4     if Transitions ( A_State , 1 ) = Next_State then$       return TRUE ; -- loop detected     end if ;   end loop ;" return FALSE ; -- no loop detected    end Loop_Found ;  I procedure Record_Thread ( Transitions     : in out Two_D_25_Char_String ;d# 			  Num_Transitions : NATURAL ) is    Action_Index : NATURAL ; A_State      : NATURAL ; An_Event     : NATURAL ;   begin  Action_Index := 0 ; . Num_Valid_Threads := Num_Valid_Threads + 1 ;    4 if ( Simulate ) then -- User wants FASTER Simulation- for Iteration in 1 .. Num_Output_Passes loop  ;   if Iteration = 1 then -- Direct Output to the Terminal   S4     Text_Io.Set_Output ( Text_Io.Standard_Output ) ;9   Text_Io.Put ( ASCII.ESC & "[?3h" ) ; -- 132 Column moder6   Text_Io.Put ( ASCII.ESC & "[1;1H" ) ; -- Home Cursor   else3     Text_Io.Set_Output ( Simulation_Report_File ) ;s:     If Num_Valid_Threads > 1 then -- Start on a fresh page       Text_Io.New_Page ;     end if ;
   end if ;     Text_Io.Put_Line (  Z "====================================================================================" ) ;   Text_Io.Put_Line ( _Z "|    S T A T E              |         E V E N T         |    A C T I O N ( S )     |" ) ;   Text_Io.Put_Line (  Z "====================================================================================" ) ;  $   for i in 1 .. Num_Transitions loop     Text_Io.Put ( "| " ) ;-     Text_Io.Put ( Transitions ( i , One ) ) ;u     Text_Io.Put ( " | " ) ; -     Text_Io.Put ( Transitions ( i , Two ) ) ;e     Text_Io.Put ( " | " ) ;  -----d2 --  Find correct STATE index into the ACTION table ----- "     for v in 1 .. Num_States loop 5       if States ( v ) = Transitions ( i , one ) then .3          A_State := v ; -- the Correct state index ,          exit ;        end if ;     end loop ; -----u6 --  Find the correct EVENT index into the ACTION table ----- "     for v in 1 .. Num_Events loop 5       if Events ( v ) = Transitions ( i , two ) then  4          An_Event := v ; -- the Correct event index           exit ;        end if ;     end loop ;N     If TA_Table ( A_State , An_Event , 1 ) /= "NULL                     " then     Action_Index := 1 ;N*       While TA_Table( A_State , An_Event ,! 			            Action_Index ) /= m# 	  "NULL                     " loopn"           if Action_Index = 1 thenE 	    Text_Io.Put ( TA_Table ( A_State , An_Event , Action_Index ) ) ;n           else     	    Text_Io.Put ( "| " ) ;l$             Text_Io.Set_Col ( 29 ) ;#             Text_Io.Put ( "| " ) ; -$             Text_Io.Set_Col ( 57 ) ;#             Text_Io.Put ( "| " ) ;  E 	    Text_Io.Put ( TA_Table ( A_State , An_Event , Action_Index ) ) ;,           end if ;   	  Text_Io.Set_Col ( 84 ) ;_ 	  Text_Io.Put_Line ( "|" ) ; ,           Action_Index := Action_Index + 1 ;)         end loop ;  -- end While TA_Table_@        else -- No actions associated with this State/Event index8           if ( Action_Index <= 0 ) then -- Balance Chart   	    Text_Io.Set_Col ( 84 ) ;n 	    Text_Io.Put_Line ( "|" ) ;p           else             Text_Io.New_Line ;           end if ;        end if ;       Text_Io.Put_Line (IX "+---------------------------+---------------------------+--------------------------+");3  end loop ;  --  for i in 1 .. Num_Transitions loop  -----ID -- Print/Display the Sink State to show final state has been reached -----n     Text_Io.Put ( "| " ) ;)     Text_Io.Put ( States ( The_Sink ) ) ;e     Text_Io.Set_Col ( 29 ) ;     Text_Io.Put ( "| " ) ;       Text_Io.Set_Col ( 57 ) ;     Text_Io.Put ( "| " ) ; r     Text_Io.Set_Col ( 84 ) ;     Text_Io.Put_Line ( "|" ) ;     Text_Io.Put_Line (X "+---------------------------+---------------------------+--------------------------+");     Text_Io.New_Line ( 2 ) ;G     Text_Io.Put ( "                        State Transition Path #" ) ;cA     Int_Io.Put ( Num_Valid_Threads , width => 2 , base => 10 ) ; m@  end loop ; --  for Iteration in 1 .. Num_Output_Passes loop ... ----- ) --  Pause screen before returning to Menuo -----n.  for Iteration in 1 .. Num_Output_Passes loop 2   if Iteration = 1 then -- Pause on screen display4     Text_Io.Set_Output ( Text_Io.Standard_Output ) ;     Text_Io.New_Line ( 2 ) ;     Text_Io.Set_Col ( 10 ) ;0     Text_Io.Put ( "Hit RETURN to continue. " ) ;.     Text_Io.Get_Line ( Any_String , Length ) ;8     Text_Io.Put ( ASCII.ESC & "[2J" ) ; -- Clear Screen 8     Text_Io.Put ( ASCII.ESC & "[1;1H" ) ; -- Home Cursor
   end if ;  end loop ;e else ----- C --  User has choosen the Generate Ada Source Code Option in the MMI  ---    e# for i in 1 .. Num_Transitions loop A8   Text_Io.Put_Line ( OS_State_Transition_Executor_File ,@   "    Transition_Events." & Transitions ( i , Two ) & " ; " ) ;
 end loop ;  8 Text_Io.New_Line ( OS_State_Transition_Executor_File ) ;  7 Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,t6 "    Num_Valid_Threads := Num_Valid_Threads + 1 ;" ) ;  7 Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,o%   "    Text_Io.New_Line ( 3 ) ; " ) ;u  7 Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,    "    Text_Io.Put ( " &     """" &4   "                       State Transition Path #" &   """" &
   " ) ; " ) ;(  7 Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,    "    Int_Io.Put ( " &_8   "Num_Valid_Threads , width => 2 , base => 10 ) ; " ) ;  7 Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,    "    Text_Io.New_Line ; " ) ; ! end if ;  -- end if Simulate then(   end Record_Thread ;t _? procedure Record_Transition ( State : Twenty_Five_Char_String ; * 			      Event : Twenty_Five_Char_String ;4 			      Transitions : in out Two_D_25_Char_String ;/ 			      Num_Transitions : in out NATURAL )  is"   begin   ( Num_Transitions := Num_Transitions + 1 ;0 Transitions ( Num_Transitions , One ) := State ;0 Transitions ( Num_Transitions , Two ) := Event ;   end Record_Transition ;   E procedure Pop_Stack ( Transitions     : in out Two_D_25_Char_String ;d- 		      Num_Transitions : in out NATURAL ) isO   beginr+   Transitions ( Num_Transitions , One ) := c!     "                         " ;F+   Transitions ( Num_Transitions , Two ) :=  !     "                         " ;e*   Num_Transitions := Num_Transitions - 1 ; end Pop_Stack ;-   begin-  ,     for An_Event in Event .. Num_Events loop*       if TC_Table ( State , An_Event ) /= " 	"NULL                     "  thenC         if TC_Table ( State , An_Event ) = States ( The_Sink ) then 3             Record_Transition ( States ( State ) , e 				Events ( An_Event ) ,  			        Transitions , 				Num_Transitions ) ;   ?             Record_Thread (  Transitions ,  Num_Transitions ) ;p4 	    Pop_Stack (  Transitions ,  Num_Transitions ) ;8 	elsif not Loop_Found (  Transitions , Num_Transitions ,. 			       TC_Table ( State , An_Event ) ) then2             Record_Transition ( States ( State ) , 				Events ( An_Event ) ,  			         Transitions ,  				 Num_Transitions ) ;: 	    for v in 1 .. Num_States loop -- get new state index  	      if States ( v ) =% 		TC_Table ( State , An_Event ) then  8 		  New_State := v ; -- the state we're transitioning to
 		  exit ; 	      end if ;y 	    end loop ; D             Find_Transitions ( New_State , State_Transition.Source ,+ 			       Transitions , Num_Transitions ) ; 4 	    Pop_Stack (  Transitions ,  Num_Transitions ) ;# 	end if ; -- if TC_Table ... = SinkT$ 	end if ; -- if TC_Table ... /= NULL       end loop ;              end Find_Transitions ; s   beginn0   Num_Valid_Threads := 0 ;  -- Assume no Threads9   if ( Simulate ) then  -- Check if output file specifiedi<     if Save_Simulation_Output then -- Open File at Run-Time C       Num_Output_Passes := 2 ;  -- Used in Find_Transitions & below 6       Text_Io.Create (File => Simulation_Report_File ,   	 Mode =>  Text_Io.Out_File , /   	 Name =>  State_Transition.Simulation_File ,    	 Form =>  "" ) ;      else.       Num_Output_Passes := 1 ; -- Display Only     end if ;   else -----i9 --  Build State Transition Executor Procedure Sub-Programa -----u=   Text_Io.Create (File => OS_State_Transition_Executor_File ,n! 			  Mode =>   Text_Io.Out_File ,x0 			  Name =>   "State_Transition_Executor.Ada" , 			  Form =>   "" ) ;   :    Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,         "with Text_Io ," ) ;5    Text_Io.Put ( OS_State_Transition_Executor_File  ,i%         "     Transition_Events " ) ;t  B    if Save_Run_Time_Output then -- with in Global Data at run timeE      Text_Io.Put_Line ( OS_State_Transition_Executor_File  , ", " ) ;         F<      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,,         "     Transition_Global_Data ; " ) ;G      Num_Write_Passes := 2 ; -- Used for how many times to write outpute    else <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,         " ; " ) ;       Num_Write_Passes := 1 ;      end if ;   <    Text_Io.New_Line ( OS_State_Transition_Executor_File  ) ;  :    Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,5         "procedure State_Transition_Executor is " ) ; <    Text_Io.New_Line ( OS_State_Transition_Executor_File  ) ;:    Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,@      "package int_io is new text_io.integer_io (integer) ; " ) ;  :    Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,      "use int_io ; " ) ;  <    Text_Io.New_Line ( OS_State_Transition_Executor_File  ) ;  :    Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,-      "Num_Valid_Threads : NATURAL := 0 ;" ) ;   <    Text_Io.New_Line ( OS_State_Transition_Executor_File  ) ;:    Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,         "  begin" ) ;=  7   if Save_Run_Time_Output then -- Open File at Run-Time=;     Text_Io.Put_Line ( OS_State_Transition_Executor_File  , Q   "    Text_Io.Create ( Transition_Global_Data.State_Transition_Report_File , ");.;     Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,=K     "                   Text_Io.Out_File , " & """" & Run_Time_Report_file   				 	     & """" & " ) ; " ) ; 
   end if ;   end if ; -- if not Simulate    Num_Transitions := 0 ; ----- $ --  Find a valid thread of execution -----e@        Find_Transitions ( The_Source , State_Transition.Source ,,       			  Transitions , Num_Transitions ) ; -----u? --  Indicate the end of the State Transition Executor Procedureh$ --  and finish bottom line of report -----s.    if ( Simulate ) then -- Output Final Totals2      for Iteration in 1 .. Num_Output_Passes loop @        if Iteration = 1 then -- Direct Output to the Terminal   9          Text_Io.Set_Output ( Text_Io.Standard_Output ) ;         else_8          Text_Io.Set_Output ( Simulation_Report_File ) ;        end if ;         Text_Io.New_Line ( 2 ) ; \      Text_Io.Put_Line ( "                       State Transition Execution Completed.  " ) ;      Text_Io.New_Line ( 2 ) ;e(      if Num_Valid_Threads <= 0 then     Q        Text_Io.Put_Line ( "          There are no Transition Paths between: " ) ;_        Text_Io.New_Line ;         Text_Io.Set_Col ( 16 ) ; 3        Text_Io.Put_Line ( States ( The_Source ) ) ;         Text_Io.Set_Col ( 12 ) ; (        Text_Io.Put_Line ( "and ... " ) ;        Text_Io.Set_Col ( 16 ) ; 1        Text_Io.Put_Line ( States ( The_Sink ) ) ;P3      else -- At least one transition path was found $      If Num_Valid_Threads >= 2 then <        Text_Io.Put ( "                       There are " ) ;	      else:;        Text_Io.Put ( "                       There is " ) ;l
      end if ;   B      Int_Io.Put ( Num_Valid_Threads , width => 1 , base => 10 ) ;   $      If Num_Valid_Threads >= 2 then 3        Text_Io.Put_Line ( " Transition Paths, " ) ;L	      else 2        Text_Io.Put_Line ( " Transition Path, " ) ;
      end if ;f  J       Text_Io.Put_Line ( "                         from Source State: " & !         States ( The_Source ) ) ;-  J       Text_Io.Put_Line ( "                         to   Sink   State: " &          States ( The_Sink ) ) ; -     end if ; -- end is Num_Valid_Threads <= 0- ----- @ --  If Output is being directed to the screen; display pause msg -----       if Iteration = 1 then     Text_Io.New_Line ( 2 ) ;     Text_Io.Set_Col ( 10 ) ;0     Text_Io.Put ( "Hit RETURN to continue. " ) ;.     Text_Io.Get_Line ( Any_String , Length ) ;D     Text_Io.Put ( ASCII.ESC & "[?3l" ) ; -- Return to 80 Column mode    end if ;-$ end loop ; -- for Iteration in 1 ... -----)! --  Close Simulation file if open  ----- <     if Save_Simulation_Output then -- CloseFile at Run-Time 0       Text_Io.Close ( Simulation_Report_File ) ;6       Text_Io.Set_Output ( Text_Io.Standard_Output ) ;     end if ;    else -- Generate Ada Code;     Text_Io.Put_Line ( OS_State_Transition_Executor_File  , (     "    Text_Io.New_Line ( 2 ) ; "  ) ;  &    if Num_Valid_Threads >= 0 then     .    for Iteration in 1 .. Num_Write_Passes loop:      if Iteration = 1 then -- direct output to report file>        Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,C         "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ; 	      elseu>        Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,V "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File) ; " ) ;
      end if ;   <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,%        "    Text_Io.New_Line ; "  ) ;s  <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,!       "    Text_Io.Put_Line ( " &n       """" &G       "                       State Transition Execution Completed.  "&        """" &       " ) ; " ) ;_  <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,+        "    Text_Io.New_Line ( 2 ) ; "  ) ;   $      If Num_Valid_Threads >= 2 then <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,       "    Text_Io.Put ( " &       """" &+       "                       There are " &e       """" &       " ) ; " ) ;i
       else<      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,       "    Text_Io.Put ( " &       """" &*       "                       There is " &       """" &       " ) ; " ) ;        end if ;  <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,       "    Int_Io.Put ( " &n<       "Num_Valid_Threads , width => 1 , base => 10 ) ; " ) ;  $      If Num_Valid_Threads >= 2 then =       Text_Io.Put_Line ( OS_State_Transition_Executor_File  , !       "    Text_Io.Put_Line ( " &=       """" &       " Transition Paths, " &n       """" &       " ) ; " ) ;i	      else_=       Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,r!       "    Text_Io.Put_Line ( " &        """" &       " Transition Path, " &       """" &       " ) ; " ) ;i
      end if ;   <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,!       "    Text_Io.Put_Line ( " &_       """" &N       "                         from Source State: " & States ( The_Source ) &       """" &       " ) ; " ) ;e  <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,!       "    Text_Io.Put_Line ( " &"       """" &L       "                         to   Sink   State: " & States ( The_Sink ) &       """" &       " ) ; " ) ;a
    end loop ;sA    else -- No valid thread between specified start and stop state,.    for Iteration in 1 .. Num_Write_Passes loop:      if Iteration = 1 then -- direct output to report file>        Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,C         "    Text_Io.Set_Output ( Text_Io.Standard_Output ) ; " ) ;v	      elsen>        Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,W "    Text_Io.Set_Output ( Transition_Global_Data.State_Transition_Report_File ) ; " ) ;.
      end if ;p  <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,!       "    Text_Io.Put_Line ( " &_       """" &4       "         There were no Transitions Found, " &       """" &       " ) ; " ) ;   <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,!       "    Text_Io.Put_Line ( " &i       """" &@       "           from Source State: " & States ( The_Source ) &       """" &       " ) ; " ) ;   <      Text_Io.Put_Line ( OS_State_Transition_Executor_File  ,!       "    Text_Io.Put_Line ( " &        """" &>       "           to   Sink   State: " & States ( The_Sink ) &       """" &       " ) ; " ) ; 
    end loop ;i    end if ;n  <    Text_Io.New_Line ( OS_State_Transition_Executor_File  ) ;5    Text_Io.Put ( OS_State_Transition_Executor_File  ,(.         "end State_Transition_Executor ; " ) ;   A    Text_Io.Close (  File => OS_State_Transition_Executor_File ) ; '   end if ; -- if ( Not Simulate ) then u  '   end Build_State_Transition_Executor ;    ----7 --  Main Processing Loop for Package "State_Transition"r ---- begina null ; end State_Transition ;