 with State_Transition , 
   --| Imports )   --|    Build_Transition_Actions_Package (   --|    Build_Transition_Events_Package   --|    Build_State_Transition         Text_io ;
   --| Imports    --|    Get_Line    --|    Put_Line    --|    Integer_Io   6   --| Identification package body State_Transition_MMI  '   --| Filename State_Transition_MMI.ada   
   --| History !   --|  10/31/88 	PLT	Created Unit +   --|  12/04/88  	PLT	Started Final Testing H   --|  12/13/88         PLT     Added additional comments for robustness7   --|  01/26/89		PLT	Added direct simulation capability D   --|  03/14/89		PLT	Added page #'s on output and no-scroll displays  E   --| Summary This procedure contains all MMI procedures used in the  -   --|         FASTER State Machine CASE Tool.      --| Description >   --|  State_Transition_MMI contains the following procedures:      --| STATE_TRANSITIONS_MMI (   --| Vax Run Time Library - DO_COMMAND #   --| Clear_Screen_And_Home_Cursor     --| Display_Msg #   --| Get_State_And_Event_Indices      --| Get_State_Index      --| Get_Event_Index      --| Write_States     --| Write_Events     --| Write_Event_Table      --| Write_Action_Table     --| Display_States     --| Display_Events  !   --| Display_States_And_Events      --| Display_Transition_Table     --| Display_Action_Table  (   --| Get_State_Transition_Diagram_File    --| Check_If_Object_Exists  *   --| Write_State_Transition_Data_To_Disk !   --| GET_STATE_TRANSITION_INPUT     --| Display_Menu  %   --| Build_State_Transition_Diagram     --| Generate_Ada_Source_Code     --| Enter_Add_Object       --| Delete_An_Object        '   --| Clean_Up_Event_And_Action_Tables     --| Delete_A_Transition    --| Delete_An_Action     --| Change_Object              --| Change_Transition_Table     --| Enter_Add_Transition_Table   --| Change_Action_Table    --| Enter_Add_Action_Table     --| Requirements,   --|  Adhere to the Ward-Mellor Methodology     --| Keywords   --|  Real-Time   --|  Unconstrained Array     --| Developed_By   --|  P.L. Treadway)   --|  GTE Government Systems Corporation    --|  1 Research Drive    --|  Mail Stop #54'   --|  Westborough, Massachusetts 01581    --|  (508) 870-4482      --| As_Part_OfB   --|  Structured Development for Real Time Systems Course (SC525)9   --|  Taught at Boston University College of Engineering #   --|  by Professor Richard Vidale.      --| Under_Contract   --|  5-9 (After Hours)  # procedure  state_transitions_mmi is  -----  --  Import VAXAda Routines.    ----- -   procedure DO_COMMAND (COMMAND : in STRING); (   pragma INTERFACE (VAXRTL, DO_COMMAND);(   pragma IMPORT_PROCEDURE ( DO_COMMAND,      		  	    "LIB$DO_COMMAND",  * 			     MECHANISM => (DESCRIPTOR(S)));      :   Num_Enter_Change_Menu_Lines   : Constant Natural := 17 ;:   Num_Master_Menu_Choices       : Constant Natural :=  6 ;:   Num_Display_Menu_Choices      : Constant Natural :=  5 ;:   Num_Enter_Change_Menu_Choices : Constant Natural := 13 ;<   Num_Code_Generation_Menu_Choices : Constant Natural := 3 ;9   Num_Simulation_Menu_Choices   : Constant Natural := 3 ; :   Num_Reports_Menu_Choices      : Constant Natural :=  6 ;5   Display_Objects_Per_Page	: Constant Natural := 16 ; .   Objects_Per_Page		: Constant Natural := 50 ;3   Transitions_Per_Page 		: Constant Natural := 15 ; 3   Zero 		                : Constant Natural  := 0 ; ;   Header_Line                   : Constant Natural  := 0 ;  +   Simulate		 	: Constant Boolean  := True ; 0   Code_Generate 		: Constant Boolean  := False ;     Selected_Option : Natural ;    Change_Option   : Natural ;    Report_Option   : Natural ; $   Code_Generation_Option : Natural ;   Simulation_Option : Natural ;    Current_Page    : Natural ; "   Objects_On_Last_Page : Natural ;   Num_Pages       : Natural ;    Num_Items 	  : NATURAL ;   Object_Counter  : Natural ;    Num_Objects     : Natural ;    Action_Index    : Natural ;    State_Event_Pairs : Natural ;    State_Index     : Natural ;    Event_Index     : Natural ;    Object_Index    : Natural ; "   String_Length   : Natural := 1 ;"   Source_State    : Natural := 1 ;"   Sink_State      : Natural := 1 ;  )   File_Activity   			: Boolean := False ; )   Build_Done      			: Boolean := False ; (   Active_Session  			: Boolean := True ;.   Latent_Errors 		        : Boolean := False ;)   Object_Exists   			: Boolean := False ; 1   Report_File_Entered      		: Boolean := False ; .   Transition_Table_In_Db 		: Boolean := False;+   Action_Table_In_Db 			: Boolean := False; &   States_In_Db  			: Boolean := False;.   Events_In_Db 		 	        : Boolean := False;)   Debug           			: Boolean := False ; )   New_File        			: Boolean := False ; 9   State_Transition_Diagram_Entered  	: Boolean := False ; *   In_Reports_Menu  			: Boolean := False ;*   In_Change_Menu   			: Boolean := False ;*   In_Display_Menu  			: Boolean := False ;0   In_Code_Generation_Menu 		: Boolean := False ;,   In_Simulation_Menu 			: Boolean := False ;  &   Any_String       : string ( 1..1)  ;A   An_Object        : String ( 1..State_Transition.Max_String  ) ; A   A_State          : String ( 1..State_Transition.Max_String  ) ; A   An_Event         : String ( 1..State_Transition.Max_String  ) ; A   An_Action        : String ( 1..State_Transition.Max_String  ) ; A   A_Transition     : String ( 1..State_Transition.Max_String  ) ; O   State_Transition_Diagram       : String ( 1..State_Transition.Max_String  ) ;   )   OS_Data_File      : Text_Io.File_Type ;   2   type Answer_Type is ( YES, NO , Y , N , Yeah ) ;#     Answer          : Answer_Type ;   L   type Generic_Menu_Type is array ( Integer range <> ) of string ( 1..45 ) ;  <   package int_io    is new text_io.integer_io     (integer);@   package Answer_io is new text_io.enumeration_io (Answer_Type);  )   type Object_Type is ( State , Event ) ; 1     Enum_State          : Object_Type := State ;  -     Enum_Event      : Object_Type := Event ;    #   Invalid_State_Index : exception ;    ------------------ --  Error Msgs  -- ------------------4   Pause_Msg                       : Constant String -     := "Hit a Carraige Return to Continue." ; 4   States_Written_To_Disk          : Constant String A     := "States Written to Report File - Hit Return To Continue" ; 4   No_Report_File                  : Constant String =     := "No Report File Specified. - Hit Return To Continue" ; 4   Events_Written_To_Disk          : Constant String A     := "Events Written to Report File - Hit Return To Continue" ; 9   Event_Table_Written_To_Disk          : Constant String  F     := "Event Table Written to Report File - Hit Return To Continue" ;:   Action_Table_Written_To_Disk          : Constant String G     := "Action Table Written to Report File - Hit Return To Continue" ; 8   Build_Done_Msg                      : Constant String \     := "State Transition Diagram Execution Completed.  Hit a Carraige Return to Continue." ;1   Data_Error_Detected_Msg       : Constant String +     := "Warning - Data Conversion Error." ; 4   Bad_File_Detected_Msg           : Constant String 0     := "Warning - End Of Data File Dectected." ;4   Invalid_Response_Entered_Msg    : Constant String ,     := "Error - Invalid Response Entered." ;4   File_Not_Found_Msg              : Constant String "     := "Error - File Not Found." ;4   Non_Existent_State_Msg          : Constant String -     := "Error - Specified State not Found." ; 0   Non_Existent_Event_Msg      : Constant String -     := "Error - Specified Event not Found." ; 0   Invalid_Event_Number_Msg    : Constant String (     := "Error - Invalid Event Number." ;4   Invalid_State_Number_Msg        : Constant String (     := "Error - Invalid State Number." ;4   Invalid_Action_Number_Msg       : Constant String )     := "Error - Invalid Action Number." ; ,   Duplicate_State_Msg     : Constant String )     := "Error - Duplicate State Found." ; (   Duplicate_Event_Msg : Constant String )     := "Error - Duplicate Event Found." ; ,   No_States_Entered       : Constant String %     := "Error - No States Entered." ; (   No_Events_Entered   : Constant String %     := "Error - No Events Entered." ; ,   Transition_Deleted      : Constant String      := "Transition Deleted." ;2   No_Transition_Table_Entered   : Constant String ;     := "Error - No Transition Table Information Entered." ; +   No_Transition_Exists   : Constant String  )     := "Error - No Transition Exists. " ; ,   No_Action_Table_Entered : Constant String 7     := "Error - No Action Table Information Entered." ; -   Invalid_State           : Constant String   7     := "Error - State Not Found.  Enter State in Db." ; ,   Not_Yet_Implemented     : Constant String *     := "Warning - Not Yet Implemented" ;  ,   No_Data_To_Display      : Constant String 4     := "Error - No Data to Display.  Enter Data." ; 9   Enter_State_Transition_Diagram       : Constant String  A     := "Error -  No data entered in State Transition Diagram." ;  <   No_State_Transition_Diagram_Selected : Constant String := +     "No State Transition Diagram Selected"; '   Unexpected_Input : Constant String := &     "Unexpected Input Encountered !" ;<   ST_Report_File_Selected              : Constant String := 7      "State Transition Executor Output File Enabled." ; /   Report_File_Already_Entered : Constant String H     := "Warning - Report File Already Entered - Closing Current File." ; ----- # --  Compile , Link and Run Commands  ----- 5     Compile_Line_And_Run_Command : Constant String := #      "@State_Transition_Executor" ;   >   States , Events  : State_Transition.ONE_D_25_CHAR_STRING := -   ( OTHERS => "NULL                     " ) ;   B   Transaction_Events    : State_Transition.TWO_D_25_CHAR_STRING :=&   ( 1..State_Transition.Max_States => %   ( 1..State_Transition.Max_Events =>a=   "NULL                     " ) ) ;                          m  I   Transaction_Actions        : State_Transition.THREE_D_25_CHAR_STRING := &   ( 1..State_Transition.Max_States => %   ( 1..State_Transition.Max_Events =>t0   ( 1..State_Transition.Max_Actions_Per_Event =>?   "NULL                     " ) ) ) ;                             D   Master_Menu :  Generic_Menu_Type ( 0..Num_Master_Menu_Choices)  :=:   ( 0 => "         FASTER Master Menu                  " ,:     1 => "1 - FASTER Data Menu                         " ,:     2 => "2 - FASTER Display Menu                      " ,:     3 => "3 - FASTER Reports Menu                      " ,:     4 => "4 - FASTER Simulation Menu                   " ,:     5 => "5 - FASTER Ada Code Generator Menu           " ,<     6 => "6 - Exit to DCL                              " ) ;  0   Enter_Change_State_Transition_Diagram_Menu :  :     Generic_Menu_Type (0..Num_Enter_Change_Menu_Lines ) :=:   ( 0 => "         FASTER Data Menu                    " ,:     1 => "1 - Enter/Add State(s)                       " ,>     2 => "2 - Change A State                           " ,    :     3 => "3 - Delete A State                           " ,:     4 => "                                             " ,:     5 => "4 - Enter/Add Event(s)                       " ,:     6 => "5 - Change An Existing Event                 " ,:     7 => "6 - Delete An Event                          " ,:     8 => "                                             " ,:     9 => "7 - Enter/Add Transition Table Entry         " ,;     10 => "8 - Change A Transition Table Entry          " , ;     11 => "9 - Delete A Transition Table Entry          " , ;     12 => "                                             " , ;     13 => "10 - Enter/Add Action Table Entry            " , ;     14 => "11 - Change An Action Table Entry            " , ;     15 => "12 - Delete An Action Table Entry            " , ;     16 => "                                             " , =     17 => "13 - Return to Master Menu                   " ) ;   +   Display_State_Transition_Diagram_Menu  :  6     Generic_Menu_Type (0..Num_Display_Menu_Choices) :=:   ( 0 => "         FASTER Display Menu                 " ,:     1 => "1 - Display State(s)                         " ,:     2 => "2 - Display Event(s)                         " ,:     3 => "3 - Display Transition Table                 " ,:     4 => "4 - Display Action Table                     " ,<     5 => "5 - Return to Master Menu                    " ) ;  E   Reports_Menu :  Generic_Menu_Type  (0..Num_Reports_Menu_Choices) := :   ( 0 => "          FASTER Reports Menu                " ,:     1 => "1 - Select Report File Name                  " ,:     2 => "2 - Write States to Report File              " ,:     3 => "3 - Write Events to Report File              " ,:     4 => "4 - Write Transition Table to Report File    " ,:     5 => "5 - Write Action Table to Report File        " ,<     6 => "6 - Return to Master Menu                    " ) ;  -   Code_Generation_Menu :  Generic_Menu_Type   -     (0..Num_Code_Generation_Menu_Choices) :=  :   ( 0 => "       FASTER Ada Code Generator Menu        " ,:     1 => "1 - Generate Ada State Machine Source Code   " ,:     2 => "2 - Save Run-Time Simulation Output          " ,<     3 => "3 - Return to Master Menu                    " ) ;  (   Simulation_Menu :  Generic_Menu_Type  (     (0..Num_Simulation_Menu_Choices) := :   ( 0 => "           FASTER Simulation Menu            " ,:     1 => "1 - Simulate State Machine                   " ,:     2 => "2 - Save Simulation Output in a Report File  " ,<     3 => "3 - Return to Master Menu                    " ) ;  +   procedure Clear_Screen_And_Home_Cursor is  ----- 9 --  This procedure Clears the SCreen and Homes the cursor  -----    begin ;     Text_Io.Put_Line ( Ascii.Esc&"[2J" ) ;  -- Clear Screen :     Text_Io.Put ( Ascii.ESC&"[1;1H" ) ;	    -- Home Cursor$   end Clear_Screen_And_Home_Cursor ;  0   procedure Display_Msg ( The_Msg    : string ; & 			  Sound_Bell : Boolean := True ) is ----- D --  This procedure displays a message on the screen and will defaultI --  to beeping the user as well, unless directed not to by the procedural J --  invocation.  ( Not all messages are error messages ; most are though ) -----    begin    Text_Io.New_Line ( 2 ) ;   Text_Io.Set_Col ( 10 ) ;   if Sound_Bell then'     Text_Io.Put ( Ascii.Bel&The_Msg ) ;    else     Text_Io.Put ( The_Msg ) ; 
   end if ;   Text_Io.New_Line ( 2 ) ;   Text_Io.Set_Col ( 10 ) ;"   Text_Io.Put_Line ( Pause_Msg ) ;5   Text_Io.Get_Line ( Any_String , String_Length ) ;      end Display_Msg ;   2   procedure Write_State_Transition_Data_To_Disk is     begin    if New_File then-     Text_Io.Create (  File =>  OS_Data_File , #   		    Mode =>  Text_Io.Out_File , *   		    Name =>  State_Transition_Diagram,   		    Form =>  "" ) ;    else ----- 6 --  Open State Transition Data File and Write Out Data ----- +     Text_Io.Open (  File =>  OS_Data_File , #   		    Mode =>  Text_Io.Out_File , *   		    Name =>  State_Transition_Diagram,   		    Form =>  "" ) ; 
   end if ; ----- * -- Output the Number of Valid States First -----       "       Int_Io.Put ( OS_Data_File , H                    State_Transition.Num_States , width=> 3, base=>10 ) ;)       Text_Io.New_Line ( OS_Data_File ) ;  ----- " --  Output the Names of all States ----- 2       for i in 1..State_Transition.Num_States loop<           Text_Io.Put_Line ( OS_Data_File , States ( i ) ) ;       end loop ; ----- ) -- Output the number of Transition Events  ----- ?       Int_Io.Put ( OS_Data_File , State_Transition.Num_Events , *                    width=> 3, base=>10 ) ;)       Text_Io.New_Line ( OS_Data_File ) ;  ----- - --  Output the Names of all Transition Events  ----- 2       for i in 1..State_Transition.Num_Events loop<           Text_Io.Put_Line ( OS_Data_File , Events ( i ) ) ;       end loop ; ----- B --  Output all State Transitions for each State/Event Intersection ----- 2       for k in 1..State_Transition.Num_States loop4         for i in 1..State_Transition.Num_Events loop.             Text_Io.Put_Line ( OS_Data_File , % 	    Transaction_Events ( k , i ) ) ;            end loop ;       end loop ; ----- F --  Output all the Transition Actions when a Event is met in the state -----               2       for k in 1..State_Transition.Num_States loop4         for i in 1..State_Transition.Num_Events loopI           for An_Action in 1..State_Transition.Max_Actions_Per_Event loop :             if Transaction_Actions ( k , i , An_Action ) =/                "NULL                     " then $               if An_Action >= 2 then3                 Text_Io.New_Line ( OS_Data_File ) ; B                 exit ;  -- rest of loop guarenteed to be NULL also              else Q                 Text_Io.Put_Line ( OS_Data_File , "NULL                     " ) ; B                 exit ;  -- rest of loop guarenteed to be NULL also.              end if ;  -- if An_Action > 2 ...             else+               Text_Io.Put ( OS_Data_File ,  5 		Transaction_Actions ( k , i , An_Action ) & " " ) ;              end if ;
 	  end loop ; 1         end loop ; -- for i in 1..Num_Events loop A       end loop ;  -- for k in 1..State_Transition.Num_States loop  ----- ( --  Close the new State Transition File  ----- &   Text_Io.New_Line ( OS_Data_File )  ;"   Text_Io.Close ( OS_Data_File ) ;  +   end Write_State_Transition_Data_To_Disk ;   %   procedure Prompt_User_To_Save_Db is  ----- E --  This procedure Prompts the user if they wish to save any database B --  insertions, deletions, changes or additions before closing the --  State Transition Database. -----    begin !             If File_Activity then "  	      Text_Io.Set_Col ( 10 ) ;  A               Text_Io.Put ( "Save Any Changes ? (Yes or No) " ) ; (               Answer_IO.Get ( Answer ) ;(               Text_Io.Skip_Line ( 1 )  ;>               if Answer = YES or ANSWER = Y or ANSWER = y then5                 Write_State_Transition_Data_To_Disk ;                end if ;     	      Text_Io.New_Line ( 2 ) ;     	    End If ; -----  --  Exception Handler Area -----l   exceptione     when others =>4       Display_Msg ( Invalid_Response_Entered_Msg ) ;+       Prompt_User_To_Save_Db ; -- Try againe     end Prompt_User_To_Save_Db ;  +   procedure Get_State_And_Event_Indices  is      procedure Get_State_Index is       begin-     Text_Io.New_Line ( 2 ) ;     Text_Io.Set_Col ( 10 ) ;+     Text_Io.Put ( "Enter State #    : " ) ;_#     Int_Io.Get ( State_Index ) ;         Text_Io.Skip_Line ( 1 ) ;s ----- ! -- Check For Invalid State Index a -----L!     If not ( State_Index > 0 and  7 	     State_Index <= State_Transition.Num_States ) thena!       raise Invalid_State_Index ;G     end if ; -----a. --  Invalid State Index Exception Handler Area -----n   exception.      when Invalid_State_Index => 8       Display_Msg ( Invalid_State_Number_Msg , False ) ;$       Get_State_Index ; -- Try Again     when others => .(       Display_Msg ( Unexpected_Input ) ;$       Get_State_Index ; -- Try Again   end Get_State_Index ;A     procedure Get_Event_Index is    #   Invalid_Event_Index : exception ;n     begin        Text_Io.New_Line ;       Text_Io.Set_Col ( 10 ) ;-       Text_Io.Put ( "Enter Event #    : " ) ;o%       Int_Io.Get ( Event_Index ) ;   "       Text_Io.Skip_Line ( 1 ) ;u ----- ! -- Check For Invalid Event Index   ----- #       If not ( Event_Index > 0 and h9 	       Event_Index <= State_Transition.Num_Events ) thenp#         raise Invalid_Event_Index ;=       end if ; -----S. --  Invalid Event Index Exception Handler Area -----e   exception)      when Invalid_Event_Index => 0       Display_Msg ( Invalid_Event_Number_Msg ) ;$       Get_Event_Index ; -- Try Again     when others =>  (       Display_Msg ( Unexpected_Input ) ;$       Get_Event_Index ; -- Try Again   end Get_Event_Index ;      begin      Get_State_Index ;      Get_Event_Index ;t#   end Get_State_And_Event_Indices ;e e`    procedure Write_Page_Number ( Current_Page : in out NATURAL ; Num_Pages : in out NATURAL ) is
      begin=        Text_Io.New_Line ( State_Transition.OS_Report_File ) ;-A        Text_Io.Set_Col ( State_Transition.OS_Report_File , 33 ) ;tB        Text_Io.Put ( State_Transition.OS_Report_File , "Page " ) ;^        Int_Io.Put ( State_Transition.OS_Report_File , Current_Page , width=> 1, base => 10 ) ;A        Text_Io.Put ( State_Transition.OS_Report_File , " of " ) ; [        Int_Io.Put ( State_Transition.OS_Report_File , Num_Pages , width=> 1, base => 10 ) ; )        Current_Page := Current_Page + 1 ;e/        Object_Counter := 0 ;  -- reset counter        end Write_Page_Number ; M     procedure Write_States is   %     procedure Write_States_Header is >
      begin=       Text_Io.New_Page ( State_Transition.OS_Report_File  ) ;tB       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  Z       Text_Io.Put_Line ( State_Transition.OS_Report_File ,"==========================" ) ;B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  W       Text_Io.Put_Line ( State_Transition.OS_Report_File , "         STATES " ) ;      (B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  [       Text_Io.Put_Line ( State_Transition.OS_Report_File , "==========================" ) ;>@       Text_Io.New_Line ( State_Transition.OS_Report_File , 2 ) ;     end Write_States_Header ;      begin,     Current_Page := 1 ;n     Object_Counter := 0 ; A     Num_Pages := State_Transition.Num_States / Objects_Per_Page ; H     if ( State_Transition.Num_States mod Objects_Per_Page /= zero ) then"       Num_Pages := Num_Pages + 1 ;     end if ;     Write_States_Header ;s8       for A_State in 1..State_Transition.Num_States loopD         Text_Io.Set_Col ( State_Transition.OS_Report_File , 27 ) ;  X         Int_Io.Put  ( State_Transition.OS_Report_File , A_State, width=> 1, base=>10 ) ;D         Text_Io.Set_Col ( State_Transition.OS_Report_File , 30 ) ;  Z         Text_Io.Put_Line ( State_Transition.OS_Report_File , ") " & States ( A_state ) ) ;.         Object_Counter := Object_Counter + 1 ;8         if Object_Counter mod Objects_Per_Page = 0 then :           Write_Page_Number ( Current_Page , Num_Pages ) ;            Write_States_Header ;          end if ;       end loop ; -----i# --  Print page number for last page  -----e8         if Object_Counter mod Objects_Per_Page /= 0 thenI                 Object_Counter := Objects_Per_Page mod Objects_Per_Page ;&@            Object_Counter := Objects_Per_Page - Object_Counter ;0            for A_State in 1..Object_Counter loopC              Text_Io.New_Line ( State_Transition.OS_Report_File ) ;u            end loop ;n;            Write_Page_Number ( Current_Page , Num_Pages ) ;,         end if ;         Text_Io.New_Line ;@       Text_Io.Set_Col ( State_Transition.OS_Report_File , 10 ) ;6       Display_Msg ( States_Written_To_Disk , False ) ;   end Write_States ;     procedure Write_Events is   $     procedure Write_Events_Header is
      begin=       Text_Io.New_Page ( State_Transition.OS_Report_File  ) ; B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  [       Text_Io.Put_Line ( State_Transition.OS_Report_File , "==========================" ) ;_B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  W       Text_Io.Put_Line ( State_Transition.OS_Report_File , "         EVENTS " ) ;       B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  [       Text_Io.Put_Line ( State_Transition.OS_Report_File , "==========================" ) ;(@       Text_Io.New_Line ( State_Transition.OS_Report_File , 2 ) ;      end Write_Events_Header ;     begin      Current_Page := 1 ;      Object_Counter := 0 ;uA     Num_Pages := State_Transition.Num_Events / Objects_Per_Page ;(H     if ( State_Transition.Num_Events mod Objects_Per_Page /= zero ) then"       Num_Pages := Num_Pages + 1 ;     end if ;     Write_Events_Header ;p9       for An_Event in 1..State_Transition.Num_Events loop_D         Text_Io.Set_Col ( State_Transition.OS_Report_File , 27 ) ;  Y         Int_Io.Put  ( State_Transition.OS_Report_File , An_Event, width=> 1, base=>10 ) ;-D         Text_Io.Set_Col ( State_Transition.OS_Report_File , 30 ) ;  [         Text_Io.Put_Line ( State_Transition.OS_Report_File , ") " & Events ( An_Event ) ) ;-.         Object_Counter := Object_Counter + 1 ;8         if Object_Counter mod Objects_Per_Page = 0 then :           Write_Page_Number ( Current_Page , Num_Pages ) ;            Write_Events_Header ;          end if ;       end loop ; -----t# --  Print page number for last page  -----n8         if Object_Counter mod Objects_Per_Page /= 0 thenB            Object_Counter := Object_Counter mod Objects_Per_Page ;@            Object_Counter := Objects_Per_Page - Object_Counter ;A            Text_Io.New_Line ( State_Transition.OS_Report_File ) ;c0            for A_State in 1..Object_Counter loopC              Text_Io.New_Line ( State_Transition.OS_Report_File ) ;             end loop ;n;            Write_Page_Number ( Current_Page , Num_Pages ) ;r         end if ;         Text_Io.New_Line ;@       Text_Io.Set_Col ( State_Transition.OS_Report_File , 10 ) ;6       Display_Msg ( Events_Written_To_Disk , False ) ;   end Write_Events ;  &   procedure Write_Transition_Table is      Num_Items : Natural ;;  -    procedure Write_Transition_Table_Header is 
      begin=       Text_Io.New_Page ( State_Transition.OS_Report_File  ) ; B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  Y       Text_Io.Put_Line ( State_Transition.OS_Report_File , "========================" ) ; B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  \       Text_Io.Put_Line ( State_Transition.OS_Report_File , "    TRANSITION TABLE " ) ;      B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  Y       Text_Io.Put_Line ( State_Transition.OS_Report_File , "========================" ) ;t@       Text_Io.New_Line ( State_Transition.OS_Report_File , 2 ) ;(      end Write_Transition_Table_Header ;  	     begin #     Write_Transition_Table_Header ;  ----- O --  Determine the number of total transitions for every state/event combinatione -----     Num_Items := 0 ; 5    for A_State in 1..State_Transition.Num_States loopb9       for An_Event in 1..State_Transition.Num_Events loop 6       if Transaction_Events ( A_State , An_Event ) /= (         "NULL                     " then 	 Num_Items := Num_Items + 1 ;       end if ;       end loop ;
    end loop ; 9    Objects_On_Last_Page := ( Num_Items * 4 + 4 ) mod 50 ;E-    Num_Pages := ( Num_Items * 4 + 4 ) / 50 ; i(    if ( Objects_On_Last_Page /= 0 ) then"       Num_Pages := Num_Pages + 1 ;    end if ;n    Object_Counter := 0 ;    Current_Page   := 1 ; -----t --  Write out the Transitions  -----_5    for A_State in 1..State_Transition.Num_States loope9       for An_Event in 1..State_Transition.Num_Events loopb6       if Transaction_Events ( A_State , An_Event ) /= (         "NULL                     " then=         Text_Io.Put_Line ( State_Transition.OS_Report_File ,  \ "======================================================================================" ) ;C         Text_Io.Set_Col ( State_Transition.OS_Report_File ,  34 ) ;WD         Text_Io.Put ( State_Transition.OS_Report_File ,  "Event" ) ;C         Text_Io.Set_Col ( State_Transition.OS_Report_File ,  60 ) ;CV         Text_Io.Put_Line ( State_Transition.OS_Report_File ,  "NEW STATE" ) ;         Y         Text_Io.Put ( State_Transition.OS_Report_File ,  "STATE: "&States ( A_State ) ) ;sC         Text_Io.Set_Col ( State_Transition.OS_Report_File ,  34 ) ;cI 	Text_Io.Put ( State_Transition.OS_Report_File ,  Events ( An_Event ) ) ;MC         Text_Io.Set_Col ( State_Transition.OS_Report_File ,  60 ) ;Od 	Text_Io.Put_Line ( State_Transition.OS_Report_File ,  Transaction_Events ( A_State , An_Event ) ) ; -----l% --  Check if data will print off page  -----s.         Object_Counter := Object_Counter + 1 ;<         if Object_Counter mod Transitions_Per_Page = 0 then >           Text_Io.Put_Line ( State_Transition.OS_Report_File ,d             "==================================================================================" ) ;:           Write_Page_Number ( Current_Page , Num_Pages ) ;)           Write_Transition_Table_Header ;          end if ;        end if ;r       end loop ;       end loop ;;       Text_Io.Put_Line ( State_Transition.OS_Report_File , t\ "======================================================================================" ) ; -----o# --  Print page number for last pagen -----	<         if Object_Counter mod Transitions_Per_Page /= 0 thenF            Object_Counter := Object_Counter mod Transitions_Per_Page ;D            Object_Counter := Transitions_Per_Page - Object_Counter ;0            for A_State in 1..Object_Counter loopC              Text_Io.New_Line ( State_Transition.OS_Report_File ) ;R            end loop ; 8         Write_Page_Number ( Current_Page , Num_Pages ) ;         end if ;A       Text_Io.New_Line ( State_Transition.OS_Report_File ,  1 ) ; A       Text_Io.Set_Col ( State_Transition.OS_Report_File ,  10 ) ;t;       Display_Msg ( Event_Table_Written_To_Disk , False ) ;=    end Write_Transition_Table ;  1!   procedure Write_Action_Table isn  '    No_Actions_Found : BOOLEAN := TRUE ;n  )    procedure Write_Action_Table_Header is:    begin=       Text_Io.New_Page ( State_Transition.OS_Report_File  ) ; B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  [       Text_Io.Put_Line ( State_Transition.OS_Report_File , "==========================" ) ; B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  Z       Text_Io.Put_Line ( State_Transition.OS_Report_File , "      ACTION TABLE " ) ;      B       Text_Io.Set_Col ( State_Transition.OS_Report_File , 25 ) ;  [       Text_Io.Put_Line ( State_Transition.OS_Report_File , "==========================" ) ;a@       Text_Io.New_Line ( State_Transition.OS_Report_File , 2 ) ;"    end Write_Action_Table_Header ;     beginS     Write_Action_Table_Header ;l ----- V --  Determine the number of total transitions for every state/event/action combination -----t    Num_Items := 0 ; 5    for A_State in 1..State_Transition.Num_States loop 9       for An_Event in 1..State_Transition.Num_Events loopi6       if Transaction_Events ( A_State , An_Event ) /= (         "NULL                     " then#         No_Actions_Found := FALSE ;iI         for An_Action in 1 .. State_Transition.Max_Actions_Per_Event loopaj           If Transaction_Actions ( A_State , An_Event , An_Action ) /= "NULL                     " then   ! 	    Num_Items := Num_Items + 1 ;r           end if ;         end loop ;       end if ;       end loop ;
    end loop ; 9    Objects_On_Last_Page := ( Num_Items * 4 + 4 ) mod 50 ;r-    Num_Pages := ( Num_Items * 4 + 4 ) / 50 ; i(    if ( Objects_On_Last_Page /= 0 ) then"       Num_Pages := Num_Pages + 1 ;    end if ;     Object_Counter := 0 ;    Current_Page   := 1 ; -----p --  Write out the Actions_ -----nB     if No_Actions_Found = FALSE then -- at least one action exists6     for A_State in 1..State_Transition.Num_States loop9       for An_Event in 1..State_Transition.Num_Events loop 6       if Transaction_Events ( A_State , An_Event ) /= (         "NULL                     " then -----T7 --  Check if this transition has any associated actionsa -----n         Action_Index := 1 ;e]         If Transaction_Actions ( A_State , An_Event , 1 ) /= "NULL                     " then :           While Transaction_Actions ( A_State , An_Event ,! 			            Action_Index ) /=  # 	  "NULL                     " loopv%           No_Actions_Found := FALSE ;R"           if Action_Index = 1 then -----n  --  Write Transition Information ----- ?            Text_Io.Put_Line ( State_Transition.OS_Report_File , \ "======================================================================================" ) ;E            Text_Io.Set_Col ( State_Transition.OS_Report_File , 34 ) ;rF            Text_Io.Put ( State_Transition.OS_Report_File , "Event" ) ;E            Text_Io.Set_Col ( State_Transition.OS_Report_File , 60 ) ; U            Text_Io.Put_Line ( State_Transition.OS_Report_File , "ACTION" ) ;         sZ            Text_Io.Put ( State_Transition.OS_Report_File , "STATE: "&States (A_State ) ) ;E            Text_Io.Set_Col ( State_Transition.OS_Report_File , 34 ) ;tK 	   Text_Io.Put ( State_Transition.OS_Report_File , Events ( An_Event ) ) ;oE            Text_Io.Set_Col ( State_Transition.OS_Report_File , 60 ) ;oY 	   Text_Io.Put_Line ( State_Transition.OS_Report_File , Transaction_Actions ( A_State , = 	  				             An_Event , 						     Action_Index ) ) ;            elseF             Text_Io.Set_Col ( State_Transition.OS_Report_File , 60 ) ;Z 	    Text_Io.Put_Line ( State_Transition.OS_Report_File , Transaction_Actions ( A_State ,  	  				             An_Event , 						     Action_Index ) ) ;            end if ; -----n% --  Check if data will print off page  -----c0           Object_Counter := Object_Counter + 1 ;>           if Object_Counter mod Transitions_Per_Page = 0 then @             Text_Io.Put_Line ( State_Transition.OS_Report_File ,f               "==================================================================================" ) ;<             Write_Page_Number ( Current_Page , Num_Pages ) ;'             Write_Action_Table_Header ;T           end if ;,           Action_Index := Action_Index + 1 ;         end loop ;        elsel*           if No_Actions_Found = FALSE thenB             Text_Io.New_Line ( State_Transition.OS_Report_File ) ;           end if ;        end if ;         end if ;.       end loop ;       end loop ;:       Text_Io.Put_Line ( State_Transition.OS_Report_File ,\ "======================================================================================" ) ; ----- # --  Print page number for last pagei -----a<         if Object_Counter mod Transitions_Per_Page /= 0 thenF            Object_Counter := Object_Counter mod Transitions_Per_Page ;D            Object_Counter := Transitions_Per_Page - Object_Counter ;0            for A_State in 1..Object_Counter loopC              Text_Io.New_Line ( State_Transition.OS_Report_File ) ;             end loop ;:;            Write_Page_Number ( Current_Page , Num_Pages ) ;          end if ;   else -- no actions found ----- # --  Check if any actions were founde -----lB         Text_Io.Set_Col ( State_Transition.OS_Report_File , 10 ) ;<         Text_Io.Put_Line ( State_Transition.OS_Report_File ,B "============================================================" ) ;B         Text_Io.Set_Col ( State_Transition.OS_Report_File , 10 ) ;<         Text_Io.Put_Line ( State_Transition.OS_Report_File ,B " There are NO actions associated with any state transition. " ) ;B         Text_Io.Set_Col ( State_Transition.OS_Report_File , 10 ) ;=         Text_Io.Put_Line ( State_Transition.OS_Report_File , sB "============================================================" ) ;-   end if ; -- if No_Actions_Found = FALSE ...  ----- 6 --  Inform user that the Action Table has been written -----s       Text_Io.Set_Col (  10 ) ;l<       Display_Msg ( Action_Table_Written_To_Disk , False ) ;   end Write_Action_Table ;      procedure Display_States is   $     procedure Write_States_Header is       beginO       Text_Io.New_Line ( 1 ) ;P       Text_Io.Put_Line ( "                       ==========================" ) ;:       Text_Io.Put ( Ascii.ESC&"#6" ) ;	    -- Double Width;       Text_Io.Put_Line ( "               STATES " ) ;      eP       Text_Io.Put_Line ( "                       ==========================" ) ;       Text_Io.New_Line ( 1 ) ;       end Write_States_Header ;=     begin=    if States_In_Db then=       Object_Counter := 0 ;=$       Clear_Screen_And_Home_Cursor ;       Write_States_Header ;t -----  --  Display States -----u8       for A_State in 1..State_Transition.Num_States loop"         Text_Io.Set_Col ( 27 ) ;  6         Int_Io.Put  ( A_State, width=> 1, base=>10 ) ;"         Text_Io.Set_Col ( 30 ) ;  8         Text_Io.Put_Line ( ") " & States ( A_state ) ) ; -----_( --  Check if data will scroll off screen ----- .         Object_Counter := Object_Counter + 1 ;@         if Object_Counter mod Display_Objects_Per_Page = 0 then        	   Text_Io.New_Line ;"       	   Text_Io.Set_Col ( 10 ) ;*           Text_Io.Put_Line ( Pause_Msg ) ;=           Text_Io.Get_Line ( Any_String , String_Length ) ;  t(           Clear_Screen_And_Home_Cursor ;            Write_States_Header ;          end if ;       end loop ;&     Else  -- error, no data to display1        Display_Msg ( No_Data_To_Display ) ;               End if ;e   end Display_States ;     procedure Display_Events is=  &     procedure Display_Events_Header is       begin=       Text_Io.New_Line ( 1 ) ;P       Text_Io.Put_Line ( "                       ==========================" ) ;:       Text_Io.Put ( Ascii.ESC&"#6" ) ;	    -- Double Width4       Text_Io.Put_Line ( "              EVENTS " ) ;P       Text_Io.Put_Line ( "                       ==========================" ) ;       Text_Io.New_Line  ;=     end Display_Events_Header ;r     beginm    if Events_In_Db then	       Object_Counter := 0 ;o$       Clear_Screen_And_Home_Cursor ;       Display_Events_Header ;_ ----- " --  Display Events on the terminal -----c8       for A_State in 1..State_Transition.Num_Events loop"         Text_Io.Set_Col ( 27 ) ;  6         Int_Io.Put  ( A_State, width=> 1, base=>10 ) ;"         Text_Io.Set_Col ( 30 ) ;  6         Text_Io.Put_Line ( ") "&Events ( A_state ) ) ; -----s( --  Check if data will scroll off screen -----S.         Object_Counter := Object_Counter + 1 ;@         if Object_Counter mod Display_Objects_Per_Page = 0 then        	  Text_Io.New_Line ;r!       	  Text_Io.Set_Col ( 10 ) ;W*           Text_Io.Put_Line ( Pause_Msg ) ;=           Text_Io.Get_Line ( Any_String , String_Length ) ;  n(           Clear_Screen_And_Home_Cursor ;"           Display_Events_Header ;          end if ;       end loop ;&     Else  -- error, no data to display1        Display_Msg ( No_Data_To_Display ) ;      u        End if ;a   end Display_Events ;"  )   procedure Display_States_And_Events  isI     begin    Text_Io.New_Line ( 2 ) ;j   Text_Io.Put_Line ("================================================================================" ) ;6   Text_Io.Put ( Ascii.ESC&"#6" ) ;	    -- Double Width:   Text_Io.Put_Line ( " STATES                  EventS" ) ;j   Text_Io.Put_Line ("================================================================================" ) ;     State_Index     := 1;l   Event_Index := 1;S  6   while State_Index <= State_Transition.Num_States or 3     Event_Index <= State_Transition.Num_Events loop/     Text_Io.Set_Col ( 3 ) ;  N7     if State_Index  <= State_Transition.Num_States thenu8       Int_Io.Put  ( State_Index, width=> 1, base=>10 ) ;2       Text_Io.Put ( ") "&States ( State_Index ) );)       State_Index     := State_Index + 1;      end if ;  7     if Event_Index  <= State_Transition.Num_Events thenA        Text_Io.Set_Col ( 50 ) ;  8       Int_Io.Put  ( Event_Index, width=> 1, base=>10 ) ;3       Text_Io.Put ( ") "&Events ( Event_Index ) ) ; %       Event_Index := Event_Index + 1;      end if ;   end loop ;     Text_Io.New_Line ;!   end Display_States_And_Events ;p  '   procedure Display_Transition_Table is=     Num_Items : Natural ;5  (   procedure Display_Transition_Header is   begin        Text_Io.New_Page ;X       Text_Io.Put_Line ( "                    =====================================" ) ;:       Text_Io.Put ( Ascii.ESC&"#6" ) ;	    -- Double Width@       Text_Io.Put_Line ( "           TRANSITION TABLE" ) ;      X       Text_Io.Put_Line ( "                    =====================================" ) ;       Text_Io.New_Line ;  !   end Display_Transition_Header ;e     begint:    Text_Io.Put ( ASCII.ESC & "[?3h" ) ; -- 132 Column mode9    Text_Io.Put ( Ascii.ESC&"[1;1H" ) ;	    -- Home Cursorc    Display_Transition_Header ;    Object_Counter := 0 ;  5    for A_State in 1..State_Transition.Num_States loop 9       for An_Event in 1..State_Transition.Num_Events loopn6       if Transaction_Events ( A_State , An_Event ) /= (         "NULL                     " thenn         Text_Io.Put_Line ("==============================================================================" ) ; ----- ( --  Check if data will scroll off screen -----iM         if Object_Counter >= 14 then -- Finish current page and start new one=       	  Text_Io.New_Line ;=!       	  Text_Io.Set_Col ( 10 ) ;(*           Text_Io.Put_Line ( Pause_Msg ) ;=           Text_Io.Get_Line ( Any_String , String_Length ) ;  n(           Clear_Screen_And_Home_Cursor ;%           Display_Transition_Header ; 0           Object_Counter := 0 ; -- reset counterp           Text_Io.Put_Line ("==============================================================================" ) ;         end if ;          Text_Io.Set_Col ( 34 ) ;!         Text_Io.Put ( "Event" ) ;           Text_Io.Set_Col ( 60 ) ;3         Text_Io.Put_Line ( "NEW STATE" ) ;         T5         Text_Io.Put ( "STATE: "&States (A_State ) ) ;           Text_Io.Set_Col ( 34 ) ;& 	Text_Io.Put ( Events ( An_Event ) ) ;          Text_Io.Set_Col ( 60 ) ;A 	Text_Io.Put_Line ( Transaction_Events ( A_State , An_Event ) ) ; .         Object_Counter := Object_Counter + 3 ;        end if ;0       end loop ;       end loop ;  "       if Object_Counter /= 0 then n         Text_Io.Put_Line ("==============================================================================" ) ;       end if ;       Text_Io.New_Line ;       Text_Io.Set_Col ( 10 ) ;&       Text_Io.Put_Line ( Pause_Msg ) ;9       Text_Io.Get_Line ( Any_String , String_Length ) ;   L       Text_Io.Put ( ASCII.ESC & "[?3l" ) ; -- Set Terminal to 80 Column mode!   end Display_Transition_Table ;=  #   procedure Display_Action_Table is=  $   Actions_Found : BOOLEAN := FALSE ;  $   procedure Display_Action_Header is   beginc       Text_Io.New_Page ;X       Text_Io.Put_Line ( "                    =====================================" ) ;:       Text_Io.Put ( Ascii.ESC&"#6" ) ;	    -- Double Width>       Text_Io.Put_Line ( "             ACTION TABLE" ) ;      X       Text_Io.Put_Line ( "                    =====================================" ) ;       Text_Io.New_Line ;     end Display_Action_Header ;=     begin=;     Text_Io.Put ( ASCII.ESC & "[?3h" ) ; -- 132 Column mode=:     Text_Io.Put ( Ascii.ESC&"[1;1H" ) ;	    -- Home Cursor     Display_Action_Header ;o     Object_Counter := 0 ;a ----- 7 --  Check if there are any actions in the state machinen -----_6     for A_State in 1..State_Transition.Num_States loop9       for An_Event in 1..State_Transition.Num_Events loopc6       if Transaction_Events ( A_State , An_Event ) /= (         "NULL                     " then         Action_Index := 1 ;P=         If Transaction_Actions ( A_State , An_Event , 1 ) /=  $ 	  "NULL                     " then "           Actions_Found := TRUE ;          End if ;        end if ;t       end loop ;     end loop ; -----  --  Display the Actionsa -----s7    if Actions_Found then -- at least 1 action was found=6     for A_State in 1..State_Transition.Num_States loop9       for An_Event in 1..State_Transition.Num_Events loopI6       if Transaction_Events ( A_State , An_Event ) /= (         "NULL                     " then -----o= --  Determine if this action entry will fit on current screenF -----0n         Object_Counter := Object_Counter + 2 ; -- 2 header lines for each state/event pair w/at least 1 action         Action_Index := 1 ;n=         If Transaction_Actions ( A_State , An_Event , 1 ) /= u# 	  "NULL                     " theni:           While Transaction_Actions ( A_State , An_Event ,! 			            Action_Index ) /= k& 	     "NULL                     " loop3              Object_Counter := Object_Counter + 1 ;a/              Action_Index := Action_Index + 1 ;v              end loop ;iR           if ( Object_Counter ) >= 18  then -- finish current page & start new one             Text_Io.Put_Line (T "==============================================================================" ) ;       	    Text_Io.New_Line ;C$             Text_Io.Set_Col ( 10 ) ;,             Text_Io.Put_Line ( Pause_Msg ) ;?             Text_Io.Get_Line ( Any_String , String_Length ) ;  s*             Clear_Screen_And_Home_Cursor ;#             Display_Action_Header ;o2             Object_Counter := 0 ; -- reset counter          end if ;  -----i2 --	Display State, Event and all associated Actions -----n*         Action_Index := 1 ; -- reset indexn         Text_Io.Put_Line ("==============================================================================" ) ;          Text_Io.Set_Col ( 34 ) ;!         Text_Io.Put ( "Event" ) ;n          Text_Io.Set_Col ( 60 ) ;0         Text_Io.Put_Line ( "ACTION" ) ;         5         Text_Io.Put ( "STATE: "&States (A_State ) ) ;           Text_Io.Set_Col ( 34 ) ;& 	Text_Io.Put ( Events ( An_Event ) ) ;          Text_Io.Set_Col ( 60 ) ; -----, --  Display the ActionsP -----a:           While Transaction_Actions ( A_State , An_Event ,! 			            Action_Index ) /=  # 	  "NULL                     " loop0"           if Action_Index = 1 then8 	    Text_Io.Put_Line ( Transaction_Actions ( A_State ,  	  				             An_Event , 						     Action_Index ) ) ;>           else$             Text_Io.Set_Col ( 60 ) ;8 	    Text_Io.Put_Line ( Transaction_Actions ( A_State ,  	  				             An_Event , 						     Action_Index ) ) ;            end if ; -----e( --  Check if data will scroll off screen -----e.         Object_Counter := Object_Counter + 1 ;*         Action_Index := Action_Index + 1 ;         end loop ;         else         Text_Io.New_Line ;	 	end if ;=        end if ;=       end loop ;       end loop ;l       Text_Io.Put_Line ("==============================================================================" ) ;'     else -- no actions in state machineo!         Text_Io.Set_Col (  10 ) ;          Text_Io.Put_Line ( _B "============================================================" ) ;          Text_Io.Set_Col ( 10 ) ;         Text_Io.Put_Line ( eB " There are NO actions associated with any state transition. " ) ;          Text_Io.Set_Col ( 10 ) ;         Text_Io.Put_Line (B "============================================================" ) ;,     end if ; -- if No_Actions_Found = FALSE        Text_Io.New_Line ;       Text_Io.Set_Col ( 10 ) ;&       Text_Io.Put_Line ( Pause_Msg ) ;9       Text_Io.Get_Line ( Any_String , String_Length ) ;  .L       Text_Io.Put ( ASCII.ESC & "[?3l" ) ; -- Set Terminal to 80 Column mode   end Display_Action_Table ;   0   procedure Get_State_Transition_Diagram_File is     begint   Text_Io.New_Line ( 1 )  ;    Text_Io.Set_Col ( 10 ) ;   Text_Io.Set_Col ( 5 ) ;S\   Text_Io.Put ( "Get State Transition Diagram From Existing File? (Enter Yes or No ) : " ) ;   Answer_IO.Get ( Answer ) ;;   State_Transition_Diagram := "                         " ;r   Text_Io.New_Line ( 2 )  ;    Text_Io.Skip_Line ( 1 )  ;   Text_Io.Set_Col ( 5 ) ; >   Text_Io.Put ( "Enter name of State Transition Diagram: " ) ;,   State_Transition_Diagram_Entered := true ;     for index in 1..25 loope    if Text_Io.End_Of_Line then       exit ;    end if ; 7    Text_io.Get ( State_Transition_Diagram ( Index ) ) ;r   end loop ;   Text_Io.Skip_Line ( 1 ) ;n  #   If Answer = NO or Answer = N then       New_File := True ;      Else2      New_File := False ;  -- Read in old file     /      State_Transition_Diagram_Entered := true ; 
   End if ; -----I --  Exception Handler Area -----    exceptioni     when Text_Io.Data_Error =>4       Display_Msg ( Invalid_Response_Entered_Msg ) ;=       Get_State_Transition_Diagram_File ;  -- Get Good Input r  )   end Get_State_Transition_Diagram_File ;   3   procedure Check_If_Object_Exists ( This_Object :  / 		in State_Transition.Twenty_Five_Char_String ;e' 		Object_Exists      : in out Boolean ;i' 		Num_Objects        : in out Natural ;= 		Composite_Object   : in out ;                 State_Transition.ONE_D_25_CHAR_STRING  ) is)     begin    Object_Exists      := False ;o(   for Some_Object in 1..Num_Objects loop:     If Composite_Object ( Some_Object ) = This_Object then       Object_Exists := True ;u"       exit ;  -- Found a Duplicate     end if ;   end loop ;   end Check_If_Object_Exists ;i  )   procedure GET_STATE_TRANSITION_INPUT (       STATES		   : out.       State_Transition.ONE_D_25_CHAR_STRING  ;     TRANSITION_EventS : out .       State_Transition.ONE_D_25_CHAR_STRING  ;!     TRANSITION_EventS_TABLE : outa.       State_Transition.TWO_D_25_CHAR_STRING  ;(     TRANSITION_ACTIONS_TABLE    : in out3       State_Transition.THREE_D_25_CHAR_STRING    ;  (     State_Transition_Diagram    : in out5       State_Transition.Twenty_Five_CHAR_STRING   ) ise  &     OS_Data_File : Text_Io.File_Type ;?     First_Action : String ( 1..State_Transition.Max_String  ) ; ?     A_State      : String ( 1..State_Transition.Max_String  ) ; %     A_Line       : String ( 1..80 ) ;a%     Blank_Char   : Character := ' ' ;v     Num_Actions	 : NATURAL ;     Index        : NATURAL ;     Index2       : NATURAL ;%     Debug        : BOOLEAN := False ; $     Bad_File_Name: BOOLEAN := True ;%     Found_Char   : BOOLEAN := False ;v  	     begin  ----- 5 --  Open State Transition Data File and Read all Datam ----- +     Text_Io.Open (  File =>  OS_Data_File , "   		    Mode =>  Text_Io.In_File ,*   		    Name =>  State_Transition_Diagram,   		    Form =>  "" ) ;      Bad_File_Name := False ; P ----- ) -- Input the Number of Valid States FirstL -----      rA       Int_Io.Get ( OS_Data_File , State_Transition.Num_States ) ;o.       Text_Io.Skip_Line ( OS_Data_File , 1 ) ;-       if State_Transition.Num_States > 0 thend5        States_In_Db := True ; -- Used To display Data        end if ; ----- ! --  Input the Names of all States; ----- 2       for i in 1..State_Transition.Num_States loop#         -- Clear out State variablei5         for j in 1..State_Transition.Max_String  loopr8           Text_Io.Get ( OS_Data_File , A_State ( j ) ) ;         end loop ;4             Text_Io.Skip_Line ( OS_Data_File , 1 ) ;!         States ( i ) := A_State ;.       end loop ; ----- & -- Get the number of Transition Events -----FA       Int_Io.Get ( OS_Data_File , State_Transition.Num_Events ) ;_.       Text_Io.Skip_Line ( OS_Data_File , 1 ) ;-       if State_Transition.Num_Events > 0 then 7          Events_In_Db := True ; -- Used To display DataR       end if ; -----I, --  Input the Names of all Transition Events -----_2       for i in 1..State_Transition.Num_Events loop#         -- Clear out input variable_5         for j in 1..State_Transition.Max_String  loope8           Text_Io.Get ( OS_Data_File , A_State ( j ) ) ;         end loop ;0         Text_Io.Skip_Line ( OS_Data_File , 1 ) ;,         Transition_Events ( i ) := A_State ;       end loop ; -----oA --  Input all State Transitions for each State/Event Intersectionf -----a6       if not Text_Io.End_Of_Line ( OS_Data_File ) then3        for k in 1..State_Transition.Num_States loop       s4         for i in 1..State_Transition.Num_Events loop           Num_Actions := 1 ;:           for j in 1..State_Transition.Max_String  loop   :             Text_Io.Get ( OS_Data_File , A_State ( j ) ) ;           end loop ;2           Text_Io.Skip_Line ( OS_Data_File , 1 ) ;8           Transition_Events_Table ( k , i ) := A_State ;*           Num_Actions := Num_Actions + 1 ;  #         end loop ; -- end for i ...u#        end loop ;  -- end for k ...=?        Transition_Table_In_Db := True ; -- Used To display Data;       end if ; ----- C --  Get all the Transition Actions when a Event is met in the statet -----               2       for k in 1..State_Transition.Num_States loop4         for i in 1..State_Transition.Num_Events looph           A_Line := "                                                                                " ;           Num_Actions := 1 ;           Index := 1 ;           Index2 := 1 ;            Num_Actions := 1 ;4           An_Action := "                         " ;G           Found_Char := false ; -- assume blank pad spaces & filter outnB           while ( not Text_Io.End_Of_Line ( OS_Data_File ) ) and  $                     Index <= 80 loop  @             Action_Table_In_Db := True ; -- Used To display Data<             Text_Io.Get ( OS_Data_File , A_Line (Index ) ) ;+             if A_Line ( Index ) /= ' ' then G                Found_Char := true ; -- found a character of some action 9                An_Action ( Index2 ) := A_Line ( Index ) ;s%                Index  := Index  + 1 ;i%                Index2 := Index2 + 1 ;=!             elsif Found_Char then=L              Transition_Actions_Table ( k , i , Num_Actions ) := An_Action ;7              An_Action := "                         " ;               Index2 := 1 ;-              Num_Actions := Num_Actions + 1 ;lF              Found_Char := false ; -- needed to handle trailing spaces             end if ;           end loop ;  E           if Found_Char and Text_Io.End_Of_Line ( OS_Data_File ) thend?               Transition_Actions_Table ( k , i , Num_Actions )  I                 := An_Action ;  -- take 'Max_String' length worth of line=           end if ;  0         Text_Io.Skip_Line ( OS_Data_File , 1 ) ;    1         end loop ; -- for i in 1..Num_Events loop A       end loop ;  -- for k in 1..State_Transition.Num_States loope -----uM --  Close the State Transition Input File and indicate routine was successfulo -----E&       Text_Io.Close ( OS_Data_File ) ; -----  --  Exception Handler Area -----c   exceptiona     when Text_Io.Name_Error =>+       Display_Msg ( File_Not_Found_Msg ) ; A       return ;     when Text_Io.End_Error  =>-       Display_Msg ( Bad_File_Detected_Msg ) ; &       Text_Io.Close ( OS_Data_File ) ;       return ;     when Text_Io.Data_Error  =>	/       Display_Msg ( Data_Error_Detected_Msg ) ; &       Text_Io.Close ( OS_Data_File ) ;       return ;  "   end GET_STATE_TRANSITION_INPUT ; 	C   procedure Display_Menu ( Menu            : in Generic_Menu_Type ;n-  		           Num_User_Options : in Natural ;f, 			   Selected_Option : in out Natural ) is   B   Invalid_Option_Selected : Boolean := True ; -- forces good input     begin;"     Clear_Screen_And_Home_Cursor ;8     Text_Io.Put ( Ascii.ESC&"#6" ) ;	    -- Double WidthI     Text_Io.Put_Line ( Menu ( Header_Line ) ) ; -- First Option is Header=     Text_Io.New_Line ;  5     for Option in Menu'First+1..Menu'Last loop               Text_Io.Set_Col ( 10 ) ;,       Text_Io.Put_Line ( Menu ( Option ) ) ;     end loop ;  &     while Invalid_Option_Selected loop
       declare G       Error_Msg : STRING ( 1..29 ) := "Invalid Option.  Try Again..." ;t       begine         Text_Io.New_Line ;         Text_Io.Set_Col ( 5 ) ; .         Text_Io.Put ( "Enter Option: " ) ;    (         Int_Io.Get ( Selected_Option ) ;"         Text_Io.Skip_Line ( 1 )  ;1         If Selected_Option > Num_User_Options or    	   Selected_Option <= Zero then"         raise Text_Io.Data_Error ;         end if ;*         Invalid_Option_Selected := False ; -----t --  Exception Handler Area -----       exception!        when Text_Io.Data_Error =>n8          Display_Msg ( Invalid_Response_Entered_Msg ) ; /      end ; -- Keep Looping UNtil Get Valid Data      end loop ;           end Display_Menu ;     I   procedure Build_Action_And_Event_Packages ( Start_State : in Natural ; s( 					      Stop_State  : in Natural ) is     begint -----i. --  Build the State Transition Actions Package -----I     Text_Io.New_Line ;     Text_Io.Set_Col ( 10 ) ;O     Text_Io.Put_Line ( "Building State Transition Actions Package .  .   ." ) ;:     Text_Io.New_Line ;O     State_Transition.Build_transition_Actions_Package ( Transaction_Actions ) ;L -----n- --  Build the State Transition Events PackageS -----a     Text_Io.Set_Col ( 10 ) ;N     Text_Io.Put_Line ( "Building State Transition Events Package .  .   ." ) ;F     State_Transition.Build_Transition_Events_Package ( States, Events,J     Transaction_Events, Transaction_Actions , Start_State , Stop_State ) ;'   end Build_Action_And_Event_Packages ;a  .   procedure Build_State_Transition_Diagram is      begin "     Clear_Screen_And_Home_Cursor ; -----)8 --  Build the State Transition Action and Event Packages -----r[     Build_Action_And_Event_Packages ( State_Transition.Source , State_Transition.Source ) ;_ -----:4 --  Build the State Transition Executor Sub-Program  -----t     Text_Io.New_Line ;     Text_Io.Set_Col ( 10 ) ;Q     Text_Io.Put_Line ( "Building State Transition Executor Procedure .  .   .") ;iJ     State_Transition.Build_State_Transition_Executor ( States  , Events , 0     Transaction_Events  , Transaction_Actions , D     State_Transition.Source , State_Transition.Source , Simulate ) ;       Build_Done := True ;       If Report_File_Entered then;9       Text_Io.Close ( State_Transition.OS_Report_File ) ;d     End If ; -----I# --  Issue Compile and Link commands  -----t1     DO_COMMAND ( Compile_Line_And_Run_Command ) ;N  ,     Display_Msg ( Build_Done_Msg , False ) ;   &   end Build_State_Transition_Diagram ; u'   procedure Generate_Ada_Source_Code isS  +   Start_State , Stop_State : Natural := 0 ;o     begint -----n$ --  Save State Machine Changes to Db -----t   If File_Activity then )     Write_State_Transition_Data_To_Disk ;C
   end if ;      Clear_Screen_And_Home_Cursor ;     if States_In_Db then      Display_States ;       Text_Io.New_Line ( 2 ) ;         Text_Io.Set_Col ( 10 ) ;e.      Text_Io.Put ( "Enter START state #: " ) ;!      Int_Io.Get ( Start_State ) ;r      Text_Io.Skip_Line ( 1 ) ;      Text_Io.New_Line ;         Text_Io.Set_Col ( 10 ) ;n.      Text_Io.Put ( "Enter STOP  state #: " ) ;       Int_Io.Get ( Stop_State ) ;9      Text_Io.Skip_Line ( 1 ) ;  -- Check for range error    M     if ( Start_State > 0 and Start_State <= State_Transition.Num_States ) and-L        ( Stop_State > 0 and Stop_State <= State_Transition.Num_States ) then -----  --  Generate the Ada Codes -----i!     Text_Io.New_Line ( 2 ) ;           Text_Io.Set_Col ( 10 ) ;A     Text_Io.Put_Line ( "Generating Ada Source Code. .  .   ." ) ;  -----_> --  Build the State Transition Action and Event Packages first -----.B     Build_Action_And_Event_Packages ( Start_State , Stop_State ) ;     Text_Io.New_Line ;     n     Text_Io.Set_Col ( 10 ) ;Q     Text_Io.Put_Line ( "Building State Transition Executor Procedure .  .   .") ;        If Report_File_Entered thena9       Text_Io.Close ( State_Transition.OS_Report_File ) ;      End If ;J     State_Transition.Build_State_Transition_Executor ( States  , Events , 0     Transaction_Events  , Transaction_Actions , 0     Start_State , Stop_State , Code_Generate ) ; -----:# --  Issue Compile and Link commands  -----t1     DO_COMMAND ( Compile_Line_And_Run_Command ) ;_  4     Display_Msg ( Build_Done_Msg , False ) ;               else I$          raise Invalid_State_Index ;       end if ;   else(      Display_Msg ( No_States_Entered ) ;
      return ;U
   end if ; -----R* --  Invalid State Index Exception Handler  -----l   exceptionv!     when Invalid_State_Index  => t0       Display_Msg ( Invalid_State_Number_Msg ) ;        Generate_Ada_Source_Code ;     when others => M(       Display_Msg ( Unexpected_Input ) ;!       Generate_Ada_Source_Code  ; !   end Generate_Ada_Source_Code  ;k L@   procedure Enter_Add_Object    ( Num_Objects : in out Natural ; 				  Objects    : in out I                                   State_Transition.ONE_D_25_CHAR_STRING ;-1 			          Object     : in out Object_Type ) isl  )   Objects_Entered        : Natural := 0 ;.)   Num_Objects_To_Enter   : Natural := 0 ;1     beginn -----N8 --  May enter states if a New Data File is being created( --  Otherwise, User is adding data to db ----"     Clear_Screen_And_Home_Cursor ;       case Object is       when State =>;        if States_In_Db then           Display_States ;             end if ;t"         Text_Io.New_Line ( 2 ) ;            Text_Io.Set_Col ( 10 ) ;8         Text_Io.Put ( "Enter # of States to Enter: " ) ;N         States_In_Db := True ;  -- Indicate Data may now be modified/displayed       when Event =>         if Events_In_Db then           Display_Events ;v        end if ; "         Text_Io.New_Line ( 2 ) ;            Text_Io.Set_Col ( 10 ) ;8         Text_Io.Put ( "Enter # of Events to Enter: " ) ;N         Events_In_Db := True ;  -- Indicate Data may now be modified/displayed     end case ;  *     Int_Io.Get ( Num_Objects_To_Enter  ) ;     Text_Io.Skip_Line ( 1 );  %     if Num_Objects_To_Enter  > 0 thent       Text_Io.New_Line ( 2 ) ;   -----e8 --  Input the Names of all States From User Via Terminal -----16      While Objects_Entered < Num_Objects_To_Enter loop        -- Clear out Object1        An_Object := "                         " ;         Text_Io.Set_Col ( 10 ) ;        case Object is       when State =>;+         Text_Io.Put ( "Enter a State: " ) ;t       when Event => +         Text_Io.Put ( "Enter a Event: " ) ;I     end case ;  4        for j in 1..State_Transition.Max_String  loop&          if Text_Io.End_Of_Line  then             exit ;           end if ;A*          Text_Io.Get ( An_Object ( j ) ) ;        end loop ;    ;         Text_Io.Skip_Line ( 1 ) ; -----o --  Check if state existss ----          Object_Exists := False ;  =         Check_If_Object_Exists ( An_Object , Object_Exists , _, 	       		         Num_Objects , Objects ) ;-         If Object_Exists then -- Report Error1           case Object is             when State => 4               Display_Msg ( Duplicate_State_Msg  ) ;             when Event =>o4               Display_Msg ( Duplicate_Event_Msg  ) ;           End Case ;1           Return ;  -- to Sender...Object Unknown=         Else  -- Add Objectt6               Objects_Entered := Objects_Entered + 1 ;.               Num_Objects := Num_Objects + 1 ;E               Objects ( Num_Objects ) := An_Object ; -- Insert Objectn         End If ;      end loop ;v    end if ;e   end Enter_Add_Object ; tD   procedure Delete_An_Object        ( Num_Objects : in out Natural ; 		 		      Objects     : in out_I                                   State_Transition.ONE_D_25_CHAR_STRING ; / 				      Object      : in out Object_Type ) is-  I     Deleted_Object         : String ( 1..State_Transition.Max_String  ) ;r -----e6 --  Delete the last row of the Event and Action tables -----_1     procedure Clean_Up_Event_And_Action_Tables is        begino         case Object is           when State     =>eA                for Event in 1 .. State_Transition.Num_Events loop = 	         Transaction_Events ( State_Transition.Num_States , a4                                           Event ) :=/                   "NULL                     " ;D                  for Action in  F                     1 .. State_Transition.Max_Actions_Per_Event  loop H                     Transaction_Actions ( State_Transition.Num_States , =                                           Event , Action ) :==1                     "NULL                     " ;                    end loop ;  ,                end loop ;                                when Event =>eC                  for State in 1 .. State_Transition.Num_States loop=! 	           Transaction_Events (  <                      State , State_Transition.Num_Events) :=1                     "NULL                     " ;n!                    for Action in nH                       1 .. State_Transition.Max_Actions_Per_Event  loop 4                       Transaction_Actions ( State , J                                             State_Transition.Num_Events , 7                                             Action ) := 3                       "NULL                     " ;v                      end loop ;                    end loop ;              end case ;  ,       end Clean_Up_Event_And_Action_Tables ; -----_# --  Get State or Event # to Delete e -----x   begin %     Clear_Screen_And_Home_Cursor ;   e     case Object is       when State =>         if States_In_Db thenr          Display_States ;     #          Text_Io.New_Line ( 2 ) ;  _!          Text_Io.Set_Col ( 10 ) ; 6          Text_Io.Put ( "Enter State # to Delete: " ) ;        else=,          Display_Msg ( No_States_Entered ) ;          return ;i        end if ;        when Event =>         if Events_In_Db then           Display_Events ; #          Text_Io.New_Line ( 2 ) ;   !          Text_Io.Set_Col ( 10 ) ;=6          Text_Io.Put ( "Enter Event # to Delete: " ) ;        elsei,          Display_Msg ( No_Events_Entered ) ;          return ;         end if ;e     end case ;  !     Int_Io.Get ( Object_Index ) ;C     Text_Io.Skip_Line ( 1 ) ;e<     if Object_Index > 0 and Object_Index <= Num_Objects then?       case Object is -- Save Deleted Object Image ( if state ) sG          when State     => Deleted_Object  := States ( Object_Index ) ;)!          when Others    => null ;        end case ; -----I7 --  Delete The Object From the State Transition Diagram= -----=1       An_Object  := "NULL                     " ;f<       if Object_Index = 1 then  -- Object is at Head of List%         for j in 2..Num_Objects  loop -           Objects ( j -1 ) := Objects ( j ) ;            case Object is             when State     =>iD                   for Event in 1 .. State_Transition.Num_Events loop;                     Transaction_Events ( j - 1 , Event ) := 8                       Transaction_Events ( j , Event ) ;"                     for Action in H                       1 .. State_Transition.Max_Actions_Per_Event  loop G                       Transaction_Actions ( j - 1 , Event , Action ) := D                         Transaction_Actions ( j , Event , Action ) ;                      end loop ;  @                   end loop ;  -- Nullify last row in Event Table                 when Event =>IB                 for State in 1 .. State_Transition.Num_States loop9                   Transaction_Events ( State , j - 1 ) :=v6                     Transaction_Events ( State , j ) ;                    for Action in F                     1 .. State_Transition.Max_Actions_Per_Event  loop E                     Transaction_Actions ( State , j - 1 , Action ) :==B                       Transaction_Actions ( State , j , Action ) ;                   end loop ;  B                 end loop ;   -- Nullify last column in Event Table             end case ;<             end loop ;  -- Now update Event and Action table -----3, --  Clear out object in State or Event Table -----a3             Objects ( Num_Objects ) := An_Object ; T' 	    Clean_Up_Event_And_Action_Tables ;F,             Num_Objects := Num_Objects - 1 ; -----i5 --  Object to Delete is at the end of the Object List" ----- 0            elsif Object_Index = Num_Objects then3              Objects ( Num_Objects ) := An_Object ;o( 	     Clean_Up_Event_And_Action_Tables ;-              Num_Objects := Num_Objects - 1 ;. -----e1 --  Object to Delete is in the middle of the list= -----=            elset7              for j in Object_Index..Num_Objects-1  loopi3                Objects ( j ) := Objects ( j + 1 ) ;o                case Object iss!                 when State     =>sF                   for Event in 1 .. State_Transition.Num_Events-1 loop8                     Transaction_Events ( j  , Event ) :=<                       Transaction_Events ( j + 1 , Event ) ;"                     for Action in H                       1 .. State_Transition.Max_Actions_Per_Event  loop D                       Transaction_Actions ( j  , Event , Action ) :=H                         Transaction_Actions ( j + 1 , Event , Action ) ;                      end loop ;  @                   end loop ;  -- Nullify last row in Event Table                 when Event =>nD                 for State in 1 .. State_Transition.Num_States-1 loop6                   Transaction_Events ( State , j  ) :=:                     Transaction_Events ( State , j + 1 ) ;                    for Action in F                     1 .. State_Transition.Max_Actions_Per_Event  loop A                     Transaction_Actions ( State , j , Action ) :=;E                       Transaction_Actions ( State , j + 1, Action ) ;n                   end loop ; =B                 end loop ;   -- Nullify last column in Event Table              end case ;f              end loop ;       3              Objects ( Num_Objects ) := An_Object ; /              Clean_Up_Event_And_Action_Tables ;i-              Num_Objects := Num_Objects - 1 ;a            end if ;      else       case Object is             when State =>I:               Display_Msg (   Invalid_State_Number_Msg ) ;               Return ;             when Event =>;8               Display_Msg ( Invalid_Event_Number_Msg ) ;               Return ;        End Case ;      end if ; -----_; --  Check for any old references in Event and Action Tables  -----I   -----e3 --  Check for any latent references of latent State  -----.   case Object is     when State =>)     Latent_Errors := False ;4     for State in 1..State_Transition.Num_States loop6       for Event in 1..State_Transition.Num_Events loop0         if Transaction_Events ( State , Event ) !           = Deleted_Object  then e$            If not Latent_Errors then$              Latent_Errors := True ;a --             Text_Io.Put_Line ( "WARNING - Event Table contains invalid references to State " & 7 --             Transaction_Events ( State , Event ) ) ;               Text_Io.New_Line ; O              Text_Io.Put_Line ( "Will Remove any references to this state." ) ;e            end if ;EP            Transaction_Events ( State , Event ) := "NULL                     " ;         end if ;      end loop ;i
    end loop ; /    when event => null ;  -- no action necessary 
    end case ;d     end Delete_An_Object ; A"   procedure Delete_A_Transition is  @   A_State         : String ( 1..State_Transition.Max_String  ) ;     begin-"     Clear_Screen_And_Home_Cursor ;     Display_States_And_Events ;s!     Get_State_And_Event_Indices ;  -----	 --  Check if transition exists ----- ;     if ( Transaction_Events ( State_Index , Event_Index ) =j(       "NULL                     " ) then+      Display_Msg ( No_Transition_Exists ) ;;     else.       A_State := "NULL                     " ;7       Transaction_Events ( State_Index , Event_Index )           := A_State ;2       Display_Msg ( Transition_Deleted , False ) ;     end if ;   end Delete_A_Transition ;r     procedure Delete_An_Action is      Action_Index      : Natural ;      beginu"     Clear_Screen_And_Home_Cursor ;     Display_States_And_Events ;e"     Get_State_And_Event_Indices ;      Text_Io.New_Line ( 2 ) ; -----e0 --  Display All Actions For This State and Event ----- P       Text_Io.Put_Line ( "                       ==========================" ) ;:       Text_Io.Put ( Ascii.ESC&"#6" ) ;	    -- Double Width;       Text_Io.Put_Line ( "                    ACTIONS " ) ;TP       Text_Io.Put_Line ( "                       ==========================" ) ;       Text_Io.New_Line  ;d     Action_Index := 1 ;t;     While Transaction_Actions ( State_Index , Event_Index , ! 			            Action_Index ) /=  # 	  "NULL                     " loopu$           Text_Io.Set_Col ( 27 ) ;  >           Int_Io.Put  ( Action_Index , width=> 1, base=>10 ) ;$           Text_Io.Set_Col ( 30 ) ;  : 	  Text_Io.Put_Line ( Transaction_Actions ( State_Index ,  	  				           Event_Index ,  						   Action_Index ) ) ;_,           Action_Index := Action_Index + 1 ;      end loop ;n -----t --  Get action # to delete -----      Text_Io.New_Line  ; ;     Text_Io.Put_Line ( "Enter ACTION # to DELETE when " ) ; 2     Text_Io.Put ( "EVENT "&Events ( Event_Index )&7       "occurs in STATE "&States ( State_Index )&":" ) ; 5         A_Transition := "                         " ;e     Text_Io.Skip_Line ( 1 ) ;   !     Int_Io.Get ( Action_Index ) ;      Text_Io.Skip_Line ( 1 ) ;T     if Action_Index > 0 and A        Action_Index < State_Transition.Max_Actions_Per_Event thenf0       An_Action := "NULL                     " ;*       Transaction_Actions ( State_Index , *                             Event_Index , 9                             Action_Index ) := An_Action ;n	      elseE2        Display_Msg ( Invalid_Action_Number_Msg ) ;
      end if ;    end Delete_An_Action ;  D   procedure Change_Object           ( Num_Objects : in out Natural ; 		 		      Objects     : in out I                                   State_Transition.ONE_D_25_CHAR_STRING ;t/ 				      Object      : in out Object_Type ) isl  B   Old_Object        : String ( 1..State_Transition.Max_String  ) ;   Object_Index      : Natural ;r   Object_Exists     : Boolean ;      begin %     Clear_Screen_And_Home_Cursor ;   _       case Object is       when State =>(         Display_States ;     ;"         Text_Io.New_Line ( 2 ) ;            Text_Io.Set_Col ( 10 ) ;5         Text_Io.Put ( "Enter State # to Change: " ) ;        when Event =>e         Display_Events ;"         Text_Io.New_Line ( 2 ) ;            Text_Io.Set_Col ( 10 ) ;5         Text_Io.Put ( "Enter Event # to Change: " ) ;t     end case ;  !     Int_Io.Get ( Object_Index ) ;n     Text_Io.Skip_Line ( 1 ) ; <     if Object_Index > 0 and Object_Index <= Num_Objects then -----   --  Get The New Object From User -----      Text_Io.New_Line ( 2 ) ;     Text_Io.Set_Col ( 10 ) ;     case Object is       when State => /         Old_Object := States ( Object_Index ) ;D-         Text_Io.Put ( "Enter New State: " ) ;        when Event => -         Text_Io.Put ( "Enter New Event: " ) ;e     end case ;  /     An_Object  := "                         " ;j1     for j in 1..State_Transition.Max_String  loopj#       if Text_Io.End_Of_Line  then e          exit ;        end if ;'       Text_Io.Get ( An_Object ( j ) ) ;1      end loop ;  ---- --  Check for duplicate state  ----=         Check_If_Object_Exists ( An_Object , Object_Exists , r+ 	       		        Num_Objects , Objects ) ;   -         If Object_Exists then -- Report Error            case Object is             when State => &               Text_Io.New_Line ( 1 ) ;4               Display_Msg ( Duplicate_State_Msg  ) ;             when Event => &               Text_Io.New_Line ( 1 ) ;4               Display_Msg ( Duplicate_Event_Msg  ) ;           End Case ;         Else  -- Make Change3             Objects ( Object_Index ) := An_Object ;i         end if ;    else      case Object is       when State => 2         Display_Msg ( Invalid_State_Number_Msg ) ;       when Event => 2         Display_Msg ( Invalid_Event_Number_Msg ) ;      End Case ;a    end if ;( -----,G --  Check for any latent references of latent State and change if foundT -----o   case Object is     when State =>      Latent_Errors := False ;4     for State in 1..State_Transition.Num_States loop6       for Event in 1..State_Transition.Num_Events loop0         if Transaction_Events ( State , Event )            = Old_Object thenn$            If not Latent_Errors then$              Latent_Errors := True ;a --             Text_Io.Put_Line ( "WARNING - Event Table contains invalid references to State " &b7 --             Transaction_Events ( State , Event ) ) ;n              Text_Io.New_Line ; O              Text_Io.Put_Line ( "Will CHANGE any references to this state." ) ;             end if ;->            Transaction_Events ( State , Event ) := An_Object ;         end if ;      end loop ;j
    end loop ;l/    when event => null ;  -- no action necessarym
    end case ;_     end Change_Object ;- b#   procedure Change_Transition_Tablee% 				 ( Num_States : in out  Natural ; " 			           States     : in out J                                    State_Transition.ONE_D_25_CHAR_STRING ;$ 				   Num_Events : in out Natural ; 				   Events: in out J                                    State_Transition.ONE_D_25_CHAR_STRING ;# 				   Transaction_Events : in out j2 				   State_Transition.TWO_D_25_CHAR_STRING ) is    #   State_Event_Pairs     : Integer ; #   The_State             : Natural ; #   State_Exists          : Boolean ;_     beginl"     Clear_Screen_And_Home_Cursor ;     Display_States_And_Events ; !     Get_State_And_Event_Indices ;a       Text_Io.New_Line ( 2 ) ;     Text_Io.Set_Col ( 10 ) ;  C     Text_Io.Put ( "Enter # of NEW STATE to TRANSITION to when " ) ;e:     Text_Io.Put_Line ( "EVENT "&Events ( Event_Index ) ) ;     Text_Io.Set_Col ( 10 ) ;  D     Text_Io.Put ( "occurs in STATE "&States ( State_Index )&": " ) ;     Int_Io.Get ( The_State ) ;     Text_Io.Skip_Line ( 1 ) ;;  C      Check_If_Object_Exists ( States ( The_State ) , State_Exists, s: 	       		        State_Transition.Num_States , States ) ;      If State_Exists then 8        Transaction_Events ( State_Index , Event_Index ) $            := States ( The_State ) ;	      elsen'         Display_Msg ( Invalid_State ) ;-
      end if ;c     end Change_Transition_Table ;e c&   procedure Enter_Add_Transition_Table% 				 ( Num_States : in out  Natural ; " 			           States     : in out J                                    State_Transition.ONE_D_25_CHAR_STRING ;$ 				   Num_Events : in out Natural ; 				   Events: in out J                                    State_Transition.ONE_D_25_CHAR_STRING ;# 				   Transaction_Events : in out t2 				   State_Transition.TWO_D_25_CHAR_STRING ) is      State_Exists    : Boolean ;x   The_State       : Natural ;      begin=       if Num_States <= 0 theni       Text_Io.New_Line ;)       Display_Msg ( No_States_Entered ) ;u     elsif Num_Events <= 0 then       Text_Io.New_Line ;)       Display_Msg ( No_Events_Entered ) ;d?     else  -- At least one state and one event have been entered &       Transition_Table_In_Db := true ;       Text_Io.New_Line ( 2 ) ;     Text_Io.Set_Col ( 10 ) ;  H     Text_Io.Put ( "How many State/Event pairs are to be entered? : " ) ;(     Int_Io.Get ( State_Event_Pairs ) ;       Text_Io.Skip_Line ( 1 ) ; 0     for Some_Index in 1..State_Event_Pairs  loop$       Clear_Screen_And_Home_Cursor ;!       Display_States_And_Events ; '       Get_State_And_Event_Indices ;    p        Text_Io.New_Line ( 2 ) ;          Text_Io.Set_Col ( 10 ) ;  A       Text_Io.Put ( "Enter # of STATE to TRANSITION to when " ) ;n<       Text_Io.Put_Line ( "EVENT "&Events ( Event_Index ) ) ;        Text_Io.Set_Col ( 10 ) ;  F       Text_Io.Put ( "occurs in STATE "&States ( State_Index )&": " ) ;        Int_Io.Get ( The_State ) ;       Text_Io.Skip_Line ( 1 ) ;;  D       Check_If_Object_Exists ( States ( The_State ) , State_Exists, : 	       		        State_Transition.Num_States , States ) ;         If State_Exists then:          Transaction_Events ( State_Index , Event_Index ) $            := States ( The_State ) ;         else+             Display_Msg ( Invalid_State ) ;I	 	end if ;;     end loop ;   i    end if ;M  $     end Enter_Add_Transition_Table ; 	   procedure Change_Action_Table % 				 ( Num_States : in out  Natural ;o" 			           States     : in out J                                    State_Transition.ONE_D_25_CHAR_STRING ;$ 				   Num_Events : in out Natural ; 				   Events: in out J                                    State_Transition.ONE_D_25_CHAR_STRING ;$ 				   Transaction_Actions : in out 4 				   State_Transition.THREE_D_25_CHAR_STRING ) is      !   Number_Of_Actions   : Natural ; !   State_Event_Pairs   : Natural ;i     begin     Clear_Screen_And_Home_Cursor ;   Display_States_And_Events ;l   Get_State_And_Event_Indices ;1   Text_Io.New_Line ;   Text_Io.Set_Col ( 10 ) ;   ----- L --  Get the number of actions to be taken when an event occurs at this state -----E>     Text_Io.Put ( "How many Actions are to be Changed? : " ) ;)     Int_Io.Get ( Number_Of_Actions ) ;         Text_Io.Skip_Line ( 1 ) ;_     Text_Io.New_Line ;  0     for Some_Action in 1..Number_Of_Actions loop          Text_Io.Set_Col ( 10 ) ;6         Text_Io.Put ( "Enter ACTION to take when " ) ;>         Text_Io.Put_Line ( "EVENT "&Events ( Event_Index ) ) ;          Text_Io.Set_Col ( 10 ) ;G        	Text_Io.Put ( "occurs in STATE "&States ( State_Index )&":" ) ;V5         A_Transition := "                         " ;   5         for j in 1..State_Transition.Max_String  loopt'           if Text_Io.End_Of_Line  then o             exit ;           end if ;.           Text_Io.Get ( A_Transition ( j ) ) ;         end loop ;!         Text_Io.Skip_Line ( 1 ) ;_  D     Transaction_Actions ( State_Index , Event_Index , Some_Action )        := A_Transition ; 
    end loop ;i     end Change_Action_Table ;d a"   procedure Enter_Add_Action_Table% 				 ( Num_States : in out  Natural ;t" 			           States     : in out J                                    State_Transition.ONE_D_25_CHAR_STRING ;$ 				   Num_Events : in out Natural ; 				   Events: in out J                                    State_Transition.ONE_D_25_CHAR_STRING ;$ 				   Transaction_Actions : in out 4 				   State_Transition.THREE_D_25_CHAR_STRING ) is      State_Event_Pairs : Natural ;D"   Number_Of_Actions    : NAtural ;     beginm       if Num_States <= 0 thenh)       Display_Msg ( No_States_Entered ) ;s     elsif Num_Events <= 0 then)       Display_Msg ( No_Events_Entered ) ;t     else"       Action_Table_In_Db := true ;          Text_Io.New_Line ( 2 ) ;          Text_Io.Set_Col ( 10 ) ;  J       Text_Io.Put ( "How many State/Event pairs are to be entered? : " ) ;+       Int_Io.Get ( State_Event_Pairs ) ;           Text_Io.Skip_Line ( 1 ) ;a  B       for Number_of_State_Event_Pairs in 1..State_Event_Pairs loop'         Clear_Screen_And_Home_Cursor ; S#         Display_States_And_Events ;u)         Get_State_And_Event_Indices ;     "         Text_Io.New_Line ( 2 ) ;  "         Text_Io.Set_Col ( 10 ) ;   -----FL --  Get the number of actions to be taken when an event occurs at this state -----CB         Text_Io.Put ( "How many Actions are to be entered? : " ) ;-         Int_Io.Get ( Number_Of_Actions ) ;   r 	Text_Io.Skip_Line ( 1 ) ;  - 	for Some_Action in 1..Number_Of_Actions loopt$           Text_Io.New_Line ( 2 ) ;  $           Text_Io.Set_Col ( 10 ) ;  8           Text_Io.Put ( "Enter ACTION to take when " ) ;@           Text_Io.Put_Line ( "EVENT "&Events ( Event_Index ) ) ;"           Text_Io.Set_Col ( 10 ) ;I           Text_Io.Put ( "occurs in STATE "&States ( State_Index )&":" ) ;x7           A_Transition := "                         " ;t   7           for j in 1..State_Transition.Max_String  loopo)             if Text_Io.End_Of_Line  then                   exit ;             end if ;0             Text_Io.Get ( A_Transition ( j ) ) ;           end loop ;#           Text_Io.Skip_Line ( 1 ) ;e  J           Transaction_Actions ( State_Index , Event_Index , Some_Action )              := A_Transition ;   +         end loop ; -- for Total_Actions ...i7       end loop ; -- for Number_of_State_Event_Pairs ...s     end if ;        end Enter_Add_Action_Table ; t   begin -- Main ProcedureeH   Text_Io.Put ( ASCII.ESC & "[?3l" ) ; -- Set Terminal to 80 Column mode   while Active_Session loopt ----- & --  Display Master Menu and Get Option -----A   Display_Menu ( Master_Menu ,  *                  Num_Master_Menu_Choices , 	         Selected_Option ) ;  -----t$ --  Execute Option User Has Selected -----c   case Selected_Option is      when 1 =>   = if not State_Transition_Diagram_Entered and not New_File thene&    Get_State_Transition_Diagram_File ;    if Not New_file thena2      Get_state_transition_input ( States, Events, J      Transaction_Events, Transaction_Actions ,State_Transition_Diagram ) ;     end if ;
  end if  ;            In_Change_Menu := True ;!         while In_Change_Menu loopnC         Display_Menu ( Enter_Change_State_Transition_Diagram_Menu , ) 	 	       Num_Enter_Change_Menu_Choices ,S 		       Change_Option ) ;  F         File_Activity := True ; -- Any changes will be flushed to disk  !             case Change_Option is   F             when 1 => Enter_Add_Object ( State_Transition.Num_States ,-                       States , Enum_State ) ;g  *             when 2 => if States_In_Db then 	 	        Change_Object ( _: 			  State_Transition.Num_States , States , Enum_State ) ;                       else( 			  Display_Msg ( No_States_Entered ) ; 		      end if ;  *             when 3 => if States_In_Db then 	 	        Delete_An_Object  (  : 			  State_Transition.Num_States , States , Enum_State ) ;                       else( 			  Display_Msg ( No_States_Entered ) ; 		      end if ;  > 	    when 4 => Enter_Add_Object ( State_Transition.Num_Events,-                       Events , Enum_Event ) ;t  *             when 5 => if Events_In_Db then8 		         Change_Object ( State_Transition.Num_Events, $ 		  		     	 Events , Enum_Event ) ;                       else( 			  Display_Msg ( No_Events_Entered ) ; 		      end if ;  *             when 6 => if Events_In_Db then< 		         Delete_An_Object  ( State_Transition.Num_Events, $ 		  		     	 Events , Enum_Event ) ;                       else( 			  Display_Msg ( No_Events_Entered ) ; 		      end if ;  0             when 7 => Enter_Add_Transition_TableJ                                            ( State_Transition.Num_States ,  			                     States ,. 				             State_Transition.Num_Events , 				             Events , 5                			             Transaction_Events ) ;t  4             when 8 => if Transition_Table_In_Db then) 	                 Change_Transition_TableeJ                                            ( State_Transition.Num_States ,  			                     States ,. 				             State_Transition.Num_Events , 				             Events ,o5                			             Transaction_Events ) ;                        else2 			  Display_Msg ( No_Transition_Table_Entered ) ; 		      end if ;  $ 	    when 9 => Delete_A_Transition ;  -             when 10 => Enter_Add_Action_TableNJ                                            ( State_Transition.Num_States ,  			                     States ,. 				             State_Transition.Num_Events , 				             Events ,i6                			             Transaction_Actions ) ;  1             when 11 => if Action_Table_In_Db then  			Change_Action_TableJ                                            ( State_Transition.Num_States ,  			                     States ,. 				             State_Transition.Num_Events , 				             Events , 6                			             Transaction_Actions ) ;                       else. 			  Display_Msg ( No_Action_Table_Entered ) ; 		      end if ;  )             when 12 => Delete_An_Action ;   A             when 13 => In_Change_Menu :=False ; -- Exit this menua  A             when others => null ;  -- Needed for Compilation Only              end case ;*        end loop ; -- while In_Change_Menu  -----  --	FASTER Display Menu ----- 8   when 2 => if not State_Transition_Diagram_Entered then/    	        Get_State_Transition_Diagram_File ;E$                 if Not New_file then@                   Get_state_transition_input (  States, Events,  						Transaction_Events,  						Transaction_Actions , # 						State_Transition_Diagram ) ;                   end if ;              end if ;t&              In_Display_Menu := True ;'              while In_Display_Menu loop F                 Display_Menu ( Display_State_Transition_Diagram_Menu ,9                                Num_Display_Menu_Choices ,e& 	  	               Change_Option ) ;    !             case Change_Option isi*             when 1 => if States_In_Db then 			 Display_States ; d       			 Text_Io.New_Line ;"       			 Text_Io.Set_Col ( 10 ) ;*       			 Text_Io.Put_Line ( Pause_Msg ) ;=       			 Text_Io.Get_Line ( Any_String , String_Length ) ;  G                       end if ;                      :,             when 2 =>   if Events_In_Db then 			  Display_Events ;5       			 Text_Io.New_Line ;"       			 Text_Io.Set_Col ( 10 ) ;*       			 Text_Io.Put_Line ( Pause_Msg ) ;=       			 Text_Io.Get_Line ( Any_String , String_Length ) ;                             end if ;  5              when 3 => if Transition_Table_In_Db then 9                            Clear_Screen_And_Home_Cursor ;t  			   Display_Transition_Table ;                        end if ;   2              when 4 =>  if Action_Table_In_Db then8                           Clear_Screen_And_Home_Cursor ;0                           Display_Action_Table ;+                         end if ;           i  A             when 5 => In_Display_Menu :=False ; -- Exit this menutA             when others => null ;  -- Needed for Compilation Onlyh             end case ;+        end loop ; -- while In_Display_Menu ) -----  -- 	FASTER Reports Menu) ----- 8   when 3 => if not State_Transition_Diagram_Entered then/    	        Get_State_Transition_Diagram_File ; $                 if Not New_file then@                   Get_state_transition_input (  States, Events,  						Transaction_Events,  						Transaction_Actions , # 						State_Transition_Diagram ) ; )                 end if ;              end if ;n 	    In_Reports_Menu := True ;&             while In_Reports_Menu loop+               Display_Menu ( Reports_Menu ,l" 			     Num_Reports_Menu_Choices , 			     Report_Option ) ;d  !             case Report_Option isn  +   when 1 => If ( Report_File_Entered ) then >               Display_Msg   ( Report_File_Already_Entered ) ; A               Text_Io.Close ( State_Transition.OS_Report_File ) ;t    	    End If ;   	      Text_Io.New_Line ( 2 ) ;T%               Text_Io.Set_Col ( 5 ) ; =               Text_Io.Put ( "Enter name of Report File: " ) ;_+               Report_File_Entered := true ;   K               State_Transition.Report_File := "                         " ; %               for index in 1..25 loope)      	        if Text_Io.End_Of_Line thenh                   exit ;                 end if ;H                 Text_io.Get ( State_Transition.Report_File ( Index ) ) ;               end loop ;  H               Text_Io.Create (File =>  State_Transition.OS_Report_File ,2   	                    Mode =>  Text_Io.Out_File ,4   		    	    Name =>  State_Transition.Report_File ,   		            Form =>  "" ) ;t  +   when 2 => if not Report_File_Entered thenH/                Display_Msg ( No_Report_File ) ; *             elsif Not States_In_Db then   3                Display_Msg ( No_Data_To_Display ) ;I             else                Write_States ;o             end if ;  +   when 3 => if not Report_File_Entered then /                Display_Msg ( No_Report_File ) ;e6             elsif Not Events_In_Db then               E                Display_Msg ( No_Data_To_Display ) ;                  t             else                Write_Events ;              end if ;  +   when 4 => if not Report_File_Entered thenA/                Display_Msg ( No_Report_File ) ;i;             elsif Not Events_In_Db or Not States_In_Db theneE                Display_Msg ( No_Data_To_Display ) ;                  t             else 		Write_Transition_Table ;             end if ;  +   when 5 => if not Report_File_Entered theni/                Display_Msg ( No_Report_File ) ;d;             elsif Not States_In_Db or Not Events_In_Db then;E                Display_Msg ( No_Data_To_Display ) ;                  ;             else 		Write_Action_Table ;             end if ;  &   when 6 => In_Reports_Menu := False ;     when others => null ;A     end case ;*   end loop ; -- end while In_Reports_Menu  ----- + --	FASTER Simulation Menu (option selected)r ----- 8   when 4 => if not State_Transition_Diagram_Entered then/    	        Get_State_Transition_Diagram_File ; $                 if Not New_file then@                   Get_state_transition_input (  States, Events,  						Transaction_Events,  						Transaction_Actions ,u# 						State_Transition_Diagram ) ; u                 end if ;              end if ;t             if States_In_Db then(             In_Simulation_Menu := True ;)             while In_Simulation_Menu loopi.               Display_Menu ( Simulation_Menu ,% 			     Num_Simulation_Menu_Choices ,  			     Simulation_Option ) ;t  %             case Simulation_Option isT  *   when 1 => Clear_Screen_And_Home_Cursor ;             Display_States ;$             Text_Io.New_Line ( 2 ) ;$             Text_Io.Set_Col ( 10 ) ;. 	    Text_Io.Put ( "Enter START state #: " ) ;)             Int_Io.Get ( Source_State ) ;              Text_Io.Skip_Line ;    	    Text_Io.New_Line ;) 	    Text_Io.Set_Col ( 10 ) ;T3      	    Text_Io.Put ( "Enter STOP  state #: " ) ;   	    Int_Io.Get ( Sink_State ) ; 	    Text_Io.Skip_Line ( 1 ) ; ------& --  Check for state out-of-range error ----- P 	    if ( Source_State > 0 and Source_State <= State_Transition.Num_States ) andM 	       ( Sink_State > 0 and Sink_State <= State_Transition.Num_States ) then)H     	      State_Transition.Build_State_Transition_Executor ( States  , ; 	      Events , Transaction_Events  , Transaction_Actions ,n/ 	      Source_State , Sink_State , Simulate ) ;a             end if ;  =   when 2 => State_Transition.Save_Simulation_Output := True ;M 	    Text_Io.New_Line ( 2 ) ; #             Text_Io.Set_Col ( 5 ) ;AB             Text_Io.Put ( "Enter Simulation Output Filename: " ) ;6 	    State_Transition.Save_Simulation_Output := true ;  M             State_Transition.Simulation_File := "                         " ;	#             for index in 1..25 loop %    	      if Text_Io.End_Of_Line thenv                 exit ;               end if ;J               Text_io.Get ( State_Transition.Simulation_File ( Index ) ) ;             end loop ;  B   when 3 => In_Simulation_Menu := False ; -- Return to Master Menu   when others => null ;r     end case ;,   end loop ; -- end while In_Simulation_Menu   else -- no states in Db '     Display_Msg ( No_States_Entered ) ;a
   end if ; -----, --	FASTER Code Generation Menu -----	-   when 5 => In_Code_Generation_Menu := True ;o.             while In_Code_Generation_Menu loop3               Display_Menu ( Code_Generation_Menu ,p* 			     Num_Code_Generation_Menu_Choices ," 			     Code_Generation_Option ) ;  *             case Code_Generation_Option is ----- ; --	Generate Ada Code With Run-Time Output (Option Selected)  -----I$   when 1 => Text_Io.New_Line ( 2 ) ;#             Text_Io.Set_Col ( 5 ) ;T. 	    if State_Transition_Diagram_Entered then (               Generate_Ada_Source_Code ;             else3               Get_State_Transition_Diagram_File ;   "               if Not New_file then=                 Get_state_transition_input ( States, Events,  9                 Transaction_Events, Transaction_Actions , % 	        State_Transition_Diagram ) ; *                 Generate_Ada_Source_Code ;               else     	        Text_Io.New_Line ; @                 Display_Msg ( Enter_State_Transition_Diagram ) ;               end if ; 	     end if ; -----a: --	Include Simulation Output in Ada Code (Option Selected) ----- $   when 2 => Text_Io.New_Line ( 2 ) ;#             Text_Io.Set_Col ( 5 ) ;_K             Text_Io.Put ( "Enter Run-Time Simulation Output Filename: " ) ;l;             State_Transition.Save_Run_Time_Output := True ;=  R             State_Transition.Run_Time_Report_File := "                         " ;#             for index in 1..25 loopa%    	      if Text_Io.End_Of_Line then                  exit ;               end if ;O               Text_io.Get ( State_Transition.Run_Time_Report_File ( Index ) ) ;              end loop ;  .   when 3 => In_Code_Generation_Menu := False ;     when others => null ;      end case ;1   end loop ; -- end while In_Code_Generation_Menu  -----a --	Exit FASTER Main Menu -----I9   when 6 => Active_Session := False ;  -- Exit this menu =$             Text_Io.New_Line ( 2 ) ;  $             Prompt_User_To_Save_Db ;     	    Text_Io.Set_Col ( 10 ) ;  B             Text_Io.Put_Line ( "Normal Termination of FASTER." ) ;  '             If Report_File_Entered thenIB                Text_Io.Close ( State_Transition.OS_Report_File ) ;    	    End If ;      _@    when others => null ;  -- Already checked for boundary error.     end case ;)   end loop ; -- While Active_Session loop  end state_transitions_mmi ;d