$!------------------------------------------------------------------------------
$!  Compile and/or link JUMP under VAX or Alpha.
$!
$!  Parameter P1 set to any value (except "T") will cause linking only.
$!
$!  If there is no Pascal compiler available, rename the appropriate object
$!  file to .OBJ, issue the SET COMMAND command, and then execute this
$!  procedure with any P1 parameter (except "T") to link the image.
$!  Making P1 equal to "T" will cause traceback.
$!
$!  Author: Jonathan Ridler,
$!	    Information Technology Services,
$!	    The University of Melbourne,
$!	    Parkville, Victoria, AUSTRALIA, 3052.
$!
$!	    Internet: jonathan@unimelb.edu.au
$!
$!..............................................................................
$!  JUMP has been successfully built and tested under OpenVMS VAX v5.5-2 and
$!  v6.2 with Pascal v5.4, and OpenVMS Alpha v6.2 with Pascal v5.5.
$!
$!  With new releases of OpenVMS, it may be necessary to re-link JUMP.
$!------------------------------------------------------------------------------
$
$ on ERROR  then  EXIT
$ say   := write SYS$OUTPUT
$ VAX    = f$getsyi ("ARCH_NAME") .eqs. "VAX"		! "VAX" or "Alpha"
$ trace := /notraceback
$
$ p1 = f$edit (p1,"UPCASE,UNCOMMENT,COLLAPSE")
$
$ if (p1 .eqs. "") .or. (p1 .eqs. "T")
$ then
$   say "Compiling JUMP source ..."
$   pascal jump /usage=(all,noperformance)
$   say "Compiling JUMP CLD ..."
$   set command /object jump_cld
$ endif
$
$ if (p1 .eqs. "T")  then  trace := /traceback
$
$ say "Linking JUMP ..."
$ if VAX
$ then
$   link 'trace' jump,jump_cld,SYS$SYSTEM:SYS.STB/select,SYSDEF.STB/select
$ else
$   link /sysexe 'trace' jump,jump_cld,SYS$LOADABLE_IMAGES:SYSDEF.STB/select
$ endif
$
$ say "*** JUMP built successfully ***"
$ say "Don't forget to install the image with the correct privileges."
$
$ EXIT 1
