) /* compress.c -- compress a memory buffer ,  * Copyright (C) 1995-1996 Jean-loup Gailly.J  * For conditions of distribution and use, see copyright notice in zlib.h   */   ; /* $Id: compress.c,v 1.6 1995/05/03 17:27:08 jloup Exp $ */    #include "zlib.h"   N /* ===========================================================================L      Compresses the source buffer into the destination buffer.  sourceLen isI    the byte length of the source buffer. Upon entry, destLen is the total J    size of the destination buffer, which must be at least 0.1% larger thanG    sourceLen plus 8 bytes. Upon exit, destLen is the actual size of the     compressed buffer. F      This function can be used to compress a whole file at once if the    input file is mmap'ed. C      compress returns Z_OK if success, Z_MEM_ERROR if there was not H    enough memory, Z_BUF_ERROR if there was not enough room in the output
    buffer. *// int compress (dest, destLen, source, sourceLen)      Bytef *dest;     uLongf *destLen;     const Bytef *source;     uLong sourceLen; {      z_stream stream;     int err;  $     stream.next_in = (Bytef*)source;&     stream.avail_in = (uInt)sourceLen;3     /* Check for source > 64K on 16-bit machine: */ @     if ((uLong)stream.avail_in != sourceLen) return Z_BUF_ERROR;       stream.next_out = dest; &     stream.avail_out = (uInt)*destLen;@     if ((uLong)stream.avail_out != *destLen) return Z_BUF_ERROR;  "     stream.zalloc = (alloc_func)0;      stream.zfree = (free_func)0;     stream.opaque = (voidpf)0;  3     err = deflateInit(&stream, Z_BEST_COMPRESSION);       if (err != Z_OK) return err;  %     err = deflate(&stream, Z_FINISH);      if (err != Z_STREAM_END) {         deflateEnd(&stream);/         return err == Z_OK ? Z_BUF_ERROR : err;      }       *destLen = stream.total_out;       err = deflateEnd(&stream);     return err;  } 