#ifndef _ps2text_h_
#define _ps2text_h_
/*------------------------------------------------------------
| ps2text.h
|
| include file for ps2text.c
+------------------------------------------------------------*/

/*------------------------------------------------------------
| Constants
+------------------------------------------------------------*/

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

    /* standard length of character arrays.  */

#define MAX_BUF 1024		/* 1024 should be plenty. */
#define MAX_TOKENS 5		/* 5 should be plenty. */

    /* list recognized token types */

#define TEXT_TOKEN 1		/* text */
#define OPERATOR 2		/* regular operator */


#define PS_C		"%!"
#define MSPS_C		"%!"
#define TRAILER_C	"%%Trailer"
#define CREATOR_C	"%%Creator:"
#define RULE "\n------------------------------------------------------------\n"
#define COMMENT_CHAR	'%'

#define HELP		"help"
#define ENDHELP		"endhelp"
#define SPECIALCHARS	"specialchars"
#define ENDSPECIALCHARS "endspecialchars"


/*------------------------------------------------------------
| error handler.  Forces an exit, with error message
+------------------------------------------------------------*/

#define Exit_error(_string)	\
    {				\
    fprintf(stderr,"\nerror: %s\n",_string);\
    exit(FALSE);		\
    }

/*------------------------------------------------------------
| special string test.  Tests for equality up to the length of
| second string
+------------------------------------------------------------*/

#define Strnequal(_s1,_s2) (_s2 != NULL ? strncmp(_s1,_s2,strlen(_s2)) == 0 : 0)
#define Strequal(_s1,_s2) (_s2 != NULL ? strcmp(_s1,_s2) == 0 : 0)

#ifdef VMS
typedef int COORD;
#define TOKEN_COORD(token) ((COORD) atoi((token)))
#else
typedef long COORD;
#define TOKEN_COORD(token) ((COORD) atol((token)))
#endif

/*------------------------------------------------------------
| creator data structure.  Contains pointers to any operators
| recognized for the current creator.  See dat file for documentation
+------------------------------------------------------------*/

typedef struct creator_s
	{
	char
	    *begindocument,
	    *enddocument,
	    *beginpage,
	    *endpage,
	    *delta_x,
	    *delta_y,
	    *delta_xy,
	    *absolute_x,
	    *absolute_y,
	    *absolute_xy,
	    *text,
	    *rule;
	int
	    kern,
	    paragraph_test;
	char
	    *special_chars[255];
	char
	    *tokens[MAX_TOKENS];
	unsigned long
	    flags;
	} CREATOR;

#define LAST_TOKEN(n) creator_data->tokens[n]

#define DEBUGGING_HEADER    1<<16
#define DEBUGGING_TOKENS    1<<17
#define DEBUGGING_VERTICAL  1<<18
#define POSTPROCESS	    1<<0

#endif

