$ save_verify = 'f$verify(0)'
$!
$!	.TITLE	KLIP.INI
$!	.IDENT	'V02-00'
$!
$!	Facility:	DCL command procedure to automate a CMUIP-to-Internet
$!				SLIP connection.
$!
$!	Abstract:	This command procedure may be invoked manually or called by
$!				the CKERMIT script, KLIP.INI, to set up a temporary SLIP
$!				connection to an Internet Service Provider (ISP).  In either
$!				case the IP address must be passed to SLIP.  The User should
$!				manually invoke SLIP with the (D)isable parameter to terminate
$!				the SLIP connection.  In all cases, SLIP stops the IPACP and
$!				dependent processes, writes or deletes the SLIP driver
$!				definition in INET$CONFIG, and restarts the terminated
$!				processes.
$!
$!	Copyright  1995, Rob Puller.  All rights reserved.
$!				This software may be used, copied, and modified if, and
$!				only if, my copyright notice and other comments appear,
$!				unchanged, in all copies.  This software may not be sold,
$!				included with any commercial product, or incorporated into
$!				any other software without my express written agreement.
$!
$!	Contact:	Rob Puller
$!				Robley S. Puller, P.E.
$!				Consulting Engineer
$!				2130 N.W. 51st Terrace
$!				Gainesville, FL 32605
$!
$!				rpuller@afn.org
$!				http://www.afn.org/~rpuller/
$!
$!	Warranty:	NONE!  I'll fix reported bugs if time permits.
$!
$!	Warnings:	This software modifies (writes to) INET$CONFIG, so make
$!				a secure copy (like INTERNET_ORI.CONFIG) before using.
$!				It also facilitates connection to the Internet and it's
$!				well (sensationally) documented hazards.  Beware...
$!
$!	History:	Include your name and contact info if you modify this code.
$!	--------	----  --------------------------------------------------------	
$!	MO-DY-YR	Ver.  Comments
$!	11-01-95	V1.0  Initial release. (RSP)
$!	03-01-96	V1.1  Add support for MGFTP. (RSP)
$!	05-04-96	V2.0  Automate acquisition of IP address. (RSP)
$!	
$!----------------------------------------------------------------------------
$ say := write sys$output
$!
$!	Get the SLIP subnet address from the User if it's not on the command line.
$!
$ if P1 .eqs. ""
$ then
$	type sys$input

  An IP Address is a 32 bit number displayed as 4 octets in a dotted decimal
  notation.  Each octet represents the following values:

              +-------------- 1st octet - Network Address
              |   +---------- 2nd octet - Network Address
              |   |   +------ 3rd octet - Sub-net Address
              |   |   |   +-- 4th octet - Machine Address
              |   |   |   |
             nnn.nnn.sss.mmm
             
  Enter your [Machine Address] to ENABLE SLIP.  Enter [D] to DISABLE SLIP."
  You may enter these values on the command line in the future."

$	inquire P1 "  Enter your choice"
$ endif
$ P1 = f$edit(P1,"UPCASE")
$ if P1 .eqs. "D"
$ then
$	say ""
$	say "%IPNCP-S-IPACP_INFO, Disabling SLIP connections"
$	say ""
$	say ""
$	goto _begin
$ endif
$ if f$type(P1) .nes. "INTEGER" then goto _no_address
$ say ""
$ say "%IPNCP-S-IPACP_INFO, Enabling SLIP connections"
$ say ""
$ say ""
$_begin:
$!
$!	Shutdown the FTP Listener if it's running.
$!
$ ctx = ""
$ context = f$context( "PROCESS", ctx, "PRCNAM", "MGFTP Listener", "EQL" )
$ pid = f$pid( ctx )
$ if pid .nes. ""
$ then
$	stop/ident='pid'
$ endif
$!
$!	Shutdown the Name Resolver if it's running.
$!
$ ctx = ""
$ context = f$context( "PROCESS", ctx, "PRCNAM", "NAMRES", "EQL" )
$ pid = f$pid( ctx )
$ if pid .nes. ""
$ then
$	define/user sys$output nl:
$	ipncp namres exit
$ endif
$!
$!	Shutdown the Domain Server if it's running.
$!
$ ctx = ""
$ context = f$context( "PROCESS", ctx, "PRCNAM", "DOMS_UDP_SERVER", "EQL" )
$ pid = f$pid( ctx )
$ if pid .nes. ""
$ then
$	define/user sys$output nl:
$	@$disk2:[domain]shutdown.com
$ endif
$!
$!	Shutdown the IP Ancillary Control Process if it's up; this will also
$!	kill the SMTP Server.
$!
$ ctx = ""
$ context = f$context( "PROCESS", ctx, "PRCNAM", "IPACP(V6.6-5A)", "EQL" )
$ pid = f$pid( ctx )
$ if pid .nes. ""
$ then
$	ipncp netexit
$ endif
$!
$!	Uncomment and revise the Slip Driver Device definition in INTERNET.CONFIG.
$!
$ opened_file = "cmuip_root:[sysmgr]internet.config"
$ open /read /write /error = _open_err file cmuip_root:[sysmgr]internet.config
$_begin_loop:
$ read /end_of_file = _rec_not_found /error = _read_err /prompt="" file record
$ if f$locate(":CSDRV", record) .eq. f$length(record) then goto _begin_loop
$ if (f$locate(":CSDRV", record) .eq. 11) then record = ";''record'"
$ record = f$edit(record,"COLLAPSE")
$ if P1 .eqs. "D" then goto _end_loop
$ part1 = f$element( 0, ":", record )
$ part1 = f$extract( 1, f$length( part1 ) - 1, part1 )
$ part2 = f$element( 1, ":", record )
$ part3 = f$element( 2, ":", record )
$ part4 = f$element( 3, ":", record )
$ part5 = f$element( 4, ":", record )
$ part5a = f$element( 0, ".", part5 )
$ part5b = f$element( 1, ".", part5 )
$ part5c = f$element( 2, ".", part5 )
$ mask = f$element( 5, ":", record )
$ record = "''part1':''part2':''part3':''part4':''part5a'.''part5b'.''part5c'.''P1':''mask'"
$_end_loop:
$ if f$length( record ) .ne. 75
$ then
$ 	pad = f$extract( 0, 75 - f$length( record ), -
	"                                       " )
$ 	record = record + pad
$ endif
$ write /update /error = _write_err file record
$ close file
$!
$!	Define a Slip logical (SHO LOG SLIP tells user if Slip is enabled).
$!
$ if P1 .eqs. "D"
$ then
$	define/system/nolog SLIP "Slip Connections disabled."
$ else
$	ip_address = f$element( 4, ":", record )
$	define/system/nolog SLIP "Slip Connections enabled to ''ip_address'"
$ endif
$!
$!	Make sure the ipacp process has exited before restarting.
$!
$_pause1:
$ ctx = ""
$ context = f$context( "PROCESS", ctx, "PRCNAM", "IPACP(V6.6-5A)", "EQL" )
$ pid = f$pid( ctx )
$ if pid .nes. ""
$ then
$ 	wait 00:00:01.00
$ 	goto _pause1
$ endif
$!
$!	Make sure the smtp_server process has exited before restarting.
$!
$_pause2:
$ ctx = ""
$ context = f$context( "PROCESS", ctx, "PRCNAM", "MX SMTP Server", "EQL" )
$ pid = f$pid( ctx )
$ if pid .nes. ""
$ then
$ 	wait 00:00:01.00
$ 	goto _pause2
$ endif
$!
$!	Make sure the Domain Server process has exited before restarting.
$!
$_pause3:
$ ctx = ""
$ context = f$context( "PROCESS", ctx, "PRCNAM", "DOMS_UDP_SERVER", "EQL" )
$ pid = f$pid( ctx )
$ if pid .nes. ""
$ then
$ 	wait 00:00:01.00
$ 	goto _pause3
$ endif
$!
$!	Determine if this is an initial startup or a restart.
$!
$ if F$TRNLNM("IPNCP$CONFIG") .eqs. ""
$ then
$	!
$	! Its an initial startup.
$	!
$	say ""
$	@cmuip_root:[sysmgr]ip_startup.com
$	@madgoat_root:[com]ftp_start_listener	!comment out if you don't use MGFTP.
$!	@sys$startup:mx_startup.com				!uncomment this if you use MX.
$!	@$disk2:[domain]startup.com				!uncomment this if you use DOMAIN.
$ else
$	!
$	! Its a restart.
$	!
$	say ""
$	run cmuip_root:[sysexe]ipacp.exe -
		/noaccountng -
		/noauthorize -
		/detached -
		/dump -
		/buffer_limit=65535 -
		/io_buffered=32767 -
		/io_direct=32767 -
		/priority=6 -
		/privileges=(noexquota,cmkrnl) -
		/file_limit=512 -
		/ast_limit=200 -
		/queue_limit=100 -
		/extent=2048 -
		/uic=[1,4] -
		/input=nl:/output=nl:/error=nl:
$	@madgoat_root:[com]ftp_start_listener	!comment out if you don't use MGFTP.
$!	@sys$startup:mx_startup smtp_server		!uncomment this if you use MX.
$!	@$disk2:[domain]startup.com				!uncomment this if you use DOMAIN.
$ endif
$!
$!	Wrap things up.
$!
$ say ""
$ if P1 .eqs. "D"
$ then
$	say "%IPNCP-S-IPACP_STARTED, IPACP now running without SLIP"
$	LOGOUT
$ else
$	say "%IPNCP-S-IPACP_STARTED, IPACP now running with SLIP at ''ip_address'"
$ endif
$!
$_exit:
$ exit 1 .or. f$verify(save_verify)
$!
$!	Error handlers.
$!
$_open_err:
$ say "  Error opening ''opened_file'."
$ say ""
$ goto _exit
$_read_err:
$ close file
$ say "  Error reading ''opened_file'."
$ say ""
$ goto _exit
$_write_err:
$ close file
$ say "  Error writing to ''opened_file'."
$ say ""
$ goto _exit
$_rec_not_found:
$ close file
$ say "  Device driver specification not found in ''opened_file'."
$ say ""
$ goto _exit
$_no_address:
$ say ""
$ say "  You must enter an address to enable SLIP or enter D to disable it."
$ say ""
$ goto _exit
