 	main(int argc, char **argv) { /*	program hlptohtml ;/ /*	read .HLP file, convert to .HTML hierarchy ; 6 /*	A.Daviel, TRIUMF,  16-FEB-1994  <advax@triumf.ca> ;B /*      modifications by Jerome Lauret <JLAURET@sbchem.sunysb.edu>> /*      some changes derived from FORTRAN version 22-Aug-94 AD */   	char **desc_pp ;  	char *descrip[] = {> 	"HLPTOHTML: This program converts Digital's DCL HELP files ",= 	"(.HLP suffix) to HTLM, the Hypertext Markup Language used", ? 	"by Mosaic. Separate files are produced for different levels", = 	"in the HELP hierarchy, preserving the hierarchical nature", ; 	"of the Help information, and allowing use of the Mosaic", ? 	"Back command. The Hypertext ouput may be generated with the", < 	"pre-formatted flag set (<pre>); the user may remove this",@ 	"and refine the presentation after conversion. Alternatively,",< 	"pairs of <pre> and </pre> directives may be pre-inserted",; 	"in the HELP file to protect tables, etc., and formatted", & 	"output produced (the default)."," ",A 	"Usage : the program expects a Help file prefix, eg. 'FOOBAR'.", > 	"It will then read FOOBAR.HLP, creating the Hypertext files",E 	"FOOBAR.HTML,FOOBAR_1.HTML,FOOBAR_2.HTML, etc. plus FOOBAR.HREF, a", ; 	"list of the references created which may be used to add", & 	"further cross-references manually.",9 	"Depending on the format of the original HLP file, the", : 	"hypertext output may start either in FOOBAR.HTML or in", 	"FOOBAR_1.HTML"," ", ) 	"Options: -pre   Force pre-format flag", > 	"         -path filepath   Insert filepath before filenames", 	"  in references.", 	0 } ;  
 #include math  #include stdio.h: #include stdlib.h		/* for EXIT_SUCCESS and EXIT_FAILURE */   #define Lline 132   7 #define maxlevel 9	/* max. no. of levels in HLP file */ & 	FILE *unit[maxlevel], *Frefs, *Finp ; #define Lfilenm 80 	char filenm[Lfilenm] ;  #define Loption 5  	char option[Loption] ;  #define Lpath 80 	char path[Lpath] ;  	int pathn ; # define Lprefix 30  	char prefix[Lprefix] ;  # define Lword 80  	char word[Lword] ;   	char line[Lline],line2[Lline] ; 	int nch, ni ;   	char **c_pp ;    	int level = 0, prev_level = 0 ;
 	int k,j,nl ;  	int partn = 0, refn = 0 ; # define Lpart 34 * 	char part[Lpart],parts[Lpart][maxlevel] ; # define Lref 7  	char ref[Lref] ;  	int nquotes = 0 ; 	char inch[1] ;  	int pre_flag = 0 ;  	char *pos ; 	int nexta = 1 ; /*==*/ 	path[0] = 0 ; 	for (k = 1 ; k < argc ; k++) {  	    if(argv[k][0] == '-') {   		nexta = k+1 ;  		strcpy(option,argv[k]) ;! 		pos = strstr("-help",option) ;   		if (pos) {2 		    for (desc_pp = descrip; *desc_pp; desc_pp++)$ 		        printf("%s\n",*desc_pp) ;  		    printf("\n") ; 		    exit(EXIT_SUCCESS) ; 		} 0 		else if (!strcmp(option,"-pre"))pre_flag = 1 ;# 		else if (!strcmp(option,"-path"))  		    if (k+1 < argc) {  			strcpy(path,argv[k+1]) ;  			nexta++ ;" /* 			printf("path=%s\n",path); */ 			} 		    else {, 		        fprintf(stderr,"Path missing\n") ; 			exit(EXIT_FAILURE) ;  		    } : 		else fprintf(stderr,"Unrecognized option %s\n",option) ; 	    } /*argv - */   	} /*for k*/   	if (argc < 2) {G 	printf("Usage: hlptohtml [-h[elp]][-pre][-path path] file_prefix\n") ;  	exit(EXIT_SUCCESS) ;      	}   	if (nexta > argc-1) {+ 	    fprintf(stderr,"Missing argument\n") ;  	    exit(EXIT_FAILURE) ;  	    } 	strcpy(prefix,argv[nexta]) ;    	strcpy(filenm, prefix) ;  	strcat(filenm, ".hlp") ;  	Finp = fopen(filenm, "r"); 
 	if (!Finp) {  /* 	    lib$signal(Finp); */A 	    fprintf(stderr, "Unable to open input file '%s'\n", filenm); + 	    exit(EXIT_FAILURE) /* exit (Finp) */ ;  	}   	strcpy(filenm,path) ; 	strcat(filenm, prefix) ;  	strcat(filenm, ".href") ; 	Frefs = fopen(filenm, "w"); 	if (!Frefs) { 	    lib$signal(Frefs); @ 	    fprintf(stderr, "Unable to open href file '%s'\n", filenm); 	}  9 	fprintf(Frefs, "List of references for '%s'\n",prefix) ;  	/* create base level file */  	strcpy(filenm,prefix) ; 	strcat(filenm,".html") ; & 	printf("Creating file %s\n",filenm) ;" 	unit[level] = fopen(filenm, "w"); 	if (!unit[level]) { 	    lib$signal(unit[level]); B 	    fprintf(stderr, "Unable to open output file '%s'\n", filenm); 	}   /*	write header for new file */ + 	fprintf(unit[level], "<html>\n<head>\n") ; C 	fprintf(unit[level], "<title> %s.hlp</title>\n</head>\n",prefix) ; # 	fprintf(unit[level], "<body>\n") ; M 	if (pre_flag) fprintf(unit[level], "<pre>\n") ; /* default pre-formatted  */    L2:	fgets(line,Lline,Finp) ; 	if (feof(Finp)) goto L99 ;  	nl = nl + 1 ;E 	nch = strlen(line) ; if (nch>0) line[--nch] = 0 ; /* strip off \n */ : 	/* if input line is zero-length or spaces, put a para. */5 	if ((nch <= 0) || (!strncmp(line,"       ",nch))) {  C 	    if (level > 0) fprintf(unit[level], "<p>\n") ; /* paragraph */  	    goto L2 ; 	} ;2 	if ((line[0] < '1') || (line[0] > '9')) goto L3 ;6 	ni = sscanf(line,"%d",&level) ; if (ni < 1) goto L3 ;5 	strncpy(word,&line[1],nch) ; /* nch-1 +1 for null */  	if (level < prev_level) {/ 	    for (k = prev_level; k >= level+1 ; --k) { . 		if (pre_flag) fprintf(unit[k], "</pre>\n") ;! 		fprintf(unit[k], "</body>\n") ; : 		fprintf(unit[k], "</html>\n") ; /* close <>"s in file */< 		fclose(unit[k]) ;	/* close all intermediate level files */! 		printf("Closing unit %d\n",k) ;  	    } ;; /* 	printf("DEBUG1::%d %s %s ",level,part,parts[level]); */ ) 	    sprintf(part,"%s_%d",prefix,level) ; $ /* 	printf("DEBUG2::%s \n",part); */K /* 	    strcpy(part,parts[level]) ;*/ /*! restore filename to old level */   	    strcpy(filenm,path) ; 	    strcat(filenm,part) ; 	    strcat(filenm,".html") ; 9 	    fprintf(unit[level], "</dir>\n") ; /* close list  */ Q 	    if (pre_flag) fprintf(unit[level],"<pre>\n") ; /* restore pre-formatting  */  	} ; 	if (level > prev_level+1)  = 	    fprintf(stderr,"ERROR - skipped level in HELP file\n") ;  	if (level > prev_level) { 	    partn = partn + 1 ;) 	    sprintf(part,"%s_%d",prefix,partn) ;   	    strcpy(parts[level],part) ; 	    strcpy(filenm,path) ; 	    strcat(filenm,part) ; 	    strcat(filenm,".html") ; * 	    printf("Creating file %s\n",filenm) ;& 	    unit[level] = fopen(filenm, "w"); 	    if (!unit[level]) {! 	        lib$signal(unit[level]); F 	        fprintf(stderr, "Unable to open output file '%s'\n", filenm); 	    }   /*	write header for new file */ / 	    fprintf(unit[level], "<html>\n<head>\n") ; G 	    fprintf(unit[level], "<title> %s.hlp</title>\n</head>\n",prefix) ; ' 	    fprintf(unit[level], "<body>\n") ; R 	     if (pre_flag) fprintf(unit[level], "<pre>\n") ; /* default pre-formatted  */9 	    if (pre_flag) fprintf(unit[prev_level],"</pre>\n") ; - 	    if (level > 1) fprintf(unit[prev_level], 1 		  "<p>Additional Information on:<br><dir>\n") ; # 	    else fprintf(unit[prev_level], 0 		  "<p>Information available on:<br><dir>\n") ; 	} /* (level > prev_level)   */  	refn = refn + 1 ; 	sprintf(ref,"Ref%d",refn) ;3 /*	write keyword in new file as heading and name */ D 	fprintf(unit[level], "<a name=\"%s\"><h2>%s</h2></a>\n",ref,word) ;8 /*	write keyword in parent file as href and list item */ 	fprintf(unit[level-1], 8 	    "<li><a href=\"%s#%s\">%s</a>\n",filenm,ref,word) ;! /*	write in list of references */  	fprintf(Frefs, 5 	     "<a href=\"%s#%s\">%s</a>\n",filenm,ref,word) ;  	prev_level=level ; 
 	goto L2 ;  9 /*	support for pre-conditioning of HLP file formatting */   B L3:	if ( (strstr(line,"<pre>") != 0 || strstr(line,"<PRE>") != 0) C 	  ||  (strstr(line,"</pre>") != 0 || strstr(line,"</PRE>") != 0)   " 	  ||  (strstr(line,"&") == 0 &&  5 	 strstr(line,">") == 0 && strstr(line,"<") == 0) ) {   ' 	    fprintf(unit[level],"%s\n",line) ;  	    goto L2 ;	 	} else { $ /*	quote HTML reserved characters */ 	    j = 0 ;! 	    for (k = 0; k <= nch; ++k) {  	        if (line[k] == '&') {! 		    strcpy(&line2[j],"&amp;") ;  		    j = j + 5 ; % 	        } else  if(line[k] == '<') {   		    strcpy(&line2[j],"&lt;") ; 		    j = j + 4 ; % 	        } else  if(line[k] == '>') {   		    strcpy(&line2[j],"&gt;") ; 		    j = j + 4 ;  	        } else { / 	        line2[j++] = line[k]  ; line2[j] = 0 ;  	        } ; 	    } /* for k */ ;  ( 	    fprintf(unit[level],"%s\n",line2) ; 	    nquotes = nquotes + 1 ; 	    goto L2 ; 	} /* quote reserved */ ;    # L99:	for (k = level; k >= 0; --k) { 1 	    if (pre_flag) fprintf(unit[k], "</pre>\n") ; $ 	    fprintf(unit[k], "</body>\n") ;> 	    fprintf(unit[k], "</html>\n") ; /* close <>"s in file  */@ 	    fclose(unit[k]) ;	/* close all intermediate level files  */$ 	    printf("Closing unit %d\n",k) ; 	} ;G 	printf("HTML reserved characters were quoted on %d lines\n",nquotes) ;  	close(Frefs) ; close(Finp) ;  	exit(EXIT_SUCCESS) ;  } /* main */