/*
**
** FileSel.c
**
** Copyright (C) 1995, 1996 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@dipmza.physik.uni-mainz.de)
**           Department of Physic
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

/*
#define MESSAGES
*/
#include "message.h"

#include "config.h"

#include <stdlib.h> /* for malloc etc.*/
#include <ctype.h>  /* for toupper    */
#include <stdio.h>

#ifdef VMS
#   include <unixio.h> /* for chdir etc. */
#else
#   include <sys/stat.h>
#   include <sys/types.h>
#   include <dirent.h>
#   include <unistd.h>
    /* Damn it, don't ever use getwd with stupid linux ###jp### */
#   define getwd(aaa) getcwd((aaa),(FS_MAXNAMLEN-2))    
#endif

#include "paths.h"
#include INC_X11(Xlib.h)
#include INC_X11(Xos.h)
#include INC_X11(IntrinsicP.h)
#include INC_X11(StringDefs.h)
#include INC_XMU(Misc.h)
#include INC_XMU(CharSet.h)		/* for XmuCompareISOLatin1() */
#include INC_XAW(XawInit.h)
#include INC_XAW(ViewportP.h)
#include "Frame.h"
#include "FileSelP.h"

/*####################################################################
   OS dependant Definitions
####################################################################*/

#ifdef VMS
#   define FS_MAXNAMLEN 255
#   define DIR_SEPARATOR_STRING "."
#   define DIR_SPECIFICATION_START_STRING "["
#   define DIR_SPECIFICATION_END_STRING "]"

#   define CHANGE_TO_HEAD_OF_DIR_SPEC(path) {				\
              char *locat;					        \
              if (!(locat = strrchr(path,'['))) {                       \
                 if (!(locat = strrchr(path,':')+1)) {			\
                    INFMESSAGE(unable to extract node/disk information)	\
                    ENDMESSAGE(TopDirSelectionProc)			\
                    return;						\
                 }							\
              }								\
              else *(locat)='\0';					\
           }

#   define ONE_STEP_UP "[-]"		/* chdir argument to make one step up in the directory tree. */
#   define HOME getenv("SYS$LOGIN")	/* chdir argument to go home (the login directory) */
#else /*################################ VMS ############################*/

#   define FS_MAXNAMLEN 255
#   define DIR_SEPARATOR_STRING "/"
#   define DIR_SPECIFICATION_START_STRING ""
#   define DIR_SPECIFICATION_END_STRING ""

#   define CHANGE_TO_HEAD_OF_DIR_SPEC(path) {		\
              char*p=path;                      \
              *p='/'; p++; *p='\0';               \
           }

#   define ONE_STEP_UP ".."		/* chdir argument to make one step up in the directory tree. */
#   define HOME getenv("HOME")	        /* chdir argument to go home (the login directory) */
#endif

/*####################################################################
   Initializations
####################################################################*/

static char *emptyList[] = {NULL};
static char *unknownList[] = {"<unknown>",NULL};
static char *cannotopenList[] = {"<cannot open>",NULL};

static void FS_textfieldFocusAction();
static void FS_textfieldDeleteAction();
static void GripAdjustListSizesAction();

static XtActionsRec file_selectionActionsTable[] = {
       { "FS_textfieldFocusAction",  (XtActionProc) FS_textfieldFocusAction },
       { "FS_textfieldDeleteAction", (XtActionProc) FS_textfieldDeleteAction },
       { "FS_gripAdjustListSizes",   (XtActionProc) GripAdjustListSizesAction }
};
   
static String TextField_translations =
"#override\n\
<Key>Down:	no-op()\n\
<Key>Up:	no-op()\n\
<Key>Linefeed: 	no-op()\n\
<Key>space: 	no-op()\n\
Ctrl<Key>J: 	no-op()\n\
Ctrl<Key>M: 	no-op()\n\
Ctrl<Key>N: 	no-op()\n\
Ctrl<Key>O: 	no-op()\n\
Ctrl<Key>P: 	no-op()\n\
Ctrl<Key>R: 	no-op()\n\
Ctrl<Key>S: 	no-op()\n\
Ctrl<Key>V: 	no-op()\n\
Ctrl<Key>Z: 	no-op()\n\
Meta<Key>V: 	no-op()\n\
Meta<Key>Z: 	no-op()\n\
<Key>BackSpace: FS_textfieldDeleteAction()\n\
<Key>Delete: 	FS_textfieldDeleteAction()\n\
<Key>Right: 	forward-character()\n\
<Key>Left: 	backward-character()\n\
<Key>Return: 	no-op()\n\
<Btn1Down>:	FS_textfieldFocusAction() select-start()\n\
<Btn3Down>:	FS_textfieldFocusAction() extend-start()\
"; 

static String TextField_accelerators =
"#override\n\
<Key>Return:	set() notify() unset()\
";

#define FILE_SELECTION_LAYOUT \
"|v{\
	hs  =(20% of |width rescan)\
	hs2 =(20% of |width button2)\
	hs3 =(20% of |width button3)\
	hs4 =(20% of |width button4)\
	s   =(30% of |height rescan)\
	$s<-50%>\
	|h{\
		$hs<-90%>\
		|v{\
			$s<-50%>\
			rescan<*+[1]>\
			$s<+50%-50%>\
			filter<*+[1]>\
			$s<-50%>\
		}\
		$hs<-50%>\
		|v{\
			$s<+50%-50%>\
			pathframe<+[1]-80%*>\
			$s<+50%-50%>\
			fileframe<+[1]-80%*>\
			$s<+50%-50%>\
		}\
		$hs<-90%>\
	}\
	$s<-50%>\
	|h{\
		$hs<-90%>\
		paned<+[1]-80%*+[2]-80%>\
		$hs<-90%>\
	}\
	$s<-50%>\
	|h{\
		$hs<+1000%-90%>\
		button1\
		$hs2<+1000%-90%>\
		button2\
		$hs3<+1000%-90%>\
		button3\
		$hs4<+1000%-90%>\
		button4\
		$hs<+1000%-90%>\
	}\
	$s<-50%>\
}"

/*####################################################################
   Macros and Definitions
####################################################################*/

/* general Xt Macros */

#ifdef MIN
#   undef MIN
#endif
#define MIN(_a_,_b_) (_a_)<(_b_)?(_a_):(_b_)
#ifdef MAX
#   undef MAX
#endif
#define MAX(_a_,_b_) (_a_)>(_b_)?(_a_):(_b_)

#define USE_Arg(num)  Arg args[num]; Cardinal argn = 0

#define ADD_Callback(widget,proc) XtAddCallback((Widget)(widget),XtNcallback,(proc),NULL)
#define ADD_Callback_Data(widget,proc,data) XtAddCallback((Widget)(widget),XtNcallback,(proc),(data))
#define ADD_Widget(name,class,parent) XtCreateManagedWidget((name),class,(Widget)(parent),NULL,(Cardinal)0)  
#define ADD_PopupShell(name,class,parent) XtCreatePopupShell((name),class,(Widget)(parent),NULL,(Cardinal)0)

#define ADD_Widget_Arg(name,class,parent) XtCreateManagedWidget((name),class,(parent),args,argn)
#define RESET_Arg argn=0
#define GOT_Arg   (argn)
#define SET_Arg(name,value)		\
	   XtSetArg(args[argn],(name),(value));	argn++

#define SET_Values(widget)   XtSetValues((widget),args,argn)
#define SET_Value(widget,name,value)	\
           RESET_Arg;			\
           SET_Arg((name),(value));	\
           SET_Values((widget))

#define GET_Values(widget)   XtGetValues((Widget)(widget),args,argn)
#define GET_Value(widget,name,value)	\
           RESET_Arg;			\
           SET_Arg((name),(value));	\
           GET_Values((widget))

#define streq(a,b) (strcmp((a),(b))==0)
#define resource(name) (appResources->name)

/* FileSelection specific Macros */

#define FS_WIDGET		FileSelectionWidget fs = (FileSelectionWidget)
#define FS_FILE_SELECTION       fs

#define FS_RESCAN 		fs->file_selection.rescanFS
#define FS_FILTER		fs->file_selection.filterFS
#define FS_BUTTON1		fs->file_selection.button1FS
#define FS_BUTTON2		fs->file_selection.button2FS
#define FS_BUTTON3		fs->file_selection.button3FS
#define FS_BUTTON4		fs->file_selection.button4FS

#define FS_PATHFRAME		fs->file_selection.pathframeFS
#define FS_PATH			fs->file_selection.pathFS
#define FS_FILEFRAME		fs->file_selection.fileframeFS
#define FS_FILE			fs->file_selection.fileFS
#define FS_PANED		fs->file_selection.panedFS
#define FS_TOPFRAME		fs->file_selection.topframeFS
#define FS_TOPVIEW		fs->file_selection.topviewFS
#define FS_TOPLIST		fs->file_selection.toplistFS
#define FS_CURFRAME		fs->file_selection.curframeFS
#define FS_CURVIEW		fs->file_selection.curviewFS
#define FS_CURLIST		fs->file_selection.curlistFS
#define FS_SUBFRAME		fs->file_selection.subframeFS
#define FS_SUBVIEW		fs->file_selection.subviewFS
#define FS_SUBLIST		fs->file_selection.sublistFS

#define TOPDIR			fs->file_selection.topdir
#define TOPDIR_ALLOC		fs->file_selection.topdir_alloc
#define TOPDIR_ENTRIES  	fs->file_selection.topdir.num_of_entries
#define TOPDIR_ENTRY(num) 	fs->file_selection.topdir.entry[(num)]
#define TOPDIR_LIST		fs->file_selection.topdir.entry

#define CURDIR			fs->file_selection.curdir
#define CURDIR_ALLOC		fs->file_selection.curdir_alloc
#define CURDIR_ENTRIES  	fs->file_selection.curdir.num_of_entries
#define CURDIR_ENTRY(num) 	fs->file_selection.curdir.entry[(num)]
#define CURDIR_LIST		fs->file_selection.curdir.entry

#define SUBDIR			fs->file_selection.subdir
#define SUBDIR_ALLOC		fs->file_selection.subdir_alloc
#define SUBDIR_ENTRIES  	fs->file_selection.subdir.num_of_entries
#define SUBDIR_ENTRY(num) 	fs->file_selection.subdir.entry[(num)]
#define SUBDIR_LIST		fs->file_selection.subdir.entry

#define PATH_RESOURCE		fs->file_selection.path
#define FILE_RESOURCE		fs->file_selection.file
#define VIEWMODE		fs->file_selection.view_mode
#define VIEWORDER		fs->file_selection.view_order
#define HIGHLIGHT		fs->file_selection.highlightPixel
#define OLD_HIGHLIGHT		fs->file_selection.old_highlightPixel

#define PATH			fs->file_selection.path_field_value
#define FILE			fs->file_selection.file_field_value
#define BOTH			fs->file_selection.both
#define APP_DIR			fs->file_selection.app_dir
#define CURRENT_DIR             fs->file_selection.current_dir

#define BUTTONS            	fs->file_selection.internal_buttons
#define BUTTONS_RESOURCE        fs->file_selection.buttons
#define PREFERRED_BUTTON	fs->file_selection.preferredButton

#define REALLOC_MORE_IF_NEEDED(list,needed,current) 					\
    if (needed >= current) {								\
       current *= 2;									\
       list = (String *) XtRealloc((char *) list,(unsigned)(current*sizeof(String)));	\
    }
#define ALLOC_LIST(list,needed) 							\
    list = (String *) XtMalloc((unsigned)(needed* sizeof(String)))

#define POSITION(pos) ((pos==1)+2*(pos==2)+4*(pos==3)+8*(pos==4)) 
#define IS_BUTTON(pos) (POSITION(pos) & BUTTONS) 
#define POSITION_TO_BUTTON_NAME(pos,name) sprintf((name),"button%d",(int)(pos))

#define MULTICLICK_INTERVAL ((unsigned long) 400)
#define DISABLED        ((XtIntervalId) 0)
#define MULTICLICK      fs->file_selection.multiclick
#define ENABLE_MULTICLICK                                   		\
    MULTICLICK = XtAppAddTimeOut(                       		\
                    XtWidgetToApplicationContext((Widget)FS_FILE_SELECTION),\
                    MULTICLICK_INTERVAL,                		\
                    MulticlickNotify,					\
                    ((XtPointer)FS_FILE_SELECTION)			\
                 )

#define DESTROY_MULTICLICK		\
    if (MULTICLICK) {			\
       XtRemoveTimeOut(MULTICLICK);	\
       MULTICLICK = DISABLED;		\
    }


#define offset(field) XtOffsetOf(FileSelectionRec, file_selection.field)
#define lay_offset(field) XtOffsetOf(FileSelectionRec, aaa.field)
static XtResource resources[] = {
    {XtNpath,XtCPath,XtRString,sizeof(String),offset(path),XtRImmediate,(XtPointer)NULL},
    {XtNfile,XtCFile,XtRString,sizeof(String),offset(file),XtRImmediate,(XtPointer)NULL},
    {XtNviewOrder, XtCViewOrder, XtRString,sizeof(String),offset(view_order),XtRImmediate,"top,cur,sub"},
    {XtNviewMode, XtCViewMode, XtRViewMode,sizeof(int),offset(view_mode),XtRImmediate,(XtPointer)XawFileSelectionRescan},
    {XtNbuttons,XtCButtons,XtRInt,sizeof(int),offset(buttons),XtRImmediate,(XtPointer)0},
    {XtNpreferredButton,XtCPreferredButton,XtRInt,sizeof(int),offset(preferredButton),XtRImmediate,(XtPointer)0},
    {XtNhighlightPixel, XtCHighlightPixel, XtRPixel, sizeof(Pixel),offset(highlightPixel), XtRImmediate, (XtPointer)NULL}, 
    {XtNlayout, XtCLayout, XtRLayout, sizeof(BoxPtr),lay_offset(layout),XtRString,FILE_SELECTION_LAYOUT},
    {XtNresizeWidth,  XtCBoolean, XtRBoolean, sizeof(Boolean),lay_offset(resize_width),XtRBoolean,False},
    {XtNresizeHeight, XtCBoolean, XtRBoolean, sizeof(Boolean),lay_offset(resize_height),XtRBoolean,False},
};
#undef offset
#undef lay_offset

static Boolean SetValues();
static void ClassInitialize(), Initialize(), Realize(), Resize(), Destroy();
static void filterProc(),rescanProc();
static void TopDirSelectionProc(), CurDirSelectionProc(), SubDirSelectionProc();
static void FS_textfieldFocusAction(),FS_textfieldDeleteAction();
       void positionFileSelPopup();
static void AdjustListSizes();
     
FileSelectionClassRec file_selectionClassRec = {
  {
/* core class fields */
    /* superclass         */   (WidgetClass) (&aaaClassRec),
    /* class name         */   "FileSelection",
    /* size               */   sizeof(FileSelectionRec),
    /* class_initialize   */   ClassInitialize,
    /* class_part init    */   NULL,
    /* class_inited       */   FALSE,
    /* initialize         */   Initialize,
    /* initialize_hook    */   NULL,
    /* realize            */   Realize,
    /* actions            */   file_selectionActionsTable,
    /* num_actions        */   XtNumber(file_selectionActionsTable),
    /* resources          */   resources,
    /* resource_count     */   XtNumber(resources),
    /* xrm_class          */   NULLQUARK,
#if defined(VMS) || defined(linux)
    /* compress_motion    */   0,
    /* compress_exposure  */   0,
    /* compress_enterleave*/   0,
#else
    /* compress_motion    */   NULL,
    /* compress_exposure  */   NULL,
    /* compress_enterleave*/   NULL,
#endif
    /* visible_interest   */   FALSE,
    /* destroy            */   Destroy,
    /* resize             */   Resize,
    /* expose             */   NULL,
    /* set_values         */   SetValues,
    /* set_values_hook    */   NULL,
    /* set_values_almost  */   XtInheritSetValuesAlmost,
    /* get_values_hook    */   NULL,
    /* accept_focus       */   NULL,
    /* version            */   XtVersion,
    /* callback_private   */   NULL,
    /* tm_table           */   NULL,
    /* query_geometry     */   XtInheritQueryGeometry,
    /* display_accelerator*/   XtInheritDisplayAccelerator,
    /* extension          */   NULL
   }, 
   {
/* composite class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
    /* extension          */   NULL
   }, 
   {
/* constraint class fields */
    /* subresources       */   NULL,
    /* subresource_count  */   0,
    /* constraint_size    */   sizeof(FileSelectionConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL,
    /* extension          */   NULL
   },
  { 
/* aaa class fields */
    /* foo                */   0
  },
  { 
/* file selection class fields */
    /* empty              */   0
  }  
};

WidgetClass file_selectionWidgetClass = (WidgetClass) &file_selectionClassRec;

/*###############################################################################
   CvtStringToViewMode
###############################################################################*/

static Boolean
CvtStringToViewMode (dpy, args, num_args, from, to, converter_data)
    Display     *dpy;
    XrmValue    *args;
    Cardinal    *num_args;
    XrmValue    *from, *to;
    XtPointer   *converter_data;
{
    char 	*in = (char *) from->addr;
    int 	value;
    
    BEGINMESSAGE(CvtStringToViewMode)
    INFSMESSAGE(trying to convert:,in)
    
    if      (streq(in,"rescan")) value = XawFileSelectionRescan;
    else if (streq(in,"filter")) value = XawFileSelectionFilter;
    else {
       String params[1];
       Cardinal num_params =1;
       params[0] = (String) from->addr;
       XtAppWarningMsg(
          XtDisplayToApplicationContext(dpy),
          "CvtStringToViewMode",
          "UnknownParameter",
          "XawFileSelectionWidget",
          "Cannot translate \"%s\" to ViewMode.",
          params,
          &num_params
       );
       INFMESSAGE(failed - unknown parameter)
       ENDMESSAGE(CvtStringToViewMode) 
       return False;
    }
 
    if (to->addr != NULL) {
       if (to->size < sizeof(int)) {
          to->size = sizeof(int);
          INFMESSAGE(failed - not enough memory allocated)
          ENDMESSAGE(CvtStringToViewMode)
          return False;
       }
       *(int *)(to->addr) = value;
    }
    else {
       static int static_val;
       static_val = value;
       to->addr = (caddr_t) &static_val;
    }
    to->size = sizeof(int);
    
    INFMESSAGE(succesfull)
    ENDMESSAGE(CvtStringToViewMode)
    return True;
}

/*###############################################################################
   FreeViewMode
###############################################################################*/

static void
FreeViewMode (app, to, data, args, num_args)
    XtAppContext    app;
    XrmValue        *to;
    XtPointer       data;
    XrmValuePtr     args;
    Cardinal        *num_args;
{
    BEGINMESSAGE(FreeViewMode)
    ENDMESSAGE(FreeViewMode)
}

/*###############################################################################
   ClassInitialize
###############################################################################*/

static void 
ClassInitialize()
{
    BEGINMESSAGE(ClassInitialize)
    XawInitializeWidgetSet();
    XtSetTypeConverter ( XtRString, XtRViewMode,
                         CvtStringToViewMode,(XtConvertArgList)NULL, (Cardinal)0,
                         XtCacheNone, 
                         FreeViewMode
                       );

    ENDMESSAGE(ClassInitialize)
}

/*###############################################################################
   Realize
###############################################################################*/

static void Realize (w, valueMask, attrs)
    Widget w;
    XtValueMask *valueMask;
    XSetWindowAttributes *attrs;
{
   BEGINMESSAGE(Realize)
   (*file_selectionWidgetClass->core_class.superclass->core_class.realize)(w, valueMask, attrs);
   AdjustListSizes(w);
   ENDMESSAGE(Realize)
}

/*###############################################################################
   Resize
###############################################################################*/

static void 
Resize(w)
   Widget w;
{
   BEGINMESSAGE(Resize)
   (*file_selectionWidgetClass->core_class.superclass->core_class.resize)(w);
   if (XtIsRealized(w)) AdjustListSizes(w);
   ENDMESSAGE(Resize)
}   

/*###############################################################################
   strwild
###############################################################################*/

static Boolean strwild(string,wild)
   char 	*string, *wild;
{
   char 	*cwild;
   int 		nwild = 0;
   int 		wildlen;

   INFMESSAGE1(executing strwild)

   strcpy((cwild=malloc(strlen(wild)+1)),wild);
   wild = cwild; while ((wild=strchr(wild,'*'))) { ++nwild;  *wild++ = '\0'; } wild=cwild;
   wildlen=strlen(wild);

   if ((wildlen) && ((strncmp(string,wild,wildlen)) || ((!nwild) && (*(string += wildlen))))) {
         free(cwild); return(FALSE); 
   }
   wild += (wildlen+1);
   
   while (nwild) {
      wildlen=strlen(wild);
      if ((wildlen) && ((!(string = strstr(string,wild))) || ((nwild==1) && (*(string += wildlen))))) { 
         free(cwild); return(FALSE); 
      }
      wild += (wildlen+1);
      --nwild;
   }
   free(cwild);
   return(TRUE);
}

#ifdef VMS
/*###############################################################################
   strreplace
###############################################################################*/

static void
strreplace(out,find,replace,in)
   char *out;
   char *find;
   char *replace;
   char *in;
{
   int locat = 0;
   int findlength;
   char *intemp;
   char *temp;

   INFMESSAGE1(executing strreplace)

   findlength = strlen(find);
   if (!(*in) || !(*find)) return;

   intemp = malloc(strlen(in)+1);
   strcpy(intemp,in);

   temp=intemp;
   while ((temp=strstr(temp,find))) { *temp='\0'; temp += findlength; ++locat; }

   temp=intemp; *out = '\0';
   while ((locat--) > 0) {
      strcat(out,temp); strcat(out,replace);
      temp = strchr(temp,'\0') + findlength;
   }
   strcat(out,temp);
   free(intemp);
}  
#endif /* endo of VMS */

/*############################################################*/
/* TranslateTildeInPath */
/*############################################################*/

void
TranslateTildeInPath(path)
   char *path;
{
   char *pos;

   BEGINMESSAGE(TranslateTildeInPath)
   if ((pos=strchr(path,'~'))) {
      char *home;
      char tmp[FS_MAXNAMLEN];
      home=getenv("HOME");
      if (strlen(home)+strlen(path)-1 < FS_MAXNAMLEN-1) {
         *pos='\0'; pos++;
         strcpy(tmp,path);
         strcat(tmp,home);
         strcat(tmp,pos);
         strcpy(path,tmp);
      }
   }
   ENDMESSAGE(TranslateTildeInPath)
}
/*###############################################################################
   FScompareEntries
###############################################################################*/

static int
FScompareEntries(p, q)
	String	*p;
	String	*q;
{
#   ifdef VMS /*versions should be sorted correctly (1.11.94)*/
       char *vp,*vq;
       int result;
       vq=strrchr(*q,';');
       vp=strrchr(*p,';');
       if ((vq) && (vp)) {
         *vp='\0'; *vq='\0';
         result=strcmp(*p,*q);
         if (!result) result = strlen(vq+1)-strlen(vp+1);
         if (!result) result = -strcmp(vp+1,vq+1);
         *vp=';'; *vq=';';
         return result;
       } else {
         return strcmp(*p,*q);
       }
#   else
	 return strcmp(*p,*q);
#   endif
}

/*########################################################################
   FS_textfieldDeleteAction 
########################################################################*/

static void FS_textfieldDeleteAction(w, event, parms, nparms)
   Widget	w;
   XEvent	*event;
   String	*parms;
   Cardinal	*nparms;
{
   BEGINMESSAGE(FS_textfieldDeleteAction)

   if (XtIsSubclass(w,asciiTextWidgetClass)) {
      XawTextPosition begin_sel,end_sel;

      XawTextGetSelectionPos(w,&begin_sel,&end_sel);
      if (begin_sel != end_sel) 
         XtCallActionProc(w,"kill-selection",(XEvent *)NULL,(String *)NULL,(Cardinal)NULL);
      else 
         XtCallActionProc(w,"delete-previous-character",(XEvent *)NULL,(String *)NULL,(Cardinal)NULL);
   }       

   ENDMESSAGE(FS_textfieldDeleteAction)
}

/*########################################################################
   FS_textfieldFocusAction 
########################################################################*/

static void FS_textfieldFocusAction(w, event, parms, nparms)
   Widget	w;
   XEvent	*event;
   String	*parms;
   Cardinal	*nparms;
{
   USE_Arg(5);
   static Widget old = NULL;

   BEGINMESSAGE(FS_textfieldFocusAction)

   if ((old) && (w != old)) {
      if (XtIsSubclass(old,asciiTextWidgetClass)) {
         FS_WIDGET XtParent(XtParent(old));
         INFMESSAGE(old is asciiTextWidget)
         RESET_Arg;
         if (HIGHLIGHT) {
            SET_Arg(XtNbackground,OLD_HIGHLIGHT); 
         }     
         SET_Arg(XtNdisplayCaret,     False);
      }       
      if (GOT_Arg) SET_Values(old);
   } 

   if ((!old) || (old != w)) {
      if (XtIsSubclass(w,asciiTextWidgetClass)) {
         FS_WIDGET XtParent(XtParent(w));
         INFMESSAGE(new is asciiTextWidget) 
         XtSetKeyboardFocus((Widget)FS_FILE_SELECTION, w);
         if (HIGHLIGHT) { GET_Value(w,XtNbackground,&(OLD_HIGHLIGHT)); } 
         RESET_Arg;
         if (HIGHLIGHT) { SET_Arg(XtNbackground,HIGHLIGHT); }     
         SET_Arg(XtNdisplayCaret,      True);
     }
     if (GOT_Arg) SET_Values(w);
  }
  old = w;

  ENDMESSAGE(FS_textfieldFocusAction)
}  

/*###############################################################################
    MulticlickNotify
###############################################################################*/

static void MulticlickNotify (client_data, idp)
    XtPointer client_data;
    XtIntervalId *idp;
{
    FS_WIDGET client_data;
   
    BEGINMESSAGE(MulticlickNotify) 
    MULTICLICK = DISABLED;
    ENDMESSAGE(MulticlickNotify)
}                               

/*###############################################################################
   Destroy
###############################################################################*/

static void 
Destroy(w)
   Widget 	w;
{
   FS_WIDGET w;

   BEGINMESSAGE(Destroy)
   while ((--TOPDIR_ENTRIES) >=0 ) XtFree((char *)TOPDIR_ENTRY(TOPDIR_ENTRIES)); ++TOPDIR_ENTRIES;
   while ((--CURDIR_ENTRIES) >=0 ) XtFree((char *)CURDIR_ENTRY(CURDIR_ENTRIES)); ++CURDIR_ENTRIES;
   while ((--SUBDIR_ENTRIES) >=0 ) XtFree((char *)SUBDIR_ENTRY(SUBDIR_ENTRIES)); ++SUBDIR_ENTRIES;

   XtFree((char *)TOPDIR_LIST);
   XtFree((char *)CURDIR_LIST);
   XtFree((char *)SUBDIR_LIST);
   XtFree((char *)PATH);
   XtFree((char *)FILE);
   XtFree((char *)BOTH);
   XtFree((char *)CURRENT_DIR);
   XtFree((char *)APP_DIR);
   DESTROY_MULTICLICK;

   ENDMESSAGE(Destroy)
}

/*###############################################################################
   SetPreferredButton
###############################################################################*/

static void SetPreferredButton(w,position,install)
   Widget	w;
   int 		position;
   int		install;
{
   FS_WIDGET 	w;
   char 	name[10];
   Widget 	button;
   static XtAccelerators accelerators = (XtAccelerators)NULL;
   USE_Arg(5);

   BEGINMESSAGE(SetPreferredButton)
   if (!accelerators) accelerators=XtParseAcceleratorTable(TextField_accelerators);
   if (IS_BUTTON(position)) {
      POSITION_TO_BUTTON_NAME(position,name);
      button = XtNameToWidget((Widget)FS_FILE_SELECTION,name);
      if (!install) { 
         SET_Value(button,XtNaccelerators,(XtAccelerators)NULL);
      }
      else {
         SET_Value(button,XtNaccelerators,(XtAccelerators)accelerators);
         XtInstallAccelerators(FS_PATH,button);
         XtInstallAccelerators(FS_FILE,button);
      }
   }
   ENDMESSAGE(SetPreferredButton)
}

/*###############################################################################
   SetValues
###############################################################################*/

static Boolean SetValues(current, request, new, in_args, in_num_args)
   Widget 	current, request, new;
   ArgList 	in_args;
   Cardinal 	*in_num_args;
{
   FS_WIDGET	new;
   FileSelectionWidget rfs = (FileSelectionWidget)request;  
   USE_Arg(5);

   BEGINMESSAGE(SetValues)

   if (PATH_RESOURCE != rfs->file_selection.path_field_value) {
      if (PATH_RESOURCE) { SET_Value(FS_PATH,XtNstring,PATH_RESOURCE); }
      else { SET_Value(FS_PATH,XtNstring,APP_DIR); }
      INFMESSAGE(changing Path Selection Field)
   }
   
   if (FILE_RESOURCE != rfs->file_selection.file_field_value) {
      SET_Value(FS_FILE,XtNstring,FILE_RESOURCE);
      INFMESSAGE(changing File Selection Field)
   }

   if (PREFERRED_BUTTON != rfs->file_selection.preferredButton) {
      SetPreferredButton(new,rfs->file_selection.preferredButton,FALSE);
      SetPreferredButton(new,PREFERRED_BUTTON,TRUE);
      INFMESSAGE(switched Accelerators)
   }

   ENDMESSAGE(SetValues)
   return False;
}

/*########################################################################
   UpdateLists
########################################################################*/

static void UpdateLists(FS_FILE_SELECTION,attemptResize) 
   FileSelectionWidget FS_FILE_SELECTION;
   Boolean attemptResize;
{
   INFMESSAGE(executing UpdateLists)
   XawListcChange(FS_TOPLIST, TOPDIR_LIST, TOPDIR_ENTRIES, 0, attemptResize);
   XawListcChange(FS_CURLIST, CURDIR_LIST, CURDIR_ENTRIES, 0, attemptResize);
   XawListcChange(FS_SUBLIST, SUBDIR_LIST, SUBDIR_ENTRIES, 0, attemptResize);
}

/*########################################################################
   UseScrollbars
########################################################################*/

static void UseScrollbars(FS_FILE_SELECTION,use) 
   FileSelectionWidget FS_FILE_SELECTION;
   Boolean use;
{
   USE_Arg(3);

#ifdef MESSAGES
   if (use) { INFMESSAGE(executing UseScrollbars - scrollbars allowed now) }
   else     { INFMESSAGE(executing UseScrollbars - removing scrollbars) }
#endif
   RESET_Arg;
   SET_Arg(XtNallowHoriz,use);
   SET_Arg(XtNallowVert,use);
   SET_Values(((Widget)FS_TOPVIEW));
   SET_Values(((Widget)FS_CURVIEW));
   SET_Values(((Widget)FS_SUBVIEW));
}

/*########################################################################
   GripAdjustListSizesAction
########################################################################*/

static void GripAdjustListSizesAction(w, event, params, nparams)
   Widget	w;
   XEvent	*event;
   String	*params;
   Cardinal	*nparams;
{
   BEGINMESSAGE(GripAdjustListSizesAction)
   if (!(XtIsSubclass(w,gripWidgetClass))) {
      INFMESSAGE(calling widget is not a subclass of grip)
      ENDMESSAGE(GripAdjustListSizesAction)
   }
   if (*nparams==1) {
      FS_WIDGET XtParent(XtParent(w));
      if        (!XmuCompareISOLatin1(params[0],"start")) {
         UseScrollbars(FS_FILE_SELECTION,False);
      } else if (!XmuCompareISOLatin1(params[0],"stop")) {
         UseScrollbars(FS_FILE_SELECTION,True);
         /* AdjustListSizes(FS_FILE_SELECTION); don't need that ###jp### 1/95*/
      }
   }
   ENDMESSAGE(GripAdjustListSizesAction)
}

/*########################################################################
   AdjustListSizes
########################################################################*/

static void AdjustListSizes(FS_FILE_SELECTION) 
   FileSelectionWidget FS_FILE_SELECTION;
{
   BEGINMESSAGE(AdjustListSizes)

   UpdateLists(FS_FILE_SELECTION,False);
   (*((ViewportWidget)(FS_TOPVIEW))->core.widget_class->core_class.resize)(FS_TOPVIEW);
   (*((ViewportWidget)(FS_CURVIEW))->core.widget_class->core_class.resize)(FS_CURVIEW);
   (*((ViewportWidget)(FS_SUBVIEW))->core.widget_class->core_class.resize)(FS_SUBVIEW);

   ENDMESSAGE(AdjustListSizes)
}

/*###############################################################################
   SetIncompleteDirectoryView
###############################################################################*/

static void
SetIncompleteDirectoryView(w,list)
   Widget	w;
   String	*list;
{
   FS_WIDGET 	w;

   BEGINMESSAGE(SetIncompleteDirectoryView)
   XawListcChange(FS_CURLIST, list, 1, 0, True); 
   chdir(APP_DIR);
   ENDMESSAGE(SetIncompleteDirectoryView)
}  

/*###############################################################################
   SetDirectoryView
   updates all lists according to the path given in the path selection field
###############################################################################*/

static void
SetDirectoryView(w,viewmode)
   Widget	w;
   int		viewmode;
{
   FS_WIDGET 		w;
   DIR			*dirp;
   struct dirent	*dp;
   String  		str;
   char 		*temp;
   Boolean 		accepted;
   char 		path[FS_MAXNAMLEN];
   char                 *file;
#  ifdef VMS
      char		tempfile[FS_MAXNAMLEN];
#  endif
   USE_Arg(5);
   
   BEGINMESSAGE(SetDirectoryView)

   GET_Value(FS_PATH,XtNstring,&temp);
   INFSMESSAGE(trying to set:,temp)
   if (!(*temp)) {
      if (chdir(CURRENT_DIR))  if (chdir(APP_DIR)) {
         SetIncompleteDirectoryView(w,unknownList); 
         INFMESSAGE(unable to change directory appropriately) ENDMESSAGE(SetDirectoryView)
         return;
      }
   }
   else if (strchr(temp,'~')) {
      char tmp[FS_MAXNAMLEN];
      if (strlen(temp) < FS_MAXNAMLEN-1) {
         strcpy(tmp,temp);
         TranslateTildeInPath(tmp);
         if (chdir(tmp)) {
            SetIncompleteDirectoryView(w,unknownList); 
            INFMESSAGE(unable to change to login directory) ENDMESSAGE(SetDirectoryView)
            return;
         } else {
            XawFileSelectionSetSelection(w,tmp,XawFileSelectionPath);
         }
      }
   }
   else if (chdir(temp)) {
         SetIncompleteDirectoryView(w,unknownList); 
         INFMESSAGE(unable to change to specified directory) ENDMESSAGE(SetDirectoryView)
         return;
   }

   if (!(dirp=opendir("."))) {
      SetIncompleteDirectoryView(w,cannotopenList);
      INFMESSAGE(unable to open directory) ENDMESSAGE(SetDirectoryView)
      return;
   }

   getwd(path);
   XtFree(CURRENT_DIR); CURRENT_DIR = XtNewString(path);
   SMESSAGE(CURRENT_DIR)

   while ((--TOPDIR_ENTRIES) >=0 ) XtFree((char *)TOPDIR_ENTRY(TOPDIR_ENTRIES)); ++TOPDIR_ENTRIES;
   while ((--CURDIR_ENTRIES) >=0 ) XtFree((char *)CURDIR_ENTRY(CURDIR_ENTRIES)); ++CURDIR_ENTRIES;
   while ((--SUBDIR_ENTRIES) >=0 ) XtFree((char *)SUBDIR_ENTRY(SUBDIR_ENTRIES)); ++SUBDIR_ENTRIES;

   GET_Value(FS_FILE,XtNstring,&file);
   SMESSAGE(file)

   if (streq(file,"")) viewmode = XawFileSelectionRescan;
   if (viewmode == XawFileSelectionDefaultScan) viewmode = VIEWMODE;

#  ifdef VMS
      temp = file;
      if (viewmode == XawFileSelectionFilter) {
         while (*temp) *(temp) = toupper(*temp++);
         if (strchr(file,'.')) {
            temp=strchr(file,';');
            if ( ((temp) && (!(*(temp+1)))) || (!temp) ) {
               strncpy(tempfile,file,FS_MAXNAMLEN-3); tempfile[FS_MAXNAMLEN-3] = '\0';
               file = tempfile;
               strcat(file,";*");
            }
         }
      }
      SMESSAGE(file)
#  endif

   accepted = TRUE;
   while ((dp = readdir(dirp))) {
      str = dp->d_name;
#     ifdef VMS
         if ((temp=strstr(str,".DIR"))) {
            *temp = '\0';
            REALLOC_MORE_IF_NEEDED(SUBDIR_LIST,SUBDIR_ENTRIES+1,SUBDIR_ALLOC);
            SUBDIR_ENTRY(SUBDIR_ENTRIES) = XtNewString(str);
            SMESSAGE1(SUBDIR_ENTRY(SUBDIR_ENTRIES))
            SUBDIR_ENTRIES++;
         } else {
            if (viewmode==XawFileSelectionFilter) accepted=strwild(str,file);
            if (accepted) {
               REALLOC_MORE_IF_NEEDED(CURDIR_LIST,CURDIR_ENTRIES+1,CURDIR_ALLOC);
               CURDIR_ENTRY(CURDIR_ENTRIES) = XtNewString(str);
               SMESSAGE(CURDIR_ENTRY(CURDIR_ENTRIES))
               CURDIR_ENTRIES++;
            }
            else {
               INFMESSAGE1(list entry not accepted by viewmode)
            }
         }
#     else /*end of VMS */
         if (!(*str == '.' && *(str+1)=='\0')) {
            struct stat s;
            stat(str,&s);
            if (S_ISDIR(s.st_mode)) {
               REALLOC_MORE_IF_NEEDED(SUBDIR_LIST,SUBDIR_ENTRIES+1,SUBDIR_ALLOC);
               SUBDIR_ENTRY(SUBDIR_ENTRIES) = XtNewString(str);
               SMESSAGE1(SUBDIR_ENTRY(SUBDIR_ENTRIES))
               SUBDIR_ENTRIES++;
            } else {
               if (viewmode==XawFileSelectionFilter) accepted=strwild(str,file);
               if (accepted) {
                  REALLOC_MORE_IF_NEEDED(CURDIR_LIST,CURDIR_ENTRIES+1,CURDIR_ALLOC);
                  CURDIR_ENTRY(CURDIR_ENTRIES) = XtNewString(str);
                  SMESSAGE(CURDIR_ENTRY(CURDIR_ENTRIES))
                  CURDIR_ENTRIES++;
               }
               else {
                  INFMESSAGE1(list entry not accepted by viewmode)
               }
            }
         }
#     endif
   }

   IMESSAGE1(CURDIR_ENTRIES)
   if (!CURDIR_ENTRIES) {
      CURDIR_ENTRY(CURDIR_ENTRIES) = (String) NULL;
      INFMESSAGE1(no entries in this direcory)
   }
   else qsort( CURDIR_LIST, CURDIR_ENTRIES, sizeof(char *), FScompareEntries);

   IMESSAGE1(SUBDIR_ENTRIES)
   if (!SUBDIR_ENTRIES) {
      SUBDIR_ENTRY(SUBDIR_ENTRIES) = (String) NULL;
      INFMESSAGE1(no subdirectories)
   }
   else qsort( SUBDIR_LIST, SUBDIR_ENTRIES, sizeof(char *), FScompareEntries);

   closedir(dirp);

   {
      if (!(chdir(ONE_STEP_UP))) {
         INFMESSAGE(one step up is allowed)
         TOPDIR_ENTRY(TOPDIR_ENTRIES) = XtNewString(".."); TOPDIR_ENTRIES++;
         chdir(CURRENT_DIR);
      }

#     ifdef VMS
      {
         int ntops = 0;
         char *p;
         p = strrchr(path,':');
         if (p) {
            ++p;
            if (strchr(p,'[')) {
               strreplace(p,".]","]",p);
               strreplace(p,"][",".",p);
               strreplace(p,".000000","",p);
               strreplace(p,"000000.","",p);
               strreplace(p,"[000000]","",p);
               strreplace(p,"]","",p);
               strreplace(p,"[","",p);
               strcpy(path,p);
            }
         }
         SMESSAGE(path)

         if (path) {
            int ntops = 1;
            temp=path;
            while ((temp=strchr(temp,'.'))) { 
               *(temp++) = '\0'; ++ntops; 
            }
            temp=path;
            while ((ntops--)) {
               REALLOC_MORE_IF_NEEDED(TOPDIR_LIST,TOPDIR_ENTRIES+1,TOPDIR_ALLOC);
               TOPDIR_ENTRY(TOPDIR_ENTRIES) = XtNewString(temp);
               SMESSAGE1(TOPDIR_ENTRY(TOPDIR_ENTRIES))
               TOPDIR_ENTRIES++;
               temp = strchr(temp+1,'\0')+1;
            }
         }
      }
#     else /*end of VMS*/
      {
         REALLOC_MORE_IF_NEEDED(TOPDIR_LIST,TOPDIR_ENTRIES+1,TOPDIR_ALLOC);
         TOPDIR_ENTRY(TOPDIR_ENTRIES) = XtNewString("/");
         SMESSAGE(TOPDIR_ENTRY(TOPDIR_ENTRIES))
         TOPDIR_ENTRIES++;
         if (path) {
            char *p=path;
            SMESSAGE(p)
            strcat(path,"/");
 	    if (*p=='/') p++;
            temp=p;
            while ((*temp != '/') && (p=strchr(p,'/'))) { 
               *p = '\0';
               p++;
               REALLOC_MORE_IF_NEEDED(TOPDIR_LIST,TOPDIR_ENTRIES+1,TOPDIR_ALLOC);
               TOPDIR_ENTRY(TOPDIR_ENTRIES) = XtNewString(temp);
               SMESSAGE(TOPDIR_ENTRY(TOPDIR_ENTRIES))
               TOPDIR_ENTRIES++;
               temp=p;
            }
         }
      }
#     endif

      IMESSAGE1(TOPDIR_ENTRIES)
      if (!TOPDIR_ENTRIES) {
         TOPDIR_ENTRY(TOPDIR_ENTRIES) = (String) NULL;
         INFMESSAGE1(no topdirectories)
      }
   }

   AdjustListSizes(FS_FILE_SELECTION);
   chdir(APP_DIR);

   ENDMESSAGE(SetDirectoryView)
   return;
}

/*########################################################################
   rescanProc
   callback for the rescan button
########################################################################*/

static void
rescanProc(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   FS_WIDGET XtParent(w);

   BEGINMESSAGE(rescanProc)
   SetDirectoryView(FS_FILE_SELECTION,XawFileSelectionRescan);
   ENDMESSAGE(rescanProc)
}

/*########################################################################
   filterProc
   callback for the filter button
########################################################################*/

static void
filterProc(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   FS_WIDGET XtParent(w);

   BEGINMESSAGE(filterProc)
   SetDirectoryView(FS_FILE_SELECTION,XawFileSelectionFilter);
   ENDMESSAGE(filterProc)
}

/*###############################################################################
   TopDirSelectionProc
   callback for topdirectory list
###############################################################################*/

static void
TopDirSelectionProc(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   XawListReturnStruct  *list_struct = (XawListReturnStruct *) call_data;
   FS_WIDGET XtParent(XtParent(XtParent(XtParent(w))));
   USE_Arg(5);
   char newpath[FS_MAXNAMLEN];
   
   BEGINMESSAGE(TopDirSelectionProc)

   if (list_struct->list_index != XAW_LIST_NONE) {
      if (!(strcmp((String)list_struct->string,".."))) {
         if (chdir(CURRENT_DIR)) {
            INFMESSAGE(unable to switch to current directory) ENDMESSAGE(TopDirSelectionProc)
            return;
         }
         if (chdir(ONE_STEP_UP)) {
            INFMESSAGE(unable to step up)
            ENDMESSAGE(TopDirSelectionProc)
            return;
         }
         getwd(newpath);
         SMESSAGE(newpath)
         SET_Value(FS_PATH,XtNstring,newpath);
      }
      else {
         if (chdir(CURRENT_DIR)) {
            INFMESSAGE(unable to switch to current directory) ENDMESSAGE(TopDirSelectionProc)
            return;
         }

         strcpy(newpath,CURRENT_DIR);
SMESSAGE(newpath)
         CHANGE_TO_HEAD_OF_DIR_SPEC(newpath);
         strcat(newpath,DIR_SPECIFICATION_START_STRING);
SMESSAGE(newpath)
         {
            int item = -1;
            while (++item <= list_struct->list_index) {
               if (strcmp(TOPDIR_ENTRY(item),"..") && strcmp(TOPDIR_ENTRY(item),"/")) {
                  strcat(newpath,TOPDIR_ENTRY(item));
SMESSAGE(newpath)
                  if (item<list_struct->list_index) strcat(newpath,DIR_SEPARATOR_STRING);
SMESSAGE(newpath)
               }
            }
         }
         strcat(newpath,DIR_SPECIFICATION_END_STRING);
SMESSAGE(newpath)
         SET_Value(FS_PATH,XtNstring,newpath);
      }
   }
   SetDirectoryView(FS_FILE_SELECTION,VIEWMODE);

   ENDMESSAGE(TopDirSelectionProc)
}

/*###############################################################################
   CurDirSelectionProc
   callback for current directory list
###############################################################################*/

static void
CurDirSelectionProc(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   FS_WIDGET	XtParent(XtParent(XtParent(XtParent(w))));
   char		name[10];
   XawListReturnStruct  *list_struct = (XawListReturnStruct *) call_data;
   USE_Arg(5);

   BEGINMESSAGE(CurDirSelectionProc)

   if (list_struct->list_index != XAW_LIST_NONE) {
      SET_Value(FS_FILE,XtNstring,list_struct->string);   
      if (MULTICLICK) {
         DESTROY_MULTICLICK;
         if (IS_BUTTON(PREFERRED_BUTTON)) {
            POSITION_TO_BUTTON_NAME(PREFERRED_BUTTON,name);
            XtCallCallbacks(XtNameToWidget((Widget)FS_FILE_SELECTION,name),XtNcallback,call_data);
         }
      }
      else ENABLE_MULTICLICK;
   }

   ENDMESSAGE(CurDirSelectionProc)
}

/*###############################################################################
   SubDirSelectionProc
   callback for subdirectory list
###############################################################################*/

static void
SubDirSelectionProc(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   XawListReturnStruct  *list_struct = (XawListReturnStruct *) call_data;
   FS_WIDGET XtParent(XtParent(XtParent(XtParent(w))));
   USE_Arg(5);
   char newpath[FS_MAXNAMLEN];
   char *temp;
   
   BEGINMESSAGE(SubDirSelectionProc)

   if (list_struct->list_index != XAW_LIST_NONE) {
      strcpy(newpath,CURRENT_DIR);      
#     ifdef VMS
         if ((temp = strrchr(newpath,']'))) {
            *(temp++) = '.';
         } else {
            temp = strrchr(newpath,':')+1; 
            *(temp++) = '[';
         }
         *temp = '\0';
         strcat(temp,list_struct->string);
         strcat(temp,"]");
#     else
         if (!strcmp(list_struct->string,"..")) {
            TopDirSelectionProc(w, client_data, call_data);
            ENDMESSAGE(SubDirSelectionProc)
            return;
         }
         temp = (char*)newpath;
         temp += strlen(newpath);
         if (temp != newpath) temp--;
         if (*temp != '/') { temp++; *temp='/'; }
         temp++;
         *temp = '\0';
         strcat(temp,list_struct->string);
#     endif
      SET_Value(FS_PATH,XtNstring,newpath);
   }

   SetDirectoryView(FS_FILE_SELECTION,VIEWMODE);

   ENDMESSAGE(SubDirSelectionProc)
}

/*########################################################################
   CreateFrameForTextWidget
########################################################################*/

static Widget CreateFrameForTextWidget(name,parent)
   String name;
   Widget parent;
{
   Widget frame;
  
   BEGINMESSAGE(CreateFormForTextWidget)
   frame = ADD_Widget(name,frameWidgetClass,parent);  
   ENDMESSAGE(CreateFormForTextWidget)
   return frame;
}   

/*########################################################################
   CreateTextField
########################################################################*/

static Widget CreateTextField(name,w)
   String name;
   Widget w;
{
   USE_Arg(12);
   static XtTranslations translations = NULL;
   Widget textfield;
   AsciiSrcObject asciisrc;

   BEGINMESSAGE(CreateTextField)

   if (!(translations)) translations=XtParseTranslationTable(TextField_translations);

               SET_Arg(XtNdisplayCaret,     False);
               SET_Arg(XtNuseStringInPlace, False);
               SET_Arg(XtNeditType,         XawtextEdit);\
               SET_Arg(XtNscrollHorizontal, XawtextScrollNever);
               SET_Arg(XtNscrollVertical,   XawtextScrollNever);
               SET_Arg(XtNtranslations,	    translations);
               SET_Arg(XtNtype,             XawAsciiString);
               SET_Arg(XtNresize,           XawtextResizeNever);
   textfield = ADD_Widget_Arg(name,         asciiTextWidgetClass,w);
               GET_Value(textfield,XtNtextSource,&asciisrc);

   ENDMESSAGE(CreateTextField)
   return textfield;
}

/*########################################################################
   CreateFrameForViewportWidget
########################################################################*/

static Widget CreateFrameForViewportWidget(name,parent)
   String name;
   Widget parent;
{
   Widget frame;
   USE_Arg(3);

   BEGINMESSAGE(CreateFrameForViewportWidget)
   SET_Arg(XtNresizeToPreferred, False);
/* leave it to the user to set the size of the topdir, subdir panes... ###jp### 1/95
   SET_Arg(XtNmin, 100);
*/
   SET_Arg(XtNresizeToPreferred, False);
   SET_Arg(XtNallowResize, False);
   frame = ADD_Widget_Arg(name,frameWidgetClass,parent);  
   ENDMESSAGE(CreateFrameForViewportWidget)
   return frame;
}

/*########################################################################
   CreateViewportWidget
########################################################################*/

static Widget CreateViewportWidget(name,parent)
   String name;
   Widget parent;
{
   USE_Arg(3);
   Widget viewport;
   
   BEGINMESSAGE(CreateViewportWidget)
 
                SET_Arg(XtNallowHoriz,		True);
                SET_Arg(XtNallowVert,		True);
   viewport   = ADD_Widget_Arg(name,viewportWidgetClass,parent);  

   ENDMESSAGE(CreateViewportWidget)
   return viewport;
}

/*########################################################################
   CreateListWidget
########################################################################*/

static Widget CreateListWidget(name,parent)
   String name;
   Widget parent;
{
   USE_Arg(10);
   Widget list;
   
   BEGINMESSAGE(CreateListWidget)

                SET_Arg(XtNforceColumns,	True);
                SET_Arg(XtNdefaultColumns,	1);
                SET_Arg(XtNlist,		emptyList);
                SET_Arg(XtNlongest,		0); 
                SET_Arg(XtNverticalList,	True); 
                SET_Arg(XtNborderWidth,		0); 
   list =       ADD_Widget_Arg(name,listcWidgetClass,parent);

   ENDMESSAGE(CreateListWidget)
   return list;
}

/*#######################################################################
   Initialize
########################################################################*/

static String str_grip_translations = "#replace\n\
<Btn1Down>:	GripAction(Start,UpLeftPane)\n\
<Btn2Down>:	GripAction(Start,ThisBorderOnly)\n\
<Btn3Down>:	GripAction(Start,LowRightPane)\n\
<Btn1Motion>:	GripAction(Move,UpLeftPane)\n\
<Btn2Motion>:	GripAction(Move,ThisBorderOnly)\n\
<Btn3Motion>:	GripAction(Move,LowRightPane)\n\
Any<BtnUp>:     FS_gripAdjustListSizes(start)\
		GripAction(Commit)\
		FS_gripAdjustListSizes(stop)\
";

static void Initialize(request, new, argl, num_argl)
   Widget 	request, new;
   ArgList 	argl;
   Cardinal 	*num_argl;
{
   FS_WIDGET 	new;
   USE_Arg(10);
   static XtTranslations grip_translations = NULL;

   BEGINMESSAGE(Initialize)

   { 
       char app_dir[FS_MAXNAMLEN];
       getwd(app_dir);
       APP_DIR = XtNewString(app_dir);
   }  

   FS_RESCAN  = ADD_Widget("rescan",commandWidgetClass,new);
                ADD_Callback(FS_RESCAN,rescanProc);

   FS_FILTER  = ADD_Widget("filter",commandWidgetClass,new);
                ADD_Callback(FS_FILTER,filterProc);

   BUTTONS = 0;
   IMESSAGE(BUTTONS_RESOURCE)
   if ((BUTTONS_RESOURCE > 0) && (BUTTONS_RESOURCE<5)) {
      if (BUTTONS_RESOURCE > 0) {
         FS_BUTTON1 = ADD_Widget("button1",commandWidgetClass,new);
         BUTTONS += 1;
      }
      if (BUTTONS_RESOURCE > 1) {
         FS_BUTTON2 = ADD_Widget("button2",commandWidgetClass,new);
         BUTTONS += 2;
      }
      if (BUTTONS_RESOURCE > 2) {
         FS_BUTTON3 = ADD_Widget("button3",commandWidgetClass,new);
         BUTTONS += 4;
      }
      if (BUTTONS_RESOURCE > 3) {
         FS_BUTTON4 = ADD_Widget("button4",commandWidgetClass,new);
         BUTTONS += 8;
      }
      IMESSAGE(BUTTONS)
   }

   FS_PATHFRAME= CreateFrameForTextWidget("pathframe",new);
   FS_PATH    = CreateTextField("path",FS_PATHFRAME);
                if (PATH_RESOURCE) { SET_Value(FS_PATH,XtNstring,PATH_RESOURCE); }
                else { SET_Value(FS_PATH,XtNstring,APP_DIR); }
   
   FS_FILEFRAME= CreateFrameForTextWidget("fileframe",new);
   FS_FILE    = CreateTextField("file",FS_FILEFRAME);
                SET_Value(FS_FILE,XtNstring,FILE_RESOURCE);

   SetPreferredButton(new,PREFERRED_BUTTON,TRUE);

   if (!(grip_translations)) grip_translations=XtParseTranslationTable(str_grip_translations);

                RESET_Arg;
                SET_Arg(XtNorientation,         XtorientHorizontal);  
                SET_Arg(XtNgripTranslations,    grip_translations);  
                SET_Arg(XtNresizable,		False);
   FS_PANED   = ADD_Widget_Arg("paned",panedWidgetClass,new);

   INFMESSAGE(examining the View Order)
   {
      char *pos = VIEWORDER;
      int o[2], i;
      Boolean skip = False;

      o[0] = o[1] = o[2] =0;
      i=0;
      --pos;
      while ((pos) && (i<3)) {
         ++pos;
         if ((*pos) == 't')  o[i] = 4;
         else if ((*pos) == 'c')  o[i] = 2;
         else if ((*pos) == 's')  o[i] = 1;
         pos = strchr(pos, ','); ++i;
      }
      if (o[0]+o[1]+o[2] != 7)  { o[0] = 4; o[1] = 2; o[2] =1; }

      i=0;
      while (i<3) {
         switch(o[i]) {
            case 4:
               FS_TOPFRAME = CreateFrameForViewportWidget("topframe",FS_PANED);
               FS_TOPVIEW = CreateViewportWidget("topview",FS_TOPFRAME);
               FS_TOPLIST = CreateListWidget("toplist",FS_TOPVIEW);
                            ADD_Callback(FS_TOPLIST,TopDirSelectionProc);
                            if (skip) {INFMESSAGE(skip adjust for top) SET_Value(FS_TOPFRAME,XtNskipAdjust,True); }
               break;
            case 2:
               FS_CURFRAME = CreateFrameForViewportWidget("curframe",FS_PANED);
               FS_CURVIEW = CreateViewportWidget("curview",FS_CURFRAME);
               FS_CURLIST = CreateListWidget("curlist",FS_CURVIEW);
                            ADD_Callback(FS_CURLIST,CurDirSelectionProc);
                            skip=True;
               break;
            case 1:
               FS_SUBFRAME = CreateFrameForViewportWidget("subframe",FS_PANED);
               FS_SUBVIEW = CreateViewportWidget("subview",FS_SUBFRAME);
               FS_SUBLIST = CreateListWidget("sublist",FS_SUBVIEW);
                            ADD_Callback(FS_SUBLIST,SubDirSelectionProc);
                            if (skip) {INFMESSAGE(skip adjust for sub) SET_Value(FS_SUBFRAME,XtNskipAdjust,True); }
               break;
         }
         ++i;
      }
   }

   TOPDIR_ALLOC = 100; TOPDIR_ENTRIES = 0; ALLOC_LIST(TOPDIR_LIST,TOPDIR_ALLOC);
   CURDIR_ALLOC = 100; CURDIR_ENTRIES = 0; ALLOC_LIST(CURDIR_LIST,CURDIR_ALLOC);
   SUBDIR_ALLOC = 100; SUBDIR_ENTRIES = 0; ALLOC_LIST(SUBDIR_LIST,SUBDIR_ALLOC);

   CURRENT_DIR = XtNewString("");
   PATH = XtNewString("");
   FILE = XtNewString("");
   BOTH = XtNewString("");
   MULTICLICK = DISABLED;

   XtCallActionProc(FS_PATH,"FS_textfieldFocusAction",(XEvent *)NULL,(String *)NULL,(Cardinal)NULL);
   XtCallActionProc(FS_FILE,"FS_textfieldFocusAction",(XEvent *)NULL,(String *)NULL,(Cardinal)NULL);

   ENDMESSAGE(Initialize)
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   PUBLIC ROUTINES
-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/   
   
/*########################################################################
   XawFileSelectionGetSelection
########################################################################*/

char *
#if NeedFunctionPrototypes
XawFileSelectionGetSelection(Widget w,int indicator)
#else
XawFileSelectionGetSelection(w,indicator)
   Widget 	w;
   int 		indicator;
#endif
{
   FS_WIDGET	w;
   String	path=NULL, file=NULL;
   USE_Arg(5);

   BEGINMESSAGE(XawFileSelectionGetSelection)

   switch (indicator) {
      case XawFileSelectionPath:
	 {
            GET_Value(FS_PATH,XtNstring,&path);
            if (path) {
               char tmp[FS_MAXNAMLEN];
               strncpy(tmp,path,FS_MAXNAMLEN-3);
               tmp[FS_MAXNAMLEN-3]='\0';
               if (strchr(tmp,'~')) TranslateTildeInPath(tmp);
#              ifndef VMS
               {
                  int i = strlen(tmp);
                  if (i>0 && tmp[i-1] != '/') { tmp[i]='/'; tmp[i+1]='\0'; }
                  path = tmp;
               }
#              endif /* not VMS */
            }
            XtFree(PATH); PATH = XtNewString(path);
            INFSMESSAGE(returning, PATH)
            ENDMESSAGE(XawFileSelectionGetSelection)
            return(PATH);
         }
      case XawFileSelectionFile:          
         GET_Value(FS_FILE,XtNstring,&file);
         XtFree(PATH); PATH = XtNewString(path);
         ENDMESSAGE(XawFileSelectionGetSelection)
         return(FILE);
      case XawFileSelectionBoth:
	 {
            GET_Value(FS_PATH,XtNstring,&path);
            if (path) {
               char tmp[FS_MAXNAMLEN];
               strncpy(tmp,path,FS_MAXNAMLEN-3);
               tmp[FS_MAXNAMLEN-3]='\0';
               if (strchr(tmp,'~')) TranslateTildeInPath(tmp);
#              ifndef VMS
               {
                  int i = strlen(tmp);
                  if (i>0 && tmp[i-1] != '/') { tmp[i]='/'; tmp[i+1]='\0'; }
                  path = tmp;
               }
#              endif /* not VMS */
            }
            GET_Value(FS_FILE,XtNstring,&file);
            SMESSAGE(file)
            XtFree(BOTH);
            BOTH = strcpy( XtMalloc((unsigned) strlen(path)+strlen(file)+1),path);
            strcat(BOTH,file);
         }
         INFSMESSAGE(returning, BOTH)
         ENDMESSAGE(XawFileSelectionGetSelection)
         return(BOTH);
      default:
   ENDMESSAGE(XawFileSelectionGetSelection)
         return NULL;
   }
   ENDMESSAGE(XawFileSelectionGetSelection)

}

/*########################################################################
   XawFileSelectionSetSelection
########################################################################*/

void
#if NeedFunctionPrototypes
XawFileSelectionSetSelection(Widget w,String string,int indicator)
#else
XawFileSelectionSetSelection(w,string,indicator)
   Widget 	w;
   String 	string;
   int 		indicator;
#endif
{
   FS_WIDGET w;
   USE_Arg(3);

   BEGINMESSAGE(XawFileSelectionSetSelection)

   switch (indicator) {
     case XawFileSelectionPath:
         if (string) {
            if (!strcmp(string,"") || !strcmp(string,".")) { 
               SET_Value(FS_PATH,XtNstring,APP_DIR);
            } else {
               SET_Value(FS_PATH,XtNstring,string);
            }
         }
         break;
      case XawFileSelectionFile:
         if (string) { SET_Value(FS_FILE,XtNstring,string); }
         break;
   }

   ENDMESSAGE(XawFileSelectionGetSelection)
}

/*########################################################################
   XawFileSelectionScan
########################################################################*/

void
#if NeedFunctionPrototypes
XawFileSelectionScan(Widget w,int indicator)
#else
XawFileSelectionScan(w,indicator)
   Widget 	w;
   int 		indicator;
#endif
{
   FS_WIDGET	w;

   BEGINMESSAGE(XawFileSelectionScan)

   if (indicator==XawFileSelectionDefaultScan) indicator = VIEWMODE;
   switch (indicator) {
      case XawFileSelectionFilter:
         filterProc(FS_FILTER,(XtPointer)NULL,(XtPointer)NULL);
         break;
      case XawFileSelectionRescan:
         rescanProc(FS_RESCAN,(XtPointer)NULL,(XtPointer)NULL);
         break;
   }

   ENDMESSAGE(XawFileSelectionScan)
}

/*########################################################################
   XawFileSelectionAddButton
########################################################################*/

void
#if NeedFunctionPrototypes
XawFileSelectionAddButton(Widget w, int position, XtCallbackProc function, XtPointer param)
#else
XawFileSelectionAddButton(w, position, function, param)
   Widget		w;
   int 			position;
   XtCallbackProc	function;
   XtPointer		param;
#endif
{
   FS_WIDGET 		w;
   char			name[10];
   Widget		button;

   BEGINMESSAGE(XawFileSelectionAddButton)

   if (IS_BUTTON(position)) {
      INFMESSAGE(desired Button Position is already used) ENDMESSAGE(XawFileSelectionAddButton)
      return;
   }

   POSITION_TO_BUTTON_NAME(position,name);
   IMESSAGE(position) SMESSAGE(name);
   button = ADD_Widget(name,commandWidgetClass,FS_FILE_SELECTION);
   BUTTONS += POSITION(position);
   if (function) XtAddCallback(button, XtNcallback, function, param);

   ENDMESSAGE(XawFileSelectionAddButton)
}

/*########################################################################
   XawFileSelectionRemoveButton
########################################################################*/

void
#if NeedFunctionPrototypes
XawFileSelectionRemoveButton(Widget w, int position)
#else
XawFileSelectionRemoveButton(w, position)
   Widget		w;
   int 			position;
#endif 
{
   FS_WIDGET 		w;
   char 		name[10];

   BEGINMESSAGE(XawFileSelectionRemoveButton)

   if (!(IS_BUTTON(position))) { 
      INFMESSAGE(Unused Button Position) ENDMESSAGE(XawFileSelectionRemoveButton)
      return;
   }

   POSITION_TO_BUTTON_NAME(position,name);
   XtDestroyWidget(XtNameToWidget((Widget)FS_FILE_SELECTION,name));
   BUTTONS -= POSITION(position);
   IMESSAGE(BUTTONS)

   ENDMESSAGE(XawFileSelectionRemoveButton)
}

/*###############################################################################
  unused code
###############################################################################*/

#if 0

#define MIN_NUM_OF_LETTERS 10
 
static void
GetListSize(l,widthp,heightp,preferredWidth,preferredHeight)  
   ListcWidget l;
   Dimension *widthp;
   Dimension *heightp;
   Dimension *preferredWidth;
   Dimension *preferredHeight;
{
   USE_Arg(11);
   Dimension internalWidth,internalHeight;
   Dimension columnSpacing,rowSpacing;
   int longest;
   int numberStrings;
   XFontStruct *font;
   Dimension tempdim;

   BEGINMESSAGE(GetListSize)

   SET_Arg( XtNheight,		heightp);
   SET_Arg( XtNwidth,		widthp);
   SET_Arg( XtNinternalHeight,	&internalHeight);
   SET_Arg( XtNinternalWidth,	&internalWidth);
   SET_Arg( XtNrowSpacing,	&rowSpacing);
   SET_Arg( XtNcolumnSpacing,	&columnSpacing);
   SET_Arg( XtNlongest,		&longest);
   SET_Arg( XtNnumberStrings,	&numberStrings);
   SET_Arg( XtNfont,		&font);
   GET_Values(l);

   *preferredWidth  = (Dimension) (2*internalWidth  + columnSpacing + longest);
   tempdim         = (Dimension) (font->max_bounds.width+font->min_bounds.width)/2*MIN_NUM_OF_LETTERS;
   *preferredWidth  = (Dimension) (*preferredWidth > tempdim ? *preferredWidth : tempdim);
   *preferredHeight = (Dimension) (
                       numberStrings*(font->max_bounds.ascent+font->max_bounds.descent+rowSpacing) + 2*internalHeight
                    );
   IIMESSAGE(*widthp,*heightp) 
   IIMESSAGE(internalWidth,internalHeight)
   IIMESSAGE(rowSpacing,columnSpacing)
   IIMESSAGE(longest,numberStrings)
   IIMESSAGE(font->max_bounds.ascent,font->max_bounds.descent)
   IIMESSAGE(*preferredWidth,*preferredHeight)

   ENDMESSAGE(GetListSize)
}


#endif /* unused code */
